/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local;

import java.lang.reflect.Field;
import org.eclipse.tm.internal.terminal.local.ILocalTerminalSettings;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;

public class LocalTerminalSettings
implements ILocalTerminalSettings {
    private String launchConfiguration;

    public void load(ISettingsStore store) {
        Field[] declaredField = this.getClass().getDeclaredFields();
        int numberOfFields = declaredField.length;
        int index = 0;
        while (index < numberOfFields) {
            Field field = declaredField[index];
            Class<?> type = field.getType();
            Object value = store.get(field.getName());
            if (type.equals(Boolean.TYPE)) {
                value = Boolean.valueOf((String)value);
            }
            try {
                field.set(this, value);
            }
            catch (IllegalAccessException illegalAccess) {
                Logger.logException((Exception)illegalAccess);
            }
            ++index;
        }
    }

    public void save(ISettingsStore store) {
        Field[] declaredField = this.getClass().getDeclaredFields();
        int numberOfFields = declaredField.length;
        int index = 0;
        while (index < numberOfFields) {
            Field field = declaredField[index];
            try {
                field.setAccessible(true);
                store.put(field.getName(), String.valueOf(field.get(this)));
            }
            catch (IllegalAccessException illegalAccess) {
                Logger.logException((Exception)illegalAccess);
            }
            ++index;
        }
    }

    public String getLaunchConfigurationName() {
        return this.launchConfiguration;
    }

    public void setLaunchConfigurationName(String launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }
}

