/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SystemPreferencesManager {
    private static boolean showLocalConnection;
    private static boolean showProfilePage;
    private static boolean showNewConnectionPrompt;
    private static SystemPreferencesManager fInstance;
    private int fModelChangeListeners = 0;
    private ISystemModelChangeListener fModelChangeListener = null;

    static {
        fInstance = new SystemPreferencesManager();
    }

    private SystemPreferencesManager() {
    }

    private static void migrateCorePreferences() {
        String[] keys = new String[]{"activeuserprofiles", "useDeferredQueries", "useridperkey"};
        int i = 0;
        while (i < keys.length) {
            SystemPreferencesManager.migrateCorePreference(keys[i]);
            ++i;
        }
    }

    private static void migrateCorePreference(String preferenceName) {
        String name = "org.eclipse.rse.preferences." + preferenceName;
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        if (store.contains(name) && !store.isDefault(name)) {
            String value = store.getString(name);
            store.setToDefault(name);
            store.setDefault(name, "*migrated*");
            store = RSECorePlugin.getDefault().getPluginPreferences();
            store.setValue(preferenceName, value);
        }
    }

    public static void initDefaults() {
        SystemPreferencesManager.migrateCorePreferences();
        SystemPreferencesManager.initDefaultsUI();
        SystemPreferencesManager.savePreferences();
        fInstance.startModelChangeListening();
    }

    private static void initDefaultsUI() {
        RSEUIPlugin ui = RSEUIPlugin.getDefault();
        Preferences store = ui.getPluginPreferences();
        showNewConnectionPrompt = SystemPreferencesManager.getBooleanProperty("rse.showNewConnectionPrompt", false);
        showLocalConnection = SystemPreferencesManager.getBooleanProperty("rse.showLocalConnection", true);
        showProfilePage = SystemPreferencesManager.getBooleanProperty("rse.showProfilePage", false);
        store.setDefault("org.eclipse.rse.preferences.restoreStateFromCache", true);
        store.setDefault("org.eclipse.rse.preferences.qualifyconnectionnames", false);
        store.setDefault("org.eclipse.rse.preferences.filterpools.show", false);
        store.setDefault("org.eclipse.rse.preferences.order.connections", "");
        store.setDefault("org.eclipse.rse.preferences.history.folder", "");
        store.setDefault("org.eclipse.rse.preferences.rememberState", true);
        store.setDefault("org.eclipse.rse.preferences.uda.cascade", false);
        store.setDefault("org.eclipse.rse.preferences.shownewconnection", showNewConnectionPrompt);
        store.setDefault("MNEMONICS_POLICY", 3);
        store.setDefault("APPEND_MNEMONICS_PATTERN", "zh.*|ja.*|ko.*");
        store.setDefault("SHOW_EMPTY_LISTS", true);
        SystemPreferencesManager.savePreferences();
    }

    private static boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        String property = System.getProperty(propertyName);
        boolean value = property == null ? defaultValue : property.equals(Boolean.toString(true));
        return value;
    }

    public static boolean getShowLocalConnection() {
        return showLocalConnection;
    }

    public static boolean getShowProfilePage() {
        return showProfilePage;
    }

    public static boolean getCascadeUserActions() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        return store.getBoolean("org.eclipse.rse.preferences.uda.cascade");
    }

    public static void setCascadeUserActions(boolean cascade) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.uda.cascade", cascade);
    }

    public static String[] getConnectionNamesOrder() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        return SystemPreferencesManager.parseStrings(store.getString("org.eclipse.rse.preferences.order.connections"));
    }

    public static String[] getConnectionNamesOrder(String profileName) {
        String[] allConnectionNamesOrder = SystemPreferencesManager.getConnectionNamesOrder();
        profileName = String.valueOf(profileName) + ".";
        int profileNameLength = profileName.length();
        ArrayList<String> l = new ArrayList<String>();
        int idx = 0;
        while (idx < allConnectionNamesOrder.length) {
            if (allConnectionNamesOrder[idx].startsWith(profileName)) {
                l.add(allConnectionNamesOrder[idx].substring(profileNameLength));
            }
            ++idx;
        }
        String[] names = new String[l.size()];
        l.toArray(names);
        return names;
    }

    public static String[] getConnectionNamesOrder(IHost[] realityConnectionList, String profileName) {
        if (realityConnectionList == null) {
            return new String[0];
        }
        String[] realityNames = new String[realityConnectionList.length];
        int idx = 0;
        while (idx < realityConnectionList.length) {
            realityNames[idx] = realityConnectionList[idx].getAliasName();
            ++idx;
        }
        String[] names = SystemPreferencesManager.resolveOrderPreferenceVersusReality(realityNames, SystemPreferencesManager.getConnectionNamesOrder(profileName));
        return names;
    }

    public static void setConnectionNamesOrder() {
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        IHost[] conns = sr.getHosts();
        String[] names = new String[conns.length];
        int idx = 0;
        while (idx < names.length) {
            names[idx] = String.valueOf(conns[idx].getSystemProfileName()) + "." + conns[idx].getAliasName();
            ++idx;
        }
        SystemPreferencesManager.setConnectionNamesOrder(names);
    }

    public static void setConnectionNamesOrder(String[] connectionNames) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.order.connections", SystemPreferencesManager.makeString(connectionNames));
        SystemPreferencesManager.savePreferences();
    }

    private static boolean find(String[] haystack, String needle) {
        int idx = 0;
        while (idx < haystack.length) {
            if (haystack[idx].equals(needle)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    private static String[] resolveOrderPreferenceVersusReality(String[] reality, String[] ordered) {
        ArrayList<String> finalList = new ArrayList<String>();
        int idx = 0;
        while (idx < ordered.length) {
            if (SystemPreferencesManager.find(reality, ordered[idx])) {
                finalList.add(ordered[idx]);
            }
            ++idx;
        }
        idx = 0;
        while (idx < reality.length) {
            if (!SystemPreferencesManager.find(ordered, reality[idx])) {
                finalList.add(reality[idx]);
            }
            ++idx;
        }
        String[] resolved = new String[finalList.size()];
        finalList.toArray(resolved);
        return resolved;
    }

    public static String[] getFolderHistory() {
        return SystemPreferencesManager.getWidgetHistory("org.eclipse.rse.preferences.history.folder");
    }

    public static void setFolderHistory(String[] newHistory) {
        SystemPreferencesManager.setWidgetHistory("org.eclipse.rse.preferences.history.folder", newHistory);
    }

    public static boolean getQualifyConnectionNames() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        return store.getBoolean("org.eclipse.rse.preferences.qualifyconnectionnames");
    }

    public static void setQualifyConnectionNames(boolean qualify) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.qualifyconnectionnames", qualify);
        SystemPreferencesManager.savePreferences();
    }

    public static boolean getRememberState() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        return store.getBoolean("org.eclipse.rse.preferences.rememberState");
    }

    public static void setRememberState(boolean remember) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.rememberState", remember);
        SystemPreferencesManager.savePreferences();
    }

    public static boolean getRestoreStateFromCache() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        return store.getBoolean("org.eclipse.rse.preferences.restoreStateFromCache");
    }

    public static void setRestoreStateFromCache(boolean restore) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.restoreStateFromCache", restore);
        SystemPreferencesManager.savePreferences();
    }

    public static boolean getShowFilterPools() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        return store.getBoolean("org.eclipse.rse.preferences.filterpools.show");
    }

    public static void setShowFilterPools(boolean show) {
        boolean prevValue = SystemPreferencesManager.getShowFilterPools();
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.filterpools.show", show);
        SystemPreferencesManager.savePreferences();
        if (show != prevValue) {
            RSEUIPlugin.getTheSystemRegistryUI().setShowFilterPools(show);
        }
    }

    public static boolean getShowNewConnectionPrompt() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        boolean value = store.getBoolean("org.eclipse.rse.preferences.shownewconnection");
        return value;
    }

    public static void setShowNewConnectionPrompt(boolean show) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.shownewconnection", show);
        SystemPreferencesManager.savePreferences();
    }

    public static boolean getVerifyConnection() {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setDefault("org.eclipse.rse.preferences.verify.connection", true);
        return store.getBoolean("org.eclipse.rse.preferences.verify.connection");
    }

    public static void setVerifyConnection(boolean verify) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue("org.eclipse.rse.preferences.verify.connection", verify);
        SystemPreferencesManager.savePreferences();
    }

    public static String[] getWidgetHistory(String key) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        String result = store.getString(key);
        if (result == null || result.length() == 0) {
            return null;
        }
        return SystemPreferencesManager.parseStrings(result);
    }

    public static void setWidgetHistory(String key, String[] newHistory) {
        Preferences store = RSEUIPlugin.getDefault().getPluginPreferences();
        store.setValue(key, SystemPreferencesManager.makeString(newHistory));
    }

    private static String makeString(String[] values) {
        StringBuffer allValues = new StringBuffer(20 * values.length);
        int idx = 0;
        while (idx < values.length) {
            if (values[idx] != null) {
                if (idx > 0) {
                    allValues = allValues.append(';');
                }
                allValues.append(values[idx]);
            }
            ++idx;
        }
        return allValues.toString();
    }

    private static String[] parseStrings(String allvalues) {
        if (allvalues == null) {
            return new String[0];
        }
        String[] tokens = allvalues.split(";");
        return tokens;
    }

    public static void savePreferences() {
        RSEUIPlugin.getDefault().savePluginPreferences();
        RSECorePlugin.getDefault().savePluginPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startModelChangeListening() {
        boolean alreadyListening;
        SystemPreferencesManager systemPreferencesManager = this;
        synchronized (systemPreferencesManager) {
            alreadyListening = this.fModelChangeListeners > 0;
            ++this.fModelChangeListeners;
        }
        if (!alreadyListening) {
            Job addListenerJob = new Job("Add Listener"){

                public IStatus run(IProgressMonitor monitor) {
                    while (!PlatformUI.isWorkbenchRunning()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    IWorkbench wb = PlatformUI.getWorkbench();
                    if (!wb.isClosing()) {
                        SystemPreferencesManager.this.fModelChangeListener = new ModelChangeListener();
                        RSECorePlugin.getTheSystemRegistry().addSystemModelChangeListener(SystemPreferencesManager.this.fModelChangeListener);
                    }
                    return Status.OK_STATUS;
                }
            };
            addListenerJob.setSystem(true);
            addListenerJob.schedule();
        }
    }

    private static class ModelChangeListener
    implements ISystemModelChangeListener,
    ISystemResourceChangeListener {
        private ModelChangeListener() {
        }

        public void systemModelResourceChanged(ISystemModelChangeEvent event) {
            int rt = event.getResourceType();
            if (rt == 2) {
                switch (event.getEventType()) {
                    case 1: 
                    case 2: 
                    case 8: {
                        SystemPreferencesManager.setConnectionNamesOrder();
                    }
                }
            } else if (rt == 1) {
                switch (event.getEventType()) {
                    case 2: 
                    case 4: 
                    case 8: {
                        SystemPreferencesManager.setConnectionNamesOrder();
                    }
                }
                if (event.getEventType() == 8) {
                    boolean namesQualified = SystemPreferencesManager.getQualifyConnectionNames();
                    RSEUIPlugin.getTheSystemRegistryUI().setQualifiedHostNames(namesQualified);
                }
            }
        }

        public void systemResourceChanged(ISystemResourceChangeEvent event) {
            if (event.getType() == 75 && event.getSource() instanceof IHost[]) {
                SystemPreferencesManager.setConnectionNamesOrder();
            }
        }
    }
}

