"use strict";
// *****************************************************************************
// Copyright (C) 2021 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LocalizationRegistry = exports.LocalizationContribution = void 0;
const fs = require("fs-extra");
const inversify_1 = require("inversify");
const common_1 = require("../../common");
const localization_provider_1 = require("./localization-provider");
exports.LocalizationContribution = Symbol('LocalizationContribution');
let LocalizationRegistry = class LocalizationRegistry {
    async initialize() {
        await Promise.all(this.contributions.getContributions().map(contribution => contribution.registerLocalizations(this)));
    }
    registerLocalization(localization) {
        this.localizationProvider.addLocalizations(localization);
    }
    registerLocalizationFromRequire(locale, required) {
        const translations = this.flattenTranslations(required);
        const localization = {
            languageId: locale,
            translations
        };
        this.registerLocalization(localization);
    }
    async registerLocalizationFromFile(localizationPath, locale) {
        if (!locale) {
            locale = this.identifyLocale(localizationPath);
        }
        if (!locale) {
            throw new Error('Could not determine locale from path.');
        }
        const translationJson = await fs.readJson(localizationPath);
        const translations = this.flattenTranslations(translationJson);
        const localization = {
            languageId: locale,
            translations
        };
        this.registerLocalization(localization);
    }
    flattenTranslations(localization) {
        if (typeof localization === 'object' && localization) {
            const record = {};
            for (const [key, value] of Object.entries(localization)) {
                if (typeof value === 'string') {
                    record[key] = value;
                }
                else if (value && typeof value === 'object') {
                    const flattened = this.flattenTranslations(value);
                    for (const [flatKey, flatValue] of Object.entries(flattened)) {
                        record[`${key}/${flatKey}`] = flatValue;
                    }
                }
            }
            return record;
        }
        else {
            return {};
        }
    }
    identifyLocale(localizationPath) {
        const regex = /nls\.(\w+)\.json$/i;
        const match = regex.exec(localizationPath);
        if (match) {
            return match[1];
        }
        return undefined;
    }
};
__decorate([
    (0, inversify_1.inject)(localization_provider_1.LocalizationProvider),
    __metadata("design:type", localization_provider_1.LocalizationProvider)
], LocalizationRegistry.prototype, "localizationProvider", void 0);
__decorate([
    (0, inversify_1.inject)(common_1.ContributionProvider),
    (0, inversify_1.named)(exports.LocalizationContribution),
    __metadata("design:type", Object)
], LocalizationRegistry.prototype, "contributions", void 0);
LocalizationRegistry = __decorate([
    (0, inversify_1.injectable)()
], LocalizationRegistry);
exports.LocalizationRegistry = LocalizationRegistry;
//# sourceMappingURL=localization-contribution.js.map