"use strict";
/********************************************************************************
 * Copyright (C) 2022 Arm and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SaveResourceService = void 0;
const inversify_1 = require("inversify");
const saveable_1 = require("./saveable");
let SaveResourceService = class SaveResourceService {
    /**
     * Indicate if the document can be saved ('Save' command should be disable if not).
     */
    canSave(saveable) {
        // By default, we never allow a document to be saved if it is untitled.
        return saveable_1.Saveable.isDirty(saveable) && !saveable_1.Saveable.isUntitled(saveable);
    }
    /**
     * Saves the document.
     *
     * This function is called only if `canSave` returns true, which means the document is not untitled
     * and is thus saveable.
     */
    async save(widget, options) {
        const saveable = saveable_1.Saveable.get(widget);
        if (saveable && this.canSave(saveable)) {
            await saveable.save(options);
        }
    }
};
SaveResourceService = __decorate([
    (0, inversify_1.injectable)()
], SaveResourceService);
exports.SaveResourceService = SaveResourceService;
//# sourceMappingURL=save-resource-service.js.map