/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.search.text;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.ls.core.internal.search.text.PatternConstructor;
import org.eclipse.jdt.ls.core.internal.search.text.TextSearchRequestor;
import org.eclipse.jdt.ls.core.internal.search.text.TextSearchScope;
import org.eclipse.jdt.ls.core.internal.search.text.TextSearchVisitor;

public abstract class TextSearchEngine {
    public static TextSearchEngine create() {
        return TextSearchEngine.createDefault();
    }

    public static TextSearchEngine createDefault() {
        return new TextSearchEngine(){

            @Override
            public IStatus search(TextSearchScope scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
                return new TextSearchVisitor(requestor, searchPattern).search(scope, monitor);
            }

            @Override
            public IStatus search(IFile[] scope, TextSearchRequestor requestor, Pattern searchPattern, IProgressMonitor monitor) {
                return new TextSearchVisitor(requestor, searchPattern).search(scope, monitor);
            }
        };
    }

    public abstract IStatus search(TextSearchScope var1, TextSearchRequestor var2, Pattern var3, IProgressMonitor var4);

    public abstract IStatus search(IFile[] var1, TextSearchRequestor var2, Pattern var3, IProgressMonitor var4);

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegex) throws PatternSyntaxException {
        return PatternConstructor.createPattern(pattern, isRegex, true, isCaseSensitive, false);
    }
}

