/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URI;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IElementInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.BatchInitializationMonitor;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClasspathAccessRule;
import org.eclipse.jdt.internal.core.ClasspathAttribute;
import org.eclipse.jdt.internal.core.ClasspathChange;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.DeltaProcessingState;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.ExternalAnnotationTracker;
import org.eclipse.jdt.internal.core.ExternalFoldersManager;
import org.eclipse.jdt.internal.core.ExternalPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementDeltaBuilder;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelCache;
import org.eclipse.jdt.internal.core.JavaModelOperation;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JavaProjectElementInfo;
import org.eclipse.jdt.internal.core.ModuleSourcePathManager;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.jdt.internal.core.SetContainerOperation;
import org.eclipse.jdt.internal.core.SetVariablesOperation;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.jdt.internal.core.dom.SourceRangeVerifier;
import org.eclipse.jdt.internal.core.dom.rewrite.RewriteEventStore;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.jdt.internal.core.search.AbstractSearchScope;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.jdt.internal.core.search.JavaWorkspaceScope;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.DeduplicationUtil;
import org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.jdt.internal.core.util.LRUCache;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaModelManager
implements ISaveParticipant,
IContentTypeManager.IContentTypeChangeListener {
    private static final Integer SAVE_THREAD_COUNT = Integer.getInteger("org.eclipse.jdt.model_save_threads");
    private static final boolean SAVE_ZIPPED = !Boolean.getBoolean("org.eclipse.jdt.disable_gzip");
    private static ServiceRegistration<DebugOptionsListener> DEBUG_REGISTRATION;
    private static final String NON_CHAINING_JARS_CACHE = "nonChainingJarsCache";
    private static final String EXTERNAL_FILES_CACHE = "externalFilesCache";
    private static final String ASSUMED_EXTERNAL_FILES_CACHE = "assumedExternalFilesCache";
    final JavaModel javaModel = new JavaModel();
    public HashMap<String, IPath> variables = new HashMap(5);
    public HashSet<String> variablesWithInitializer = new HashSet(5);
    public HashMap<String, String> deprecatedVariables = new HashMap(5);
    public HashSet<String> readOnlyVariables = new HashSet(5);
    public HashMap<String, IPath> previousSessionVariables = new HashMap(5);
    private final ThreadLocal<Set<String>> variableInitializationInProgress = new ThreadLocal();
    public HashMap<IJavaProject, Map<IPath, IClasspathContainer>> containers = new HashMap(5);
    public HashMap<IJavaProject, Map<IPath, IClasspathContainer>> previousSessionContainers = new HashMap(5);
    private final ThreadLocal<Map<IJavaProject, Set<IPath>>> containerInitializationInProgress = new ThreadLocal();
    ThreadLocal<Map<IJavaProject, Map<IPath, IClasspathContainer>>> containersBeingInitialized = new ThreadLocal();
    public static final int NO_BATCH_INITIALIZATION = 0;
    public static final int NEED_BATCH_INITIALIZATION = 1;
    public static final int BATCH_INITIALIZATION_IN_PROGRESS = 2;
    public static final int BATCH_INITIALIZATION_FINISHED = 3;
    public int batchContainerInitializations = 0;
    public Object batchContainerInitializationsLock = new Object();
    public BatchInitializationMonitor batchContainerInitializationsProgress = new BatchInitializationMonitor();
    public Hashtable<String, ClasspathContainerInitializer> containerInitializersCache = new Hashtable(5);
    private final ThreadLocal<Set<IJavaProject>> classpathsBeingResolved = new ThreadLocal();
    public JavaWorkspaceScope workspaceScope;
    private IConfigurationElement annotationProcessorManagerFactory = null;
    public Map<IPath, String> rootPathToAttachments = new Hashtable<IPath, String>();
    public static final String CP_VARIABLE_PREFERENCES_PREFIX = "org.eclipse.jdt.core.classpathVariable.";
    public static final String CP_CONTAINER_PREFERENCES_PREFIX = "org.eclipse.jdt.core.classpathContainer.";
    public static final String CP_USERLIBRARY_PREFERENCES_PREFIX = "org.eclipse.jdt.core.userLibrary.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    public static final IPath CP_ENTRY_IGNORE_PATH;
    public static final String TRUE = "true";
    private static final int VARIABLES_AND_CONTAINERS_FILE_VERSION = 2;
    public static final String CPVARIABLE_INITIALIZER_EXTPOINT_ID = "classpathVariableInitializer";
    public static final String CPCONTAINER_INITIALIZER_EXTPOINT_ID = "classpathContainerInitializer";
    public static final String FORMATTER_EXTPOINT_ID = "codeFormatter";
    public static final String COMPILATION_PARTICIPANT_EXTPOINT_ID = "compilationParticipant";
    public static final String ANNOTATION_PROCESSOR_MANAGER_EXTPOINT_ID = "annotationProcessorManager";
    private static final String RESOLVE_REFERENCED_LIBRARIES_FOR_CONTAINERS = "resolveReferencedLibrariesForContainers";
    public static final String MAX_COMPILED_UNITS_AT_ONCE = "maxCompiledUnitsAtOnce";
    public static final IPath VARIABLE_INITIALIZATION_IN_PROGRESS;
    public static final IClasspathContainer CONTAINER_INITIALIZATION_IN_PROGRESS;
    private static final String DEBUG = "org.eclipse.jdt.core/debug";
    private static final String BUFFER_MANAGER_DEBUG = "org.eclipse.jdt.core/debug/buffermanager";
    private static final String INDEX_MANAGER_DEBUG = "org.eclipse.jdt.core/debug/indexmanager";
    private static final String INDEX_MANAGER_ADVANCED_DEBUG = "org.eclipse.jdt.core/debug/indexmanager/advanced";
    private static final String COMPILER_DEBUG = "org.eclipse.jdt.core/debug/compiler";
    private static final String JAVAMODEL_CLASSPATH = "org.eclipse.jdt.core/debug/javamodel/classpath";
    private static final String JAVAMODEL_DEBUG = "org.eclipse.jdt.core/debug/javamodel";
    private static final String JAVAMODEL_STDOUT = "org.eclipse.jdt.core/debug/traceToStdOut";
    private static final String JAVAMODEL_INVALID_ARCHIVES = "org.eclipse.jdt.core/debug/javamodel/invalid_archives";
    private static final String JAVAMODELCACHE_DEBUG = "org.eclipse.jdt.core/debug/javamodel/cache";
    private static final String JAVAMODELCACHE_INSERTIONS_DEBUG = "org.eclipse.jdt.core/debug/javamodel/insertions";
    private static final String CP_RESOLVE_DEBUG = "org.eclipse.jdt.core/debug/cpresolution";
    private static final String CP_RESOLVE_ADVANCED_DEBUG = "org.eclipse.jdt.core/debug/cpresolution/advanced";
    private static final String CP_RESOLVE_FAILURE_DEBUG = "org.eclipse.jdt.core/debug/cpresolution/failure";
    private static final String ZIP_ACCESS_DEBUG = "org.eclipse.jdt.core/debug/zipaccess";
    private static final String ZIP_ACCESS_WARNING_DEBUG_ = "org.eclipse.jdt.core/debug/zipaccessWarning";
    private static final String DELTA_DEBUG = "org.eclipse.jdt.core/debug/javadelta";
    private static final String DELTA_DEBUG_VERBOSE = "org.eclipse.jdt.core/debug/javadelta/verbose";
    private static final String DOM_AST_DEBUG = "org.eclipse.jdt.core/debug/dom/ast";
    private static final String DOM_AST_DEBUG_THROW = "org.eclipse.jdt.core/debug/dom/ast/throw";
    private static final String DOM_REWRITE_DEBUG = "org.eclipse.jdt.core/debug/dom/rewrite";
    private static final String HIERARCHY_DEBUG = "org.eclipse.jdt.core/debug/hierarchy";
    private static final String POST_ACTION_DEBUG = "org.eclipse.jdt.core/debug/postaction";
    private static final String BUILDER_DEBUG = "org.eclipse.jdt.core/debug/builder";
    private static final String BUILDER_STATS_DEBUG = "org.eclipse.jdt.core/debug/builder/stats";
    private static final String COMPLETION_DEBUG = "org.eclipse.jdt.core/debug/completion";
    private static final String RESOLUTION_DEBUG = "org.eclipse.jdt.core/debug/resolution";
    private static final String SELECTION_DEBUG = "org.eclipse.jdt.core/debug/selection";
    private static final String SEARCH_DEBUG = "org.eclipse.jdt.core/debug/search";
    private static final String SOURCE_MAPPER_DEBUG_VERBOSE = "org.eclipse.jdt.core/debug/sourcemapper";
    private static final String FORMATTER_DEBUG = "org.eclipse.jdt.core/debug/formatter";
    public static final String COMPLETION_PERF = "org.eclipse.jdt.core/perf/completion";
    public static final String SELECTION_PERF = "org.eclipse.jdt.core/perf/selection";
    public static final String DELTA_LISTENER_PERF = "org.eclipse.jdt.core/perf/javadeltalistener";
    public static final String VARIABLE_INITIALIZER_PERF = "org.eclipse.jdt.core/perf/variableinitializer";
    public static final String CONTAINER_INITIALIZER_PERF = "org.eclipse.jdt.core/perf/containerinitializer";
    public static final String RECONCILE_PERF = "org.eclipse.jdt.core/perf/reconcile";
    public static boolean PERF_VARIABLE_INITIALIZER;
    public static boolean PERF_CONTAINER_INITIALIZER;
    boolean resolveReferencedLibrariesForContainers = false;
    public static final ICompilationUnit[] NO_WORKING_COPY;
    private static final int UNKNOWN_OPTION = 0;
    private static final int DEPRECATED_OPTION = 1;
    private static final int VALID_OPTION = 2;
    HashSet<String> optionNames = new HashSet(20);
    Map<String, String[]> deprecatedOptions = new HashMap<String, String[]>();
    volatile Hashtable<String, String> optionsCache;
    public final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    static final Object[][] NO_PARTICIPANTS;
    private static DebugTrace DEBUG_TRACE;
    private final Set<IProject> touchQueue = ConcurrentHashMap.newKeySet();
    public final CompilationParticipants compilationParticipants = new CompilationParticipants();
    public ThreadLocal<Boolean> abortOnMissingSource = new ThreadLocal();
    private final ExternalFoldersManager externalFoldersManager = ExternalFoldersManager.getExternalFoldersManager();
    private static JavaModelManager MANAGER;
    private JavaModelCache cache;
    private final ThreadLocal<HashMap<IJavaElement, IElementInfo>> temporaryCache = new ThreadLocal();
    protected HashSet<Openable> elementsOutOfSynchWithBuffers = new HashSet(11);
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    public IndexManager indexManager = null;
    protected Map<IProject, PerProjectInfo> perProjectInfos = new HashMap<IProject, PerProjectInfo>(5);
    protected HashMap<WorkingCopyOwner, Map<CompilationUnit, PerWorkingCopyInfo>> perWorkingCopyInfos = new HashMap(5);
    protected WeakHashMap<AbstractSearchScope, ?> searchScopes = new WeakHashMap();
    public static boolean VERBOSE;
    public static boolean DEBUG_CLASSPATH;
    public static boolean DEBUG_INVALID_ARCHIVES;
    public static boolean CP_RESOLVE_VERBOSE;
    public static boolean CP_RESOLVE_VERBOSE_ADVANCED;
    public static boolean CP_RESOLVE_VERBOSE_FAILURE;
    public static boolean ZIP_ACCESS_WARNING;
    public static boolean ZIP_ACCESS_VERBOSE;
    public static boolean JRT_ACCESS_VERBOSE;
    private final ThreadLocal<ZipCache> zipFiles = new ThreadLocal();
    private UserLibraryManager userLibraryManager;
    private ModuleSourcePathManager modulePathManager;
    private Set<IPath> nonChainingJars;
    private static long INVALID_ARCHIVE_TTL_MILLISECONDS;
    private static boolean TRACE_TO_STDOUT;
    private final Map<IPath, InvalidArchiveInfo> invalidArchives = new HashMap<IPath, InvalidArchiveInfo>();
    private Map<IPath, Boolean> externalFiles;
    private Set<IPath> assumedExternalFiles;
    EclipsePreferencesListener instancePreferencesListener = new EclipsePreferencesListener();
    IEclipsePreferences.INodeChangeListener instanceNodeListener = new IEclipsePreferences.INodeChangeListener(){

        public void added(IEclipsePreferences.NodeChangeEvent event) {
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getChild() == JavaModelManager.this.preferencesLookup[0]) {
                JavaModelManager.this.preferencesLookup[0] = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
                JavaModelManager.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
            }
        }
    };
    IEclipsePreferences.INodeChangeListener defaultNodeListener = new IEclipsePreferences.INodeChangeListener(){

        public void added(IEclipsePreferences.NodeChangeEvent event) {
        }

        public void removed(IEclipsePreferences.NodeChangeEvent event) {
            if (event.getChild() == JavaModelManager.this.preferencesLookup[1]) {
                JavaModelManager.this.preferencesLookup[1] = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.core");
            }
        }
    };
    IEclipsePreferences.IPreferenceChangeListener propertyListener;
    IEclipsePreferences.IPreferenceChangeListener resourcesPropertyListener;
    public static boolean throwIoExceptionsInGetZipFile;
    private final ThreadLocal<Map<IPath, Deque<Instant>>> lastAccessByPath = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<Instant> lastWarning = new ThreadLocal();
    private static ThreadLocal<Boolean> readOnly;

    static {
        CP_ENTRY_IGNORE_PATH = new Path(CP_ENTRY_IGNORE);
        VARIABLE_INITIALIZATION_IN_PROGRESS = new Path("Variable Initialization In Progress");
        CONTAINER_INITIALIZATION_IN_PROGRESS = new IClasspathContainer(){

            @Override
            public IClasspathEntry[] getClasspathEntries() {
                return null;
            }

            @Override
            public String getDescription() {
                return "Container Initialization In Progress";
            }

            @Override
            public int getKind() {
                return 0;
            }

            @Override
            public IPath getPath() {
                return null;
            }

            public String toString() {
                return this.getDescription();
            }
        };
        PERF_VARIABLE_INITIALIZER = false;
        PERF_CONTAINER_INITIALIZER = false;
        NO_WORKING_COPY = new ICompilationUnit[0];
        NO_PARTICIPANTS = new Object[0][];
        MANAGER = new JavaModelManager();
        VERBOSE = false;
        DEBUG_CLASSPATH = false;
        DEBUG_INVALID_ARCHIVES = false;
        CP_RESOLVE_VERBOSE = false;
        CP_RESOLVE_VERBOSE_ADVANCED = false;
        CP_RESOLVE_VERBOSE_FAILURE = false;
        ZIP_ACCESS_WARNING = false;
        ZIP_ACCESS_VERBOSE = false;
        JRT_ACCESS_VERBOSE = false;
        INVALID_ARCHIVE_TTL_MILLISECONDS = 120000L;
        throwIoExceptionsInGetZipFile = false;
        readOnly = ThreadLocal.withInitial(() -> Boolean.FALSE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean conflictsWithOutputLocation(IPath folderPath, JavaProject project) {
        try {
            IPath outputLocation = project.getOutputLocation();
            if (outputLocation == null) {
                return true;
            }
            if (!outputLocation.isPrefixOf(folderPath)) {
                return false;
            }
            IClasspathEntry[] classpath = project.getResolvedClasspath();
            boolean isOutputUsed = false;
            IClasspathEntry[] iClasspathEntryArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return isOutputUsed;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 3) {
                    if (entry.getPath().equals((Object)outputLocation)) {
                        return false;
                    }
                    if (entry.getOutputLocation() == null) {
                        isOutputUsed = true;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            return true;
        }
    }

    public synchronized IClasspathContainer containerGet(IJavaProject project, IPath containerPath) {
        if (this.containerIsInitializationInProgress(project, containerPath)) {
            return CONTAINER_INITIALIZATION_IN_PROGRESS;
        }
        Map<IPath, IClasspathContainer> projectContainers = this.containers.get(project);
        if (projectContainers == null) {
            return null;
        }
        IClasspathContainer container = projectContainers.get(containerPath);
        return container;
    }

    synchronized boolean containerIsSet(IJavaProject project, IPath containerPath) {
        Map<IPath, IClasspathContainer> projectContainers = this.containers.get(project);
        if (projectContainers == null) {
            return false;
        }
        IClasspathContainer container = projectContainers.get(containerPath);
        return container != null;
    }

    public synchronized IClasspathContainer containerGetDefaultToPreviousSession(IJavaProject project, IPath containerPath) {
        Map<IPath, IClasspathContainer> projectContainers = this.containers.get(project);
        if (projectContainers == null) {
            return this.getPreviousSessionContainer(containerPath, project);
        }
        IClasspathContainer container = projectContainers.get(containerPath);
        if (container == null) {
            return this.getPreviousSessionContainer(containerPath, project);
        }
        return container;
    }

    private boolean containerIsInitializationInProgress(IJavaProject project, IPath containerPath) {
        Map<IJavaProject, Set<IPath>> initializations = this.containerInitializationInProgress.get();
        if (initializations == null) {
            return false;
        }
        Set<IPath> projectInitializations = initializations.get(project);
        if (projectInitializations == null) {
            return false;
        }
        return projectInitializations.contains(containerPath);
    }

    private void containerAddInitializationInProgress(IJavaProject project, IPath containerPath) {
        Set<IPath> projectInitializations;
        Map<IJavaProject, Set<IPath>> initializations = this.containerInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashMap<IJavaProject, Set<IPath>>();
            this.containerInitializationInProgress.set(initializations);
        }
        if ((projectInitializations = initializations.get(project)) == null) {
            projectInitializations = new HashSet<IPath>();
            initializations.put(project, projectInitializations);
        }
        projectInitializations.add(containerPath);
    }

    public void containerBeingInitializedPut(IJavaProject project, IPath containerPath, IClasspathContainer container) {
        Map<IPath, IClasspathContainer> perPathContainers;
        Map<IJavaProject, Map<IPath, IClasspathContainer>> perProjectContainers = this.containersBeingInitialized.get();
        if (perProjectContainers == null) {
            perProjectContainers = new HashMap<IJavaProject, Map<IPath, IClasspathContainer>>();
            this.containersBeingInitialized.set(perProjectContainers);
        }
        if ((perPathContainers = perProjectContainers.get(project)) == null) {
            perPathContainers = new HashMap<IPath, IClasspathContainer>();
            perProjectContainers.put(project, perPathContainers);
        }
        perPathContainers.put(containerPath, container);
    }

    public IClasspathContainer containerBeingInitializedGet(IJavaProject project, IPath containerPath) {
        Map<IJavaProject, Map<IPath, IClasspathContainer>> perProjectContainers = this.containersBeingInitialized.get();
        if (perProjectContainers == null) {
            return null;
        }
        Map<IPath, IClasspathContainer> perPathContainers = perProjectContainers.get(project);
        if (perPathContainers == null) {
            return null;
        }
        return perPathContainers.get(containerPath);
    }

    public IClasspathContainer containerBeingInitializedRemove(IJavaProject project, IPath containerPath) {
        Map<IJavaProject, Map<IPath, IClasspathContainer>> perProjectContainers = this.containersBeingInitialized.get();
        if (perProjectContainers == null) {
            return null;
        }
        Map<IPath, IClasspathContainer> perPathContainers = perProjectContainers.get(project);
        if (perPathContainers == null) {
            return null;
        }
        IClasspathContainer container = perPathContainers.remove(containerPath);
        if (perPathContainers.size() == 0) {
            perProjectContainers.remove(project);
        }
        if (perProjectContainers.size() == 0) {
            this.containersBeingInitialized.remove();
        }
        return container;
    }

    public synchronized void containerPut(IJavaProject project, IPath containerPath, IClasspathContainer container) {
        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
            this.containerAddInitializationInProgress(project, containerPath);
            return;
        }
        this.containerRemoveInitializationInProgress(project, containerPath);
        Map<IPath, IClasspathContainer> projectContainers = this.containers.get(project);
        if (projectContainers == null) {
            projectContainers = new HashMap<IPath, IClasspathContainer>(1);
            this.containers.put(project, projectContainers);
        }
        if (container == null) {
            projectContainers.remove(containerPath);
        } else {
            projectContainers.put(containerPath, container);
        }
        Map<IPath, IClasspathContainer> previousContainers = this.previousSessionContainers.get(project);
        if (previousContainers != null) {
            previousContainers.remove(containerPath);
        }
    }

    public synchronized void containerRemove(IJavaProject project) {
        Map<IJavaProject, Set<IPath>> initializations = this.containerInitializationInProgress.get();
        if (initializations != null) {
            initializations.remove(project);
        }
        this.containers.remove(project);
    }

    public boolean containerPutIfInitializingWithSameEntries(IPath containerPath, IJavaProject[] projects, IClasspathContainer[] respectiveContainers) {
        int projectLength = projects.length;
        if (projectLength != 1) {
            return false;
        }
        IClasspathContainer container = respectiveContainers[0];
        IJavaProject project = projects[0];
        if (!this.containerIsInitializationInProgress(project, containerPath)) {
            return false;
        }
        IClasspathContainer previousContainer = this.containerGetDefaultToPreviousSession(project, containerPath);
        if (container == null) {
            if (previousContainer == null) {
                this.containerPut(project, containerPath, null);
                return true;
            }
            return false;
        }
        IClasspathEntry[] newEntries = container.getClasspathEntries();
        if (previousContainer == null) {
            if (newEntries.length == 0) {
                this.containerPut(project, containerPath, container);
                return true;
            }
            if (CP_RESOLVE_VERBOSE || CP_RESOLVE_VERBOSE_FAILURE) {
                this.verbose_missbehaving_container(containerPath, projects, respectiveContainers, container, newEntries, null);
            }
            return false;
        }
        IClasspathEntry[] oldEntries = previousContainer.getClasspathEntries();
        if (oldEntries.length != newEntries.length) {
            if (CP_RESOLVE_VERBOSE || CP_RESOLVE_VERBOSE_FAILURE) {
                this.verbose_missbehaving_container(containerPath, projects, respectiveContainers, container, newEntries, oldEntries);
            }
            return false;
        }
        int i = 0;
        int length = newEntries.length;
        while (i < length) {
            if (newEntries[i] == null) {
                if (CP_RESOLVE_VERBOSE || CP_RESOLVE_VERBOSE_FAILURE) {
                    this.verbose_missbehaving_container(project, containerPath, newEntries);
                }
                return false;
            }
            if (!newEntries[i].equals(oldEntries[i])) {
                if (CP_RESOLVE_VERBOSE || CP_RESOLVE_VERBOSE_FAILURE) {
                    this.verbose_missbehaving_container(containerPath, projects, respectiveContainers, container, newEntries, oldEntries);
                }
                return false;
            }
            ++i;
        }
        this.containerPut(project, containerPath, container);
        return true;
    }

    private void verbose_missbehaving_container(IPath containerPath, IJavaProject[] projects, IClasspathContainer[] respectiveContainers, final IClasspathContainer container, final IClasspathEntry[] newEntries, final IClasspathEntry[] oldEntries) {
        JavaModelManager.trace("CPContainer SET  - missbehaving container\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tprojects: {" + org.eclipse.jdt.internal.compiler.util.Util.toString((Object[])projects, (Util.Displayable)new Util.Displayable(){

            public String displayString(Object o) {
                return ((IJavaProject)o).getElementName();
            }
        }) + "}\n\tvalues on previous session: {\n" + org.eclipse.jdt.internal.compiler.util.Util.toString((Object[])respectiveContainers, (Util.Displayable)new Util.Displayable(){

            public String displayString(Object o) {
                StringBuilder buffer = new StringBuilder("\t\t");
                if (o == null) {
                    buffer.append("<null>");
                    return buffer.toString();
                }
                buffer.append(container.getDescription());
                buffer.append(" {\n");
                if (oldEntries == null) {
                    buffer.append(" \t\t\t");
                    buffer.append("<null>\n");
                } else {
                    IClasspathEntry[] iClasspathEntryArray = oldEntries;
                    int n = oldEntries.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry oldEntry = iClasspathEntryArray[n2];
                        buffer.append(" \t\t\t");
                        buffer.append(oldEntry);
                        buffer.append('\n');
                        ++n2;
                    }
                }
                buffer.append(" \t\t}");
                return buffer.toString();
            }
        }) + "}\n\tnew values: {\n" + org.eclipse.jdt.internal.compiler.util.Util.toString((Object[])respectiveContainers, (Util.Displayable)new Util.Displayable(){

            public String displayString(Object o) {
                StringBuilder buffer = new StringBuilder("\t\t");
                if (o == null) {
                    buffer.append("<null>");
                    return buffer.toString();
                }
                buffer.append(container.getDescription());
                buffer.append(" {\n");
                IClasspathEntry[] iClasspathEntryArray = newEntries;
                int n = newEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry newEntry = iClasspathEntryArray[n2];
                    buffer.append(" \t\t\t");
                    buffer.append(newEntry);
                    buffer.append('\n');
                    ++n2;
                }
                buffer.append(" \t\t}");
                return buffer.toString();
            }
        }) + "\n\t}");
    }

    void verbose_missbehaving_container(IJavaProject project, IPath containerPath, IClasspathEntry[] classpathEntries) {
        JavaModelManager.trace("CPContainer GET - missbehaving container (returning null classpath entry)\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tclasspath entries: {\n" + org.eclipse.jdt.internal.compiler.util.Util.toString((Object[])classpathEntries, (Util.Displayable)new Util.Displayable(){

            public String displayString(Object o) {
                StringBuilder buffer = new StringBuilder("\t\t");
                if (o == null) {
                    buffer.append("<null>");
                    return buffer.toString();
                }
                buffer.append(o);
                return buffer.toString();
            }
        }) + "\n\t}");
    }

    void verbose_missbehaving_container_null_entries(IJavaProject project, IPath containerPath) {
        JavaModelManager.trace("CPContainer GET - missbehaving container (returning null as classpath entries)\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tclasspath entries: <null>");
    }

    void containerRemoveInitializationInProgress(IJavaProject project, IPath containerPath) {
        Map<IJavaProject, Set<IPath>> initializations = this.containerInitializationInProgress.get();
        if (initializations == null) {
            return;
        }
        Set<IPath> projectInitializations = initializations.get(project);
        if (projectInitializations == null) {
            return;
        }
        projectInitializations.remove(containerPath);
        if (projectInitializations.size() == 0) {
            initializations.remove(project);
        }
        if (initializations.size() == 0) {
            this.containerInitializationInProgress.remove();
        }
    }

    private synchronized void containersReset(String[] containerIDs) {
        String[] stringArray = containerIDs;
        int n = containerIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String containerID = stringArray[n2];
            for (Map<IPath, IClasspathContainer> projectContainers : this.containers.values()) {
                if (projectContainers == null) continue;
                for (IPath containerPath : projectContainers.keySet()) {
                    if (!containerID.equals(containerPath.segment(0))) continue;
                    projectContainers.put(containerPath, null);
                }
            }
            ++n2;
        }
    }

    public static IJavaElement create(IResource resource, IJavaProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return JavaCore.create((IProject)resource);
            }
            case 1: {
                return JavaModelManager.create((IFile)resource, project);
            }
            case 2: {
                return JavaModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return JavaCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IJavaElement create(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if (file.getFileExtension() != null) {
            String name = file.getName();
            if (Util.isJavaLikeFileName(name)) {
                return JavaModelManager.createCompilationUnitFrom(file, project);
            }
            if (org.eclipse.jdt.internal.compiler.util.Util.isClassFileName((String)name)) {
                return JavaModelManager.createClassFileFrom(file, project);
            }
            return JavaModelManager.createJarPackageFragmentRootFrom(file, project);
        }
        return null;
    }

    public static IJavaElement create(IFolder folder, IJavaProject project) {
        IJavaElement element;
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(folder.getProject());
            element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
            if (element == null) {
                IJavaProject[] projects;
                try {
                    projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
                }
                catch (JavaModelException e) {
                    return null;
                }
                IJavaProject[] iJavaProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject p = iJavaProjectArray[n2];
                    project = p;
                    element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
                    if (element == null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
        }
        return element;
    }

    public static IClassFile createClassFileFrom(IFile file, IJavaProject project) {
        String fileName;
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)file, project)) == null) {
            PackageFragmentRoot root = (PackageFragmentRoot)project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment(CharOperation.NO_STRINGS);
        }
        if ("module-info.class".equals(fileName = file.getName())) {
            return pkg.getModularClassFile();
        }
        return pkg.getClassFile(file.getName());
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)file, project)) == null) {
            PackageFragmentRoot root = (PackageFragmentRoot)project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment(CharOperation.NO_STRINGS);
            if (VERBOSE) {
                JavaModelManager.trace("WARNING : creating unit element outside classpath (" + String.valueOf(Thread.currentThread()) + "): " + String.valueOf(file.getFullPath()));
            }
        }
        return pkg.getCompilationUnit(file.getName());
    }

    public static IPackageFragmentRoot createJarPackageFragmentRootFrom(IFile file, IJavaProject project) {
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        IPath resourcePath = file.getFullPath();
        try {
            IClasspathEntry entry = ((JavaProject)project).getClasspathEntryFor(resourcePath);
            if (entry != null) {
                return project.getPackageFragmentRoot((IResource)file);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IJavaElement determineIfOnClasspath(IResource resource, IJavaProject project) {
        IPath resourcePath = resource.getFullPath();
        boolean isExternal = ExternalFoldersManager.isInternalPathForExternalFolder(resourcePath);
        if (isExternal) {
            resourcePath = resource.getLocation();
        }
        try {
            JavaProjectElementInfo projectInfo = (JavaProjectElementInfo)JavaModelManager.getJavaModelManager().getInfo(project);
            JavaProjectElementInfo.ProjectCache projectCache = projectInfo == null ? null : projectInfo.projectCache;
            HashtableOfArrayToObject allPkgFragmentsCache = projectCache == null ? null : projectCache.allPkgFragmentsCache;
            boolean isJavaLike = Util.isJavaLikeFileName(resourcePath.lastSegment());
            IClasspathEntry[] entries = isJavaLike ? project.getRawClasspath() : ((JavaProject)project).getResolvedClasspath();
            int length = entries.length;
            if (length <= 0) return null;
            String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            String complianceLevel = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            int i = 0;
            while (true) {
                if (i >= length) {
                    return null;
                }
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 2) {
                    IPath rootPath = entry.getPath();
                    if (rootPath.equals((Object)resourcePath)) {
                        if (!isJavaLike) return project.getPackageFragmentRoot(resource);
                        return null;
                    }
                    if (rootPath.isPrefixOf(resourcePath) && !Util.isExcluded(resource, ((ClasspathEntry)entry).fullInclusionPatternChars(), ((ClasspathEntry)entry).fullExclusionPatternChars())) {
                        PackageFragmentRoot root;
                        PackageFragmentRoot packageFragmentRoot = root = isExternal ? new ExternalPackageFragmentRoot(rootPath, (JavaProject)project) : (PackageFragmentRoot)((JavaProject)project).getFolderPackageFragmentRoot(rootPath);
                        if (root == null) {
                            return null;
                        }
                        IPath pkgPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
                        if (resource.getType() == 1) {
                            pkgPath = pkgPath.removeLastSegments(1);
                        }
                        Object[] pkgName = pkgPath.segments();
                        if (allPkgFragmentsCache != null && allPkgFragmentsCache.containsKey(pkgName)) {
                            return root.getPackageFragment((String[])pkgName);
                        }
                        if (pkgName.length == 0) return root.getPackageFragment((String[])pkgName);
                        if (JavaConventions.validatePackageName(Util.packageName(pkgPath, sourceLevel, complianceLevel), sourceLevel, complianceLevel).getSeverity() != 4) return root.getPackageFragment((String[])pkgName);
                        return null;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException npe) {
            return null;
        }
    }

    private JavaModelManager() {
        if (Platform.isRunning()) {
            this.indexManager = new IndexManager();
            this.nonChainingJars = this.loadClasspathListCache(NON_CHAINING_JARS_CACHE);
            Set<IPath> external = this.loadClasspathListCache(EXTERNAL_FILES_CACHE);
            this.externalFiles = new ConcurrentHashMap<IPath, Boolean>();
            for (IPath p : external) {
                this.externalFiles.put(p, Boolean.TRUE);
            }
            this.assumedExternalFiles = this.loadClasspathListCache(ASSUMED_EXTERNAL_FILES_CACHE);
            String includeContainerReferencedLib = System.getProperty(RESOLVE_REFERENCED_LIBRARIES_FOR_CONTAINERS);
            this.resolveReferencedLibrariesForContainers = TRUE.equalsIgnoreCase(includeContainerReferencedLib);
        }
    }

    private void addDeprecatedOptions(Hashtable<String, String> options) {
        options.put("org.eclipse.jdt.core.compiler.problem.invalidImport", "error");
        options.put("org.eclipse.jdt.core.compiler.problem.unreachableCode", "error");
    }

    public void addNonChainingJar(IPath path) {
        if (this.nonChainingJars != null) {
            this.nonChainingJars.add(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvalidArchive(IPath path, ArchiveValidity reason) {
        if (DEBUG_INVALID_ARCHIVES) {
            JavaModelManager.trace("JAR cache: adding " + String.valueOf((Object)reason) + " " + String.valueOf(path));
        }
        Map<IPath, InvalidArchiveInfo> map = this.invalidArchives;
        synchronized (map) {
            this.invalidArchives.put(path, new InvalidArchiveInfo(System.currentTimeMillis() + INVALID_ARCHIVE_TTL_MILLISECONDS, reason));
        }
    }

    public void addExternalFile(IPath path, boolean exits) {
        if (this.externalFiles == null) {
            this.externalFiles = new ConcurrentHashMap<IPath, Boolean>();
        }
        if (this.externalFiles != null) {
            this.externalFiles.put(path, exits);
        }
    }

    public void cacheZipFiles(Object owner) {
        ZipCache zipCache = this.zipFiles.get();
        if (zipCache != null) {
            return;
        }
        this.zipFiles.set(new ZipCache(owner));
    }

    public void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        if (this.zipFiles.get() != null) {
            if (ZIP_ACCESS_VERBOSE) {
                JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [JavaModelManager.closeZipFile(ZipFile)] NOT closed ZipFile (cache exist!) on " + zipFile.getName());
            }
            return;
        }
        try {
            if (ZIP_ACCESS_VERBOSE) {
                JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [JavaModelManager.closeZipFile(ZipFile)] Closing ZipFile on " + zipFile.getName());
            }
            zipFile.close();
        }
        catch (IOException e) {
            JavaCore.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Error closing " + zipFile.getName(), (Throwable)e));
        }
    }

    public static void registerDebugOptionsListener(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        properties.put("listener.symbolic.name", "org.eclipse.jdt.core");
        DEBUG_REGISTRATION = context.registerService(DebugOptionsListener.class, (Object)new DebugOptionsListener(){

            public void optionsChanged(DebugOptions options) {
                DEBUG_TRACE = options.newDebugTrace("org.eclipse.jdt.core", JavaModelManager.class);
                boolean debug = options.getBooleanOption(JavaModelManager.DEBUG, false);
                BufferManager.VERBOSE = debug && options.getBooleanOption(JavaModelManager.BUFFER_MANAGER_DEBUG, false);
                JavaBuilder.DEBUG = debug && options.getBooleanOption(JavaModelManager.BUILDER_DEBUG, false);
                Compiler.DEBUG = debug && options.getBooleanOption(JavaModelManager.COMPILER_DEBUG, false);
                JavaBuilder.SHOW_STATS = debug && options.getBooleanOption(JavaModelManager.BUILDER_STATS_DEBUG, false);
                CompletionEngine.DEBUG = debug && options.getBooleanOption(JavaModelManager.COMPLETION_DEBUG, false);
                CP_RESOLVE_VERBOSE = debug && options.getBooleanOption(JavaModelManager.CP_RESOLVE_DEBUG, false);
                CP_RESOLVE_VERBOSE_ADVANCED = debug && options.getBooleanOption(JavaModelManager.CP_RESOLVE_ADVANCED_DEBUG, false);
                CP_RESOLVE_VERBOSE_FAILURE = debug && options.getBooleanOption(JavaModelManager.CP_RESOLVE_FAILURE_DEBUG, false);
                DeltaProcessor.DEBUG = debug && options.getBooleanOption(JavaModelManager.DELTA_DEBUG, false);
                DeltaProcessor.VERBOSE = debug && options.getBooleanOption(JavaModelManager.DELTA_DEBUG_VERBOSE, false);
                SourceRangeVerifier.DEBUG = debug && options.getBooleanOption(JavaModelManager.DOM_AST_DEBUG, false);
                SourceRangeVerifier.DEBUG_THROW = debug && options.getBooleanOption(JavaModelManager.DOM_AST_DEBUG_THROW, false);
                SourceRangeVerifier.DEBUG |= SourceRangeVerifier.DEBUG_THROW;
                RewriteEventStore.DEBUG = debug && options.getBooleanOption(JavaModelManager.DOM_REWRITE_DEBUG, false);
                TypeHierarchy.DEBUG = debug && options.getBooleanOption(JavaModelManager.HIERARCHY_DEBUG, false);
                JobManager.VERBOSE = debug && options.getBooleanOption(JavaModelManager.INDEX_MANAGER_DEBUG, false);
                IndexManager.DEBUG = debug && options.getBooleanOption(JavaModelManager.INDEX_MANAGER_ADVANCED_DEBUG, false);
                DEBUG_CLASSPATH = debug && options.getBooleanOption(JavaModelManager.JAVAMODEL_CLASSPATH, false);
                DEBUG_INVALID_ARCHIVES = debug && options.getBooleanOption(JavaModelManager.JAVAMODEL_INVALID_ARCHIVES, false);
                VERBOSE = debug && options.getBooleanOption(JavaModelManager.JAVAMODEL_DEBUG, false);
                TRACE_TO_STDOUT = debug && options.getBooleanOption(JavaModelManager.JAVAMODEL_STDOUT, false);
                JavaModelCache.VERBOSE = debug && options.getBooleanOption(JavaModelManager.JAVAMODELCACHE_DEBUG, false);
                JavaModelCache.DEBUG_CACHE_INSERTIONS = debug && options.getBooleanOption(JavaModelManager.JAVAMODELCACHE_INSERTIONS_DEBUG, false);
                JavaModelOperation.POST_ACTION_VERBOSE = debug && options.getBooleanOption(JavaModelManager.POST_ACTION_DEBUG, false);
                NameLookup.VERBOSE = debug && options.getBooleanOption(JavaModelManager.RESOLUTION_DEBUG, false);
                BasicSearchEngine.VERBOSE = debug && options.getBooleanOption(JavaModelManager.SEARCH_DEBUG, false);
                SelectionEngine.DEBUG = debug && options.getBooleanOption(JavaModelManager.SELECTION_DEBUG, false);
                ZIP_ACCESS_VERBOSE = debug && options.getBooleanOption(JavaModelManager.ZIP_ACCESS_DEBUG, false);
                ZIP_ACCESS_WARNING = debug && options.getBooleanOption(JavaModelManager.ZIP_ACCESS_WARNING_DEBUG_, false);
                SourceMapper.VERBOSE = debug && options.getBooleanOption(JavaModelManager.SOURCE_MAPPER_DEBUG_VERBOSE, false);
                boolean bl = DefaultCodeFormatter.DEBUG = debug && options.getBooleanOption(JavaModelManager.FORMATTER_DEBUG, false);
                if (PerformanceStats.ENABLED) {
                    CompletionEngine.PERF = PerformanceStats.isEnabled((String)JavaModelManager.COMPLETION_PERF);
                    SelectionEngine.PERF = PerformanceStats.isEnabled((String)JavaModelManager.SELECTION_PERF);
                    DeltaProcessor.PERF = PerformanceStats.isEnabled((String)JavaModelManager.DELTA_LISTENER_PERF);
                    PERF_VARIABLE_INITIALIZER = PerformanceStats.isEnabled((String)JavaModelManager.VARIABLE_INITIALIZER_PERF);
                    PERF_CONTAINER_INITIALIZER = PerformanceStats.isEnabled((String)JavaModelManager.CONTAINER_INITIALIZER_PERF);
                    ReconcileWorkingCopyOperation.PERF = PerformanceStats.isEnabled((String)JavaModelManager.RECONCILE_PERF);
                }
            }
        }, properties);
    }

    public static void unregisterDebugOptionsListener() {
        DEBUG_REGISTRATION.unregister();
        DEBUG_REGISTRATION = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractAnnotationProcessorManager createAnnotationProcessorManager() {
        block10: {
            JavaModelManager javaModelManager = this;
            synchronized (javaModelManager) {
                IExtensionPoint extension;
                block9: {
                    if (this.annotationProcessorManagerFactory != null) break block10;
                    extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", ANNOTATION_PROCESSOR_MANAGER_EXTPOINT_ID);
                    if (extension != null) break block9;
                    return null;
                }
                IExtension[] extensions = extension.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configElements;
                    if (i > 0) {
                        Util.log(null, "An annotation processor manager is already registered: ignoring " + extensions[i].getUniqueIdentifier());
                        break;
                    }
                    IConfigurationElement[] iConfigurationElementArray = configElements = extensions[i].getConfigurationElements();
                    int n = configElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement configElement = iConfigurationElementArray[n2];
                        if (ANNOTATION_PROCESSOR_MANAGER_EXTPOINT_ID.equals(configElement.getName())) {
                            this.annotationProcessorManagerFactory = configElement;
                            break;
                        }
                        ++n2;
                    }
                    ++i;
                }
            }
        }
        if (this.annotationProcessorManagerFactory == null) {
            return null;
        }
        final AbstractAnnotationProcessorManager[] apm = new AbstractAnnotationProcessorManager[]{null};
        final IConfigurationElement factory = this.annotationProcessorManagerFactory;
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                Util.log(exception, "Exception occurred while loading annotation processor manager");
            }

            public void run() throws Exception {
                Object executableExtension = factory.createExecutableExtension("class");
                if (executableExtension instanceof AbstractAnnotationProcessorManager) {
                    apm[0] = (AbstractAnnotationProcessorManager)executableExtension;
                }
            }
        });
        return apm[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discardPerWorkingCopyInfo(CompilationUnit workingCopy) throws JavaModelException {
        JavaElementDeltaBuilder deltaBuilder = null;
        if (workingCopy.isPrimary() && workingCopy.hasUnsavedChanges()) {
            deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
        }
        PerWorkingCopyInfo info = null;
        HashMap<WorkingCopyOwner, Map<CompilationUnit, PerWorkingCopyInfo>> hashMap = this.perWorkingCopyInfos;
        synchronized (hashMap) {
            Map<CompilationUnit, PerWorkingCopyInfo> workingCopyToInfos;
            WorkingCopyOwner owner;
            block12: {
                block11: {
                    owner = workingCopy.owner;
                    workingCopyToInfos = this.perWorkingCopyInfos.get(owner);
                    if (workingCopyToInfos != null) break block11;
                    return -1;
                }
                info = workingCopyToInfos.get(workingCopy);
                if (info != null) break block12;
                return -1;
            }
            if (--info.useCount == 0) {
                workingCopyToInfos.remove(workingCopy);
                if (workingCopyToInfos.isEmpty()) {
                    this.perWorkingCopyInfos.remove(owner);
                }
            }
        }
        if (info.useCount == 0) {
            this.removeInfoAndChildren(workingCopy);
            workingCopy.closeBuffer();
            if (deltaBuilder != null) {
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null) {
                    this.getDeltaProcessor().registerJavaModelDelta(deltaBuilder.delta);
                }
            }
        }
        return info.useCount;
    }

    public void doneSaving(ISaveContext context) {
    }

    public void flushZipFiles(Object owner) {
        ZipCache zipCache = this.zipFiles.get();
        if (zipCache == null) {
            if (ZIP_ACCESS_VERBOSE) {
                JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [JavaModelManager.flushZipFiles(String)] NOT found cache for " + String.valueOf(owner));
            }
            return;
        }
        if (zipCache.owner == owner) {
            this.zipFiles.remove();
            zipCache.flush();
        } else if (ZIP_ACCESS_VERBOSE) {
            JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [JavaModelManager.flushZipFiles(String)] NOT closed cache, wrong owner, expected: " + String.valueOf(zipCache.owner) + ", got: " + String.valueOf(owner));
        }
    }

    public synchronized boolean forceBatchInitializations(boolean initAfterLoad) {
        switch (this.batchContainerInitializations) {
            case 0: {
                this.batchContainerInitializations = 1;
                return true;
            }
            case 3: {
                if (initAfterLoad) {
                    return false;
                }
                this.batchContainerInitializations = 1;
                return true;
            }
        }
        return false;
    }

    private synchronized boolean batchContainerInitializations() {
        switch (this.batchContainerInitializations) {
            case 1: {
                this.batchContainerInitializations = 2;
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private synchronized void batchInitializationFinished() {
        this.batchContainerInitializations = 3;
    }

    public IClasspathContainer getClasspathContainer(IPath containerPath, IJavaProject project) throws JavaModelException {
        IClasspathContainer container = this.containerGet(project, containerPath);
        if (container == null) {
            if (this.batchContainerInitializations()) {
                try {
                    container = this.initializeAllContainers(project, containerPath);
                }
                finally {
                    this.batchInitializationFinished();
                }
            } else {
                container = this.initializeContainer(project, containerPath);
                this.containerBeingInitializedRemove(project, containerPath);
                SetContainerOperation operation = new SetContainerOperation(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{container});
                operation.runOperation(null);
            }
        }
        return container;
    }

    public IClasspathEntry[] getReferencedClasspathEntries(IClasspathEntry libraryEntry, IJavaProject project) {
        IClasspathEntry[] referencedEntries = ((ClasspathEntry)libraryEntry).resolvedChainedLibraries();
        if (project == null) {
            return referencedEntries;
        }
        PerProjectInfo perProjectInfo = this.getPerProjectInfo(project.getProject(), false);
        if (perProjectInfo == null) {
            return referencedEntries;
        }
        LinkedHashSet<IPath> pathToReferencedEntries = new LinkedHashSet<IPath>(referencedEntries.length);
        int index = 0;
        while (index < referencedEntries.length) {
            if (!pathToReferencedEntries.contains(referencedEntries[index].getPath())) {
                IClasspathEntry persistedEntry = null;
                persistedEntry = perProjectInfo.rootPathToResolvedEntries.get(referencedEntries[index].getPath());
                if (persistedEntry != null) {
                    referencedEntries[index] = persistedEntry;
                }
                pathToReferencedEntries.add(referencedEntries[index].getPath());
            }
            ++index;
        }
        return referencedEntries;
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    public static DeltaProcessingState getDeltaState() {
        return JavaModelManager.MANAGER.deltaState;
    }

    protected HashSet<Openable> getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public static ExternalFoldersManager getExternalManager() {
        return JavaModelManager.MANAGER.externalFoldersManager;
    }

    public static IndexManager getIndexManager() {
        return JavaModelManager.MANAGER.indexManager;
    }

    public synchronized IElementInfo getInfo(IJavaElement element) {
        IElementInfo result;
        HashMap<IJavaElement, IElementInfo> tempCache = this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.getInfo(element);
    }

    public synchronized IJavaElement getExistingElement(IJavaElement element) {
        return this.cache.getExistingElement(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<IJavaProject> getExternalWorkingCopyProjects() {
        HashMap<WorkingCopyOwner, Map<CompilationUnit, PerWorkingCopyInfo>> hashMap = this.perWorkingCopyInfos;
        synchronized (hashMap) {
            HashSet<IJavaProject> result = null;
            for (Map<CompilationUnit, PerWorkingCopyInfo> ownerCopies : this.perWorkingCopyInfos.values()) {
                for (ICompilationUnit iCompilationUnit : ownerCopies.keySet()) {
                    IJavaProject project = iCompilationUnit.getJavaProject();
                    if (!project.getElementName().equals(" ")) continue;
                    if (result == null) {
                        result = new HashSet<IJavaProject>();
                    }
                    result.add(project);
                }
            }
            return result;
        }
    }

    public IEclipsePreferences getInstancePreferences() {
        return this.preferencesLookup[0];
    }

    public Hashtable<String, String> getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>(10);
        IEclipsePreferences defaultPreferences = this.getDefaultPreferences();
        for (String propertyName : this.optionNames) {
            String value = defaultPreferences.get(propertyName, null);
            if (value == null) continue;
            defaultOptions.put(propertyName, value);
        }
        defaultOptions.put("org.eclipse.jdt.core.encoding", JavaCore.getEncoding());
        this.addDeprecatedOptions(defaultOptions);
        return defaultOptions;
    }

    public IEclipsePreferences getDefaultPreferences() {
        return this.preferencesLookup[1];
    }

    public final JavaModel getJavaModel() {
        return this.javaModel;
    }

    public static final JavaModelManager getJavaModelManager() {
        return MANAGER;
    }

    public Object getLastBuiltState(IProject project, IProgressMonitor monitor) {
        if (!JavaProject.hasJavaNature(project)) {
            if (JavaBuilder.DEBUG) {
                JavaModelManager.trace(String.valueOf(project) + " is not a Java project");
            }
            return null;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        if (!info.triedRead) {
            info.triedRead = true;
            try {
                if (monitor != null) {
                    monitor.subTask(Messages.bind(Messages.build_readStateProgress, project.getName()));
                }
                info.savedState = this.readState(project);
            }
            catch (CoreException e) {
                Util.log(e, "Exception while reading last build state for: " + String.valueOf(project));
            }
        }
        return info.savedState;
    }

    public String getOption(String optionName) {
        if ("org.eclipse.jdt.core.encoding".equals(optionName)) {
            return JavaCore.getEncoding();
        }
        if (this.isDeprecatedOption(optionName)) {
            return "error";
        }
        int optionLevel = this.getOptionLevel(optionName);
        if (optionLevel != 0) {
            IPreferencesService service = Platform.getPreferencesService();
            String value = service.get(optionName, null, (Preferences[])this.preferencesLookup);
            if (value == null && optionLevel == 1) {
                String[] compatibleOptions = this.deprecatedOptions.get(optionName);
                value = service.get(compatibleOptions[0], null, (Preferences[])this.preferencesLookup);
            }
            return value == null ? null : value.trim();
        }
        return null;
    }

    public String getOption(String optionName, boolean inheritJavaCoreOptions, IEclipsePreferences projectPreferences) {
        switch (this.getOptionLevel(optionName)) {
            case 2: {
                String javaCoreDefault;
                String string = javaCoreDefault = inheritJavaCoreOptions ? JavaCore.getOption(optionName) : null;
                if (projectPreferences == null) {
                    return javaCoreDefault;
                }
                String value = projectPreferences.get(optionName, javaCoreDefault);
                return value == null ? null : value.trim();
            }
            case 1: {
                String oldValue = projectPreferences.get(optionName, null);
                if (oldValue != null) {
                    return oldValue.trim();
                }
                String[] compatibleOptions = this.deprecatedOptions.get(optionName);
                String newDefault = inheritJavaCoreOptions ? JavaCore.getOption(compatibleOptions[0]) : null;
                String newValue = projectPreferences.get(compatibleOptions[0], newDefault);
                return newValue == null ? null : newValue.trim();
            }
        }
        return null;
    }

    public boolean knowsOption(String optionName) {
        boolean knownOption = this.optionNames.contains(optionName);
        if (!knownOption) {
            knownOption = this.deprecatedOptions.get(optionName) != null;
        }
        return knownOption;
    }

    public int getOptionLevel(String optionName) {
        if (this.optionNames.contains(optionName)) {
            return 2;
        }
        if (this.deprecatedOptions.get(optionName) != null) {
            return 1;
        }
        return 0;
    }

    public Hashtable<String, String> getOptions() {
        Hashtable<String, String> cachedOptions = this.optionsCache;
        if (cachedOptions != null) {
            return new Hashtable<String, String>(cachedOptions);
        }
        if (!Platform.isRunning()) {
            Hashtable<String, String> defaults = this.getDefaultOptionsNoInitialization();
            this.optionsCache = defaults;
            return new Hashtable<String, String>(defaults);
        }
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        IPreferencesService service = Platform.getPreferencesService();
        for (String string : this.optionNames) {
            String propertyValue = service.get(string, null, (Preferences[])this.preferencesLookup);
            if (propertyValue == null) continue;
            options.put(string, propertyValue);
        }
        for (Map.Entry entry : this.deprecatedOptions.entrySet()) {
            String[] compatibleOptions;
            String propertyName = (String)entry.getKey();
            String propertyValue = service.get(propertyName, null, (Preferences[])this.preferencesLookup);
            if (propertyValue == null) continue;
            options.put(propertyName, propertyValue);
            String[] stringArray = compatibleOptions = (String[])entry.getValue();
            int n = compatibleOptions.length;
            int n2 = 0;
            while (n2 < n) {
                String compatibleOption = stringArray[n2];
                if (!options.containsKey(compatibleOption)) {
                    options.put(compatibleOption, propertyValue);
                }
                ++n2;
            }
        }
        options.put("org.eclipse.jdt.core.encoding", JavaCore.getEncoding());
        this.addDeprecatedOptions(options);
        Util.fixTaskTags(options);
        this.optionsCache = new Hashtable<String, String>(options);
        return options;
    }

    private Hashtable<String, String> getDefaultOptionsNoInitialization() {
        Map defaultOptionsMap = new CompilerOptions().getMap();
        defaultOptionsMap.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        defaultOptionsMap.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        defaultOptionsMap.put("org.eclipse.jdt.core.compiler.taskTags", "TODO,FIXME,XXX");
        defaultOptionsMap.put("org.eclipse.jdt.core.compiler.taskPriorities", "NORMAL,HIGH,NORMAL");
        defaultOptionsMap.put("org.eclipse.jdt.core.compiler.taskCaseSensitive", "enabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        defaultOptionsMap.put("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.builder.invalidClasspath", "abort");
        defaultOptionsMap.put("org.eclipse.jdt.core.builder.duplicateResourceTask", "warning");
        defaultOptionsMap.put("org.eclipse.jdt.core.builder.cleanOutputFolder", "clean");
        defaultOptionsMap.put("org.eclipse.jdt.core.builder.annotationPath.allLocations", "disabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.computeJavaBuildOrder", "ignore");
        defaultOptionsMap.put("org.eclipse.jdt.core.incompleteClasspath", "error");
        defaultOptionsMap.put("org.eclipse.jdt.core.circularClasspath", "error");
        defaultOptionsMap.put("org.eclipse.jdt.core.incompatibleJDKLevel", "ignore");
        defaultOptionsMap.put("org.eclipse.jdt.core.classpath.mainOnlyProjectHasTestOnlyDependency", "error");
        defaultOptionsMap.put("org.eclipse.jdt.core.classpath.outputOverlappingAnotherSource", "error");
        defaultOptionsMap.put("org.eclipse.jdt.core.classpath.exclusionPatterns", "enabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.classpath.multipleOutputLocations", "enabled");
        defaultOptionsMap.putAll(DefaultCodeFormatterConstants.getEclipseDefaultSettings());
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.visibilityCheck", "disabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.deprecationCheck", "disabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.forceImplicitQualification", "disabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.fieldPrefixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.staticFieldPrefixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.staticFinalFieldPrefixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.localPrefixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.argumentPrefixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.fieldSuffixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.staticFieldSuffixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.staticFinalFieldSuffixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.localSuffixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.argumentSuffixes", "");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck", "enabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck", "disabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.camelCaseMatch", "enabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.subwordMatch", "enabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.codeComplete.suggestStaticImports", "enabled");
        defaultOptionsMap.put("org.eclipse.jdt.core.timeoutForParameterNameFromAttachedJavadoc", "50");
        return new Hashtable<String, String>(defaultOptionsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfos.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws JavaModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!JavaProject.hasJavaNature(project)) {
                throw ((JavaProject)JavaCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerWorkingCopyInfo getPerWorkingCopyInfo(CompilationUnit workingCopy, boolean create, boolean recordUsage, IProblemRequestor problemRequestor) {
        HashMap<WorkingCopyOwner, Map<CompilationUnit, PerWorkingCopyInfo>> hashMap = this.perWorkingCopyInfos;
        synchronized (hashMap) {
            PerWorkingCopyInfo info;
            WorkingCopyOwner owner = workingCopy.owner;
            Map<CompilationUnit, PerWorkingCopyInfo> workingCopyToInfos = this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null && create) {
                workingCopyToInfos = new HashMap<CompilationUnit, PerWorkingCopyInfo>();
                this.perWorkingCopyInfos.put(owner, workingCopyToInfos);
            }
            PerWorkingCopyInfo perWorkingCopyInfo = info = workingCopyToInfos == null ? null : workingCopyToInfos.get(workingCopy);
            if (info == null && create) {
                info = new PerWorkingCopyInfo(workingCopy, problemRequestor);
                workingCopyToInfos.put(workingCopy, info);
            }
            if (info != null && recordUsage) {
                ++info.useCount;
            }
            return info;
        }
    }

    public IClasspathContainer getPreviousSessionContainer(IPath containerPath, IJavaProject project) {
        IClasspathContainer previousContainer;
        Map<IPath, IClasspathContainer> previousContainerValues = this.previousSessionContainers.get(project);
        if (previousContainerValues != null && (previousContainer = previousContainerValues.get(containerPath)) != null) {
            if (CP_RESOLVE_VERBOSE_ADVANCED) {
                this.verbose_reentering_project_container_access(containerPath, project, previousContainer);
            }
            return previousContainer;
        }
        return null;
    }

    private void verbose_reentering_project_container_access(IPath containerPath, IJavaProject project, IClasspathContainer previousContainer) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CPContainer INIT - reentering access to project container during its initialization, will see previous value\n");
        buffer.append("\tproject: " + project.getElementName() + "\n");
        buffer.append("\tcontainer path: " + String.valueOf(containerPath) + "\n");
        buffer.append("\tprevious value: ");
        buffer.append(previousContainer.getDescription());
        buffer.append(" {\n");
        IClasspathEntry[] entries = previousContainer.getClasspathEntries();
        if (entries != null) {
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                buffer.append(" \t\t");
                buffer.append(entry);
                buffer.append('\n');
                ++n2;
            }
        }
        buffer.append(" \t}");
        JavaModelManager.trace(buffer.toString(), new Exception("<Fake exception>"));
    }

    public IPath getPreviousSessionVariable(String variableName) {
        IPath previousPath = this.previousSessionVariables.get(variableName);
        if (previousPath != null) {
            if (CP_RESOLVE_VERBOSE_ADVANCED) {
                this.verbose_reentering_variable_access(variableName, previousPath);
            }
            return previousPath;
        }
        return null;
    }

    private void verbose_reentering_variable_access(String variableName, IPath previousPath) {
        JavaModelManager.trace("CPVariable INIT - reentering access to variable during its initialization, will see previous value\n\tvariable: " + variableName + "\n\tprevious value: " + String.valueOf(previousPath), new Exception("<Fake exception>"));
    }

    public HashMap<IJavaElement, IElementInfo> getTemporaryCache() {
        HashMap<IJavaElement, IElementInfo> result = this.temporaryCache.get();
        if (result == null) {
            result = new HashMap<IJavaElement, IElementInfo>(){
                private static final long serialVersionUID = 1L;

                @Override
                public IElementInfo put(IJavaElement key, IElementInfo value) {
                    return super.put(key, value);
                }
            };
            this.temporaryCache.set(result);
        }
        return result;
    }

    private File getVariableAndContainersFile() {
        return JavaCore.getPlugin().getStateLocation().append("variablesAndContainers.dat").toFile();
    }

    public static String[] getRegisteredVariableNames() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> variableList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", CPVARIABLE_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String varAttribute = configElement.getAttribute("variable");
                    if (varAttribute != null) {
                        variableList.add(varAttribute);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        String[] variableNames = new String[variableList.size()];
        variableList.toArray(variableNames);
        return variableNames;
    }

    public static String[] getRegisteredContainerIDs() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList<String> containerIDList = new ArrayList<String>(5);
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", CPCONTAINER_INITIALIZER_EXTPOINT_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String idAttribute = configElement.getAttribute("id");
                    if (idAttribute != null) {
                        containerIDList.add(idAttribute);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        String[] containerIDs = new String[containerIDList.size()];
        containerIDList.toArray(containerIDs);
        return containerIDs;
    }

    public IClasspathEntry resolveVariableEntry(IClasspathEntry entry, boolean usePreviousSession) {
        if (entry.getEntryKind() != 4) {
            return entry;
        }
        IPath resolvedPath = this.getResolvedVariablePath(entry.getPath(), usePreviousSession);
        if (resolvedPath == null) {
            return null;
        }
        Object target = JavaModel.getTarget(resolvedPath = ClasspathEntry.resolveDotDot(null, resolvedPath), false);
        if (target == null) {
            return null;
        }
        if (target instanceof IResource) {
            IResource resolvedResource = (IResource)target;
            switch (resolvedResource.getType()) {
                case 4: {
                    return JavaCore.newProjectEntry(resolvedPath, entry.getAccessRules(), entry.combineAccessRules(), entry.getExtraAttributes(), entry.isExported());
                }
                case 1: {
                    return JavaCore.newLibraryEntry(resolvedPath, this.getResolvedVariablePath(entry.getSourceAttachmentPath(), usePreviousSession), this.getResolvedVariablePath(entry.getSourceAttachmentRootPath(), usePreviousSession), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
                }
                case 2: {
                    return JavaCore.newLibraryEntry(resolvedPath, this.getResolvedVariablePath(entry.getSourceAttachmentPath(), usePreviousSession), this.getResolvedVariablePath(entry.getSourceAttachmentRootPath(), usePreviousSession), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
                }
            }
        }
        if (target instanceof File) {
            File tf = (File)target;
            File externalFile = JavaModel.getFile(tf);
            if (externalFile != null) {
                return JavaCore.newLibraryEntry(resolvedPath, this.getResolvedVariablePath(entry.getSourceAttachmentPath(), usePreviousSession), this.getResolvedVariablePath(entry.getSourceAttachmentRootPath(), usePreviousSession), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
            }
            if (resolvedPath.isAbsolute()) {
                return JavaCore.newLibraryEntry(resolvedPath, this.getResolvedVariablePath(entry.getSourceAttachmentPath(), usePreviousSession), this.getResolvedVariablePath(entry.getSourceAttachmentRootPath(), usePreviousSession), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
            }
        }
        return null;
    }

    public IPath getResolvedVariablePath(IPath variablePath, boolean usePreviousSession) {
        IPath resolvedPath;
        if (variablePath == null) {
            return null;
        }
        int count = variablePath.segmentCount();
        if (count == 0) {
            return null;
        }
        String variableName = variablePath.segment(0);
        IPath iPath = resolvedPath = usePreviousSession ? this.getPreviousSessionVariable(variableName) : JavaCore.getClasspathVariable(variableName);
        if (resolvedPath == null) {
            return null;
        }
        if (count > 1) {
            resolvedPath = resolvedPath.append(variablePath.removeFirstSegments(1));
        }
        return resolvedPath;
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.jdt.core");
        return workingLocation.append("state.dat").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserLibraryManager getUserLibraryManager() {
        if (JavaModelManager.MANAGER.userLibraryManager == null) {
            UserLibraryManager libraryManager = new UserLibraryManager();
            JavaModelManager javaModelManager = MANAGER;
            synchronized (javaModelManager) {
                if (JavaModelManager.MANAGER.userLibraryManager == null) {
                    JavaModelManager.MANAGER.userLibraryManager = libraryManager;
                }
            }
        }
        return JavaModelManager.MANAGER.userLibraryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSourcePathManager getModulePathManager() {
        if (JavaModelManager.MANAGER.modulePathManager == null) {
            ModuleSourcePathManager modulePathManager = new ModuleSourcePathManager();
            JavaModelManager javaModelManager = MANAGER;
            synchronized (javaModelManager) {
                if (JavaModelManager.MANAGER.modulePathManager == null) {
                    JavaModelManager.MANAGER.modulePathManager = modulePathManager;
                }
            }
        }
        return JavaModelManager.MANAGER.modulePathManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompilationUnit[] getWorkingCopies(WorkingCopyOwner owner, boolean addPrimary) {
        HashMap<WorkingCopyOwner, Map<CompilationUnit, PerWorkingCopyInfo>> hashMap = this.perWorkingCopyInfos;
        synchronized (hashMap) {
            ICompilationUnit[] primaryWCs = addPrimary && owner != DefaultWorkingCopyOwner.PRIMARY ? this.getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false) : null;
            Map<CompilationUnit, PerWorkingCopyInfo> workingCopyToInfos = this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null) {
                return primaryWCs;
            }
            int primaryLength = primaryWCs == null ? 0 : primaryWCs.length;
            int size = workingCopyToInfos.size();
            ICompilationUnit[] result = new ICompilationUnit[primaryLength + size];
            int index = 0;
            if (primaryWCs != null) {
                int i = 0;
                while (i < primaryLength) {
                    ICompilationUnit primaryWorkingCopy = primaryWCs[i];
                    CompilationUnit workingCopy = new CompilationUnit((PackageFragment)primaryWorkingCopy.getParent(), primaryWorkingCopy.getElementName(), owner);
                    if (!workingCopyToInfos.containsKey(workingCopy)) {
                        result[index++] = primaryWorkingCopy;
                    }
                    ++i;
                }
                if (index != primaryLength) {
                    ICompilationUnit[] iCompilationUnitArray = result;
                    result = new ICompilationUnit[index + size];
                    System.arraycopy(iCompilationUnitArray, 0, result, 0, index);
                }
            }
            for (PerWorkingCopyInfo info : workingCopyToInfos.values()) {
                result[index++] = info.getWorkingCopy();
            }
            return result;
        }
    }

    public JavaWorkspaceScope getWorkspaceScope() {
        if (this.workspaceScope == null) {
            this.workspaceScope = new JavaWorkspaceScope();
        }
        return this.workspaceScope;
    }

    public static boolean isJrt(IPath path) {
        return path.toString().endsWith("jrt-fs.jar");
    }

    public static boolean isJrt(String path) {
        return JavaModelManager.isJrt((IPath)new Path(path));
    }

    public void verifyArchiveContent(IPath path) throws CoreException {
        if (JavaModelManager.isJrt(path)) {
            return;
        }
        if (this.isArchiveStateKnownToBeValid(path)) {
            return;
        }
        ZipFile file = this.getZipFile(path);
        this.closeZipFile(file);
    }

    public ZipFile getZipFile(IPath path) throws CoreException {
        return this.getZipFile(path, true);
    }

    private void traceZipAccessWarning(IPath path) {
        long elapsedMs;
        Instant now = Instant.now();
        Deque lastAcesses = this.lastAccessByPath.get().compute(path, (p, l) -> l == null ? new ArrayDeque() : l);
        Instant recentAccess = (Instant)lastAcesses.peekFirst();
        Instant lastAccess = (Instant)lastAcesses.peekLast();
        lastAcesses.offerLast(now);
        if (lastAccess != null && (elapsedMs = lastAccess.until(now, ChronoUnit.MILLIS)) <= 100000L) {
            JavaModelManager.trace(String.valueOf(path) + " opened again in this thread after " + elapsedMs + "ms");
        }
        if (recentAccess != null && lastAcesses.size() > 2) {
            long elapsedWarningMs;
            elapsedMs = recentAccess.until(now, ChronoUnit.MILLIS);
            lastAcesses.pollFirst();
            Instant lastInstant = this.lastWarning.get();
            long l2 = elapsedWarningMs = lastInstant == null ? Long.MAX_VALUE : lastInstant.until(now, ChronoUnit.MILLIS);
            if (elapsedMs < 100L && elapsedWarningMs > 1000L) {
                this.lastWarning.set(now);
                new Exception("Zipfile was opened multiple times wihtin " + elapsedMs + "ms in same thread " + String.valueOf(Thread.currentThread()) + ", consider caching: " + String.valueOf(path)).printStackTrace();
            }
        }
    }

    public ZipFile getZipFile(IPath path, boolean checkInvalidArchiveCache) throws CoreException {
        ZipFile zipFile;
        ZipCache zipCache;
        if (checkInvalidArchiveCache) {
            this.isArchiveStateKnownToBeValid(path);
        }
        if ((zipCache = this.zipFiles.get()) != null && (zipFile = zipCache.getCache(path)) != null) {
            return zipFile;
        }
        File localFile = JavaModelManager.getLocalFile(path);
        try {
            if (ZIP_ACCESS_WARNING) {
                this.traceZipAccessWarning(path);
            }
            if (ZIP_ACCESS_VERBOSE) {
                JavaModelManager.trace("(" + String.valueOf(Thread.currentThread()) + ") [JavaModelManager.getZipFile(IPath)] Creating ZipFile on " + String.valueOf(localFile));
            }
            if (throwIoExceptionsInGetZipFile) {
                throw new IOException();
            }
            zipFile = new ZipFile(localFile);
            if (zipCache != null) {
                zipCache.setCache(path, zipFile);
            }
            this.addInvalidArchive(path, ArchiveValidity.VALID);
            return zipFile;
        }
        catch (IOException e) {
            ArchiveValidity reason = ArchiveValidity.INVALID;
            this.addInvalidArchive(path, reason);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", -1, Messages.status_IOException, (Throwable)e));
        }
    }

    public static File getLocalFile(IPath path) throws CoreException {
        File localFile = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource file = root.findMember(path);
        if (file != null) {
            URI location;
            if (file.getType() != 1 || (location = file.getLocationURI()) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", -1, Messages.bind(Messages.file_notFound, path.toString()), null));
            }
            localFile = Util.toLocalFile(location, null);
            if (localFile == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", -1, Messages.bind(Messages.file_notFound, path.toString()), null));
            }
        } else {
            localFile = path.toFile();
        }
        return localFile;
    }

    private boolean isArchiveStateKnownToBeValid(IPath path) throws CoreException {
        ArchiveValidity validity = this.getArchiveValidity(path);
        return validity != null && validity != ArchiveValidity.INVALID;
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    private IClasspathContainer initializeAllContainers(IJavaProject javaProjectToInit, IPath containerToInit) throws JavaModelException {
        block18: {
            IProject[] projects;
            if (CP_RESOLVE_VERBOSE_ADVANCED) {
                this.verbose_batching_containers_initialization(javaProjectToInit, containerToInit);
            }
            final HashMap<IJavaProject, HashSet<IPath>> allContainerPaths = new HashMap<IJavaProject, HashSet<IPath>>();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (JavaProject.hasJavaNature(project)) {
                    IClasspathEntry[] rawClasspath;
                    JavaProject javaProject = new JavaProject(project, this.getJavaModel());
                    HashSet<IPath> paths = (HashSet<IPath>)allContainerPaths.get(javaProject);
                    IClasspathEntry[] iClasspathEntryArray = rawClasspath = javaProject.getRawClasspath();
                    int n3 = rawClasspath.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathEntry entry = iClasspathEntryArray[n4];
                        IPath path = entry.getPath();
                        if (entry.getEntryKind() == 5 && this.containerGet(javaProject, path) == null) {
                            if (paths == null) {
                                paths = new HashSet<IPath>();
                                allContainerPaths.put(javaProject, paths);
                            }
                            paths.add(path);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (javaProjectToInit != null) {
                HashSet<IPath> containerPaths = (HashSet<IPath>)allContainerPaths.get(javaProjectToInit);
                if (containerPaths == null) {
                    containerPaths = new HashSet<IPath>();
                    allContainerPaths.put(javaProjectToInit, containerPaths);
                }
                containerPaths.add(containerToInit);
            }
            boolean ok = false;
            try {
                try {
                    IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run(IProgressMonitor monitor) throws CoreException {
                            try {
                                Set entrySet = allContainerPaths.entrySet();
                                int length = entrySet.size();
                                if (monitor != null) {
                                    monitor.beginTask("", length);
                                }
                                HashSet entries = new HashSet(entrySet);
                                for (Map.Entry entry : entries) {
                                    IJavaProject javaProject = (IJavaProject)entry.getKey();
                                    Set pathSet = (Set)entry.getValue();
                                    if (pathSet == null) continue;
                                    int length2 = pathSet.size();
                                    IPath[] paths = new IPath[length2];
                                    pathSet.toArray(paths);
                                    int j = 0;
                                    while (j < length2) {
                                        block18: {
                                            IPath path = paths[j];
                                            Object object = JavaModelManager.this.batchContainerInitializationsLock;
                                            synchronized (object) {
                                                if (JavaModelManager.this.containerIsSet(javaProject, path)) {
                                                    break block18;
                                                }
                                            }
                                            JavaModelManager.this.initializeContainer(javaProject, path);
                                            IClasspathContainer container = JavaModelManager.this.containerBeingInitializedGet(javaProject, path);
                                            if (container != null) {
                                                Object object2 = JavaModelManager.this.batchContainerInitializationsLock;
                                                synchronized (object2) {
                                                    if (JavaModelManager.this.containerIsSet(javaProject, path)) {
                                                        JavaModelManager.this.containerBeingInitializedRemove(javaProject, path);
                                                        JavaModelManager.this.containerRemoveInitializationInProgress(javaProject, path);
                                                    } else {
                                                        JavaModelManager.this.containerPut(javaProject, path, container);
                                                    }
                                                }
                                            }
                                        }
                                        ++j;
                                    }
                                    if (monitor == null) continue;
                                    monitor.worked(1);
                                }
                                Map<IJavaProject, Map<IPath, IClasspathContainer>> map = JavaModelManager.this.containersBeingInitialized.get();
                                while (map != null && !map.isEmpty()) {
                                    this.initKnownContainers(map, monitor);
                                }
                                JavaModelManager.this.containersBeingInitialized.remove();
                            }
                            finally {
                                if (monitor != null) {
                                    monitor.done();
                                }
                            }
                        }

                        private void initKnownContainers(Map<IJavaProject, Map<IPath, IClasspathContainer>> perProjectContainers, IProgressMonitor monitor) throws JavaModelException {
                            ArrayList<SetContainerOperation> operations = new ArrayList<SetContainerOperation>();
                            for (Map.Entry<IJavaProject, Map<IPath, IClasspathContainer>> entry : perProjectContainers.entrySet()) {
                                IJavaProject project = entry.getKey();
                                Map<IPath, IClasspathContainer> perPathContainers = entry.getValue();
                                for (Map.Entry<IPath, IClasspathContainer> containerEntry : perPathContainers.entrySet()) {
                                    IPath containerPath = containerEntry.getKey();
                                    IClasspathContainer container = containerEntry.getValue();
                                    SetContainerOperation operation = new SetContainerOperation(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{container});
                                    operations.add(operation);
                                }
                            }
                            perProjectContainers.clear();
                            for (SetContainerOperation operation : operations) {
                                operation.runOperation(monitor);
                            }
                        }
                    };
                    BatchInitializationMonitor monitor = this.batchContainerInitializationsProgress;
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (workspace.isTreeLocked()) {
                        runnable.run((IProgressMonitor)monitor);
                    } else {
                        workspace.run(runnable, null, 1, (IProgressMonitor)monitor);
                    }
                    ok = true;
                }
                catch (CoreException e) {
                    Util.log(e, "Exception while initializing all containers");
                    if (!ok) {
                        this.containerInitializationInProgress.remove();
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (!ok) {
                    this.containerInitializationInProgress.remove();
                }
                throw throwable;
            }
            if (!ok) {
                this.containerInitializationInProgress.remove();
            }
        }
        return this.containerGet(javaProjectToInit, containerToInit);
    }

    private void verbose_batching_containers_initialization(IJavaProject javaProjectToInit, IPath containerToInit) {
        JavaModelManager.trace("CPContainer INIT - batching containers initialization\n\tproject to init: " + (javaProjectToInit == null ? "null" : javaProjectToInit.getElementName()) + "\n\tcontainer path to init: " + String.valueOf(containerToInit));
    }

    /*
     * Unable to fully structure code
     */
    IClasspathContainer initializeContainer(IJavaProject project, IPath containerPath) throws JavaModelException {
        block25: {
            block24: {
                monitor = this.batchContainerInitializationsProgress;
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                container = null;
                initializer = JavaCore.getClasspathContainerInitializer(containerPath.segment(0));
                if (initializer == null) break block24;
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    this.verbose_triggering_container_initialization(project, containerPath, initializer);
                }
                if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                    this.verbose_triggering_container_initialization_invocation_trace();
                }
                stats = null;
                if (JavaModelManager.PERF_CONTAINER_INITIALIZER) {
                    stats = PerformanceStats.getStats((String)"org.eclipse.jdt.core/perf/containerinitializer", (Object)this);
                    stats.startRun(String.valueOf(containerPath) + " of " + String.valueOf(project.getPath()));
                }
                this.containerPut(project, containerPath, JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS);
                ok = false;
                try {
                    if (monitor != null) {
                        monitor.subTask(Messages.bind(Messages.javamodel_configuring, initializer.getDescription(containerPath, project)));
                    }
                    initializer.initialize(containerPath, project);
                    if (monitor != null) {
                        monitor.subTask("");
                    }
                    if ((container = this.containerBeingInitializedGet(project, containerPath)) != null || this.containerGet(project, containerPath) != JavaModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) ** GOTO lbl33
                    container = initializer.getFailureContainer(containerPath, project);
                    if (container == null) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                            this.verbose_container_null_failure_container(project, containerPath, initializer);
                        }
                        return null;
                    }
                    try {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                            this.verbose_container_using_failure_container(project, containerPath, initializer);
                        }
                        this.containerPut(project, containerPath, container);
lbl33:
                        // 2 sources

                        ok = true;
                    }
                    catch (CoreException e) {
                        if (e instanceof JavaModelException) {
                            throw (JavaModelException)e;
                        }
                        throw new JavaModelException(e);
                    }
                    catch (Error | RuntimeException e) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                            JavaModelManager.trace("", new Exception(e));
                        }
                        throw e;
                    }
                }
                finally {
                    if (JavaModelManager.PERF_CONTAINER_INITIALIZER) {
                        stats.endRun();
                    }
                    if (!ok) {
                        this.containerRemoveInitializationInProgress(project, containerPath);
                        if (JavaModelManager.CP_RESOLVE_VERBOSE || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                            this.verbose_container_initialization_failed(project, containerPath, container, initializer);
                        }
                    }
                }
                if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED) {
                    this.verbose_container_value_after_initialization(project, containerPath, container);
                }
                break block25;
            }
            container = new ClasspathContainerInitializer(){

                @Override
                public void initialize(IPath path, IJavaProject javaProject) throws CoreException {
                }
            }.getFailureContainer(containerPath, project);
            if (JavaModelManager.CP_RESOLVE_VERBOSE_ADVANCED || JavaModelManager.CP_RESOLVE_VERBOSE_FAILURE) {
                this.verbose_no_container_initializer_found(project, containerPath);
            }
        }
        return container;
    }

    private void verbose_no_container_initializer_found(IJavaProject project, IPath containerPath) {
        JavaModelManager.trace("CPContainer INIT - no initializer found\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath));
    }

    private void verbose_container_value_after_initialization(IJavaProject project, IPath containerPath, IClasspathContainer container) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CPContainer INIT - after resolution\n");
        buffer.append("\tproject: " + project.getElementName() + "\n");
        buffer.append("\tcontainer path: " + String.valueOf(containerPath) + "\n");
        if (container != null) {
            buffer.append("\tcontainer: " + container.getDescription() + " {\n");
            IClasspathEntry[] entries = container.getClasspathEntries();
            if (entries != null) {
                IClasspathEntry[] iClasspathEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    buffer.append("\t\t" + String.valueOf(entry) + "\n");
                    ++n2;
                }
            }
            buffer.append("\t}");
        } else {
            buffer.append("\tcontainer: {unbound}");
        }
        JavaModelManager.trace(buffer.toString());
    }

    private void verbose_container_initialization_failed(IJavaProject project, IPath containerPath, IClasspathContainer container, ClasspathContainerInitializer initializer) {
        if (container == CONTAINER_INITIALIZATION_IN_PROGRESS) {
            JavaModelManager.trace("CPContainer INIT - FAILED (initializer did not initialize container)\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tinitializer: " + String.valueOf(initializer));
        } else {
            JavaModelManager.trace("CPContainer INIT - FAILED (see exception above)\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tinitializer: " + String.valueOf(initializer));
        }
    }

    private void verbose_container_null_failure_container(IJavaProject project, IPath containerPath, ClasspathContainerInitializer initializer) {
        JavaModelManager.trace("CPContainer INIT - FAILED (and failure container is null)\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tinitializer: " + String.valueOf(initializer));
    }

    private void verbose_container_using_failure_container(IJavaProject project, IPath containerPath, ClasspathContainerInitializer initializer) {
        JavaModelManager.trace("CPContainer INIT - FAILED (using failure container)\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tinitializer: " + String.valueOf(initializer));
    }

    private void verbose_triggering_container_initialization(IJavaProject project, IPath containerPath, ClasspathContainerInitializer initializer) {
        JavaModelManager.trace("CPContainer INIT - triggering initialization\n\tproject: " + project.getElementName() + "\n\tcontainer path: " + String.valueOf(containerPath) + "\n\tinitializer: " + String.valueOf(initializer));
    }

    private void verbose_triggering_container_initialization_invocation_trace() {
        JavaModelManager.trace("CPContainer INIT - triggering initialization\n\tinvocation trace:", new Exception("<Fake exception>"));
    }

    public void initializePreferences() {
        this.preferencesLookup[0] = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
        this.preferencesLookup[1] = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.core");
        this.instanceNodeListener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == JavaModelManager.this.preferencesLookup[0]) {
                    JavaModelManager.this.preferencesLookup[0] = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
                    JavaModelManager.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new EclipsePreferencesListener());
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener(this.instanceNodeListener);
        this.instancePreferencesListener = new EclipsePreferencesListener();
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.instancePreferencesListener);
        this.defaultNodeListener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == JavaModelManager.this.preferencesLookup[1]) {
                    JavaModelManager.this.preferencesLookup[1] = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.core");
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener(this.defaultNodeListener);
    }

    void touchProjectsAsync(IProject[] projectsToTouch) throws JavaModelException {
        IProject[] iProjectArray = projectsToTouch;
        int n = projectsToTouch.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            this.touchQueue.add(iProject);
            ++n2;
        }
        TouchJob.INSTANCE.schedule();
    }

    private Set<IJavaProject> getClasspathBeingResolved() {
        Set<IJavaProject> result = this.classpathsBeingResolved.get();
        if (result == null) {
            result = new HashSet<IJavaProject>();
            this.classpathsBeingResolved.set(result);
        }
        return result;
    }

    public boolean isClasspathBeingResolved(IJavaProject project) {
        return this.getClasspathBeingResolved().contains(project);
    }

    private boolean isDeprecatedOption(String optionName) {
        return "org.eclipse.jdt.core.compiler.problem.invalidImport".equals(optionName) || "org.eclipse.jdt.core.compiler.problem.unreachableCode".equals(optionName);
    }

    public boolean isNonChainingJar(IPath path) {
        return this.nonChainingJars != null && this.nonChainingJars.contains(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveValidity getArchiveValidity(IPath path) {
        InvalidArchiveInfo invalidArchiveInfo;
        Map<IPath, InvalidArchiveInfo> map = this.invalidArchives;
        synchronized (map) {
            invalidArchiveInfo = this.invalidArchives.get(path);
        }
        if (invalidArchiveInfo == null) {
            if (DEBUG_INVALID_ARCHIVES) {
                JavaModelManager.trace("JAR cache: UNKNOWN validity for " + String.valueOf(path));
            }
            return null;
        }
        long now = System.currentTimeMillis();
        if (now > invalidArchiveInfo.evictionTimestamp) {
            try {
                ZipFile zipFile = this.getZipFile(path, false);
                this.closeZipFile(zipFile);
                this.removeFromInvalidArchiveCache(path);
                this.addInvalidArchive(path, ArchiveValidity.VALID);
                return ArchiveValidity.VALID;
            }
            catch (CoreException coreException) {
                this.addInvalidArchive(path, ArchiveValidity.INVALID);
                return ArchiveValidity.INVALID;
            }
        }
        if (DEBUG_INVALID_ARCHIVES) {
            JavaModelManager.trace("JAR cache: " + String.valueOf((Object)invalidArchiveInfo.reason) + " " + String.valueOf(path));
        }
        return invalidArchiveInfo.reason;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromInvalidArchiveCache(IPath path) {
        Map<IPath, InvalidArchiveInfo> map = this.invalidArchives;
        synchronized (map) {
            InvalidArchiveInfo entry = this.invalidArchives.get(path);
            if (entry != null && entry.reason == ArchiveValidity.VALID) {
                if (DEBUG_INVALID_ARCHIVES) {
                    JavaModelManager.trace("JAR cache: keep VALID " + String.valueOf(path));
                }
                return;
            }
            if (this.invalidArchives.remove(path) != null) {
                if (DEBUG_INVALID_ARCHIVES) {
                    JavaModelManager.trace("JAR cache: removed INVALID " + String.valueOf(path));
                }
                try {
                    IJavaProject[] iJavaProjectArray = this.getJavaModel().getJavaProjects();
                    int n = iJavaProjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaProject project = iJavaProjectArray[n2];
                        if (project.findPackageFragmentRoot(path) != null) {
                            ((JavaProject)project).resetCaches();
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)((Object)e), "Unable to retrieve the Java model.");
                }
            }
        }
    }

    public boolean isExternalFile(IPath path) {
        if (this.externalFiles == null) {
            return false;
        }
        Boolean exists = this.externalFiles.get(path);
        return exists == null ? false : exists;
    }

    public boolean knownToNotExistOnFileSystem(IPath path) {
        if (this.externalFiles == null) {
            return false;
        }
        Boolean exists = this.externalFiles.get(path);
        return exists == null ? false : exists == false;
    }

    public void clearExternalFileState(IPath path) {
        if (this.externalFiles != null) {
            this.externalFiles.remove(path);
        }
    }

    public void resetExternalFilesCache() {
        if (this.externalFiles != null) {
            this.externalFiles.clear();
        }
    }

    public boolean isAssumedExternalFile(IPath path) {
        if (this.assumedExternalFiles == null) {
            return false;
        }
        return this.assumedExternalFiles.contains(path);
    }

    public void addAssumedExternalFile(IPath path) {
        this.assumedExternalFiles.add(path);
    }

    public void setClasspathBeingResolved(IJavaProject project, boolean classpathIsResolved) {
        if (classpathIsResolved) {
            this.getClasspathBeingResolved().add(project);
        } else {
            this.getClasspathBeingResolved().remove(project);
        }
    }

    private Set<IPath> loadClasspathListCache(String cacheName) {
        HashSet<IPath> pathCache;
        block12: {
            pathCache = new HashSet<IPath>();
            File cacheFile = this.getClasspathListFile(cacheName);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(cacheFile)));){
                    int size = in.readInt();
                    while (size-- > 0) {
                        String path = in.readUTF();
                        pathCache.add(Path.fromPortableString((String)path));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (!cacheFile.exists()) break block12;
                Util.log(e, "Unable to read JavaModelManager " + cacheName + " file");
            }
        }
        return Collections.synchronizedSet(pathCache);
    }

    private File getClasspathListFile(String fileName) {
        return JavaCore.getPlugin().getStateLocation().append(fileName).toFile();
    }

    private Set<IPath> getNonChainingJarsCache() throws CoreException {
        IJavaProject[] projects;
        if (this.nonChainingJars != null && this.nonChainingJars.size() > 0) {
            return this.nonChainingJars;
        }
        HashSet<IPath> result = new HashSet<IPath>();
        IJavaProject[] iJavaProjectArray = projects = this.getJavaModel().getJavaProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry[] classpath;
            IJavaProject javaProject = iJavaProjectArray[n2];
            IClasspathEntry[] iClasspathEntryArray = classpath = ((JavaProject)javaProject).getResolvedClasspath();
            int n3 = classpath.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath path;
                IClasspathEntry entry = iClasspathEntryArray[n4];
                if (entry.getEntryKind() == 1 && !result.contains(path = entry.getPath()) && ClasspathEntry.resolvedChainedLibraries(path).length == 0) {
                    result.add(path);
                }
                ++n4;
            }
            ++n2;
        }
        this.nonChainingJars = Collections.synchronizedSet(result);
        return this.nonChainingJars;
    }

    private Set<IPath> getClasspathListCache(String cacheName) throws CoreException {
        if (cacheName == NON_CHAINING_JARS_CACHE) {
            return this.getNonChainingJarsCache();
        }
        if (cacheName == EXTERNAL_FILES_CACHE) {
            return this.externalFiles.entrySet().stream().filter(e -> (Boolean)e.getValue()).map(e -> (IPath)e.getKey()).collect(Collectors.toSet());
        }
        if (cacheName == ASSUMED_EXTERNAL_FILES_CACHE) {
            return this.assumedExternalFiles;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void loadVariablesAndContainers() throws CoreException {
        block50: {
            block44: {
                block48: {
                    block49: {
                        block46: {
                            block47: {
                                qName = new QualifiedName("org.eclipse.jdt.core", "variables");
                                xmlString = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qName);
                                if (xmlString == null) break block44;
                                try {
                                    var4_3 = null;
                                    var5_9 = null;
                                    try {
                                        reader = new StringReader(xmlString);
                                        try {
                                            parser = XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE();
                                            cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                                        }
                                        finally {
                                            if (reader != null) {
                                                reader.close();
                                            }
                                        }
                                    }
                                    catch (Throwable var5_10) {
                                        if (var4_3 == null) {
                                            var4_3 = var5_10;
                                        } else if (var4_3 != var5_10) {
                                            var4_3.addSuppressed(var5_10);
                                        }
                                        throw var4_3;
                                    }
                                }
                                catch (ParserConfigurationException | SAXException e) {
                                    if (xmlString != null) {
                                        ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                                    }
                                    return;
                                }
                                if (cpElement != null) break block46;
                                if (xmlString == null) break block47;
                                ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                            }
                            return;
                        }
                        if (cpElement.getNodeName().equalsIgnoreCase("variables")) break block48;
                        if (xmlString == null) break block49;
                        ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                    }
                    return;
                }
                try {
                    try {
                        list = cpElement.getChildNodes();
                        length = list.getLength();
                        i = 0;
                        while (i < length) {
                            node = list.item(i);
                            type = node.getNodeType();
                            if (type == 1 && (element = (Element)node).getNodeName().equalsIgnoreCase("variable")) {
                                this.variablePut(element.getAttribute("name"), (IPath)new Path(element.getAttribute("path")));
                            }
                            ++i;
                        }
                    }
                    catch (IOException cpElement) {
                        if (xmlString == null) ** GOTO lbl68
                        ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                    }
                }
                catch (Throwable var10_30) {
                    if (xmlString != null) {
                        ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
                    }
                    throw var10_30;
                }
            }
            if (xmlString != null) {
                ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qName, null);
            }
lbl68:
            // 5 sources

            this.loadVariablesAndContainers(this.getDefaultPreferences());
            this.loadVariablesAndContainers(this.getInstancePreferences());
            file = this.getVariableAndContainersFile();
            try {
                list = null;
                length = null;
                try {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    try {
                        switch (in.readInt()) {
                            case 2: {
                                new VariablesAndContainersLoadHelper(in).load();
                                ** break;
lbl81:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                size = in.readInt();
                                while (size-- > 0) {
                                    varName = in.readUTF();
                                    pathString = in.readUTF();
                                    if ("##<cp entry ignore>##".equals(pathString)) continue;
                                    varPath = Path.fromPortableString((String)pathString);
                                    this.variables.put(varName, varPath);
                                    this.previousSessionVariables.put(varName, varPath);
                                }
                                model = this.getJavaModel();
                                projectSize = in.readInt();
                                while (projectSize-- > 0) {
                                    projectName = in.readUTF();
                                    project = model.getJavaProject(projectName);
                                    containerSize = in.readInt();
                                    while (containerSize-- > 0) {
                                        containerPath = Path.fromPortableString((String)in.readUTF());
                                        length = in.readInt();
                                        containerString = new byte[length];
                                        in.readFully(containerString);
                                        JavaModelManager.recreatePersistedContainer(project, containerPath, new String(containerString), true);
                                    }
                                }
                                break;
                            }
                            ** default:
lbl110:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                catch (Throwable length) {
                    if (list == null) {
                        list = length;
                    } else if (list != length) {
                        list.addSuppressed(length);
                    }
                    throw list;
                }
            }
            catch (IOException e) {
                if (file.exists()) {
                    Util.log(e, "Unable to read variable and containers file");
                }
            }
            catch (RuntimeException e) {
                if (!file.exists()) break block50;
                Util.log(e, "Unable to read variable and containers file (file is corrupt)");
            }
        }
        var8_27 = registeredVariables = JavaModelManager.getRegisteredVariableNames();
        var7_21 = registeredVariables.length;
        var6_18 = 0;
        while (var6_18 < var7_21) {
            varName = var8_27[var6_18];
            this.variables.put(varName, null);
            ++var6_18;
        }
        this.containersReset(JavaModelManager.getRegisteredContainerIDs());
    }

    private void loadVariablesAndContainers(IEclipsePreferences preferences) {
        try {
            String[] propertyNames = preferences.keys();
            int variablePrefixLength = CP_VARIABLE_PREFERENCES_PREFIX.length();
            String[] stringArray = propertyNames;
            int n = propertyNames.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyValue;
                String propertyName = stringArray[n2];
                if (propertyName.startsWith(CP_VARIABLE_PREFERENCES_PREFIX)) {
                    String varName = propertyName.substring(variablePrefixLength);
                    String propertyValue2 = preferences.get(propertyName, null);
                    if (propertyValue2 != null) {
                        String pathString = propertyValue2.trim();
                        if (CP_ENTRY_IGNORE.equals(pathString)) {
                            preferences.remove(propertyName);
                        } else {
                            Path varPath = new Path(pathString);
                            this.variables.put(varName, (IPath)varPath);
                            this.previousSessionVariables.put(varName, (IPath)varPath);
                        }
                    }
                } else if (propertyName.startsWith(CP_CONTAINER_PREFERENCES_PREFIX) && (propertyValue = preferences.get(propertyName, null)) != null) {
                    preferences.remove(propertyName);
                    JavaModelManager.recreatePersistedContainer(propertyName, propertyValue, true);
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    protected synchronized IElementInfo peekAtInfo(IJavaElement element) {
        IElementInfo result;
        HashMap<IJavaElement, IElementInfo> tempCache = this.temporaryCache.get();
        if (tempCache != null && (result = tempCache.get(element)) != null) {
            return result;
        }
        return this.cache.peekAtInfo(element);
    }

    public void prepareToSave(ISaveContext context) {
    }

    protected synchronized IElementInfo putInfos(IJavaElement openedElement, IElementInfo newInfo, boolean forceAdd, Map<IJavaElement, IElementInfo> newElements) {
        IElementInfo existingInfo = this.cache.peekAtInfo(openedElement);
        if (existingInfo != null && !forceAdd) {
            return existingInfo;
        }
        if (openedElement instanceof IParent) {
            this.closeChildren(existingInfo);
        }
        Iterator<Map.Entry<IJavaElement, IElementInfo>> it = newElements.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IJavaElement, IElementInfo> entry = it.next();
            IJavaElement element = entry.getKey();
            if (!(element instanceof JarPackageFragmentRoot)) continue;
            IElementInfo info = entry.getValue();
            it.remove();
            this.cache.putInfo(element, info);
        }
        for (Map.Entry<IJavaElement, IElementInfo> entry : newElements.entrySet()) {
            this.cache.putInfo(entry.getKey(), entry.getValue());
        }
        return newInfo;
    }

    private void closeChildren(Object info) {
        if (info instanceof JavaElementInfo) {
            IJavaElement child;
            IJavaElement[] iJavaElementArray = ((JavaElementInfo)info).getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                child = iJavaElementArray[n2];
                try {
                    ((JavaElement)child).close();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++n2;
            }
            iJavaElementArray = ((JavaElementInfo)info).getExtendedChildren();
            n = iJavaElementArray.length;
            n2 = 0;
            while (n2 < n) {
                child = iJavaElementArray[n2];
                try {
                    ((JavaElement)child).close();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    protected synchronized void putJarTypeInfo(IJavaElement type, IElementInfo info) {
        this.cache.jarTypeCache.put(type, info);
    }

    protected Object readState(IProject project) throws CoreException {
        long startTime = System.currentTimeMillis();
        Object result = this.readStateTimed(project);
        if (JavaBuilder.DEBUG) {
            long stopTime = System.currentTimeMillis();
            JavaModelManager.trace("readState took " + (stopTime - startTime) + "ms:" + project.getName());
        }
        return result;
    }

    private Object readStateTimed(IProject project) throws CoreException {
        block21: {
            File file = this.getSerializationFile(project);
            if (file != null && file.exists()) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (DataInputStream in = new DataInputStream(this.createInputStream(file));){
                        String pluginID = in.readUTF();
                        if (!pluginID.equals("org.eclipse.jdt.core")) {
                            throw new IOException(Messages.build_wrongFileFormat);
                        }
                        String kind = in.readUTF();
                        if (!kind.equals("STATE")) {
                            throw new IOException(Messages.build_wrongFileFormat);
                        }
                        if (in.readBoolean()) {
                            return JavaBuilder.readState(project, in);
                        }
                        if (JavaBuilder.DEBUG) {
                            JavaModelManager.trace("Saved state thinks last build failed for " + project.getName());
                        }
                        break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    if (JavaBuilder.DEBUG) {
                        JavaModelManager.trace("", e);
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
                }
            }
            if (JavaBuilder.DEBUG) {
                if (file == null) {
                    JavaModelManager.trace("Project does not exist: " + String.valueOf(project));
                } else {
                    JavaModelManager.trace("Build state file " + file.getPath() + " does not exist");
                }
            }
        }
        return null;
    }

    public static void recreatePersistedContainer(String propertyName, String containerString, boolean addToContainerValues) {
        int containerPrefixLength = CP_CONTAINER_PREFERENCES_PREFIX.length();
        int index = propertyName.indexOf(124, containerPrefixLength);
        if (containerString != null) {
            containerString = containerString.trim();
        }
        if (index > 0) {
            String projectName = propertyName.substring(containerPrefixLength, index).trim();
            JavaProject project = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
            Path containerPath = new Path(propertyName.substring(index + 1).trim());
            JavaModelManager.recreatePersistedContainer(project, (IPath)containerPath, containerString, addToContainerValues);
        }
    }

    private static void recreatePersistedContainer(final IJavaProject project, final IPath containerPath, String containerString, boolean addToContainerValues) {
        if (!project.getProject().isAccessible()) {
            return;
        }
        if (containerString == null) {
            JavaModelManager.getJavaModelManager().containerPut(project, containerPath, null);
        } else {
            IClasspathEntry[] entries;
            try {
                entries = ((JavaProject)project).decodeClasspath(containerString, null)[0];
            }
            catch (IOException e) {
                Util.log(e, "Could not recreate persisted container: \n" + containerString);
                entries = JavaProject.INVALID_CLASSPATH;
            }
            if (entries != JavaProject.INVALID_CLASSPATH) {
                Map<IPath, IClasspathContainer> projectContainers;
                final IClasspathEntry[] containerEntries = entries;
                IClasspathContainer container = new IClasspathContainer(){

                    @Override
                    public IClasspathEntry[] getClasspathEntries() {
                        return containerEntries;
                    }

                    @Override
                    public String getDescription() {
                        return "Persisted container [" + String.valueOf(containerPath) + " for project [" + project.getElementName() + "]";
                    }

                    @Override
                    public int getKind() {
                        return 0;
                    }

                    @Override
                    public IPath getPath() {
                        return containerPath;
                    }

                    public String toString() {
                        return this.getDescription();
                    }
                };
                if (addToContainerValues) {
                    JavaModelManager.getJavaModelManager().containerPut(project, containerPath, container);
                }
                if ((projectContainers = JavaModelManager.getJavaModelManager().previousSessionContainers.get(project)) == null) {
                    projectContainers = new HashMap<IPath, IClasspathContainer>(1);
                    JavaModelManager.getJavaModelManager().previousSessionContainers.put(project, projectContainers);
                }
                projectContainers.put(containerPath, container);
            }
        }
    }

    public void rememberScope(AbstractSearchScope scope) {
        this.searchScopes.put(scope, null);
    }

    public synchronized Object removeInfoAndChildren(JavaElement element) throws JavaModelException {
        IElementInfo info = this.cache.peekAtInfo(element);
        if (info != null) {
            boolean wasVerbose = false;
            try {
                if (JavaModelCache.VERBOSE) {
                    String elementType = JavaModelCache.getCacheType(element);
                    JavaModelManager.trace(String.valueOf(Thread.currentThread()) + " CLOSING " + elementType + " " + element.toStringWithAncestors());
                    wasVerbose = true;
                    JavaModelCache.VERBOSE = false;
                }
                element.closing(info);
                if (element instanceof IParent) {
                    this.closeChildren(info);
                }
                this.cache.removeInfo(element);
                if (wasVerbose) {
                    JavaModelManager.trace(this.cache.toStringFillingRation("-> "));
                }
            }
            finally {
                JavaModelCache.VERBOSE = wasVerbose;
            }
            return info;
        }
        return null;
    }

    void removeFromJarTypeCache(BinaryType type) {
        this.cache.removeFromJarTypeCache(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(JavaProject javaProject, boolean removeExtJarInfo) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info != null) {
                this.perProjectInfos.remove(project);
                if (removeExtJarInfo) {
                    info.forgetExternalTimestampsAndIndexes();
                }
            }
        }
        this.resetClasspathListCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectOptions(JavaProject javaProject) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info != null) {
                info.options = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetProjectPreferences(JavaProject javaProject) {
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = this.perProjectInfos.get(project);
            if (info != null) {
                info.preferences = null;
            }
        }
    }

    public static final void doNotUse() {
        JavaModelManager.MANAGER.deltaState.doNotUse();
        MANAGER = new JavaModelManager();
    }

    protected synchronized void resetJarTypeCache() {
        this.cache.resetJarTypeCache();
    }

    public void resetClasspathListCache() {
        if (this.nonChainingJars != null) {
            this.nonChainingJars.clear();
        }
        if (this.externalFiles != null) {
            this.externalFiles.clear();
        }
        if (this.assumedExternalFiles != null) {
            this.assumedExternalFiles.clear();
        }
    }

    public void resetTemporaryCache() {
        this.temporaryCache.remove();
    }

    public void rollback(ISaveContext context) {
    }

    private void saveState(PerProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            long startTime = System.currentTimeMillis();
            this.saveBuiltState(info);
            if (JavaBuilder.DEBUG) {
                long stopTime = System.currentTimeMillis();
                JavaModelManager.trace("saveState took " + (stopTime - startTime) + "ms:" + info.project.getName());
            }
        }
    }

    private void saveBuiltState(PerProjectInfo info) throws CoreException {
        File file;
        if (JavaBuilder.DEBUG) {
            JavaModelManager.trace(Messages.bind(Messages.build_saveStateProgress, info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (DataOutputStream out = new DataOutputStream(this.createOutputStream(file));){
                out.writeUTF("org.eclipse.jdt.core");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    JavaBuilder.writeState(info.savedState, out);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", 2, Messages.bind(Messages.build_cannotSaveState, info.project.getName()), (Throwable)e));
        }
        if (JavaBuilder.DEBUG) {
            t = System.currentTimeMillis() - t;
            JavaModelManager.trace(Messages.bind(Messages.build_saveStateComplete, String.valueOf(t)));
        }
    }

    private InputStream createInputStream(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            return new BufferedInputStream(new GZIPInputStream((InputStream)in, 8192));
        }
        catch (ZipException e) {
            boolean isZip;
            ((InputStream)in).close();
            Throwable throwable = null;
            Object var6_6 = null;
            try (DataInputStream din = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                isZip = din.readShort() == -29921;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (isZip) {
                throw e;
            }
            return new BufferedInputStream(new FileInputStream(file));
        }
    }

    private OutputStream createOutputStream(File file) throws IOException {
        if (SAVE_ZIPPED) {
            return new BufferedOutputStream(new GZIPOutputStream((OutputStream)new FileOutputStream(file), 8192));
        }
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveClasspathListCache(String cacheName) throws CoreException {
        File file = this.getClasspathListFile(cacheName);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                Set<IPath> pathCache;
                Set<IPath> set = pathCache = this.getClasspathListCache(cacheName);
                synchronized (set) {
                    out.writeInt(pathCache.size());
                    for (IPath path : pathCache) {
                        out.writeUTF(path.toPortableString());
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.core", 4, "Problems while saving non-chaining jar cache", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void saveVariablesAndContainers(ISaveContext context) throws CoreException {
        File file = this.getVariableAndContainersFile();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
                out.writeInt(2);
                new VariablesAndContainersSaveHelper(out).save(context);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.jdt.core", 4, "Problems while saving variables and containers", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void traceVariableAndContainers(String action, long start) {
        Long delta = System.currentTimeMillis() - start;
        Long length = this.getVariableAndContainersFile().length();
        String pattern = "{0} {1} bytes in variablesAndContainers.dat in {2}ms";
        String message = MessageFormat.format(pattern, action, length, delta);
        JavaModelManager.trace(message);
    }

    public static void trace(String msg) {
        if (TRACE_TO_STDOUT) {
            System.out.println(msg);
        } else {
            DEBUG_TRACE.trace(null, msg);
        }
    }

    public static void trace(String msg, Exception e) {
        DEBUG_TRACE.trace(null, msg, (Throwable)e);
    }

    public static void traceDumpStack() {
        DEBUG_TRACE.traceDumpStack(null);
    }

    public void saving(ISaveContext context) throws CoreException {
        long startTime = System.currentTimeMillis();
        this.savingTimed(context);
        if (JavaBuilder.DEBUG) {
            long stopTime = System.currentTimeMillis();
            JavaModelManager.trace("saving took " + (stopTime - startTime) + "ms:" + this.perProjectInfos.values().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savingTimed(ISaveContext context) throws CoreException {
        IStatus[] stats;
        ArrayList<PerProjectInfo> infos;
        long start = -1L;
        if (VERBOSE) {
            start = System.currentTimeMillis();
        }
        this.saveVariablesAndContainers(context);
        if (VERBOSE) {
            this.traceVariableAndContainers("Saved", start);
        }
        switch (context.getKind()) {
            case 1: {
                this.saveClasspathListCache(NON_CHAINING_JARS_CACHE);
                this.saveClasspathListCache(EXTERNAL_FILES_CACHE);
                this.saveClasspathListCache(ASSUMED_EXTERNAL_FILES_CACHE);
                context.needDelta();
                IndexManager manager = this.indexManager;
                if (manager != null && this.workspaceScope != null) {
                    manager.cleanUpIndexes();
                }
            }
            case 2: {
                this.externalFoldersManager.cleanUp(null);
            }
        }
        IProject savedProject = context.getProject();
        if (savedProject != null) {
            if (!JavaProject.hasJavaNature(savedProject)) {
                return;
            }
            PerProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            return;
        }
        Map<IProject, PerProjectInfo> map = this.perProjectInfos;
        synchronized (map) {
            infos = new ArrayList<PerProjectInfo>(this.perProjectInfos.values());
        }
        int parallelism = Math.max(1, SAVE_THREAD_COUNT == null ? ForkJoinPool.getCommonPoolParallelism() : SAVE_THREAD_COUNT);
        ForkJoinPool forkJoinPool = new ForkJoinPool(parallelism, pool -> new ForkJoinWorkerThread(pool){}, null, false);
        try {
            try {
                stats = (IStatus[])((ForkJoinTask)forkJoinPool.submit(() -> (IStatus[])((Stream)infos.stream().parallel()).map(info -> {
                    try {
                        this.saveState((PerProjectInfo)info, context);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return null;
                }).filter(Objects::nonNull).toArray(IStatus[]::new))).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new CoreException(Status.error((String)Messages.build_cannotSaveStates, (Throwable)e));
            }
        }
        finally {
            forkJoinPool.shutdown();
        }
        if (stats.length > 0) {
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.jdt.core", 4, stats, Messages.build_cannotSaveStates, null));
        }
        this.deltaState.saveExternalLibTimeStamps();
    }

    public void secondaryTypeAdding(String path, char[] typeName, char[] packageName) {
        IWorkspaceRoot wRoot;
        IResource resource;
        if (VERBOSE) {
            StringBuilder buffer = new StringBuilder("JavaModelManager.addSecondaryType(");
            buffer.append(path);
            buffer.append(',');
            buffer.append('[');
            buffer.append(new String(packageName));
            buffer.append('.');
            buffer.append(new String(typeName));
            buffer.append(']');
            buffer.append(')');
            JavaModelManager.trace(buffer.toString());
        }
        if ((resource = (wRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) instanceof IFile && Util.isJavaLikeFileName(path)) {
            IProject project = resource.getProject();
            try {
                ICompilationUnit unit;
                PerProjectInfo projectInfo = this.getPerProjectInfoCheckExistence(project);
                SecondaryTypesCache stCache = projectInfo.secondaryTypes.getOrCreateCache();
                Map<IFile, Map<String, Map<String, IType>>> indexedSecondaryTypes = stCache.indexingSecondaryCache();
                Map<String, Map<String, IType>> allTypes = indexedSecondaryTypes.get(resource);
                if (allTypes == null) {
                    allTypes = new HashMap<String, Map<String, IType>>(3);
                    indexedSecondaryTypes.put((IFile)resource, allTypes);
                }
                if ((unit = JavaModelManager.createCompilationUnitFrom((IFile)resource, null)) != null) {
                    String typeString = new String(typeName);
                    IType type = unit.getType(typeString);
                    String packageString = type.getPackageFragment().getElementName();
                    Map<String, IType> packageTypes = allTypes.get(packageString);
                    if (packageTypes == null) {
                        packageTypes = new HashMap<String, IType>(3);
                        allTypes.put(packageString, packageTypes);
                    }
                    packageTypes.put(typeString, type);
                }
                if (VERBOSE) {
                    JavaModelManager.trace("\t- indexing cache:");
                    this.dumpIndexingSecondaryTypes(indexedSecondaryTypes);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpIndexingSecondaryTypes(Map<IFile, Map<String, Map<String, IType>>> indexedSecondaryTypes) {
        Map<IFile, Map<String, Map<String, IType>>> map = indexedSecondaryTypes;
        synchronized (map) {
            for (Map.Entry<IFile, Map<String, Map<String, IType>>> entry : indexedSecondaryTypes.entrySet()) {
                IFile file = entry.getKey();
                JavaModelManager.trace("\t\t+ " + String.valueOf(file.getFullPath()) + ":" + String.valueOf(entry.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSecondaryTypes(Map<String, Map<String, IType>> secondaryTypes) {
        Map<String, Map<String, IType>> map = secondaryTypes;
        synchronized (map) {
            for (Map.Entry<String, Map<String, IType>> entry : secondaryTypes.entrySet()) {
                String packName = entry.getKey();
                JavaModelManager.trace("\t\t+ " + packName + ":" + String.valueOf(entry.getValue()));
            }
        }
    }

    public Map<String, Map<String, IType>> secondaryTypes(IJavaProject project, boolean waitForIndexes, IProgressMonitor monitor) throws JavaModelException {
        boolean indexing;
        if (VERBOSE) {
            StringBuilder buffer = new StringBuilder("JavaModelManager.secondaryTypes(");
            buffer.append(project.getElementName()).append(',').append(waitForIndexes).append(')');
            JavaModelManager.trace(buffer.toString());
        }
        PerProjectInfo projectInfo = this.getPerProjectInfoCheckExistence(project.getProject());
        SecondaryTypesCache secondaryTypesCache = projectInfo.secondaryTypes.cache();
        Hashtable<String, Map<String, IType>> secondaryTypes = secondaryTypesCache.secondaryTypes();
        if (secondaryTypesCache.isIndexingDone()) {
            return secondaryTypes;
        }
        if (secondaryTypes == null) {
            return JavaModelManager.secondaryTypesSearching(project, waitForIndexes, monitor, projectInfo);
        }
        boolean bl = indexing = this.indexManager.awaitingJobsCount() > 0;
        if (indexing) {
            if (!waitForIndexes) {
                return secondaryTypes;
            }
            try {
                this.indexManager.performConcurrentJob(new IJob(){

                    @Override
                    public boolean belongsTo(String jobFamily) {
                        return true;
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void ensureReadyToRun() {
                    }

                    @Override
                    public boolean execute(IProgressMonitor progress) {
                        return progress == null || !progress.isCanceled();
                    }

                    @Override
                    public String getJobFamily() {
                        return "";
                    }
                }, 3, monitor);
            }
            catch (OperationCanceledException oce) {
                return secondaryTypes;
            }
        }
        return JavaModelManager.secondaryTypesMerging(projectInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, IType>> secondaryTypesMerging(PerProjectInfo projectInfo) {
        SecondaryTypes secondaryTypes = projectInfo.secondaryTypes;
        synchronized (secondaryTypes) {
            HashMap<IFile, Map<String, Map<String, IType>>> indexedSecondaryTypesCopy;
            Map<IFile, Map<String, Map<String, IType>>> indexedSecondaryTypes;
            SecondaryTypesCache cache = projectInfo.secondaryTypes.cache();
            Hashtable<String, Map<String, IType>> secondaryTypes2 = cache.secondaryTypes();
            if (cache.isIndexingDone()) {
                return secondaryTypes2;
            }
            if (VERBOSE) {
                JavaModelManager.trace("JavaModelManager.getSecondaryTypesMerged()");
                JavaModelManager.trace("\t- current cache to merge:");
                JavaModelManager.dumpSecondaryTypes(secondaryTypes2);
            }
            Map<IFile, Map<String, Map<String, IType>>> map = indexedSecondaryTypes = cache.indexingSecondaryCache();
            synchronized (map) {
                indexedSecondaryTypesCopy = new HashMap<IFile, Map<String, Map<String, IType>>>(indexedSecondaryTypes);
            }
            for (Map.Entry entry : indexedSecondaryTypesCopy.entrySet()) {
                IFile file = (IFile)entry.getKey();
                JavaModelManager.secondaryTypesRemoving(secondaryTypes2, file);
                Map fileSecondaryTypes = (Map)entry.getValue();
                for (Map.Entry e : fileSecondaryTypes.entrySet()) {
                    String packageName = (String)e.getKey();
                    Map cachedTypes = (Map)secondaryTypes2.get(packageName);
                    if (cachedTypes == null) {
                        secondaryTypes2.put(packageName, (Map)e.getValue());
                        continue;
                    }
                    Map types = (Map)e.getValue();
                    for (Map.Entry entry3 : types.entrySet()) {
                        String typeName = (String)entry3.getKey();
                        cachedTypes.put(typeName, (IType)entry3.getValue());
                    }
                }
            }
            if (VERBOSE) {
                JavaModelManager.trace("\t- secondary types cache merged:");
                JavaModelManager.dumpSecondaryTypes(secondaryTypes2);
            }
            projectInfo.secondaryTypes.indexingDone();
            return secondaryTypes2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Map<String, IType>> secondaryTypesSearching(IJavaProject project, boolean waitForIndexes, IProgressMonitor monitor, PerProjectInfo projectInfo) throws JavaModelException {
        if (VERBOSE || BasicSearchEngine.VERBOSE) {
            StringBuilder buffer = new StringBuilder("JavaModelManager.secondaryTypesSearch(");
            buffer.append(project.getElementName());
            buffer.append(',');
            buffer.append(waitForIndexes);
            buffer.append(')');
            JavaModelManager.trace(buffer.toString());
        }
        final Hashtable secondaryTypesSearch = new Hashtable(3);
        IRestrictedAccessTypeRequestor nameRequestor = new IRestrictedAccessTypeRequestor(){

            @Override
            public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                String key = packageName == null ? "" : DeduplicationUtil.toString(packageName);
                HashMap<String, String> types = (HashMap<String, String>)secondaryTypesSearch.get(key);
                if (types == null) {
                    types = new HashMap<String, String>(3);
                }
                types.put(DeduplicationUtil.toString(simpleTypeName), path);
                secondaryTypesSearch.put(key, types);
            }
        };
        IPackageFragmentRoot[] allRoots = project.getAllPackageFragmentRoots();
        int length = allRoots.length;
        int size = 0;
        IPackageFragmentRoot[] allSourceFolders = new IPackageFragmentRoot[length];
        int i = 0;
        while (i < length) {
            if (allRoots[i].getKind() == 1) {
                allSourceFolders[size++] = allRoots[i];
            }
            ++i;
        }
        if (size < length) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = allSourceFolders;
            allSourceFolders = new IPackageFragmentRoot[size];
            System.arraycopy(iPackageFragmentRootArray, 0, allSourceFolders, 0, size);
        }
        new BasicSearchEngine().searchAllSecondaryTypeNames(allSourceFolders, nameRequestor, waitForIndexes, monitor);
        Hashtable<String, Map<String, IType>> secondaryTypes = new Hashtable<String, Map<String, IType>>(secondaryTypesSearch.size());
        for (Map.Entry packageEntry : secondaryTypesSearch.entrySet()) {
            String packageName = (String)packageEntry.getKey();
            Map types = (Map)packageEntry.getValue();
            HashMap<String, IType> tempTypes = new HashMap<String, IType>(types.size());
            for (Map.Entry entry : types.entrySet()) {
                String typeName = (String)entry.getKey();
                String path = (String)entry.getValue();
                if (!Util.isJavaLikeFileName(path)) continue;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                ICompilationUnit unit = JavaModelManager.createCompilationUnitFrom(file, null);
                IType type = unit.getType(typeName);
                tempTypes.put(typeName, type);
            }
            secondaryTypes.put(packageName, tempTypes);
        }
        SecondaryTypes secondaryTypes2 = projectInfo.secondaryTypes;
        synchronized (secondaryTypes2) {
            SecondaryTypesCache stCache = projectInfo.secondaryTypes.cache();
            if (stCache.secondaryTypes() == null || stCache.indexingSecondaryCache() != null) {
                stCache = projectInfo.secondaryTypes.doneSearching(secondaryTypes);
                if (VERBOSE || BasicSearchEngine.VERBOSE) {
                    JavaModelManager.trace("\t-> secondary paths stored in cache: ");
                    JavaModelManager.dumpSecondaryTypes(secondaryTypes);
                }
            }
            return stCache.secondaryTypes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void secondaryTypesRemoving(IFile file, boolean cleanIndexCache) {
        if (VERBOSE) {
            StringBuilder buffer = new StringBuilder("JavaModelManager.removeFromSecondaryTypesCache(");
            buffer.append(file.getName());
            buffer.append(')');
            JavaModelManager.trace(buffer.toString());
        }
        if (file != null) {
            PerProjectInfo projectInfo = this.getPerProjectInfo(file.getProject(), false);
            if (projectInfo == null) {
                return;
            }
            SecondaryTypes secondaryTypes = projectInfo.secondaryTypes;
            synchronized (secondaryTypes) {
                SecondaryTypesCache stCache = projectInfo.secondaryTypes.cache();
                Hashtable<String, Map<String, IType>> secondaryTypes2 = stCache.secondaryTypes();
                if (secondaryTypes2 == null) {
                    return;
                }
                if (VERBOSE) {
                    JavaModelManager.trace("-> remove file from cache of project: " + file.getProject().getName());
                }
                JavaModelManager.secondaryTypesRemoving(secondaryTypes2, file);
                Map<IFile, Map<String, Map<String, IType>>> indexingCache = stCache.indexingSecondaryCache();
                if (!cleanIndexCache) {
                    if (indexingCache == null) {
                        projectInfo.secondaryTypes.startIndexing();
                    }
                    return;
                }
                if (indexingCache != null) {
                    indexingCache.remove(file);
                }
            }
        }
    }

    private static void secondaryTypesRemoving(Map<String, Map<String, IType>> secondaryTypesMap, IFile file) {
        if (VERBOSE) {
            StringBuilder buffer = new StringBuilder("JavaModelManager.removeSecondaryTypesFromMap(");
            buffer.append(',').append(file.getFullPath()).append(')');
            JavaModelManager.trace(buffer.toString());
            JavaModelManager.dumpSecondaryTypes(secondaryTypesMap);
        }
        Set<Map.Entry<String, Map<String, IType>>> packageEntries = secondaryTypesMap.entrySet();
        int packagesSize = packageEntries.size();
        int removedPackagesCount = 0;
        String[] removedPackages = null;
        for (Map.Entry<String, Map<String, IType>> entry : packageEntries) {
            String packName = entry.getKey();
            Map<String, IType> types = entry.getValue();
            Set<Map.Entry<String, IType>> nameEntries = types.entrySet();
            int namesSize = nameEntries.size();
            int removedNamesCount = 0;
            String[] removedNames = null;
            for (Map.Entry<String, IType> e : nameEntries) {
                String typeName = e.getKey();
                JavaElement type = (JavaElement)((Object)e.getValue());
                if (!file.equals((Object)type.resource())) continue;
                if (removedNames == null) {
                    removedNames = new String[namesSize];
                }
                --namesSize;
                removedNames[removedNamesCount++] = typeName;
            }
            if (removedNames != null) {
                int i = 0;
                while (i < removedNamesCount) {
                    types.remove(removedNames[i]);
                    ++i;
                }
            }
            if (types.size() != 0) continue;
            if (removedPackages == null) {
                removedPackages = new String[packagesSize];
            }
            --packagesSize;
            removedPackages[removedPackagesCount++] = packName;
        }
        if (removedPackages != null) {
            int i = 0;
            while (i < removedPackagesCount) {
                secondaryTypesMap.remove(removedPackages[i]);
                ++i;
            }
        }
        if (VERBOSE) {
            JavaModelManager.trace("\t- new secondary types map:");
            JavaModelManager.dumpSecondaryTypes(secondaryTypesMap);
        }
    }

    protected void setBuildOrder(String[] javaBuildOrder) throws JavaModelException {
        String[] newOrder;
        if (!"compute".equals(JavaCore.getOption("org.eclipse.jdt.core.computeJavaBuildOrder"))) {
            return;
        }
        if (javaBuildOrder == null || javaBuildOrder.length <= 1) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        String[] wksBuildOrder = description.getBuildOrder();
        if (wksBuildOrder == null) {
            newOrder = javaBuildOrder;
        } else {
            int javaCount = javaBuildOrder.length;
            HashMap<String, String> newSet = new HashMap<String, String>(javaCount);
            int i = 0;
            while (i < javaCount) {
                newSet.put(javaBuildOrder[i], javaBuildOrder[i]);
                ++i;
            }
            int removed = 0;
            int oldCount = wksBuildOrder.length;
            int i2 = 0;
            while (i2 < oldCount) {
                if (newSet.containsKey(wksBuildOrder[i2])) {
                    wksBuildOrder[i2] = null;
                    ++removed;
                }
                ++i2;
            }
            newOrder = new String[oldCount - removed + javaCount];
            System.arraycopy(javaBuildOrder, 0, newOrder, 0, javaCount);
            int index = javaCount;
            int i3 = 0;
            while (i3 < oldCount) {
                if (wksBuildOrder[i3] != null) {
                    newOrder[index++] = wksBuildOrder[i3];
                }
                ++i3;
            }
        }
        description.setBuildOrder(newOrder);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (JavaProject.hasJavaNature(project)) {
            PerProjectInfo info = this.getPerProjectInfo(project, true);
            info.triedRead = true;
            info.savedState = state;
        }
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public boolean storePreference(String optionName, String optionValue, IEclipsePreferences eclipsePreferences, Map<String, String> otherOptions) {
        int optionLevel = this.getOptionLevel(optionName);
        if (optionLevel == 0) {
            return false;
        }
        switch (optionLevel) {
            case 2: {
                if (optionValue == null) {
                    eclipsePreferences.remove(optionName);
                    break;
                }
                eclipsePreferences.put(optionName, optionValue);
                break;
            }
            case 1: {
                String[] compatibleOptions;
                eclipsePreferences.remove(optionName);
                String[] stringArray = compatibleOptions = this.deprecatedOptions.get(optionName);
                int n = compatibleOptions.length;
                int n2 = 0;
                while (n2 < n) {
                    String compatibleOption = stringArray[n2];
                    if (otherOptions == null || !otherOptions.containsKey(compatibleOption)) {
                        if (optionValue == null) {
                            eclipsePreferences.remove(compatibleOption);
                        } else {
                            eclipsePreferences.put(compatibleOption, optionValue);
                        }
                    }
                    ++n2;
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void setOptions(Hashtable<String, String> newOptions) {
        Hashtable<String, String> cachedValue = newOptions == null ? null : new Hashtable<String, String>(newOptions);
        IEclipsePreferences defaultPreferences = this.getDefaultPreferences();
        IEclipsePreferences instancePreferences = this.getInstancePreferences();
        if (newOptions == null) {
            try {
                instancePreferences.clear();
            }
            catch (BackingStoreException backingStoreException) {}
        } else {
            Enumeration<String> keys = newOptions.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                int optionLevel = this.getOptionLevel(key);
                if (optionLevel == 0) continue;
                if (key.equals("org.eclipse.jdt.core.encoding")) {
                    if (cachedValue == null) continue;
                    cachedValue.put(key, JavaCore.getEncoding());
                    continue;
                }
                String value = newOptions.get(key);
                String defaultValue = defaultPreferences.get(key, null);
                if (defaultValue != null && defaultValue.equals(value)) {
                    value = null;
                }
                this.storePreference(key, value, instancePreferences, newOptions);
            }
            try {
                instancePreferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        if (cachedValue == null) {
            this.getOptions();
        } else {
            Util.fixTaskTags(cachedValue);
            this.optionsCache = cachedValue;
        }
    }

    public void startup() throws CoreException {
        try {
            this.cache = new JavaModelCache();
            JavaCore.getPlugin().getStateLocation();
            this.initializePreferences();
            this.propertyListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    JavaModelManager.this.optionsCache = null;
                }
            };
            InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core").addPreferenceChangeListener(this.propertyListener);
            this.resourcesPropertyListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    if ("encoding".equals(event.getKey())) {
                        JavaModelManager.this.optionsCache = null;
                    }
                }
            };
            String resourcesPluginId = ResourcesPlugin.getPlugin().getBundle().getSymbolicName();
            InstanceScope.INSTANCE.getNode(resourcesPluginId).addPreferenceChangeListener(this.resourcesPropertyListener);
            Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
            long start = -1L;
            if (VERBOSE) {
                start = System.currentTimeMillis();
            }
            this.loadVariablesAndContainers();
            if (VERBOSE) {
                this.traceVariableAndContainers("Loaded", start);
            }
            this.deltaState.initializeRootsWithPreviousSession();
            final IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener((IResourceChangeListener)this.deltaState, 63);
            ExternalAnnotationTracker.start(workspace);
            this.startIndexing();
            Job processSavedState = new Job(Messages.savedState_jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        workspace.run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor progress) throws CoreException {
                                ISavedState savedState = workspace.addSaveParticipant("org.eclipse.jdt.core", (ISaveParticipant)JavaModelManager.this);
                                if (savedState != null) {
                                    (this).JavaModelManager.this.deltaState.getDeltaProcessor().overridenEventType = 1;
                                    savedState.processResourceChangeEvents((IResourceChangeListener)(this).JavaModelManager.this.deltaState);
                                }
                            }
                        }, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            processSavedState.setSystem(true);
            processSavedState.setPriority(20);
            processSavedState.schedule();
        }
        catch (RuntimeException e) {
            try {
                this.shutdown();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    private void startIndexing() {
        if (this.indexManager != null) {
            this.indexManager.reset();
        }
    }

    public void shutdown() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.core");
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            Util.log(e, "Could not save JavaCore preferences");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.deltaState);
        workspace.removeSaveParticipant("org.eclipse.jdt.core");
        ExternalAnnotationTracker.shutdown(workspace);
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        if (contentTypeManager != null) {
            contentTypeManager.removeContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
        }
        if (this.indexManager != null) {
            this.indexManager.shutdown();
        }
        preferences.removePreferenceChangeListener(this.propertyListener);
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).removeNodeChangeListener(this.defaultNodeListener);
        this.preferencesLookup[1] = null;
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).removeNodeChangeListener(this.instanceNodeListener);
        this.preferencesLookup[0].removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this.instancePreferencesListener);
        this.preferencesLookup[0] = null;
        String resourcesPluginId = ResourcesPlugin.getPlugin().getBundle().getSymbolicName();
        InstanceScope.INSTANCE.getNode(resourcesPluginId).removePreferenceChangeListener(this.resourcesPropertyListener);
        try {
            Job.getJobManager().join((Object)"org.eclipse.jdt.core", null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized IPath variableGet(String variableName) {
        Set<String> initializations = this.variableInitializationInProgress();
        if (initializations.contains(variableName)) {
            return VARIABLE_INITIALIZATION_IN_PROGRESS;
        }
        return this.variables.get(variableName);
    }

    private synchronized IPath variableGetDefaultToPreviousSession(String variableName) {
        IPath variablePath = this.variables.get(variableName);
        if (variablePath == null) {
            return this.getPreviousSessionVariable(variableName);
        }
        return variablePath;
    }

    private Set<String> variableInitializationInProgress() {
        Set<String> initializations = this.variableInitializationInProgress.get();
        if (initializations == null) {
            initializations = new HashSet<String>();
            this.variableInitializationInProgress.set(initializations);
        }
        return initializations;
    }

    public synchronized String[] variableNames() {
        return (String[])this.variables.keySet().toArray(String[]::new);
    }

    public synchronized void variablePut(String variableName, IPath variablePath) {
        Set<String> initializations = this.variableInitializationInProgress();
        if (variablePath == VARIABLE_INITIALIZATION_IN_PROGRESS) {
            initializations.add(variableName);
            return;
        }
        initializations.remove(variableName);
        if (variablePath == null) {
            this.variables.put(variableName, CP_ENTRY_IGNORE_PATH);
            this.variablesWithInitializer.remove(variableName);
            this.deprecatedVariables.remove(variableName);
        } else {
            this.variables.put(variableName, variablePath);
        }
        this.previousSessionVariables.remove(variableName);
    }

    public void variablePreferencesPut(String variableName, IPath variablePath) {
        String variableKey = CP_VARIABLE_PREFERENCES_PREFIX + variableName;
        if (variablePath == null) {
            this.getInstancePreferences().remove(variableKey);
        } else {
            this.getInstancePreferences().put(variableKey, variablePath.toString());
        }
        try {
            this.getInstancePreferences().flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public boolean variablePutIfInitializingWithSameValue(String[] variableNames, IPath[] variablePaths) {
        if (variableNames.length != 1) {
            return false;
        }
        String variableName = variableNames[0];
        IPath oldPath = this.variableGetDefaultToPreviousSession(variableName);
        if (oldPath == null) {
            return false;
        }
        IPath newPath = variablePaths[0];
        if (!oldPath.equals((Object)newPath)) {
            return false;
        }
        this.variablePut(variableName, newPath);
        return true;
    }

    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
        IJavaProject[] projects;
        Util.resetJavaLikeExtensions();
        try {
            projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        }
        catch (JavaModelException e) {
            return;
        }
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            PerProjectInfo projectInfo = this.getPerProjectInfo(project.getProject(), false);
            if (projectInfo != null) {
                projectInfo.secondaryTypes.clearAllCaches();
            }
            ++n2;
        }
    }

    public synchronized String cacheToString(String prefix) {
        return this.cache.toStringFillingRation(prefix);
    }

    public LRUCache.Stats debugNewOpenableCacheStats() {
        return new LRUCache.Stats(this.cache.openableCache);
    }

    public int getOpenableCacheSize() {
        return this.cache.openableCache.getSpaceLimit();
    }

    public IAccessRule getAccessRule(IPath filePattern, int kind) {
        ClasspathAccessRule rule = new ClasspathAccessRule(filePattern, kind);
        return this.getFromCache(rule);
    }

    public ClasspathAccessRule getAccessRuleForProblemId(char[] filePattern, int problemId) {
        ClasspathAccessRule rule = new ClasspathAccessRule(filePattern, problemId);
        return this.getFromCache(rule);
    }

    private ClasspathAccessRule getFromCache(ClasspathAccessRule rule) {
        return DeduplicationUtil.internObject(rule);
    }

    public static void assertModelModifiable() {
        if (readOnly.get().booleanValue()) {
            throw new IllegalStateException("Its not allow to modify JavaModel during ReadOnly action.");
        }
    }

    public static <T, E extends Exception> T callReadOnly(JavaCore.JavaCallable<T, E> callable) throws E {
        if (readOnly.get().booleanValue()) {
            return callable.call();
        }
        try {
            readOnly.set(Boolean.TRUE);
            T t = JavaModelManager.cacheZipFiles(callable);
            return t;
        }
        finally {
            readOnly.set(Boolean.FALSE);
        }
    }

    public static <T, E extends Exception> T cacheZipFiles(JavaCore.JavaCallable<T, E> callable) throws E {
        Object instance = new Object();
        try {
            JavaModelManager.getJavaModelManager().cacheZipFiles(instance);
            T t = callable.call();
            return t;
        }
        finally {
            JavaModelManager.getJavaModelManager().flushZipFiles(instance);
        }
    }

    public static enum ArchiveValidity {
        INVALID,
        VALID;


        public boolean isValid() {
            return this == VALID;
        }
    }

    public static class CompilationParticipants {
        static final int MAX_SOURCE_LEVEL = JavaCore.getAllVersions().size() - 1;
        private Object[][] registeredParticipants = null;
        private HashSet<String> managedMarkerTypes;

        public CompilationParticipant[] getCompilationParticipants(IJavaProject project) {
            final Object[][] participantsPerSource = this.getRegisteredParticipants();
            if (participantsPerSource == NO_PARTICIPANTS) {
                return null;
            }
            String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            final int sourceLevelIndex = this.indexForSourceLevel(sourceLevel);
            Object[] participants = participantsPerSource[sourceLevelIndex];
            int length = participants.length;
            CompilationParticipant[] result = new CompilationParticipant[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                CompilationParticipant participant;
                if (participants[i] instanceof IConfigurationElement) {
                    final IConfigurationElement configElement = (IConfigurationElement)participants[i];
                    final int participantIndex = i;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            Util.log(exception, "Exception occurred while creating compilation participant");
                        }

                        public void run() throws Exception {
                            Object executableExtension = configElement.createExecutableExtension("class");
                            int j = sourceLevelIndex;
                            while (j < MAX_SOURCE_LEVEL) {
                                participantsPerSource[j][participantIndex] = executableExtension;
                                ++j;
                            }
                        }
                    });
                }
                if (participants[i] instanceof CompilationParticipant && (participant = (CompilationParticipant)participants[i]).isActive(project)) {
                    result[index++] = participant;
                }
                ++i;
            }
            if (index == 0) {
                return null;
            }
            if (index < length) {
                CompilationParticipant[] compilationParticipantArray = result;
                result = new CompilationParticipant[index];
                System.arraycopy(compilationParticipantArray, 0, result, 0, index);
            }
            return result;
        }

        public HashSet<String> managedMarkerTypes() {
            if (this.managedMarkerTypes == null) {
                this.getRegisteredParticipants();
            }
            return this.managedMarkerTypes;
        }

        private synchronized Object[][] getRegisteredParticipants() {
            IExtension[] extensions;
            if (this.registeredParticipants != null) {
                return this.registeredParticipants;
            }
            this.managedMarkerTypes = new HashSet();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jdt.core", JavaModelManager.COMPILATION_PARTICIPANT_EXTPOINT_ID);
            if (extension == null) {
                this.registeredParticipants = NO_PARTICIPANTS;
                return NO_PARTICIPANTS;
            }
            ArrayList<IConfigurationElement> modifyingEnv = new ArrayList<IConfigurationElement>();
            ArrayList<IConfigurationElement> creatingProblems = new ArrayList<IConfigurationElement>();
            ArrayList<IConfigurationElement> others = new ArrayList<IConfigurationElement>();
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String elementName = configElement.getName();
                    if (JavaModelManager.COMPILATION_PARTICIPANT_EXTPOINT_ID.equals(elementName)) {
                        IConfigurationElement[] managedMarkers;
                        if (JavaModelManager.TRUE.equals(configElement.getAttribute("modifiesEnvironment"))) {
                            modifyingEnv.add(configElement);
                        } else if (JavaModelManager.TRUE.equals(configElement.getAttribute("createsProblems"))) {
                            creatingProblems.add(configElement);
                        } else {
                            others.add(configElement);
                        }
                        IConfigurationElement[] iConfigurationElementArray2 = managedMarkers = configElement.getChildren("managedMarker");
                        int n5 = managedMarkers.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IConfigurationElement element = iConfigurationElementArray2[n6];
                            String markerType = element.getAttribute("markerType");
                            if (markerType != null) {
                                this.managedMarkerTypes.add(markerType);
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            int size = modifyingEnv.size() + creatingProblems.size() + others.size();
            if (size == 0) {
                this.registeredParticipants = NO_PARTICIPANTS;
                return NO_PARTICIPANTS;
            }
            IConfigurationElement[] configElements = new IConfigurationElement[size];
            int index = 0;
            index = this.sortParticipants(modifyingEnv, configElements, index);
            index = this.sortParticipants(creatingProblems, configElements, index);
            index = this.sortParticipants(others, configElements, index);
            Object[][] result = new Object[MAX_SOURCE_LEVEL][];
            int length = configElements.length;
            int i = 0;
            while (i < MAX_SOURCE_LEVEL) {
                result[i] = new Object[length];
                ++i;
            }
            i = 0;
            while (i < length) {
                int sourceLevelIndex;
                String sourceLevel = configElements[i].getAttribute("requiredSourceLevel");
                int j = sourceLevelIndex = this.indexForSourceLevel(sourceLevel);
                while (j < MAX_SOURCE_LEVEL) {
                    result[j][i] = configElements[i];
                    ++j;
                }
                ++i;
            }
            this.registeredParticipants = result;
            return result;
        }

        private int indexForSourceLevel(String sourceLevel) {
            if (sourceLevel == null) {
                return 0;
            }
            int majVersion = (int)(CompilerOptions.versionToJdkLevel((String)sourceLevel) >>> 16);
            if (majVersion > 46) {
                return majVersion - 45;
            }
            return 0;
        }

        private int sortParticipants(ArrayList<IConfigurationElement> group, IConfigurationElement[] configElements, int index) {
            int size = group.size();
            if (size == 0) {
                return index;
            }
            Object[] elements = group.toArray();
            Util.sort(elements, new Util.Comparer(){

                @Override
                public int compare(Object a, Object b) {
                    IConfigurationElement[] requiredElements;
                    if (a == b) {
                        return 0;
                    }
                    String id = ((IConfigurationElement)a).getAttribute("id");
                    if (id == null) {
                        return -1;
                    }
                    IConfigurationElement[] iConfigurationElementArray = requiredElements = ((IConfigurationElement)b).getChildren("requires");
                    int n = requiredElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement required = iConfigurationElementArray[n2];
                        if (id.equals(required.getAttribute("id"))) {
                            return -1;
                        }
                        ++n2;
                    }
                    return 1;
                }
            });
            int i = 0;
            while (i < size) {
                configElements[index + i] = (IConfigurationElement)elements[i];
                ++i;
            }
            return index + size;
        }
    }

    public static class EclipsePreferencesListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String propertyName = event.getKey();
            if (propertyName.startsWith("org.eclipse.jdt.core")) {
                if (propertyName.startsWith(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX)) {
                    String varName = propertyName.substring(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX.length());
                    manager = JavaModelManager.getJavaModelManager();
                    if (((JavaModelManager)manager).variablesWithInitializer.contains(varName)) {
                        String oldValue = (String)event.getOldValue();
                        if (oldValue == null) {
                            ((JavaModelManager)manager).variablesWithInitializer.remove(varName);
                        } else {
                            ((JavaModelManager)manager).getInstancePreferences().put(varName, oldValue);
                        }
                    } else {
                        String newValue = (String)event.getNewValue();
                        Path newPath = newValue != null && !(newValue = newValue.trim()).equals(JavaModelManager.CP_ENTRY_IGNORE) ? new Path(newValue) : null;
                        try {
                            SetVariablesOperation operation = new SetVariablesOperation(new String[]{varName}, new IPath[]{newPath}, false);
                            operation.runOperation(null);
                        }
                        catch (JavaModelException e) {
                            Util.log((Throwable)((Object)e), "Could not set classpath variable " + varName + " to " + String.valueOf(newPath));
                        }
                    }
                } else if (propertyName.startsWith(JavaModelManager.CP_CONTAINER_PREFERENCES_PREFIX)) {
                    JavaModelManager.recreatePersistedContainer(propertyName, (String)event.getNewValue(), false);
                } else if (propertyName.equals("org.eclipse.jdt.core.builder.cleanOutputFolder") || propertyName.equals("org.eclipse.jdt.core.builder.resourceCopyExclusionFilter") || propertyName.equals("org.eclipse.jdt.core.builder.duplicateResourceTask") || propertyName.equals("org.eclipse.jdt.core.builder.recreateModifiedClassFileInOutputFolder") || propertyName.equals("org.eclipse.jdt.core.builder.invalidClasspath") || propertyName.equals("org.eclipse.jdt.core.classpath.exclusionPatterns") || propertyName.equals("org.eclipse.jdt.core.classpath.multipleOutputLocations") || propertyName.equals("org.eclipse.jdt.core.incompleteClasspath") || propertyName.equals("org.eclipse.jdt.core.circularClasspath") || propertyName.equals("org.eclipse.jdt.core.incompatibleJDKLevel") || propertyName.equals("org.eclipse.jdt.core.classpath.mainOnlyProjectHasTestOnlyDependency") || propertyName.equals("org.eclipse.jdt.core.compiler.codegen.targetPlatform") || propertyName.equals("org.eclipse.jdt.core.classpath.outputOverlappingAnotherSource")) {
                    JavaModelManager manager = JavaModelManager.getJavaModelManager();
                    JavaModel model = manager.getJavaModel();
                    try {
                        IJavaProject[] jProjects = model.getJavaProjects();
                        IProject[] projects = new IProject[jProjects.length];
                        int i = 0;
                        int pl = jProjects.length;
                        while (i < pl) {
                            JavaProject javaProject = (JavaProject)jProjects[i];
                            projects[i] = javaProject.getProject();
                            manager.deltaState.addClasspathValidation(javaProject);
                            ++i;
                        }
                        manager.touchProjectsAsync(projects);
                    }
                    catch (JavaModelException javaModelException) {}
                } else if (propertyName.startsWith(JavaModelManager.CP_USERLIBRARY_PREFERENCES_PREFIX)) {
                    String libName = propertyName.substring(JavaModelManager.CP_USERLIBRARY_PREFERENCES_PREFIX.length());
                    manager = JavaModelManager.getUserLibraryManager();
                    ((UserLibraryManager)manager).updateUserLibrary(libName, (String)event.getNewValue());
                }
            }
            try {
                IJavaProject[] projects;
                IJavaProject[] iJavaProjectArray = projects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject project = iJavaProjectArray[n2];
                    ((JavaProject)project).resetCaches();
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private static class InvalidArchiveInfo {
        final long evictionTimestamp;
        final ArchiveValidity reason;

        InvalidArchiveInfo(long evictionTimestamp, ArchiveValidity reason) {
            this.evictionTimestamp = evictionTimestamp;
            this.reason = reason;
        }
    }

    public static class PerProjectInfo {
        private static final int JAVADOC_CACHE_INITIAL_SIZE = 10;
        static final IJavaModelStatus NEED_RESOLUTION = new JavaModelStatus();
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public IClasspathEntry[] rawClasspath;
        public IClasspathEntry[] referencedEntries;
        public IJavaModelStatus rawClasspathStatus;
        public int rawTimeStamp = 0;
        public boolean writtingRawClasspath = false;
        public IClasspathEntry[] resolvedClasspath;
        public IJavaModelStatus unresolvedEntryStatus;
        public Map<IPath, IClasspathEntry> rootPathToRawEntries;
        public Map<IPath, IClasspathEntry> rootPathToResolvedEntries;
        public IPath outputLocation;
        public Map<IPath, ObjectVector> jrtRoots;
        public IEclipsePreferences preferences;
        public Hashtable<String, String> options;
        private final SecondaryTypes secondaryTypes;
        public LRUCache<IJavaElement, Object> javadocCache;

        public PerProjectInfo(IProject project) {
            this.project = project;
            this.javadocCache = new LRUCache(10);
            this.secondaryTypes = new SecondaryTypes();
        }

        public synchronized IClasspathEntry[] getResolvedClasspath() {
            if (this.unresolvedEntryStatus == NEED_RESOLUTION) {
                return null;
            }
            return this.resolvedClasspath;
        }

        public void forgetExternalTimestampsAndIndexes() {
            IClasspathEntry[] classpath = this.resolvedClasspath;
            if (classpath == null) {
                return;
            }
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            IndexManager indexManager = manager.indexManager;
            Hashtable<IPath, Long> externalTimeStamps = manager.deltaState.getExternalLibTimeStamps();
            Map<IPath, List<DeltaProcessor.RootInfo>> rootInfos = JavaModelManager.getDeltaState().otherRoots;
            IClasspathEntry[] iClasspathEntryArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 1 && rootInfos.get(path = entry.getPath()) == null) {
                    externalTimeStamps.remove(path);
                    indexManager.removeIndex(path);
                }
                ++n2;
            }
        }

        public void rememberExternalLibTimestamps() {
            IClasspathEntry[] classpath = this.resolvedClasspath;
            if (classpath == null) {
                return;
            }
            Hashtable<IPath, Long> externalTimeStamps = JavaModelManager.getJavaModelManager().deltaState.getExternalLibTimeStamps();
            IClasspathEntry[] iClasspathEntryArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (n2 < n) {
                Object target;
                IPath path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 1 && externalTimeStamps.get(path = entry.getPath()) == null && (target = JavaModel.getExternalTarget(path, true)) instanceof File) {
                    long timestamp = DeltaProcessor.getTimeStamp((File)target);
                    externalTimeStamps.put(path, timestamp);
                }
                ++n2;
            }
        }

        public synchronized ClasspathChange resetResolvedClasspath() {
            JavaModelManager.getJavaModelManager().resetClasspathListCache();
            return this.setResolvedClasspath(null, null, null, null, this.rawTimeStamp, true);
        }

        private ClasspathChange setClasspath(IClasspathEntry[] newRawClasspath, IClasspathEntry[] referencedEntries, IPath newOutputLocation, IJavaModelStatus newRawClasspathStatus, IClasspathEntry[] newResolvedClasspath, Map<IPath, IClasspathEntry> newRootPathToRawEntries, Map<IPath, IClasspathEntry> newRootPathToResolvedEntries, IJavaModelStatus newUnresolvedEntryStatus, boolean addClasspathChange) {
            ClasspathChange classpathChange;
            if (DEBUG_CLASSPATH) {
                JavaModelManager.trace("Setting resolved classpath for " + String.valueOf(this.project.getFullPath()));
                if (newResolvedClasspath == null) {
                    JavaModelManager.trace("New classpath = null");
                } else {
                    IClasspathEntry[] iClasspathEntryArray = newResolvedClasspath;
                    int n = newResolvedClasspath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry next = iClasspathEntryArray[n2];
                        JavaModelManager.trace("    " + String.valueOf(next));
                        ++n2;
                    }
                }
            }
            ClasspathChange classpathChange2 = classpathChange = addClasspathChange ? this.addClasspathChange() : null;
            if (referencedEntries != null) {
                this.referencedEntries = referencedEntries;
            }
            if (this.referencedEntries == null) {
                this.referencedEntries = ClasspathEntry.NO_ENTRIES;
            }
            this.rawClasspath = newRawClasspath;
            this.outputLocation = newOutputLocation;
            this.rawClasspathStatus = newRawClasspathStatus;
            this.resolvedClasspath = newResolvedClasspath;
            this.rootPathToRawEntries = newRootPathToRawEntries;
            this.rootPathToResolvedEntries = newRootPathToResolvedEntries;
            this.unresolvedEntryStatus = newUnresolvedEntryStatus;
            this.javadocCache = new LRUCache(10);
            return classpathChange;
        }

        protected ClasspathChange addClasspathChange() {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            ClasspathChange classpathChange = manager.deltaState.addClasspathChange(this.project, this.rawClasspath, this.outputLocation, this.resolvedClasspath);
            return classpathChange;
        }

        public ClasspathChange setRawClasspath(IClasspathEntry[] newRawClasspath, IPath newOutputLocation, IJavaModelStatus newRawClasspathStatus) {
            return this.setRawClasspath(newRawClasspath, null, newOutputLocation, newRawClasspathStatus);
        }

        public synchronized ClasspathChange setRawClasspath(IClasspathEntry[] newRawClasspath, IClasspathEntry[] referencedEntries, IPath newOutputLocation, IJavaModelStatus newRawClasspathStatus) {
            ++this.rawTimeStamp;
            return this.setClasspath(newRawClasspath, referencedEntries, newOutputLocation, newRawClasspathStatus, null, null, null, null, true);
        }

        public ClasspathChange setResolvedClasspath(IClasspathEntry[] newResolvedClasspath, Map<IPath, IClasspathEntry> newRootPathToRawEntries, Map<IPath, IClasspathEntry> newRootPathToResolvedEntries, IJavaModelStatus newUnresolvedEntryStatus, int timeStamp, boolean addClasspathChange) {
            return this.setResolvedClasspath(newResolvedClasspath, null, newRootPathToRawEntries, newRootPathToResolvedEntries, newUnresolvedEntryStatus, timeStamp, addClasspathChange);
        }

        public synchronized ClasspathChange setResolvedClasspath(IClasspathEntry[] newResolvedClasspath, IClasspathEntry[] referencedEntries, Map<IPath, IClasspathEntry> newRootPathToRawEntries, Map<IPath, IClasspathEntry> newRootPathToResolvedEntries, IJavaModelStatus newUnresolvedEntryStatus, int timeStamp, boolean addClasspathChange) {
            if (this.rawTimeStamp != timeStamp) {
                return null;
            }
            return this.setClasspath(this.rawClasspath, referencedEntries, this.outputLocation, this.rawClasspathStatus, newResolvedClasspath, newRootPathToRawEntries, newRootPathToResolvedEntries, newUnresolvedEntryStatus, addClasspathChange);
        }

        public synchronized void setJrtPackageRoots(IPath jrtPath, ObjectVector roots) {
            if (this.jrtRoots == null) {
                this.jrtRoots = new HashMap<IPath, ObjectVector>();
            }
            this.jrtRoots.put(jrtPath, roots);
        }

        public synchronized IClasspathEntry[][] readAndCacheClasspath(JavaProject javaProject) {
            IClasspathEntry entry;
            IJavaModelStatus status;
            IClasspathEntry[][] classpath;
            try {
                classpath = javaProject.readFileEntriesWithException(null);
                status = JavaModelStatus.VERIFIED_OK;
            }
            catch (CoreException e) {
                classpath = new IClasspathEntry[][]{JavaProject.INVALID_CLASSPATH, ClasspathEntry.NO_ENTRIES};
                status = new JavaModelStatus(1000, Messages.bind(Messages.classpath_cannotReadClasspathFile, javaProject.getElementName()));
            }
            catch (IOException e) {
                classpath = new IClasspathEntry[][]{JavaProject.INVALID_CLASSPATH, ClasspathEntry.NO_ENTRIES};
                status = Messages.file_badFormat.equals(e.getMessage()) ? new JavaModelStatus(1000, Messages.bind(Messages.classpath_xmlFormatError, javaProject.getElementName(), Messages.file_badFormat)) : new JavaModelStatus(1000, Messages.bind(Messages.classpath_cannotReadClasspathFile, javaProject.getElementName()));
            }
            catch (ClasspathEntry.AssertionFailedException e) {
                classpath = new IClasspathEntry[][]{JavaProject.INVALID_CLASSPATH, ClasspathEntry.NO_ENTRIES};
                status = new JavaModelStatus(1000, Messages.bind(Messages.classpath_illegalEntryInClasspathFile, new String[]{javaProject.getElementName(), e.getMessage()}));
            }
            int rawClasspathLength = classpath[0].length;
            IPath output = null;
            if (rawClasspathLength > 0 && (entry = classpath[0][rawClasspathLength - 1]).getContentKind() == 10) {
                output = entry.getPath();
                IClasspathEntry[] copy = new IClasspathEntry[rawClasspathLength - 1];
                System.arraycopy(classpath[0], 0, copy, 0, copy.length);
                classpath[0] = copy;
            }
            this.setRawClasspath(classpath[0], classpath[1], output, status);
            return classpath;
        }

        public String toString() {
            int n;
            StringBuilder buffer = new StringBuilder();
            buffer.append("Info for ");
            buffer.append(this.project.getFullPath());
            buffer.append("\nRaw classpath:\n");
            if (this.rawClasspath == null) {
                buffer.append("  <null>\n");
            } else {
                IClasspathEntry[] iClasspathEntryArray = this.rawClasspath;
                n = this.rawClasspath.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry cpe = iClasspathEntryArray[n2];
                    buffer.append("  ");
                    buffer.append(cpe);
                    buffer.append('\n');
                    ++n2;
                }
            }
            buffer.append("Resolved classpath:\n");
            IClasspathEntry[] resolvedCP = this.resolvedClasspath;
            if (resolvedCP == null) {
                buffer.append("  <null>\n");
            } else {
                IClasspathEntry[] iClasspathEntryArray = resolvedCP;
                int n3 = resolvedCP.length;
                n = 0;
                while (n < n3) {
                    IClasspathEntry cpe = iClasspathEntryArray[n];
                    buffer.append("  ");
                    buffer.append(cpe);
                    buffer.append('\n');
                    ++n;
                }
            }
            buffer.append("Resolved classpath status: ");
            if (this.unresolvedEntryStatus == NEED_RESOLUTION) {
                buffer.append("NEED RESOLUTION");
            } else {
                buffer.append(this.unresolvedEntryStatus == null ? "<null>\n" : this.unresolvedEntryStatus.toString());
            }
            buffer.append("Output location:\n  ");
            if (this.outputLocation == null) {
                buffer.append("<null>");
            } else {
                buffer.append(this.outputLocation);
            }
            return buffer.toString();
        }

        public boolean writeAndCacheClasspath(JavaProject javaProject, IClasspathEntry[] newRawClasspath, IClasspathEntry[] newReferencedEntries, IPath newOutputLocation) throws JavaModelException {
            try {
                this.writtingRawClasspath = true;
                if (newReferencedEntries == null) {
                    newReferencedEntries = this.referencedEntries;
                }
                if (!javaProject.writeFileEntries(newRawClasspath, newReferencedEntries, newOutputLocation)) {
                    return false;
                }
                this.setRawClasspath(newRawClasspath, newReferencedEntries, newOutputLocation, JavaModelStatus.VERIFIED_OK);
            }
            finally {
                this.writtingRawClasspath = false;
            }
            return true;
        }

        public boolean writeAndCacheClasspath(JavaProject javaProject, IClasspathEntry[] newRawClasspath, IPath newOutputLocation) throws JavaModelException {
            return this.writeAndCacheClasspath(javaProject, newRawClasspath, null, newOutputLocation);
        }
    }

    public static class PerWorkingCopyInfo
    implements IProblemRequestor {
        int useCount = 0;
        IProblemRequestor problemRequestor;
        CompilationUnit workingCopy;

        public PerWorkingCopyInfo(CompilationUnit workingCopy, IProblemRequestor problemRequestor) {
            this.workingCopy = workingCopy;
            this.problemRequestor = problemRequestor;
        }

        @Override
        public void acceptProblem(IProblem problem) {
            IProblemRequestor requestor = this.getProblemRequestor();
            if (requestor == null) {
                return;
            }
            requestor.acceptProblem(problem);
        }

        @Override
        public void beginReporting() {
            IProblemRequestor requestor = this.getProblemRequestor();
            if (requestor == null) {
                return;
            }
            requestor.beginReporting();
        }

        @Override
        public void endReporting() {
            IProblemRequestor requestor = this.getProblemRequestor();
            if (requestor == null) {
                return;
            }
            requestor.endReporting();
        }

        public IProblemRequestor getProblemRequestor() {
            if (this.problemRequestor == null && this.workingCopy.owner != null) {
                return this.workingCopy.owner.getProblemRequestor(this.workingCopy);
            }
            return this.problemRequestor;
        }

        public ICompilationUnit getWorkingCopy() {
            return this.workingCopy;
        }

        @Override
        public boolean isActive() {
            IProblemRequestor requestor = this.getProblemRequestor();
            return requestor != null && requestor.isActive();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Info for ");
            buffer.append(this.workingCopy.toStringWithAncestors());
            buffer.append("\nUse count = ");
            buffer.append(this.useCount);
            buffer.append("\nProblem requestor:\n  ");
            buffer.append(this.problemRequestor);
            if (this.problemRequestor == null) {
                IProblemRequestor requestor = this.getProblemRequestor();
                buffer.append("\nOwner problem requestor:\n  ");
                buffer.append(requestor);
            }
            return buffer.toString();
        }
    }

    private static final class PersistedClasspathContainer
    implements IClasspathContainer {
        private final IPath containerPath;
        private final IClasspathEntry[] entries;
        private final IJavaProject project;

        PersistedClasspathContainer(IJavaProject project, IPath containerPath, IClasspathEntry[] entries) {
            this.containerPath = containerPath;
            this.entries = entries;
            this.project = project;
        }

        @Override
        public IClasspathEntry[] getClasspathEntries() {
            return this.entries;
        }

        @Override
        public String getDescription() {
            return "Persisted container [" + String.valueOf(this.containerPath) + " for project [" + this.project.getElementName() + "]]";
        }

        @Override
        public int getKind() {
            return 0;
        }

        @Override
        public IPath getPath() {
            return this.containerPath;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    private static class SecondaryTypes {
        private volatile SecondaryTypesCache cache = new SecondaryTypesCache(null, null);

        SecondaryTypesCache cache() {
            return this.cache;
        }

        private synchronized SecondaryTypesCache getOrCreateCache() {
            Hashtable<String, Map<String, IType>> secondaryTypes = this.cache.secondaryTypes;
            Map<Object, Map<String, Map<String, IType>>> indexingSecondaryCache = this.cache.indexingSecondaryCache;
            if (secondaryTypes != null && indexingSecondaryCache != null) {
                return this.cache;
            }
            if (secondaryTypes == null) {
                secondaryTypes = new Hashtable(3);
            }
            if (indexingSecondaryCache == null) {
                indexingSecondaryCache = Collections.synchronizedMap(new HashMap(3));
            }
            this.cache = new SecondaryTypesCache(secondaryTypes, indexingSecondaryCache);
            return this.cache;
        }

        private synchronized SecondaryTypesCache startIndexing() {
            this.cache = new SecondaryTypesCache(this.cache.secondaryTypes(), Collections.synchronizedMap(new HashMap(3)));
            return this.cache;
        }

        private synchronized void indexingDone() {
            this.cache = new SecondaryTypesCache(this.cache.secondaryTypes(), null);
        }

        private synchronized SecondaryTypesCache doneSearching(Hashtable<String, Map<String, IType>> newSecondaryTypes) {
            this.cache = new SecondaryTypesCache(newSecondaryTypes, this.cache.indexingSecondaryCache());
            return this.cache;
        }

        private synchronized void clearAllCaches() {
            this.cache = new SecondaryTypesCache(null, null);
        }
    }

    private record SecondaryTypesCache(Hashtable<String, Map<String, IType>> secondaryTypes, Map<IFile, Map<String, Map<String, IType>>> indexingSecondaryCache) {
        boolean isIndexingDone() {
            return this.secondaryTypes != null && this.indexingSecondaryCache == null;
        }
    }

    private static final class TouchJob
    extends WorkspaceJob {
        private static final WorkspaceJob INSTANCE = new TouchJob();

        private TouchJob() {
            super(Messages.synchronizing_projects_job);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)javaModelManager.touchQueue.size());
            javaModelManager.touchQueue.removeIf(iProject -> {
                subMonitor.setWorkRemaining(javaModelManager.touchQueue.size());
                if (JavaBuilder.DEBUG) {
                    JavaModelManager.trace("Touching project " + iProject.getName());
                }
                if (iProject.isAccessible()) {
                    try {
                        iProject.touch((IProgressMonitor)subMonitor.split(1));
                    }
                    catch (CoreException e) {
                        Util.log(e, "Could not touch project " + iProject.getName());
                    }
                }
                return true;
            });
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_REFRESH == family;
        }
    }

    private final class VariablesAndContainersLoadHelper {
        private static final int ARRAY_INCREMENT = 200;
        private IClasspathEntry[] allClasspathEntries = null;
        private int allClasspathEntryCount = 0;
        private final Map<String, IPath> allPaths = new HashMap<String, IPath>();
        private String[] allStrings = null;
        private int allStringsCount = 0;
        private final DataInputStream in;

        VariablesAndContainersLoadHelper(DataInputStream in) {
            this.in = in;
        }

        void load() throws IOException {
            this.loadProjects(JavaModelManager.this.getJavaModel());
            this.loadVariables();
        }

        private IAccessRule loadAccessRule() throws IOException {
            int problemId = this.loadInt();
            IPath pattern = this.loadPath();
            return JavaModelManager.this.getAccessRuleForProblemId(pattern.toString().toCharArray(), problemId);
        }

        private IAccessRule[] loadAccessRules() throws IOException {
            int count = this.loadInt();
            if (count == 0) {
                return ClasspathEntry.NO_ACCESS_RULES;
            }
            IAccessRule[] rules = new IAccessRule[count];
            int i = 0;
            while (i < count) {
                rules[i] = this.loadAccessRule();
                ++i;
            }
            return rules;
        }

        private IClasspathAttribute loadAttribute() throws IOException {
            String name = this.loadString();
            String value = this.loadString();
            return new ClasspathAttribute(name, value);
        }

        private IClasspathAttribute[] loadAttributes() throws IOException {
            int count = this.loadInt();
            if (count == 0) {
                return ClasspathEntry.NO_EXTRA_ATTRIBUTES;
            }
            IClasspathAttribute[] attributes = new IClasspathAttribute[count];
            int i = 0;
            while (i < count) {
                attributes[i] = this.loadAttribute();
                ++i;
            }
            return attributes;
        }

        private boolean loadBoolean() throws IOException {
            return this.in.readBoolean();
        }

        private IClasspathEntry[] loadClasspathEntries() throws IOException {
            int count = this.loadInt();
            IClasspathEntry[] entries = new IClasspathEntry[count];
            int i = 0;
            while (i < count) {
                entries[i] = this.loadClasspathEntry();
                ++i;
            }
            return entries;
        }

        private IClasspathEntry loadClasspathEntry() throws IOException {
            int id = this.loadInt();
            if (id < 0 || id > this.allClasspathEntryCount) {
                throw new IOException("Unexpected classpathentry id");
            }
            if (id < this.allClasspathEntryCount) {
                return this.allClasspathEntries[id];
            }
            int contentKind = this.loadInt();
            int entryKind = this.loadInt();
            IPath path = this.loadPath();
            IPath[] inclusionPatterns = this.loadPaths();
            IPath[] exclusionPatterns = this.loadPaths();
            IPath sourceAttachmentPath = this.loadPath();
            IPath sourceAttachmentRootPath = this.loadPath();
            IPath specificOutputLocation = this.loadPath();
            boolean isExported = this.loadBoolean();
            IAccessRule[] accessRules = this.loadAccessRules();
            boolean combineAccessRules = this.loadBoolean();
            IClasspathAttribute[] extraAttributes = this.loadAttributes();
            ClasspathEntry entry = new ClasspathEntry(contentKind, entryKind, path, inclusionPatterns, exclusionPatterns, sourceAttachmentPath, sourceAttachmentRootPath, specificOutputLocation, isExported, accessRules, combineAccessRules, extraAttributes);
            IClasspathEntry[] array = this.allClasspathEntries;
            if (array == null || id == array.length) {
                array = new IClasspathEntry[id + 200];
                if (id != 0) {
                    System.arraycopy(this.allClasspathEntries, 0, array, 0, id);
                }
                this.allClasspathEntries = array;
            }
            array[id] = entry;
            this.allClasspathEntryCount = id + 1;
            return entry;
        }

        private void loadContainers(IJavaProject project) throws IOException {
            boolean projectIsAccessible = project.getProject().isAccessible();
            int count = this.loadInt();
            int i = 0;
            while (i < count) {
                IPath path = this.loadPath();
                IClasspathEntry[] entries = this.loadClasspathEntries();
                if (projectIsAccessible) {
                    PersistedClasspathContainer container = new PersistedClasspathContainer(project, path, entries);
                    JavaModelManager.this.containerPut(project, path, container);
                    Map<IPath, IClasspathContainer> oldContainers = JavaModelManager.this.previousSessionContainers.get(project);
                    if (oldContainers == null) {
                        oldContainers = new HashMap<IPath, IClasspathContainer>();
                        JavaModelManager.this.previousSessionContainers.put(project, oldContainers);
                    }
                    oldContainers.put(path, container);
                }
                ++i;
            }
        }

        private int loadInt() throws IOException {
            return this.in.readInt();
        }

        private IPath loadPath() throws IOException {
            if (this.loadBoolean()) {
                return null;
            }
            String portableString = this.loadString();
            IPath path = this.allPaths.get(portableString);
            if (path == null) {
                path = Path.fromPortableString((String)portableString);
                this.allPaths.put(portableString, path);
            }
            return path;
        }

        private IPath[] loadPaths() throws IOException {
            int count = this.loadInt();
            IPath[] pathArray = new IPath[count];
            int i = 0;
            while (i < count) {
                pathArray[i] = this.loadPath();
                ++i;
            }
            return pathArray;
        }

        private void loadProjects(IJavaModel model) throws IOException {
            int count = this.loadInt();
            int i = 0;
            while (i < count) {
                String projectName = this.loadString();
                this.loadContainers(model.getJavaProject(projectName));
                ++i;
            }
        }

        private String loadString() throws IOException {
            int id = this.loadInt();
            if (id < 0 || id > this.allStringsCount) {
                throw new IOException("Unexpected string id");
            }
            if (id < this.allStringsCount) {
                return this.allStrings[id];
            }
            String string = this.in.readUTF();
            String[] array = this.allStrings;
            if (array == null || id == array.length) {
                array = new String[id + 200];
                if (id != 0) {
                    System.arraycopy(this.allStrings, 0, array, 0, id);
                }
                this.allStrings = array;
            }
            array[id] = string;
            this.allStringsCount = id + 1;
            return string;
        }

        private void loadVariables() throws IOException {
            int size = this.loadInt();
            HashMap<String, IPath> loadedVars = new HashMap<String, IPath>(size);
            int i = 0;
            while (i < size) {
                String varName = this.loadString();
                IPath varPath = this.loadPath();
                if (varPath != null) {
                    loadedVars.put(varName, varPath);
                }
                ++i;
            }
            JavaModelManager.this.previousSessionVariables.putAll(loadedVars);
            JavaModelManager.this.variables.putAll(loadedVars);
        }
    }

    private final class VariablesAndContainersSaveHelper {
        private final HashtableOfObjectToInt classpathEntryIds = new HashtableOfObjectToInt();
        private final DataOutputStream out;
        private final HashtableOfObjectToInt stringIds;

        VariablesAndContainersSaveHelper(DataOutputStream out) {
            this.out = out;
            this.stringIds = new HashtableOfObjectToInt();
        }

        void save(ISaveContext context) throws IOException, JavaModelException {
            this.saveProjects(JavaModelManager.this.getJavaModel().getJavaProjects());
            HashMap<String, IPath> varsToSave = null;
            IEclipsePreferences defaultPreferences = JavaModelManager.this.getDefaultPreferences();
            for (Map.Entry<String, IPath> entry : JavaModelManager.this.variables.entrySet()) {
                String varName = entry.getKey();
                if (defaultPreferences.get(JavaModelManager.CP_VARIABLE_PREFERENCES_PREFIX + varName, null) == null && !CP_ENTRY_IGNORE_PATH.equals((Object)entry.getValue())) continue;
                if (varsToSave == null) {
                    varsToSave = new HashMap<String, IPath>(JavaModelManager.this.variables);
                }
                varsToSave.remove(varName);
            }
            this.saveVariables(varsToSave != null ? varsToSave : JavaModelManager.this.variables);
        }

        private void saveAccessRule(ClasspathAccessRule rule) throws IOException {
            this.saveInt(rule.problemId);
            this.savePath(rule.getPattern());
        }

        private void saveAccessRules(IAccessRule[] rules) throws IOException {
            int count = rules == null ? 0 : rules.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.saveAccessRule((ClasspathAccessRule)rules[i]);
                ++i;
            }
        }

        private void saveAttribute(IClasspathAttribute attribute) throws IOException {
            this.saveString(attribute.getName());
            this.saveString(attribute.getValue());
        }

        private void saveAttributes(IClasspathAttribute[] attributes) throws IOException {
            int n;
            int n2;
            IClasspathAttribute[] iClasspathAttributeArray;
            int count = 0;
            if (attributes != null) {
                iClasspathAttributeArray = attributes;
                n2 = attributes.length;
                n = 0;
                while (n < n2) {
                    IClasspathAttribute attr = iClasspathAttributeArray[n];
                    if (attr != null) {
                        ++count;
                    }
                    ++n;
                }
            }
            this.saveInt(count);
            iClasspathAttributeArray = attributes;
            n2 = attributes.length;
            n = 0;
            while (n < n2) {
                IClasspathAttribute attribute = iClasspathAttributeArray[n];
                if (attribute != null) {
                    this.saveAttribute(attribute);
                }
                ++n;
            }
        }

        private void saveClasspathEntries(IClasspathEntry[] entries) throws IOException {
            IClasspathEntry entry;
            int n;
            int n2;
            IClasspathEntry[] iClasspathEntryArray;
            int count = 0;
            if (entries != null) {
                iClasspathEntryArray = entries;
                n2 = entries.length;
                n = 0;
                while (n < n2) {
                    entry = iClasspathEntryArray[n];
                    if (entry != null) {
                        ++count;
                    }
                    ++n;
                }
            }
            this.saveInt(count);
            iClasspathEntryArray = entries;
            n2 = entries.length;
            n = 0;
            while (n < n2) {
                entry = iClasspathEntryArray[n];
                if (entry != null) {
                    this.saveClasspathEntry(entry);
                }
                ++n;
            }
        }

        private void saveClasspathEntry(IClasspathEntry entry) throws IOException {
            if (this.saveNewId(entry, this.classpathEntryIds)) {
                this.saveInt(entry.getContentKind());
                this.saveInt(entry.getEntryKind());
                this.savePath(entry.getPath());
                this.savePaths(entry.getInclusionPatterns());
                this.savePaths(entry.getExclusionPatterns());
                this.savePath(entry.getSourceAttachmentPath());
                this.savePath(entry.getSourceAttachmentRootPath());
                this.savePath(entry.getOutputLocation());
                this.out.writeBoolean(entry.isExported());
                this.saveAccessRules(entry.getAccessRules());
                this.out.writeBoolean(entry.combineAccessRules());
                this.saveAttributes(entry.getExtraAttributes());
            }
        }

        private void saveContainers(IJavaProject project, Map<IPath, IClasspathContainer> containerMap) throws IOException {
            this.saveInt(containerMap.size());
            for (Map.Entry<IPath, IClasspathContainer> entry : containerMap.entrySet()) {
                IPath path = entry.getKey();
                IClasspathContainer container = entry.getValue();
                IClasspathEntry[] cpEntries = null;
                if (container == null) {
                    container = JavaModelManager.this.getPreviousSessionContainer(path, project);
                }
                if (container != null) {
                    cpEntries = container.getClasspathEntries();
                }
                this.savePath(path);
                this.saveClasspathEntries(cpEntries);
            }
        }

        private void saveInt(int value) throws IOException {
            this.out.writeInt(value);
        }

        private boolean saveNewId(Object key, HashtableOfObjectToInt map) throws IOException {
            int id = map.get(key);
            if (id == -1) {
                int newId = map.size();
                map.put(key, newId);
                this.saveInt(newId);
                return true;
            }
            this.saveInt(id);
            return false;
        }

        private void savePath(IPath path) throws IOException {
            if (path == null) {
                this.out.writeBoolean(true);
            } else {
                this.out.writeBoolean(false);
                this.saveString(path.toPortableString());
            }
        }

        private void savePaths(IPath[] paths) throws IOException {
            int count = paths == null ? 0 : paths.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                this.savePath(paths[i]);
                ++i;
            }
        }

        private void saveProjects(IJavaProject[] projects) throws IOException, JavaModelException {
            int count = projects.length;
            this.saveInt(count);
            int i = 0;
            while (i < count) {
                IJavaProject project = projects[i];
                this.saveString(project.getElementName());
                HashMap<IPath, IClasspathContainer> containerMap = JavaModelManager.this.containers.get(project);
                containerMap = containerMap == null ? Collections.EMPTY_MAP : new HashMap<IPath, IClasspathContainer>(containerMap);
                this.saveContainers(project, containerMap);
                ++i;
            }
        }

        private void saveString(String string) throws IOException {
            if (this.saveNewId(string, this.stringIds)) {
                this.out.writeUTF(string);
            }
        }

        private void saveVariables(Map<String, IPath> map) throws IOException {
            this.saveInt(map.size());
            for (Map.Entry<String, IPath> entry : map.entrySet()) {
                String varName = entry.getKey();
                IPath varPath = entry.getValue();
                this.saveString(varName);
                this.savePath(varPath);
            }
        }
    }

    static class ZipCache {
        private final Map<Object, ZipFile> map = new HashMap<Object, ZipFile>();
        Object owner;

        ZipCache(Object owner) {
            this.owner = owner;
        }

        public void flush() {
            Thread currentThread = Thread.currentThread();
            for (ZipFile zf : this.map.values()) {
                String zipFileName = null;
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (ZipFile zipFile = zf;){
                        zipFileName = zipFile.getName();
                        if (!ZIP_ACCESS_VERBOSE) continue;
                        JavaModelManager.trace("(" + String.valueOf(currentThread) + ") [ZipCache[" + String.valueOf(this.owner) + "].flush()] Closing ZipFile on " + zipFile.getName());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    JavaCore.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.jdt.core", "Error closing " + zipFileName, (Throwable)e));
                }
            }
        }

        public ZipFile getCache(IPath path) {
            return this.map.get(path);
        }

        public void setCache(IPath path, ZipFile zipFile) {
            block12: {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (ZipFile old = this.map.put(path, zipFile);){
                        if (old != null && ZIP_ACCESS_VERBOSE) {
                            Thread currentThread = Thread.currentThread();
                            JavaModelManager.trace("(" + String.valueOf(currentThread) + ") [ZipCache[" + String.valueOf(this.owner) + "].setCache()] leaked ZipFile on " + old.getName() + " for path: " + String.valueOf(path));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    if (!VERBOSE) break block12;
                    JavaModelManager.trace("", e);
                }
            }
        }
    }
}

