/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.jdt.core.search.TypeReferenceMatch;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.search.matching.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;

public class TypeReferenceLocator
extends PatternLocator {
    protected final TypeReferencePattern pattern;
    protected final boolean isDeclarationOfReferencedTypesPattern;
    private final int fineGrain;
    private final Map<QualifiedTypeReference, List<TypeBinding>> recordedResolutions = new HashMap<QualifiedTypeReference, List<TypeBinding>>();
    private List<IJavaElement> foundElements = new ArrayList<IJavaElement>();

    public TypeReferenceLocator(TypeReferencePattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.fineGrain = pattern == null ? 0 : pattern.fineGrain;
        this.isDeclarationOfReferencedTypesPattern = this.pattern instanceof DeclarationOfReferencedTypesPattern;
    }

    @Override
    protected void clear() {
        this.recordedResolutions.clear();
    }

    protected IJavaElement findElement(IJavaElement element, int accuracy) {
        if (accuracy != 0) {
            return null;
        }
        DeclarationOfReferencedTypesPattern declPattern = (DeclarationOfReferencedTypesPattern)this.pattern;
        while (element != null && !declPattern.enclosingElement.equals(element)) {
            element = element.getParent();
        }
        return element;
    }

    @Override
    protected int fineGrain() {
        return this.fineGrain;
    }

    @Override
    public int match(Annotation node, MatchingNodeSet nodeSet) {
        return this.match(node.type, nodeSet);
    }

    @Override
    public int match(org.eclipse.jdt.core.dom.Annotation node, MatchingNodeSet nodeSet, MatchLocator locator) {
        return this.match(node.getTypeName(), nodeSet, locator);
    }

    @Override
    public int match(org.eclipse.jdt.internal.compiler.ast.ASTNode node, MatchingNodeSet nodeSet) {
        if (!(node instanceof ImportReference)) {
            return 0;
        }
        return nodeSet.addMatch(node, this.matchLevel((ImportReference)node));
    }

    @Override
    public int match(Reference node, MatchingNodeSet nodeSet) {
        if (!(node instanceof NameReference)) {
            return 0;
        }
        if (this.pattern.simpleName == null) {
            return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, this.pattern.mustResolve ? 2 : 3);
        }
        if (node instanceof SingleNameReference) {
            if (this.matchesName(this.pattern.simpleName, ((SingleNameReference)node).token)) {
                return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, 2);
            }
        } else {
            char[][] tokens;
            char[][] cArray = tokens = ((QualifiedNameReference)node).tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                char[] token = cArray[n2];
                if (this.matchesName(this.pattern.simpleName, token)) {
                    return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, 2);
                }
                ++n2;
            }
        }
        return 0;
    }

    @Override
    public int match(Name name, MatchingNodeSet nodeSet, MatchLocator locator) {
        BreakStatement bs;
        LabeledStatement ls;
        if (name.getParent() instanceof AbstractTypeDeclaration) {
            return 0;
        }
        ASTNode aSTNode = name.getParent();
        if (aSTNode instanceof LabeledStatement && (ls = (LabeledStatement)aSTNode).getLabel() == name) {
            return 0;
        }
        ASTNode aSTNode2 = name.getParent();
        if (aSTNode2 instanceof BreakStatement && (bs = (BreakStatement)aSTNode2).getLabel() == name) {
            return 0;
        }
        if (this.pattern.simpleName == null) {
            return nodeSet.addMatch(name, this.pattern.mustResolve ? 2 : 3);
        }
        if (name instanceof SimpleName) {
            QualifiedName qn3;
            SimpleName sn2 = (SimpleName)name;
            if (this.pattern.qualification == null) {
                return this.match(sn2, nodeSet);
            }
            ASTNode parent3 = name.getParent();
            if (!(parent3 instanceof QualifiedName)) {
                return this.match(sn2, nodeSet);
            }
            if (parent3 instanceof QualifiedName && (qn3 = (QualifiedName)parent3).getQualifier() == name && this.match(sn2, nodeSet) == 2) {
                return 2;
            }
            if (this.pattern.getMatchMode() == 0) {
                return 0;
            }
            if (this.match(sn2, nodeSet) == 2) {
                return 2;
            }
            return 0;
        }
        if (name instanceof QualifiedName) {
            QualifiedName qn2 = (QualifiedName)name;
            return this.match(qn2, nodeSet);
        }
        return 0;
    }

    public int match(SimpleName name, MatchingNodeSet nodeSet) {
        String simpleName = name.getIdentifier();
        return simpleName != null && this.matchesName(this.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    public int match(QualifiedName name, MatchingNodeSet nodeSet) {
        String desiredQualifier;
        String simpleName = name.getName().getIdentifier();
        String qualifier = name.getQualifier().toString();
        if (this.pattern.qualification == null) {
            return 0;
        }
        if (qualifier != null && !qualifier.equals(desiredQualifier = new String(this.pattern.qualification))) {
            return 0;
        }
        return simpleName != null && this.matchesName(this.pattern.simpleName, simpleName.toCharArray()) ? 2 : 0;
    }

    @Override
    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        if (this.pattern.simpleName == null) {
            return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, this.pattern.mustResolve ? 2 : 3);
        }
        if (node instanceof SingleTypeReference) {
            if (this.matchesName(this.pattern.simpleName, ((SingleTypeReference)node).token)) {
                return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, this.pattern.mustResolve ? 2 : 3);
            }
        } else {
            char[][] tokens;
            char[][] cArray = tokens = ((QualifiedTypeReference)node).tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                char[] token = cArray[n2];
                if (this.matchesName(this.pattern.simpleName, token)) {
                    return nodeSet.addMatch((org.eclipse.jdt.internal.compiler.ast.ASTNode)node, 2);
                }
                ++n2;
            }
        }
        return 0;
    }

    @Override
    public int match(ASTNode node, MatchingNodeSet nodeSet, MatchLocator locator) {
        if (node instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDecl = (EnumConstantDeclaration)node;
            ASTNode aSTNode = node.getParent();
            if (aSTNode instanceof EnumDeclaration) {
                EnumDeclaration enumDeclaration = (EnumDeclaration)aSTNode;
                if (enumConstantDecl.getAnonymousClassDeclaration() != null) {
                    if (this.pattern.simpleName == null) {
                        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
                    }
                    if (this.matchesName(this.pattern.simpleName, enumDeclaration.getName().getIdentifier().toCharArray())) {
                        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
                    }
                }
            }
        }
        return 0;
    }

    @Override
    public int match(Type node, MatchingNodeSet nodeSet, MatchLocator locator) {
        if (this.pattern.simpleName == null) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        String qualifiedName = null;
        String simpleName = null;
        if (node instanceof SimpleType) {
            Name name;
            SimpleType simple = (SimpleType)node;
            Name name2 = simple.getName();
            if (name2 instanceof SimpleName) {
                SimpleName name3 = (SimpleName)name2;
                simpleName = name3.getIdentifier();
            }
            if ((name = simple.getName()) instanceof QualifiedName) {
                QualifiedName name4 = (QualifiedName)name;
                simpleName = name4.getName().getIdentifier();
                qualifiedName = name4.getFullyQualifiedName();
            }
        } else if (node instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)node;
            simpleName = qualified.getName().getIdentifier();
            qualifiedName = qualified.getName().getFullyQualifiedName();
        }
        if (qualifiedName != null && this.pattern.qualification != null) {
            char[] found;
            char[] patternQualified = (new String(this.pattern.qualification) + "." + new String(this.pattern.simpleName)).toCharArray();
            if (this.matchesName(patternQualified, found = qualifiedName.toCharArray())) {
                return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
            }
        } else if (simpleName != null && this.matchesName(this.pattern.simpleName, simpleName.toCharArray())) {
            return nodeSet.addMatch(node, this.pattern.mustResolve || this.pattern.qualification == null ? 2 : 3);
        }
        return 0;
    }

    @Override
    protected int matchLevel(ImportReference importRef) {
        if (this.pattern.qualification == null) {
            if (this.pattern.simpleName == null) {
                return 3;
            }
            char[][] tokens = importRef.tokens;
            boolean onDemand = (importRef.bits & 0x20000) != 0;
            boolean isStatic = importRef.isStatic();
            if (!isStatic && onDemand) {
                return 0;
            }
            int length = tokens.length;
            if (this.matchesName(this.pattern.simpleName, tokens[length - 1])) {
                return 3;
            }
            if (isStatic && !onDemand && length > 1 && this.matchesName(this.pattern.simpleName, tokens[length - 2])) {
                return 3;
            }
        } else {
            char[][] tokens = importRef.tokens;
            char[] qualifiedPattern = this.pattern.simpleName == null ? this.pattern.qualification : CharOperation.concat((char[])this.pattern.qualification, (char[])this.pattern.simpleName, (char)'.');
            char[] qualifiedTypeName = CharOperation.concatWith((char[][])tokens, (char)'.');
            if (qualifiedPattern == null) {
                return 3;
            }
            if (qualifiedTypeName == null) {
                return 0;
            }
            if (qualifiedTypeName.length == 0) {
                if (qualifiedPattern.length == 0) {
                    return 3;
                }
                return 0;
            }
            boolean matchFirstChar = !this.isCaseSensitive || qualifiedPattern[0] == qualifiedTypeName[0];
            switch (this.matchMode) {
                case 0: 
                case 1: {
                    if (!CharOperation.prefixEquals((char[])qualifiedPattern, (char[])qualifiedTypeName, (boolean)this.isCaseSensitive)) break;
                    return 2;
                }
                case 2: {
                    if (!CharOperation.match((char[])qualifiedPattern, (char[])qualifiedTypeName, (boolean)this.isCaseSensitive)) break;
                    return 2;
                }
                case 4: {
                    break;
                }
                case 128: {
                    if (matchFirstChar && CharOperation.camelCaseMatch((char[])qualifiedPattern, (char[])qualifiedTypeName, (boolean)false)) {
                        return 2;
                    }
                    if (this.isCaseSensitive || !CharOperation.prefixEquals((char[])qualifiedPattern, (char[])qualifiedTypeName, (boolean)false)) break;
                    return 2;
                }
                case 256: {
                    if (!matchFirstChar || !CharOperation.camelCaseMatch((char[])qualifiedPattern, (char[])qualifiedTypeName, (boolean)true)) break;
                    return 2;
                }
            }
        }
        return 0;
    }

    @Override
    protected void matchLevelAndReportImportRef(ImportReference importRef, Binding binding, MatchLocator locator) throws CoreException {
        Binding refBinding = binding;
        if (importRef.isStatic()) {
            MemberTypeBinding memberBinding;
            if (binding instanceof FieldBinding) {
                FieldBinding fieldBinding = (FieldBinding)binding;
                if (!fieldBinding.isStatic()) {
                    return;
                }
                refBinding = fieldBinding.declaringClass;
            } else if (binding instanceof MethodBinding) {
                MethodBinding methodBinding = (MethodBinding)binding;
                if (!methodBinding.isStatic()) {
                    return;
                }
                refBinding = methodBinding.declaringClass;
            } else if (binding instanceof MemberTypeBinding && !(memberBinding = (MemberTypeBinding)binding).isStatic()) {
                return;
            }
            int level = this.resolveLevel(refBinding);
            if (level >= 1) {
                this.matchReportImportRef(importRef, binding, locator.createImportHandle(importRef), level == 3 ? 0 : 1, locator);
            }
            return;
        }
        super.matchLevelAndReportImportRef(importRef, refBinding, locator);
    }

    @Override
    protected void matchReportImportRef(ImportReference importRef, Binding binding, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (this.isDeclarationOfReferencedTypesPattern) {
            if ((element = this.findElement(element, accuracy)) != null) {
                SimpleSet knownTypes = ((DeclarationOfReferencedTypesPattern)this.pattern).knownTypes;
                while (binding instanceof ReferenceBinding) {
                    ReferenceBinding typeBinding = (ReferenceBinding)binding;
                    this.reportDeclaration(typeBinding, 1, locator, knownTypes);
                    binding = typeBinding.enclosingType();
                }
            }
            return;
        }
        if (this.pattern.hasTypeArguments() && !this.isEquivalentMatch && !this.isErasureMatch) {
            return;
        }
        if (this.pattern.fineGrain != 0 && (this.pattern.fineGrain & 0x8000) == 0) {
            return;
        }
        this.match = locator.newTypeReferenceMatch(element, binding, accuracy, (org.eclipse.jdt.internal.compiler.ast.ASTNode)importRef);
        this.match.setRaw(true);
        if (this.pattern.hasTypeArguments()) {
            this.match.setRule(this.match.getRule() & 0xFFFFFFBF);
        }
        ReferenceBinding typeBinding = null;
        boolean lastButOne = false;
        if (binding instanceof ReferenceBinding) {
            typeBinding = (ReferenceBinding)binding;
        } else if (binding instanceof FieldBinding) {
            typeBinding = ((FieldBinding)binding).declaringClass;
            lastButOne = importRef.isStatic() && (importRef.bits & 0x20000) == 0;
        } else if (binding instanceof MethodBinding) {
            typeBinding = ((MethodBinding)binding).declaringClass;
            boolean bl = lastButOne = importRef.isStatic() && (importRef.bits & 0x20000) == 0;
        }
        if (typeBinding != null) {
            int lastIndex = importRef.tokens.length - 1;
            if (lastButOne) {
                --lastIndex;
            }
            if (typeBinding instanceof ProblemReferenceBinding) {
                ProblemReferenceBinding pbBinding = (ProblemReferenceBinding)typeBinding;
                typeBinding = pbBinding.closestMatch();
                lastIndex = pbBinding.compoundName.length - 1;
            }
            while (typeBinding != null && lastIndex >= 0) {
                if (this.resolveLevelForType((TypeBinding)typeBinding) != 0) {
                    if (locator.encloses(element)) {
                        long[] positions = importRef.sourcePositions;
                        int index = lastIndex;
                        if (this.pattern.qualification != null) {
                            index = lastIndex - this.pattern.segmentsSize;
                        }
                        if (index < 0) {
                            index = 0;
                        }
                        int start = (int)(positions[index] >>> 32);
                        int end = (int)positions[lastIndex];
                        this.match.setOffset(start);
                        this.match.setLength(end - start + 1);
                        locator.report(this.match);
                    }
                    return;
                }
                --lastIndex;
                typeBinding = typeBinding.enclosingType();
            }
        }
        locator.reportAccurateTypeReference(this.match, (org.eclipse.jdt.internal.compiler.ast.ASTNode)importRef, this.pattern.simpleName);
    }

    protected void matchReportReference(ArrayTypeReference arrayRef, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        if (this.pattern.simpleName == null && locator.encloses(element)) {
            int offset = arrayRef.sourceStart;
            int length = arrayRef.sourceEnd - offset + 1;
            if (this.match == null) {
                this.match = locator.newTypeReferenceMatch(element, elementBinding, accuracy, offset, length, (org.eclipse.jdt.internal.compiler.ast.ASTNode)arrayRef);
            } else {
                this.match.setOffset(offset);
                this.match.setLength(length);
            }
            locator.report(this.match);
            return;
        }
        this.match = locator.newTypeReferenceMatch(element, elementBinding, accuracy, (org.eclipse.jdt.internal.compiler.ast.ASTNode)arrayRef);
        if (arrayRef.resolvedType != null) {
            this.matchReportReference((Expression)arrayRef, -1, arrayRef.resolvedType.leafComponentType(), locator);
            return;
        }
        locator.reportAccurateTypeReference(this.match, (org.eclipse.jdt.internal.compiler.ast.ASTNode)arrayRef, this.pattern.simpleName);
    }

    @Override
    protected void matchReportReference(org.eclipse.jdt.internal.compiler.ast.ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        this.matchReportReference(reference, element, null, null, elementBinding, accuracy, locator);
    }

    @Override
    protected void matchReportReference(org.eclipse.jdt.internal.compiler.ast.ASTNode reference, IJavaElement element, IJavaElement localElement, IJavaElement[] otherElements, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        if (this.isDeclarationOfReferencedTypesPattern) {
            if ((element = this.findElement(element, accuracy)) != null) {
                this.reportDeclaration(reference, element, locator, ((DeclarationOfReferencedTypesPattern)this.pattern).knownTypes);
            }
            return;
        }
        TypeReferenceMatch refMatch = locator.newTypeReferenceMatch(element, elementBinding, accuracy, reference);
        refMatch.setLocalElement(localElement);
        refMatch.setOtherElements(otherElements);
        this.match = refMatch;
        if (reference instanceof QualifiedNameReference) {
            this.matchReportReference((QualifiedNameReference)reference, element, elementBinding, accuracy, locator);
        } else if (reference instanceof QualifiedTypeReference) {
            this.matchReportReference((QualifiedTypeReference)reference, element, elementBinding, accuracy, locator);
        } else if (reference instanceof ArrayTypeReference) {
            this.matchReportReference((ArrayTypeReference)reference, element, elementBinding, accuracy, locator);
        } else {
            TypeBinding typeBinding;
            TypeBinding typeBinding2 = typeBinding = reference instanceof Expression && ((Expression)reference).isTrulyExpression() ? ((Expression)reference).resolvedType : null;
            if (typeBinding != null) {
                this.matchReportReference((Expression)reference, -1, typeBinding, locator);
                return;
            }
            locator.report(this.match);
        }
    }

    protected void matchReportReference(QualifiedNameReference qNameRef, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        Binding binding = qNameRef.binding;
        TypeBinding typeBinding = null;
        int lastIndex = qNameRef.tokens.length - 1;
        switch (qNameRef.bits & 7) {
            case 1: {
                typeBinding = qNameRef.actualReceiverType;
                lastIndex -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                break;
            }
            case 4: {
                if (!(binding instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                if (binding instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                if (binding instanceof ProblemFieldBinding) {
                    typeBinding = qNameRef.actualReceiverType;
                    lastIndex -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                    break;
                }
                if (!(binding instanceof ProblemBinding)) break;
                typeBinding = ((ProblemBinding)binding).searchType;
            }
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            ProblemReferenceBinding pbBinding = (ProblemReferenceBinding)typeBinding;
            typeBinding = pbBinding.closestMatch();
            lastIndex = pbBinding.compoundName.length - 1;
        }
        if (this.match == null) {
            this.match = locator.newTypeReferenceMatch(element, elementBinding, accuracy, (org.eclipse.jdt.internal.compiler.ast.ASTNode)qNameRef);
        }
        if (typeBinding instanceof ReferenceBinding) {
            ReferenceBinding refBinding = (ReferenceBinding)typeBinding;
            while (refBinding != null && lastIndex >= 0) {
                if (this.resolveLevelForType((TypeBinding)refBinding) == 3) {
                    if (locator.encloses(element)) {
                        long[] positions = qNameRef.sourcePositions;
                        int index = lastIndex;
                        if (this.pattern.qualification != null) {
                            index = lastIndex - this.pattern.segmentsSize;
                        }
                        if (index < 0) {
                            index = 0;
                        }
                        int start = (int)(positions[index] >>> 32);
                        int end = (int)positions[lastIndex];
                        this.match.setOffset(start);
                        this.match.setLength(end - start + 1);
                        this.matchReportReference((Expression)qNameRef, lastIndex, (TypeBinding)refBinding, locator);
                    }
                    return;
                }
                --lastIndex;
                refBinding = refBinding.enclosingType();
            }
        }
        locator.reportAccurateTypeReference(this.match, (org.eclipse.jdt.internal.compiler.ast.ASTNode)qNameRef, this.pattern.simpleName);
    }

    protected void matchReportReference(QualifiedTypeReference qTypeRef, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        TypeBinding typeBinding = qTypeRef.resolvedType;
        int lastIndex = qTypeRef.tokens.length - 1;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            ProblemReferenceBinding pbBinding = (ProblemReferenceBinding)typeBinding;
            typeBinding = pbBinding.closestMatch();
            lastIndex = pbBinding.compoundName.length - 1;
        }
        if (this.match == null) {
            this.match = locator.newTypeReferenceMatch(element, elementBinding, accuracy, (org.eclipse.jdt.internal.compiler.ast.ASTNode)qTypeRef);
        }
        if (typeBinding instanceof ReferenceBinding) {
            ReferenceBinding refBinding = (ReferenceBinding)typeBinding;
            while (refBinding != null && lastIndex >= 0) {
                if (this.resolveLevelForType((TypeBinding)refBinding) != 0) {
                    if (locator.encloses(element)) {
                        long[] positions = qTypeRef.sourcePositions;
                        int index = lastIndex;
                        if (this.pattern.qualification != null) {
                            index = lastIndex - this.pattern.segmentsSize;
                        }
                        if (index < 0) {
                            index = 0;
                        }
                        int start = (int)(positions[index] >>> 32);
                        int end = (int)positions[lastIndex];
                        this.match.setOffset(start);
                        this.match.setLength(end - start + 1);
                        this.matchReportReference((Expression)qTypeRef, lastIndex, (TypeBinding)refBinding, locator);
                    }
                    return;
                }
                --lastIndex;
                refBinding = refBinding.enclosingType();
            }
        }
        locator.reportAccurateTypeReference(this.match, (org.eclipse.jdt.internal.compiler.ast.ASTNode)qTypeRef, this.pattern.simpleName);
    }

    void matchReportReference(Expression expr, int lastIndex, TypeBinding refBinding, MatchLocator locator) throws CoreException {
        if (refBinding.isParameterizedType() || refBinding.isRawType()) {
            boolean report;
            ParameterizedTypeBinding parameterizedBinding = (ParameterizedTypeBinding)refBinding;
            this.updateMatch(parameterizedBinding, this.pattern.getTypeArguments(), this.pattern.hasTypeParameters(), 0, locator);
            if (this.match.getRule() == 0) {
                return;
            }
            boolean bl = report = this.isErasureMatch && this.match.isErasure() || this.isEquivalentMatch && this.match.isEquivalent() || this.match.isExact();
            if (!report) {
                return;
            }
            if (refBinding.isParameterizedType() && this.pattern.hasTypeArguments()) {
                ParameterizedQualifiedTypeReference typeRef = null;
                TypeReference[] typeArguments = null;
                if (expr instanceof ParameterizedQualifiedTypeReference) {
                    typeRef = (ParameterizedQualifiedTypeReference)expr;
                    typeArguments = ((ParameterizedQualifiedTypeReference)expr).typeArguments[lastIndex];
                } else if (expr instanceof ParameterizedSingleTypeReference) {
                    typeRef = (ParameterizedSingleTypeReference)expr;
                    typeArguments = ((ParameterizedSingleTypeReference)expr).typeArguments;
                }
                if (typeRef != null) {
                    locator.reportAccurateParameterizedTypeReference(this.match, (TypeReference)typeRef, lastIndex, typeArguments);
                    return;
                }
            }
        } else if (this.pattern.hasTypeArguments()) {
            this.match.setRule(16);
        }
        if (expr instanceof ArrayTypeReference) {
            locator.reportAccurateTypeReference(this.match, (org.eclipse.jdt.internal.compiler.ast.ASTNode)expr, this.pattern.simpleName);
            return;
        }
        if (refBinding.isLocalType()) {
            IMethod method;
            LocalTypeBinding local = (LocalTypeBinding)refBinding.erasure();
            IJavaElement focus = this.pattern.focus;
            if (focus != null && local.enclosingMethod != null && focus.getParent().getElementType() == 9 && !CharOperation.equals((char[])local.enclosingMethod.selector, (char[])(method = (IMethod)focus.getParent()).getElementName().toCharArray())) {
                return;
            }
        }
        if (this.pattern.simpleName == null) {
            this.match.setOffset(expr.sourceStart);
            this.match.setLength(expr.sourceEnd - expr.sourceStart + 1);
        }
        locator.report(this.match);
    }

    @Override
    protected int referenceType() {
        return 7;
    }

    protected void reportDeclaration(org.eclipse.jdt.internal.compiler.ast.ASTNode reference, IJavaElement element, MatchLocator locator, SimpleSet knownTypes) throws CoreException {
        TypeBinding typeBinding;
        int maxType;
        block15: {
            block16: {
                block14: {
                    maxType = -1;
                    typeBinding = null;
                    if (!(reference instanceof TypeReference)) break block14;
                    typeBinding = ((TypeReference)reference).resolvedType;
                    maxType = Integer.MAX_VALUE;
                    break block15;
                }
                if (!(reference instanceof QualifiedNameReference)) break block16;
                QualifiedNameReference qNameRef = (QualifiedNameReference)reference;
                Binding binding = qNameRef.binding;
                maxType = qNameRef.tokens.length - 1;
                switch (qNameRef.bits & 7) {
                    case 1: {
                        typeBinding = qNameRef.actualReceiverType;
                        maxType -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                        break;
                    }
                    case 4: {
                        if (binding instanceof TypeBinding) {
                            typeBinding = (TypeBinding)binding;
                            break;
                        }
                        break block15;
                    }
                    case 3: 
                    case 7: {
                        if (binding instanceof ProblemFieldBinding) {
                            typeBinding = qNameRef.actualReceiverType;
                            maxType -= qNameRef.otherBindings == null ? 1 : qNameRef.otherBindings.length + 1;
                            break;
                        }
                        if (binding instanceof ProblemBinding) {
                            ProblemBinding pbBinding = (ProblemBinding)binding;
                            typeBinding = pbBinding.searchType;
                            char[] partialQualifiedName = pbBinding.name;
                            maxType = CharOperation.occurencesOf((char)'.', (char[])partialQualifiedName) - 1;
                            if (typeBinding == null || maxType < 0) {
                                return;
                            }
                        }
                        break block15;
                    }
                }
                break block15;
            }
            if (reference instanceof SingleNameReference) {
                typeBinding = (TypeBinding)((SingleNameReference)reference).binding;
                maxType = 1;
            }
        }
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding == null || typeBinding instanceof BaseTypeBinding) {
            return;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            TypeBinding original = typeBinding.closestMatch();
            if (original == null) {
                return;
            }
            typeBinding = original;
        }
        typeBinding = typeBinding.erasure();
        this.reportDeclaration((ReferenceBinding)typeBinding, maxType, locator, knownTypes);
    }

    protected void reportDeclaration(ReferenceBinding typeBinding, int maxType, MatchLocator locator, SimpleSet knownTypes) throws CoreException {
        IType type = locator.lookupType(typeBinding);
        if (type == null) {
            return;
        }
        IResource resource = type.getResource();
        boolean isBinary = type.isBinary();
        IBinaryType info = null;
        if (isBinary) {
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
        }
        while (maxType >= 0 && type != null) {
            if (!knownTypes.includes((Object)type)) {
                if (isBinary) {
                    locator.reportBinaryMemberDeclaration(resource, type, (Binding)typeBinding, info, 0);
                } else {
                    ClassScope scope;
                    if (typeBinding instanceof ParameterizedTypeBinding) {
                        typeBinding = ((ParameterizedTypeBinding)typeBinding).genericType();
                    }
                    if ((scope = ((SourceTypeBinding)typeBinding).scope) != null) {
                        TypeDeclaration typeDecl = scope.referenceContext;
                        int offset = typeDecl.sourceStart;
                        this.match = new TypeDeclarationMatch(((JavaElement)((Object)type)).resolved((Binding)typeBinding), 0, offset, typeDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
                        locator.report(this.match);
                    }
                }
                knownTypes.add((Object)type);
            }
            typeBinding = typeBinding.enclosingType();
            IJavaElement parent = type.getParent();
            type = parent instanceof IType ? (IType)parent : null;
            --maxType;
        }
    }

    @Override
    public int resolveLevel(org.eclipse.jdt.internal.compiler.ast.ASTNode node) {
        if (node instanceof TypeReference) {
            return this.resolveLevel((TypeReference)node);
        }
        if (node instanceof NameReference) {
            return this.resolveLevel((NameReference)node);
        }
        return 0;
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof MethodBinding) {
            return this.resolveLevel((MethodBinding)binding);
        }
        if (binding instanceof VariableBinding) {
            return this.resolveLevel((VariableBinding)binding);
        }
        if (!(binding instanceof TypeBinding)) {
            return 0;
        }
        TypeBinding typeBinding = (TypeBinding)binding;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).closestMatch();
        }
        return this.resolveLevelForTypeOrEnclosingTypes(this.pattern.simpleName, this.pattern.qualification, typeBinding);
    }

    private int resolveLevel(MethodBinding binding) {
        int level = this.resolveLevelForTypes(binding.parameters);
        if (level != 0) {
            return level;
        }
        if (binding.typeVariables != null) {
            TypeVariableBinding[] typeVariableBindingArray = binding.typeVariables;
            int n = binding.typeVariables.length;
            int n2 = 0;
            while (n2 < n) {
                TypeVariableBinding tv = typeVariableBindingArray[n2];
                if (tv.superclass != null && (level = this.resolveLevelForType((TypeBinding)tv.superclass)) != 0) {
                    return level;
                }
                level = this.resolveLevelForTypes((TypeBinding[])tv.superInterfaces);
                if (level != 0) {
                    return level;
                }
                ++n2;
            }
        }
        if (!binding.isVoidMethod() && binding.returnType != null) {
            return this.resolveLevelForType(binding.returnType);
        }
        return 0;
    }

    private int resolveLevel(VariableBinding binding) {
        if (binding.type != null) {
            return this.resolveLevelForType(binding.type);
        }
        return 0;
    }

    private int resolveLevelForTypes(TypeBinding[] types) {
        if (types != null) {
            TypeBinding[] typeBindingArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding t = typeBindingArray[n2];
                int levelForType = this.resolveLevelForType(t);
                if (levelForType != 0) {
                    return levelForType;
                }
                ++n2;
            }
        }
        return 0;
    }

    protected int resolveLevel(NameReference nameRef) {
        Binding binding = nameRef.binding;
        if (nameRef instanceof SingleNameReference) {
            if (binding instanceof ProblemReferenceBinding) {
                binding = ((ProblemReferenceBinding)binding).closestMatch();
            }
            if (binding instanceof ReferenceBinding) {
                return this.resolveLevelForType((TypeBinding)((ReferenceBinding)binding));
            }
            if (((SingleNameReference)nameRef).isLabel) {
                return 0;
            }
            return binding == null || binding instanceof ProblemBinding ? 1 : 0;
        }
        TypeBinding typeBinding = null;
        QualifiedNameReference qNameRef = (QualifiedNameReference)nameRef;
        switch (qNameRef.bits & 7) {
            case 1: {
                if (qNameRef.tokens.length < (qNameRef.otherBindings == null ? 2 : qNameRef.otherBindings.length + 2)) {
                    return 0;
                }
                typeBinding = nameRef.actualReceiverType;
                break;
            }
            case 2: {
                return 0;
            }
            case 4: {
                if (!(binding instanceof TypeBinding)) break;
                typeBinding = (TypeBinding)binding;
                break;
            }
            case 3: 
            case 7: {
                if (binding instanceof ProblemReferenceBinding) {
                    typeBinding = (TypeBinding)binding;
                    break;
                }
                if (binding instanceof ProblemFieldBinding) {
                    if (qNameRef.tokens.length < (qNameRef.otherBindings == null ? 2 : qNameRef.otherBindings.length + 2)) {
                        return 0;
                    }
                    typeBinding = nameRef.actualReceiverType;
                    break;
                }
                if (!(binding instanceof ProblemBinding)) break;
                ProblemBinding pbBinding = (ProblemBinding)binding;
                if (CharOperation.occurencesOf((char)'.', (char[])pbBinding.name) <= 0) {
                    return 1;
                }
                typeBinding = pbBinding.searchType;
            }
        }
        return this.resolveLevel((Binding)typeBinding);
    }

    protected int resolveLevel(TypeReference typeRef) {
        TypeBinding typeBinding = typeRef.resolvedType;
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).closestMatch();
        }
        if (typeRef instanceof SingleTypeReference) {
            return this.resolveLevelForType(typeBinding);
        }
        return this.resolveLevelForTypeOrQualifyingTypes(typeRef, typeBinding);
    }

    protected int resolveLevelForType(TypeBinding typeBinding) {
        if (typeBinding == null || !typeBinding.isValidBinding()) {
            if (this.pattern.typeSuffix != '\u0000') {
                return 1;
            }
        } else {
            switch (this.pattern.typeSuffix) {
                case 'C': {
                    if (typeBinding.isClass()) break;
                    return 0;
                }
                case '\n': {
                    if (typeBinding.isClass() || typeBinding.isInterface() && !typeBinding.isAnnotationType()) break;
                    return 0;
                }
                case '\t': {
                    if (typeBinding.isClass() || typeBinding.isEnum()) break;
                    return 0;
                }
                case 'I': {
                    if (typeBinding.isInterface() && !typeBinding.isAnnotationType()) break;
                    return 0;
                }
                case '\u000b': {
                    if (typeBinding.isInterface() || typeBinding.isAnnotationType()) break;
                    return 0;
                }
                case 'E': {
                    if (typeBinding.isEnum()) break;
                    return 0;
                }
                case 'A': {
                    if (typeBinding.isAnnotationType()) break;
                    return 0;
                }
            }
        }
        return this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, this.pattern.getTypeArguments(), 0, typeBinding);
    }

    protected int resolveLevelForType(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            if (this.pattern.typeSuffix != '\u0000') {
                return 1;
            }
        } else {
            switch (this.pattern.typeSuffix) {
                case 'C': {
                    if (typeBinding.isClass()) break;
                    return 0;
                }
                case '\n': {
                    if (typeBinding.isClass() || typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\t': {
                    if (typeBinding.isClass() || typeBinding.isEnum()) break;
                    return 0;
                }
                case 'I': {
                    if (typeBinding.isInterface() && !typeBinding.isAnnotation()) break;
                    return 0;
                }
                case '\u000b': {
                    if (typeBinding.isInterface() || typeBinding.isAnnotation()) break;
                    return 0;
                }
                case 'E': {
                    if (typeBinding.isEnum()) break;
                    return 0;
                }
                case 'A': {
                    if (typeBinding.isAnnotation()) break;
                    return 0;
                }
            }
        }
        return this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, typeBinding);
    }

    protected int resolveLevelForTypeOrEnclosingTypes(char[] simpleNamePattern, char[] qualificationPattern, TypeBinding binding) {
        if (binding == null) {
            return 1;
        }
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding type = (ReferenceBinding)binding;
            while (type != null) {
                int level = this.resolveLevelForType((TypeBinding)type);
                if (level != 0) {
                    return level;
                }
                type = type.enclosingType();
            }
        }
        return 0;
    }

    int resolveLevelForTypeOrQualifyingTypes(TypeReference typeRef, TypeBinding typeBinding) {
        if (typeBinding == null || !typeBinding.isValidBinding()) {
            return 1;
        }
        List<TypeBinding> resolutionsList = this.recordedResolutions.get(typeRef);
        if (resolutionsList != null) {
            for (TypeBinding resolution : resolutionsList) {
                int level = this.resolveLevelForType(resolution);
                if (level == 0) continue;
                return level;
            }
        }
        return 0;
    }

    @Override
    public void recordResolution(QualifiedTypeReference typeReference, TypeBinding resolution) {
        List<TypeBinding> resolutionsForTypeReference = this.recordedResolutions.get(typeReference);
        if (resolutionsForTypeReference == null) {
            resolutionsForTypeReference = new ArrayList<TypeBinding>();
        }
        resolutionsForTypeReference.add(resolution);
        this.recordedResolutions.put(typeReference, resolutionsForTypeReference);
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }

    private boolean hasPackageDeclarationAncestor(ASTNode node) {
        if (node instanceof PackageDeclaration) {
            return true;
        }
        return node == null ? false : this.hasPackageDeclarationAncestor(node.getParent());
    }

    @Override
    public int resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (binding == null) {
            SimpleName sn;
            int accuracy;
            if (node instanceof SimpleName && (accuracy = this.resolveLevelForSimpleName(node, (sn = (SimpleName)node).getIdentifier())) != -1) {
                IResource r = null;
                IJavaElement enclosing = DOMASTNodeUtils.getEnclosingJavaElement(node);
                IJavaElement ancestor = enclosing == null ? null : enclosing.getAncestor(5);
                try {
                    r = ancestor == null ? null : ancestor.getCorrespondingResource();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                TypeReferenceMatch typeMatch = new TypeReferenceMatch(enclosing, accuracy, node.getStartPosition(), node.getLength(), DOMASTNodeUtils.insideDocComment(node), locator.getParticipant(), r);
                try {
                    locator.report(typeMatch);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return 0;
            }
            return 1;
        }
        if (binding instanceof ITypeBinding) {
            ITypeBinding typeBinding = (ITypeBinding)binding;
            return this.resolveLevelForTypeBinding(node, typeBinding, locator);
        }
        if (binding instanceof IPackageBinding && node instanceof SimpleName) {
            SimpleName sn = (SimpleName)node;
            if (this.isDeclarationOfReferencedTypesPattern) {
                return 0;
            }
            if (this.hasPackageDeclarationAncestor(node)) {
                return 0;
            }
            String identifier = sn.getIdentifier();
            if (this.matchesName(this.pattern.simpleName, identifier.toCharArray())) {
                return 1;
            }
        }
        return 0;
    }

    private int resolveLevelForSimpleName(ASTNode node, String simpleNameNeedle) {
        if (!simpleNameNeedle.contains(".") && this.pattern.qualification != null && this.pattern.qualification.length > 0) {
            CompilationUnit cu = this.findCU(node);
            List imports = cu.imports();
            for (Object id : imports) {
                QualifiedName qn;
                ImportDeclaration idd = (ImportDeclaration)id;
                Name name = idd.getName();
                if (!(name instanceof QualifiedName) || !(qn = (QualifiedName)name).getName().toString().equals(simpleNameNeedle)) continue;
                char[] qualifiedPattern = this.getQualifiedPattern(this.pattern.simpleName, this.pattern.qualification);
                int level3 = this.resolveLevelForTypeSourceName(qualifiedPattern, qn.toString().toCharArray(), null);
                if (level3 == 3) {
                    return 1;
                }
                return 1;
            }
        }
        return -1;
    }

    private int resolveLevelForTypeBinding(ASTNode node, ITypeBinding typeBinding, MatchLocator locator) {
        String qualNameFromBinding;
        int simpleNameMatch;
        int newLevel = this.resolveLevelForType(this.pattern.simpleName, this.pattern.qualification, typeBinding);
        if (newLevel == 0 && (simpleNameMatch = this.resolveLevelForSimpleName(node, qualNameFromBinding = typeBinding.getQualifiedName())) != -1) {
            return simpleNameMatch;
        }
        if (this.isDeclarationOfReferencedTypesPattern) {
            IJavaElement je;
            IJavaElement enclosing = ((DeclarationOfReferencedTypesPattern)this.pattern).enclosingElement;
            ITypeBinding t2 = typeBinding.getTypeDeclaration();
            IJavaElement iJavaElement = je = t2 == null ? null : t2.getJavaElement();
            if (je != null && !this.foundElements.contains(je) && DOMASTNodeUtils.isWithinRange(node, enclosing)) {
                ISourceRange rangeToUse;
                ISourceReference sr = je instanceof ISourceReference ? (ISourceReference)((Object)je) : null;
                IResource r = null;
                ISourceRange srg = null;
                ISourceRange nameRange = null;
                try {
                    srg = sr.getSourceRange();
                    nameRange = sr.getNameRange();
                    IJavaElement ancestor = je.getAncestor(5);
                    r = ancestor == null ? null : ancestor.getCorrespondingResource();
                }
                catch (JavaModelException ancestor) {
                    // empty catch block
                }
                ISourceRange iSourceRange = rangeToUse = nameRange == null ? srg : nameRange;
                if (rangeToUse != null) {
                    TypeDeclarationMatch tdm = new TypeDeclarationMatch(je, newLevel, rangeToUse.getOffset(), rangeToUse.getLength(), locator.getParticipant(), r);
                    try {
                        this.foundElements.add(je);
                        locator.report(tdm);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }
        return newLevel;
    }

    private CompilationUnit findCU(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)node;
            return cu;
        }
        return this.findCU(node.getParent());
    }
}

