/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.semantictokens.SemanticTokensVisitor;
import org.eclipse.jdt.ls.core.internal.semantictokens.TokenModifier;
import org.eclipse.jdt.ls.core.internal.semantictokens.TokenType;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensParams;

public class SemanticTokensHandler {
    public static SemanticTokens full(IProgressMonitor monitor, SemanticTokensParams params, BaseDocumentLifeCycleHandler.DocumentMonitor documentMonitor) {
        ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        documentMonitor.checkChanged();
        if (typeRoot == null || monitor.isCanceled()) {
            return new SemanticTokens(Collections.emptyList());
        }
        JobHelpers.waitForJobs("DocumentLifeCycleJobs", monitor);
        documentMonitor.checkChanged();
        CompilationUnit root = SemanticTokensHandler.getAst(typeRoot, monitor);
        documentMonitor.checkChanged();
        if (root == null || monitor.isCanceled()) {
            return new SemanticTokens(Collections.emptyList());
        }
        SemanticTokensVisitor collector = new SemanticTokensVisitor(root);
        root.accept((ASTVisitor)collector);
        return collector.getSemanticTokens();
    }

    public static SemanticTokensLegend legend() {
        return new SemanticTokensLegend(Arrays.stream(TokenType.values()).map(TokenType::toString).collect(Collectors.toList()), Arrays.stream(TokenModifier.values()).map(TokenModifier::toString).collect(Collectors.toList()));
    }

    private static CompilationUnit getAst(ITypeRoot typeRoot, IProgressMonitor monitor) {
        CompilationUnit root = CoreASTProvider.getInstance().getAST(typeRoot, CoreASTProvider.WAIT_YES, monitor);
        if (root == null) {
            return null;
        }
        IJavaElement element = root.getJavaElement();
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            try {
                if (cu.getBuffer().getLength() != root.getLength()) {
                    CoreASTProvider.getInstance().disposeAST();
                    root = CoreASTProvider.getInstance().getAST(typeRoot, CoreASTProvider.WAIT_YES, monitor);
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
            }
        }
        return root;
    }
}

