/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.launchers;

import com.microsoft.java.test.plugin.launchers.JUnitLaunchArguments;
import com.microsoft.java.test.plugin.launchers.JUnitLaunchUtils;
import com.microsoft.java.test.plugin.model.Response;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.util.JUnitPlugin;
import com.microsoft.java.test.plugin.util.TestSearchUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class JUnitLaunchConfigurationDelegate
extends org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate {
    private JUnitLaunchUtils.Argument args;
    private static final Set<String> testNameArgs = new HashSet<String>(Arrays.asList("-test", "-classNames", "-packageNameFile", "-testNameFile"));

    public JUnitLaunchConfigurationDelegate(JUnitLaunchUtils.Argument args) {
        this.args = args;
    }

    public Response<JUnitLaunchArguments> getJUnitLaunchArguments(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        Launch launch = new Launch(configuration, mode, null);
        try {
            Method getVMRunnerConfiguration = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredMethod("getVMRunnerConfiguration", ILaunchConfiguration.class, ILaunch.class, String.class, IProgressMonitor.class);
            getVMRunnerConfiguration.setAccessible(true);
            VMRunnerConfiguration config = (VMRunnerConfiguration)getVMRunnerConfiguration.invoke((Object)this, configuration, launch, mode, new NullProgressMonitor());
            IJavaProject javaProject = this.getJavaProject(configuration);
            JUnitLaunchArguments launchArguments = new JUnitLaunchArguments();
            launchArguments.workingDirectory = config.getWorkingDirectory();
            launchArguments.mainClass = config.getClassToLaunch();
            launchArguments.projectName = javaProject.getProject().getName();
            launchArguments.classpath = config.getClassPath();
            launchArguments.modulepath = config.getModulepath();
            launchArguments.vmArguments = this.getVmArguments(config);
            launchArguments.programArguments = this.parseParameters(config.getProgramArguments());
            return new Response<JUnitLaunchArguments>(launchArguments, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException | CoreException e) {
            JUnitPlugin.logException("failed to resolve the classpath.", e);
            String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            return new Response<Object>(null, msg);
        }
    }

    private String[] getVmArguments(VMRunnerConfiguration config) {
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.addAll(Arrays.asList(config.getVMArguments()));
        if (config.isPreviewEnabled()) {
            vmArgs.add("--enable-preview");
        }
        String dependencies = config.getOverrideDependencies();
        JUnitLaunchUtils.addOverrideDependencies(vmArgs, dependencies);
        return vmArgs.toArray(new String[vmArgs.size()]);
    }

    private String[] parseParameters(String[] programArguments) throws CoreException {
        LinkedList<String> arguments = new LinkedList<String>();
        int i = 0;
        while (i < programArguments.length) {
            if (testNameArgs.contains(programArguments[i])) {
                while (i + 1 < programArguments.length && !programArguments[i + 1].startsWith("-")) {
                    ++i;
                }
            } else {
                arguments.add(programArguments[i]);
                while (i + 1 < programArguments.length && !programArguments[i + 1].startsWith("-")) {
                    arguments.add(programArguments[++i]);
                }
            }
            ++i;
        }
        this.addTestItemArgs(arguments);
        return arguments.toArray(new String[arguments.size()]);
    }

    private void addTestItemArgs(List<String> arguments) throws CoreException {
        if (this.args.testLevel == TestLevel.CLASS) {
            String fileName = this.createTestNamesFile(this.args.testNames);
            arguments.add("-testNameFile");
            arguments.add(fileName);
        } else if (this.args.testLevel == TestLevel.METHOD) {
            arguments.add("-test");
            IMethod method = (IMethod)JavaCore.create((String)this.args.testNames[0]);
            Object testName = method.getElementName();
            if (this.args.testKind == TestKind.JUnit5 && method.getParameters().length > 0) {
                String key;
                ICompilationUnit unit = method.getCompilationUnit();
                if (unit == null) {
                    throw new CoreException((IStatus)new Status(4, "java.test.runner", 4, "Cannot get compilation unit of method" + method.getElementName(), null));
                }
                CompilationUnit root = (CompilationUnit)TestSearchUtils.parseToAst(unit, false, (IProgressMonitor)new NullProgressMonitor());
                ASTNode methodDeclaration = root.findDeclaringNode(key = method.getKey());
                if (methodDeclaration == null) {
                    methodDeclaration = NodeFinder.perform((ASTNode)root, (int)method.getSourceRange().getOffset(), (int)method.getSourceRange().getLength(), (ITypeRoot)unit);
                }
                if (!(methodDeclaration instanceof MethodDeclaration)) {
                    throw new CoreException((IStatus)new Status(4, "java.test.runner", 4, "Cannot get method declaration of method" + method.getElementName(), null));
                }
                LinkedList<String> parameters = new LinkedList<String>();
                for (Object obj : ((MethodDeclaration)methodDeclaration).parameters()) {
                    if (!(obj instanceof SingleVariableDeclaration)) continue;
                    ITypeBinding paramTypeBinding = ((SingleVariableDeclaration)obj).getType().resolveBinding();
                    if (paramTypeBinding == null) {
                        throw new CoreException((IStatus)new Status(4, "java.test.runner", 4, "Cannot set set argument for method" + methodDeclaration.toString(), null));
                    }
                    if (paramTypeBinding.isPrimitive()) {
                        parameters.add(paramTypeBinding.getQualifiedName());
                        continue;
                    }
                    parameters.add(paramTypeBinding.getBinaryName());
                }
                if (parameters.size() > 0) {
                    testName = (String)testName + "(" + String.join((CharSequence)",", parameters) + ")";
                }
            }
            arguments.add(method.getDeclaringType().getFullyQualifiedName() + ":" + (String)testName);
            if (StringUtils.isNotBlank((CharSequence)this.args.uniqueId)) {
                arguments.add("-uniqueId");
                arguments.add(this.args.uniqueId);
            }
        }
    }

    private String createTestNamesFile(String[] testNames) throws CoreException {
        try {
            File file = File.createTempFile("testNames", ".txt");
            file.deleteOnExit();
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
                String[] stringArray = testNames;
                int n = testNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String testName = stringArray[n2];
                    bw.write(testName.substring(testName.indexOf("@") + 1));
                    bw.newLine();
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "java.test.runner", 4, "", (Throwable)e));
        }
    }
}

