/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;

public class BasicFileDetector {
    private static final String METADATA_FOLDER = "**/.metadata";
    private static final Set<FileVisitOption> FOLLOW_LINKS_OPTION = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
    private List<Path> directories;
    private Path rootDir;
    private List<String> fileNames;
    private int maxDepth = 5;
    private boolean includeNested = true;
    private Set<String> exclusions = new LinkedHashSet<String>(1);

    public BasicFileDetector(Path rootDir, String ... fileNames) {
        this.rootDir = rootDir;
        this.fileNames = fileNames == null ? new ArrayList() : Arrays.asList(fileNames);
        this.directories = new ArrayList<Path>();
        this.addExclusions(METADATA_FOLDER);
        List<String> javaImportExclusions = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getJavaImportExclusions();
        if (javaImportExclusions != null) {
            for (String pattern : javaImportExclusions) {
                this.addExclusions(pattern);
            }
        }
    }

    public BasicFileDetector addExclusions(String ... excludes) {
        if (excludes != null) {
            this.exclusions.addAll(Arrays.asList(excludes));
        }
        return this;
    }

    public BasicFileDetector includeNested(boolean includeNested) {
        this.includeNested = includeNested;
        return this;
    }

    public BasicFileDetector maxDepth(int maxDepth) {
        Assert.isTrue((maxDepth > 0 ? 1 : 0) != 0, (String)"maxDepth must be > 0");
        this.maxDepth = maxDepth;
        return this;
    }

    public Collection<Path> getDirectories() {
        return Collections.unmodifiableList(this.directories);
    }

    public Collection<Path> scan(IProgressMonitor monitor) throws CoreException {
        try {
            this.scanDir(this.rootDir, (IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor));
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Failed to scan " + String.valueOf(this.rootDir), e));
        }
        return this.getDirectories();
    }

    private void scanDir(Path dir, final IProgressMonitor monitor) throws IOException {
        final boolean hasInclusionPattern = this.exclusions.stream().anyMatch(e -> e.startsWith("!"));
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                Objects.requireNonNull(dir);
                if (BasicFileDetector.this.isExcluded(dir)) {
                    return hasInclusionPattern ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                }
                if (BasicFileDetector.this.hasTargetFile(dir)) {
                    BasicFileDetector.this.directories.add(dir);
                    return BasicFileDetector.this.includeNested ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                Objects.requireNonNull(file);
                if (exc instanceof FileSystemLoopException) {
                    return FileVisitResult.CONTINUE;
                }
                if (exc instanceof NoSuchFileException || exc instanceof AccessDeniedException || exc instanceof FileSystemException) {
                    JavaLanguageServerPlugin.logInfo("Scan of file failed: " + exc.toString());
                    return FileVisitResult.CONTINUE;
                }
                throw exc;
            }
        };
        Files.walkFileTree(dir, FOLLOW_LINKS_OPTION, this.maxDepth, (FileVisitor<? super Path>)visitor);
    }

    private boolean isExcluded(Path dir) {
        if (dir.getFileName() == null) {
            return true;
        }
        boolean excluded = false;
        for (String pattern : this.exclusions) {
            PathMatcher matcher;
            boolean includePattern = false;
            if (pattern.startsWith("!")) {
                includePattern = true;
                pattern = pattern.substring(1);
            }
            if (!(matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern)).matches(dir)) continue;
            boolean bl = excluded = !includePattern;
        }
        return excluded;
    }

    private boolean hasTargetFile(Path dir) {
        for (String fileName : this.fileNames) {
            if (!Files.isRegularFile(dir.resolve(fileName), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }
}

