/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.fix.AddInferredLambdaParameterTypesFixCore;
import org.eclipse.jdt.internal.corext.fix.AddMissingMethodDeclarationFixCore;
import org.eclipse.jdt.internal.corext.fix.AddVarLambdaParameterTypesFixCore;
import org.eclipse.jdt.internal.corext.fix.ChangeLambdaBodyToBlockFixCore;
import org.eclipse.jdt.internal.corext.fix.ChangeLambdaBodyToExpressionFixCore;
import org.eclipse.jdt.internal.corext.fix.ConvertLambdaToMethodReferenceFixCore;
import org.eclipse.jdt.internal.corext.fix.ConvertToMessageFormatFixCore;
import org.eclipse.jdt.internal.corext.fix.ConvertToStringBufferFixCore;
import org.eclipse.jdt.internal.corext.fix.ConvertToStringFormatFixCore;
import org.eclipse.jdt.internal.corext.fix.InvertEqualsExpressionFixCore;
import org.eclipse.jdt.internal.corext.fix.JoinVariableFixCore;
import org.eclipse.jdt.internal.corext.fix.LambdaExpressionAndMethodRefFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.fix.RemoveVarOrInferredLambdaParameterTypesFixCore;
import org.eclipse.jdt.internal.corext.fix.SplitVariableFixCore;
import org.eclipse.jdt.internal.corext.fix.StringConcatToTextBlockFixCore;
import org.eclipse.jdt.internal.corext.fix.SwitchExpressionsFixCore;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryWithResourcesAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithTryWithResourcesRefactoringCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.QuickAssistProcessorUtil;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AssignToVariableAssistProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.internal.ui.text.correction.proposals.RefactoringCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.JavadocTagsSubProcessor;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.RefactorProposalUtility;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;

public class QuickAssistProcessor {
    public static final String SPLIT_JOIN_VARIABLE_DECLARATION_ID = "org.eclipse.jdt.ls.correction.splitJoinVariableDeclaration.assist";
    public static final String CONVERT_FOR_LOOP_ID = "org.eclipse.jdt.ls.correction.convertForLoop.assist";
    public static final String ASSIGN_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.assignToLocal.assist";
    public static final String ASSIGN_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignToField.assist";
    public static final String ASSIGN_PARAM_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.assignParamToField.assist";
    public static final String ASSIGN_ALL_PARAMS_TO_NEW_FIELDS_ID = "org.eclipse.jdt.ls.correction.assignAllParamsToNewFields.assist";
    public static final String ADD_BLOCK_ID = "org.eclipse.jdt.ls.correction.addBlock.assist";
    public static final String EXTRACT_LOCAL_ID = "org.eclipse.jdt.ls.correction.extractLocal.assist";
    public static final String EXTRACT_LOCAL_NOT_REPLACE_ID = "org.eclipse.jdt.ls.correction.extractLocalNotReplaceOccurrences.assist";
    public static final String EXTRACT_CONSTANT_ID = "org.eclipse.jdt.ls.correction.extractConstant.assist";
    public static final String INLINE_LOCAL_ID = "org.eclipse.jdt.ls.correction.inlineLocal.assist";
    public static final String CONVERT_LOCAL_TO_FIELD_ID = "org.eclipse.jdt.ls.correction.convertLocalToField.assist";
    public static final String CONVERT_ANONYMOUS_TO_LOCAL_ID = "org.eclipse.jdt.ls.correction.convertAnonymousToLocal.assist";
    public static final String CONVERT_TO_STRING_BUFFER_ID = "org.eclipse.jdt.ls.correction.convertToStringBuffer.assist";
    public static final String CONVERT_TO_MESSAGE_FORMAT_ID = "org.eclipse.jdt.ls.correction.convertToMessageFormat.assist";
    public static final String EXTRACT_METHOD_INPLACE_ID = "org.eclipse.jdt.ls.correction.extractMethodInplace.assist";
    private PreferenceManager preferenceManager;

    public QuickAssistProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<ProposalKindWrapper> getAssists(CodeActionParams params, IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ASTNode coveringNode = context.getCoveringNode();
        String declsToFinal = this.preferenceManager.getPreferences().getCodeGenerationAddFinalForNewDeclaration();
        if (coveringNode != null) {
            ArrayList<ProposalKindWrapper> resultingCollections = new ArrayList<ProposalKindWrapper>();
            QuickAssistProcessor.getAssignParamToFieldProposals(context, coveringNode, resultingCollections, "all".equals(declsToFinal) || "fields".equals(declsToFinal));
            QuickAssistProcessor.getAssignAllParamsToFieldsProposals(context, coveringNode, resultingCollections, "all".equals(declsToFinal) || "fields".equals(declsToFinal));
            boolean problemsAtLocation = locations.length != 0;
            QuickAssistProcessor.getExtractMethodFromLambdaProposal(context, coveringNode, problemsAtLocation, resultingCollections);
            QuickAssistProcessor.getConvertLambdaExpressionAndMethodRefCleanUpProposal(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getConvertMethodReferenceToLambdaProposal(context, coveringNode, resultingCollections);
            this.getConvertLambdaToMethodReferenceProposal(context, coveringNode, resultingCollections);
            this.getAddInferredLambdaParameterTypesProposal(context, coveringNode, resultingCollections);
            this.getAddVarLambdaParameterTypesProposal(context, coveringNode, resultingCollections);
            this.getRemoveVarOrInferredLambdaParameterTypesProposal(context, coveringNode, resultingCollections);
            this.getChangeLambdaBodyToBlockProposal(context, coveringNode, resultingCollections);
            this.getChangeLambdaBodyToExpressionProposal(context, coveringNode, resultingCollections);
            this.getConvertToMessageFormatProposal(context, coveringNode, resultingCollections);
            this.getConvertToStringBufferProposal(context, coveringNode, resultingCollections);
            this.getConvertToStringFormatProposal(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getStringConcatToTextBlockProposal(context, coveringNode, resultingCollections);
            this.getAddMissingMethodDeclarationProposal(context, coveringNode, resultingCollections);
            QuickAssistProcessor.getTryWithResourceProposals(locations, context, coveringNode, resultingCollections);
            QuickAssistProcessor.getConvertToSwitchExpressionProposals(context, coveringNode, resultingCollections);
            List<Integer> javaDocCommentProblems = Arrays.asList(-1610612250);
            if (!QuickAssistProcessor.problemExists(locations, javaDocCommentProblems)) {
                JavadocTagsSubProcessor.getMissingJavadocCommentProposals(context, coveringNode, resultingCollections, "quickassist");
            }
            this.getSplitVariableProposal(context, coveringNode, resultingCollections);
            this.getJoinVariableProposal(context, coveringNode, resultingCollections);
            this.getInvertEqualsProposal(context, coveringNode, resultingCollections);
            return resultingCollections;
        }
        return Collections.emptyList();
    }

    private static boolean getExtractMethodFromLambdaProposal(IInvocationContext context, ASTNode coveringNode, boolean problemsAtLocation, Collection<ProposalKindWrapper> proposals) throws CoreException {
        if (coveringNode instanceof Block && coveringNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            return false;
        }
        ASTNode node = ASTNodes.getFirstAncestorOrNull((ASTNode)coveringNode, LambdaExpression.class, (Class[])new Class[]{BodyDeclaration.class});
        if (!(node instanceof LambdaExpression)) {
            return false;
        }
        ASTNode body = ((LambdaExpression)node).getBody();
        ICompilationUnit cu = context.getCompilationUnit();
        ExtractMethodRefactoring extractMethodRefactoring = new ExtractMethodRefactoring(context.getASTRoot(), body.getStartPosition(), body.getLength());
        String uniqueMethodName = RefactorProposalUtility.getUniqueMethodName(coveringNode, "extracted");
        extractMethodRefactoring.setMethodName(uniqueMethodName);
        if (extractMethodRefactoring.checkInitialConditions((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            if (proposals == null) {
                return true;
            }
            String label = CorrectionMessages.QuickAssistProcessor_extractmethod_from_lambda_description;
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            extractMethodRefactoring.setLinkedProposalModel(linkedProposalModel);
            int relevance = problemsAtLocation ? 1 : 3;
            RefactoringCorrectionProposalCore proposal = new RefactoringCorrectionProposalCore(label, cu, (Refactoring)extractMethodRefactoring, relevance);
            proposal.setLinkedProposalModel(linkedProposalModel);
            proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickassist"));
            return true;
        }
        return false;
    }

    private static boolean getConvertLambdaExpressionAndMethodRefCleanUpProposal(IInvocationContext context, ASTNode coveringNode, Collection<ProposalKindWrapper> proposals) throws CoreException {
        if (coveringNode instanceof Block && coveringNode.getLocationInParent() == LambdaExpression.BODY_PROPERTY) {
            return false;
        }
        ASTNode node = ASTNodes.getFirstAncestorOrNull((ASTNode)coveringNode, LambdaExpression.class, (Class[])new Class[]{BodyDeclaration.class});
        if (!(node instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpressionAndMethodRefFixCore fix = LambdaExpressionAndMethodRefFixCore.createLambdaExpressionAndMethodRefFix((ASTNode)node);
        if (fix == null) {
            return false;
        }
        try {
            CompilationUnitChange change = fix.createChange(null);
            ChangeCorrectionProposalCore proposal = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)change, 1);
            proposals.add(CodeActionHandler.wrap(proposal, "quickassist"));
            return true;
        }
        catch (CoreException coreException) {
            return true;
        }
    }

    private static boolean getAssignParamToFieldProposals(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections, boolean addFinal) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        SingleVariableDeclaration paramDecl = (SingleVariableDeclaration)parent;
        IVariableBinding binding = paramDecl.resolveBinding();
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (binding == null || methodDecl.getBody() == null) {
            return false;
        }
        ITypeBinding typeBinding = binding.getType();
        if (typeBinding == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType != null) {
            if (parentType.isInterface()) {
                return false;
            }
            CompilationUnit root = context.getASTRoot();
            IVariableBinding[] declaredFields = parentType.getDeclaredFields();
            boolean isStaticContext = ASTResolving.isInStaticContext((ASTNode)node);
            int i = 0;
            while (i < declaredFields.length) {
                VariableDeclarationFragment fragment;
                ASTNode fieldDeclFrag;
                IVariableBinding curr = declaredFields[i];
                if (isStaticContext == Modifier.isStatic((int)curr.getModifiers()) && typeBinding.isAssignmentCompatible(curr.getType()) && (fieldDeclFrag = root.findDeclaringNode((IBinding)curr)) instanceof VariableDeclarationFragment && (fragment = (VariableDeclarationFragment)fieldDeclFrag).getInitializer() == null) {
                    AssignToVariableAssistProposalCore p = new AssignToVariableAssistProposalCore(context.getCompilationUnit(), paramDecl, fragment, typeBinding, 1, false);
                    resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, "quickassist"));
                }
                ++i;
            }
        }
        AssignToVariableAssistProposalCore fieldProposal = new AssignToVariableAssistProposalCore(context.getCompilationUnit(), paramDecl, null, typeBinding, 3, addFinal);
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)fieldProposal, "quickassist"));
        return true;
    }

    private static boolean getAssignAllParamsToFieldsProposals(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections, boolean addFinal) {
        ASTNode parent = (node = ASTNodes.getNormalizedNode((ASTNode)node)).getParent();
        if (!(parent instanceof SingleVariableDeclaration) || !(parent.getParent() instanceof MethodDeclaration)) {
            return false;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)parent.getParent();
        if (methodDecl.getBody() == null) {
            return false;
        }
        List parameters = methodDecl.parameters();
        if (parameters.size() <= 1) {
            return false;
        }
        ITypeBinding parentType = Bindings.getBindingOfParentType((ASTNode)node);
        if (parentType == null || parentType.isInterface()) {
            return false;
        }
        for (SingleVariableDeclaration param : parameters) {
            IVariableBinding binding = param.resolveBinding();
            if (binding != null && binding.getType() != null) continue;
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AssignToVariableAssistProposalCore fieldProposal = new AssignToVariableAssistProposalCore(context.getCompilationUnit(), parameters, 2, addFinal);
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)fieldProposal, "quickassist"));
        return true;
    }

    public static ArrayList<ASTNode> getFullyCoveredNodes(IInvocationContext context, ASTNode coveringNode) {
        final ArrayList<ASTNode> coveredNodes = new ArrayList<ASTNode>();
        final int selectionBegin = context.getSelectionOffset();
        final int selectionEnd = selectionBegin + context.getSelectionLength();
        coveringNode.accept((ASTVisitor)new GenericVisitor(){

            protected boolean visitNode(ASTNode node) {
                ASTNode parent;
                int nodeStart = node.getStartPosition();
                int nodeEnd = nodeStart + node.getLength();
                if (nodeEnd < selectionBegin || selectionEnd < nodeStart) {
                    return false;
                }
                if (this.isCovered(node) && ((parent = node.getParent()) == null || !this.isCovered(parent))) {
                    coveredNodes.add(node);
                    return false;
                }
                return true;
            }

            private boolean isCovered(ASTNode node) {
                int begin = node.getStartPosition();
                int end = begin + node.getLength();
                return begin >= selectionBegin && end <= selectionEnd;
            }
        });
        return coveredNodes;
    }

    public static IMethodBinding getFunctionalMethodForMethodReference(MethodReference methodReference) {
        ITypeBinding targetTypeBinding = ASTNodes.getTargetType((Expression)methodReference);
        if (targetTypeBinding == null) {
            return null;
        }
        IMethodBinding functionalMethod = targetTypeBinding.getFunctionalInterfaceMethod();
        if (functionalMethod != null && functionalMethod.isSynthetic()) {
            functionalMethod = Bindings.findOverriddenMethodInType((ITypeBinding)functionalMethod.getDeclaringClass(), (IMethodBinding)functionalMethod);
        }
        return functionalMethod;
    }

    public static LambdaExpression convertMethodRefernceToLambda(MethodReference methodReference, IMethodBinding functionalMethod, CompilationUnit astRoot, ASTRewrite rewrite, LinkedProposalModelCore linkedProposalModel, boolean createBlockBody) throws JavaModelException {
        AST ast = astRoot.getAST();
        LambdaExpression lambda = ast.newLambdaExpression();
        String[] lambdaParamNames = QuickAssistProcessor.getUniqueParameterNames(methodReference, functionalMethod);
        List lambdaParameters = lambda.parameters();
        int i = 0;
        while (i < lambdaParamNames.length) {
            String paramName = lambdaParamNames[i];
            VariableDeclarationFragment lambdaParameter = ast.newVariableDeclarationFragment();
            SimpleName name = ast.newSimpleName(paramName);
            lambdaParameter.setName(name);
            lambdaParameters.add(lambdaParameter);
            if (linkedProposalModel != null) {
                linkedProposalModel.getPositionGroup(name.getIdentifier(), true).addPosition(rewrite.track((ASTNode)name), i == 0);
            }
            ++i;
        }
        int noOfLambdaParameters = lambdaParamNames.length;
        lambda.setParentheses(noOfLambdaParameters != 1);
        ITypeBinding returnTypeBinding = functionalMethod.getReturnType();
        IMethodBinding referredMethodBinding = methodReference.resolveMethodBinding();
        if (methodReference instanceof CreationReference) {
            CreationReference creationRef = (CreationReference)methodReference;
            Type type = creationRef.getType();
            if (type instanceof ArrayType) {
                ArrayCreation arrayCreation = ast.newArrayCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)arrayCreation, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)arrayCreation);
                }
                ArrayType arrayType = (ArrayType)type;
                Type copiedElementType = (Type)rewrite.createCopyTarget((ASTNode)arrayType.getElementType());
                arrayCreation.setType(ast.newArrayType(copiedElementType, arrayType.getDimensions()));
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                arrayCreation.dimensions().add(name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                ClassInstanceCreation cic = ast.newClassInstanceCreation();
                if (createBlockBody) {
                    Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)cic, returnTypeBinding, ast);
                    lambda.setBody((ASTNode)blockBody);
                } else {
                    lambda.setBody((ASTNode)cic);
                }
                ITypeBinding typeBinding = type.resolveBinding();
                if (!(type instanceof ParameterizedType) && typeBinding != null && typeBinding.getTypeDeclaration().isGenericType()) {
                    cic.setType((Type)ast.newParameterizedType((Type)rewrite.createCopyTarget((ASTNode)type)));
                } else {
                    cic.setType((Type)rewrite.createCopyTarget((ASTNode)type));
                }
                List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
                cic.arguments().addAll(invocationArgs);
                if (linkedProposalModel != null) {
                    for (SimpleName name : invocationArgs) {
                        linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                    }
                }
                cic.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
            }
        } else if (referredMethodBinding != null && Modifier.isStatic((int)referredMethodBinding.getModifiers())) {
            MethodInvocation methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            Expression expr = null;
            boolean hasConflict = QuickAssistProcessor.hasConflict(methodReference.getStartPosition(), referredMethodBinding, 17, astRoot);
            if (hasConflict || !Bindings.isSuperType((ITypeBinding)referredMethodBinding.getDeclaringClass(), (ITypeBinding)ASTNodes.getEnclosingType((ASTNode)methodReference)) || methodReference.typeArguments().size() != 0) {
                TypeMethodReference typedMethodReference;
                Type type;
                ITypeBinding typeBinding;
                if (methodReference instanceof ExpressionMethodReference) {
                    ExpressionMethodReference expressionMethodReference = (ExpressionMethodReference)methodReference;
                    expr = (Expression)rewrite.createCopyTarget((ASTNode)expressionMethodReference.getExpression());
                } else if (methodReference instanceof TypeMethodReference && (typeBinding = (type = (typedMethodReference = (TypeMethodReference)methodReference).getType()).resolveBinding()) != null) {
                    ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)astRoot, (boolean)true);
                    expr = ast.newName(importRewrite.addImport(typeBinding));
                }
            }
            methodInvocation.setExpression(expr);
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodInvocation superMethodInvocation = ast.newSuperMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)superMethodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)superMethodInvocation);
            }
            Name superQualifier = ((SuperMethodReference)methodReference).getQualifier();
            if (superQualifier != null) {
                superMethodInvocation.setQualifier((Name)rewrite.createCopyTarget((ASTNode)superQualifier));
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            superMethodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, 0, noOfLambdaParameters, lambdaParamNames);
            superMethodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            superMethodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        } else {
            MethodInvocation methodInvocation = ast.newMethodInvocation();
            if (createBlockBody) {
                Block blockBody = QuickAssistProcessor.getBlockBodyForLambda((Expression)methodInvocation, returnTypeBinding, ast);
                lambda.setBody((ASTNode)blockBody);
            } else {
                lambda.setBody((ASTNode)methodInvocation);
            }
            boolean isTypeReference = QuickAssistProcessor.isTypeReferenceToInstanceMethod(methodReference);
            if (isTypeReference) {
                SimpleName name = ast.newSimpleName(lambdaParamNames[0]);
                methodInvocation.setExpression((Expression)name);
                if (linkedProposalModel != null) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            } else {
                Expression expr = ((ExpressionMethodReference)methodReference).getExpression();
                if (!(expr instanceof ThisExpression) || methodReference.typeArguments().size() != 0) {
                    methodInvocation.setExpression((Expression)rewrite.createCopyTarget((ASTNode)expr));
                }
            }
            SimpleName methodName = QuickAssistProcessor.getMethodInvocationName(methodReference);
            methodInvocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)methodName));
            List<SimpleName> invocationArgs = QuickAssistProcessor.getInvocationArguments(ast, isTypeReference ? 1 : 0, noOfLambdaParameters, lambdaParamNames);
            methodInvocation.arguments().addAll(invocationArgs);
            if (linkedProposalModel != null) {
                for (SimpleName name : invocationArgs) {
                    linkedProposalModel.getPositionGroup(name.getIdentifier(), false).addPosition(rewrite.track((ASTNode)name), -1);
                }
            }
            methodInvocation.typeArguments().addAll(QuickAssistProcessor.getCopiedTypeArguments(rewrite, methodReference.typeArguments()));
        }
        rewrite.replace((ASTNode)methodReference, (ASTNode)lambda, null);
        return lambda;
    }

    private static boolean hasConflict(int startPosition, IMethodBinding referredMethodBinding, int flags, CompilationUnit cu) {
        ScopeAnalyzer analyzer = new ScopeAnalyzer(cu);
        IBinding[] declarationsInScope = analyzer.getDeclarationsInScope(startPosition, flags);
        int i = 0;
        while (i < declarationsInScope.length) {
            IBinding decl = declarationsInScope[i];
            if (decl.getName().equals(referredMethodBinding.getName()) && !referredMethodBinding.getMethodDeclaration().isEqualTo(decl)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String[] getUniqueParameterNames(MethodReference methodReference, IMethodBinding functionalMethod) throws JavaModelException {
        String[] parameterNames = ((IMethod)functionalMethod.getJavaElement()).getParameterNames();
        ArrayList<String> oldNames = new ArrayList<String>(Arrays.asList(parameterNames));
        String[] newNames = new String[oldNames.size()];
        ArrayList<String> excludedNames = new ArrayList<String>(ASTNodes.getVisibleLocalVariablesInScope((ASTNode)methodReference));
        int i = 0;
        while (i < oldNames.size()) {
            String paramName = (String)oldNames.get(i);
            ArrayList<String> allNamesToExclude = new ArrayList<String>(excludedNames);
            allNamesToExclude.addAll(oldNames.subList(0, i));
            allNamesToExclude.addAll(oldNames.subList(i + 1, oldNames.size()));
            if (allNamesToExclude.contains(paramName)) {
                String newParamName = QuickAssistProcessor.createName(paramName, allNamesToExclude);
                excludedNames.add(newParamName);
                newNames[i] = newParamName;
            } else {
                newNames[i] = paramName;
            }
            ++i;
        }
        return newNames;
    }

    private static String createName(String candidate, List<String> excludedNames) {
        int i = 1;
        Object result = candidate;
        while (excludedNames.contains(result)) {
            result = candidate + i++;
        }
        return result;
    }

    private static boolean isTypeReferenceToInstanceMethod(MethodReference methodReference) {
        Name name;
        IBinding nameBinding;
        ExpressionMethodReference expressionMethodReference;
        Expression expression;
        if (methodReference instanceof TypeMethodReference) {
            return true;
        }
        return methodReference instanceof ExpressionMethodReference && (expression = (expressionMethodReference = (ExpressionMethodReference)methodReference).getExpression()) instanceof Name && (nameBinding = (name = (Name)expression).resolveBinding()) != null && nameBinding instanceof ITypeBinding;
    }

    private static List<SimpleName> getInvocationArguments(AST ast, int begIndex, int noOfLambdaParameters, String[] lambdaParamNames) {
        ArrayList<SimpleName> args = new ArrayList<SimpleName>();
        int i = begIndex;
        while (i < noOfLambdaParameters) {
            args.add(ast.newSimpleName(lambdaParamNames[i]));
            ++i;
        }
        return args;
    }

    private static List<Type> getCopiedTypeArguments(ASTRewrite rewrite, List<Type> typeArguments) {
        ArrayList<Type> copiedTypeArgs = new ArrayList<Type>();
        for (Type typeArg : typeArguments) {
            copiedTypeArgs.add((Type)rewrite.createCopyTarget((ASTNode)typeArg));
        }
        return copiedTypeArgs;
    }

    private static SimpleName getMethodInvocationName(MethodReference methodReference) {
        SimpleName name = null;
        if (methodReference instanceof ExpressionMethodReference) {
            ExpressionMethodReference expressionMethodReference = (ExpressionMethodReference)methodReference;
            name = expressionMethodReference.getName();
        } else if (methodReference instanceof TypeMethodReference) {
            TypeMethodReference typeMethodReference = (TypeMethodReference)methodReference;
            name = typeMethodReference.getName();
        } else if (methodReference instanceof SuperMethodReference) {
            SuperMethodReference superMethodReference = (SuperMethodReference)methodReference;
            name = superMethodReference.getName();
        }
        return name;
    }

    public static void changeLambdaBodyToBlock(LambdaExpression lambda, AST ast, ASTRewrite rewrite) {
        Expression bodyExpr = (Expression)rewrite.createMoveTarget(lambda.getBody());
        Block blockBody = QuickAssistProcessor.getBlockBodyForLambda(bodyExpr, lambda.resolveMethodBinding().getReturnType(), ast);
        rewrite.set((ASTNode)lambda, (StructuralPropertyDescriptor)LambdaExpression.BODY_PROPERTY, (Object)blockBody, null);
    }

    private static Block getBlockBodyForLambda(Expression bodyExpr, ITypeBinding returnTypeBinding, AST ast) {
        ExpressionStatement statementInBlockBody;
        if (ast.resolveWellKnownType("void").isEqualTo((IBinding)returnTypeBinding)) {
            ExpressionStatement expressionStatement;
            statementInBlockBody = expressionStatement = ast.newExpressionStatement(bodyExpr);
        } else {
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(bodyExpr);
            statementInBlockBody = returnStatement;
        }
        Block blockBody = ast.newBlock();
        blockBody.statements().add(statementInBlockBody);
        return blockBody;
    }

    public static boolean getCatchClauseToThrowsProposals(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections) {
        ASTRewriteCorrectionProposalCore proposal;
        String label;
        ASTRewrite rewrite;
        if (resultingCollections == null) {
            return true;
        }
        CatchClause catchClause = (CatchClause)ASTResolving.findAncestor((ASTNode)node, (int)12);
        if (catchClause == null) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (statement != catchClause.getParent() && statement != catchClause.getBody()) {
            return false;
        }
        Type type = catchClause.getException().getType();
        if (!(type.isSimpleType() || type.isUnionType() || type.isNameQualifiedType())) {
            return false;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration((ASTNode)catchClause);
        if (!(bodyDeclaration instanceof MethodDeclaration) && !(bodyDeclaration instanceof Initializer)) {
            return false;
        }
        AST ast = bodyDeclaration.getAST();
        SimpleType selectedMultiCatchType = null;
        if (type.isUnionType() && node instanceof Name) {
            Name name = (Name)node;
            Name topMostName = ASTNodes.getTopMostName((Name)name);
            ASTNode parent = topMostName.getParent();
            if (parent instanceof SimpleType) {
                SimpleType simpleType;
                selectedMultiCatchType = simpleType = (SimpleType)parent;
            } else if (parent instanceof NameQualifiedType) {
                NameQualifiedType nameQualifiedType = (NameQualifiedType)parent;
                selectedMultiCatchType = nameQualifiedType;
            }
        }
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            rewrite = ASTRewrite.create((AST)ast);
            if (selectedMultiCatchType != null) {
                QuickAssistProcessor.removeException(rewrite, (UnionType)type, selectedMultiCatchType);
                QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, (Type)selectedMultiCatchType);
                label = CorrectionMessages.QuickAssistProcessor_exceptiontothrows_description;
                proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 6);
                resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
            } else {
                QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
                if (type.isUnionType()) {
                    UnionType unionType = (UnionType)type;
                    List types = unionType.types();
                    for (Type elementType : types) {
                        if (!(elementType instanceof SimpleType) && !(elementType instanceof NameQualifiedType)) {
                            return false;
                        }
                        QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, elementType);
                    }
                } else {
                    QuickAssistProcessor.addExceptionToThrows(ast, methodDeclaration, rewrite, type);
                }
                label = CorrectionMessages.QuickAssistProcessor_catchclausetothrows_description;
                proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 4);
                resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
            }
        }
        rewrite = ASTRewrite.create((AST)ast);
        if (selectedMultiCatchType != null) {
            QuickAssistProcessor.removeException(rewrite, (UnionType)type, selectedMultiCatchType);
            label = CorrectionMessages.QuickAssistProcessor_removeexception_description;
            proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 6);
            resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        } else {
            QuickAssistProcessor.removeCatchBlock(rewrite, catchClause);
            label = CorrectionMessages.QuickAssistProcessor_removecatchclause_description;
            proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 5);
            resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        }
        return true;
    }

    private static void removeException(ASTRewrite rewrite, UnionType unionType, Type exception) {
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)unionType, UnionType.TYPES_PROPERTY);
        List types = unionType.types();
        for (Type type : types) {
            if (!type.equals((Object)exception)) continue;
            listRewrite.remove((ASTNode)type, null);
        }
    }

    private static void addExceptionToThrows(AST ast, MethodDeclaration methodDeclaration, ASTRewrite rewrite, Type type2) {
        ITypeBinding binding = type2.resolveBinding();
        if (binding == null || QuickAssistProcessor.isNotYetThrown(binding, methodDeclaration.thrownExceptionTypes())) {
            Type newType = (Type)ASTNode.copySubtree((AST)ast, (ASTNode)type2);
            ListRewrite listRewriter = rewrite.getListRewrite((ASTNode)methodDeclaration, MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
            listRewriter.insertLast((ASTNode)newType, null);
        }
    }

    private static void removeCatchBlock(ASTRewrite rewrite, CatchClause catchClause) {
        TryStatement tryStatement = (TryStatement)catchClause.getParent();
        if (tryStatement.catchClauses().size() > 1 || tryStatement.getFinally() != null || !tryStatement.resources().isEmpty()) {
            rewrite.remove((ASTNode)catchClause, null);
        } else {
            Block block = tryStatement.getBody();
            List statements = block.statements();
            int nStatements = statements.size();
            if (nStatements == 1) {
                ASTNode first = (ASTNode)statements.get(0);
                rewrite.replace((ASTNode)tryStatement, rewrite.createCopyTarget(first), null);
            } else if (nStatements > 1) {
                ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY);
                ASTNode first = (ASTNode)statements.get(0);
                ASTNode last = (ASTNode)statements.get(statements.size() - 1);
                ASTNode newStatement = listRewrite.createCopyTarget(first, last);
                if (ASTNodes.isControlStatementBody((StructuralPropertyDescriptor)tryStatement.getLocationInParent())) {
                    Block newBlock = rewrite.getAST().newBlock();
                    newBlock.statements().add(newStatement);
                    newStatement = newBlock;
                }
                rewrite.replace((ASTNode)tryStatement, newStatement, null);
            } else {
                rewrite.remove((ASTNode)tryStatement, null);
            }
        }
    }

    private static boolean isNotYetThrown(ITypeBinding binding, List<Type> thrownExceptions) {
        for (Type thrownException : thrownExceptions) {
            ITypeBinding elem = thrownException.resolveBinding();
            if (elem == null || !Bindings.isSuperType((ITypeBinding)elem, (ITypeBinding)binding)) continue;
            return false;
        }
        return true;
    }

    private static boolean getConvertMethodReferenceToLambdaProposal(IInvocationContext context, ASTNode covering, Collection<ProposalKindWrapper> resultingCollections) throws JavaModelException {
        MethodReference methodReference;
        if (covering instanceof MethodReference) {
            MethodReference ref;
            methodReference = ref = (MethodReference)covering;
        } else {
            ASTNode aSTNode = covering.getParent();
            if (aSTNode instanceof MethodReference) {
                MethodReference parentMethodRef;
                methodReference = parentMethodRef = (MethodReference)aSTNode;
            } else {
                return false;
            }
        }
        IMethodBinding functionalMethod = QuickAssistProcessor.getFunctionalMethodForMethodReference(methodReference);
        if (functionalMethod == null || functionalMethod.isGenericMethod()) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)methodReference.getAST());
        LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
        LambdaExpression lambda = QuickAssistProcessor.convertMethodRefernceToLambda(methodReference, functionalMethod, context.getASTRoot(), rewrite, linkedProposalModel, false);
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_lambda_expression;
        LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 6);
        proposal.setLinkedProposalModel(linkedProposalModel);
        proposal.setEndPosition(rewrite.track((ASTNode)lambda));
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickassist"));
        return true;
    }

    public static boolean getTryWithResourceProposals(IProblemLocation[] locations, IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections) throws IllegalArgumentException, CoreException {
        List<Integer> exceptionProblems = Arrays.asList(536871799, 536871799, 536871797, 16777384);
        if (QuickAssistProcessor.problemExists(locations, exceptionProblems)) {
            return false;
        }
        ArrayList<ASTNode> coveredNodes = QuickAssistProcessor.getFullyCoveredNodes(context, context.getCoveringNode());
        return QuickAssistProcessor.getTryWithResourceProposals(context, node, coveredNodes, resultingCollections);
    }

    public static boolean problemExists(IProblemLocation[] locations, List<Integer> problems) {
        return QuickAssistProcessor.findProblemLocation(locations, problems) != null;
    }

    public static IProblemLocation findProblemLocation(IProblemLocation[] locations, List<Integer> problems) {
        IProblemLocation[] iProblemLocationArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IProblemLocation location = iProblemLocationArray[n2];
            if (problems.contains(location.getProblemId())) {
                return location;
            }
            ++n2;
        }
        return null;
    }

    public static boolean getTryWithResourceProposals(IInvocationContext context, ASTNode node, ArrayList<ASTNode> coveredNodes, Collection<ProposalKindWrapper> resultingCollections) throws IllegalArgumentException, CoreException {
        int start;
        if (!JavaModelUtil.is1d8OrHigher((IJavaProject)context.getCompilationUnit().getJavaProject())) {
            return false;
        }
        ASTNode parentStatement = ASTResolving.findAncestor((ASTNode)node, (int)60);
        if (!(parentStatement instanceof VariableDeclarationStatement || parentStatement instanceof ExpressionStatement || node instanceof SimpleName || coveredNodes != null && !coveredNodes.isEmpty())) {
            return false;
        }
        ArrayList<Object> coveredStatements = new ArrayList<Object>();
        if (coveredNodes == null || coveredNodes.isEmpty() && parentStatement != null) {
            coveredStatements.add(parentStatement);
        } else {
            for (ASTNode coveredNode : coveredNodes) {
                Statement statement = ASTResolving.findParentStatement((ASTNode)coveredNode);
                if (statement == null || coveredStatements.contains(statement)) continue;
                coveredStatements.add(statement);
            }
        }
        List coveredAutoClosableNodes = QuickAssistProcessorUtil.getCoveredAutoClosableNodes(coveredStatements);
        if (coveredAutoClosableNodes.isEmpty()) {
            return false;
        }
        ASTNode parentBodyDeclaration = node instanceof Block || node instanceof BodyDeclaration ? node : ASTNodes.getFirstAncestorOrNull((ASTNode)node, Block.class, (Class[])new Class[]{BodyDeclaration.class});
        int end = start = ((ASTNode)coveredAutoClosableNodes.get(0)).getStartPosition();
        for (ASTNode astNode : coveredAutoClosableNodes) {
            int endPosition = QuickAssistProcessorUtil.findEndPostion((ASTNode)astNode);
            end = Math.max(end, endPosition);
        }
        List nodesInRange = SurroundWithTryWithResourcesRefactoringCore.findNodesInRange((ASTNode)parentBodyDeclaration, (int)start, (int)end);
        int oldEnd = end;
        while (true) {
            int newEnd = oldEnd;
            for (ASTNode astNode : nodesInRange) {
                int endPosition = QuickAssistProcessorUtil.findEndPostion((ASTNode)astNode);
                newEnd = Math.max(newEnd, endPosition);
            }
            if (newEnd <= oldEnd) break;
            oldEnd = newEnd;
            nodesInRange = SurroundWithTryWithResourcesRefactoringCore.findNodesInRange((ASTNode)parentBodyDeclaration, (int)start, (int)newEnd);
        }
        nodesInRange.removeAll(coveredAutoClosableNodes);
        CompilationUnit cu = (CompilationUnit)node.getRoot();
        IBuffer buffer = context.getCompilationUnit().getBuffer();
        AST ast = node.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        boolean modifyExistingTry = false;
        TryStatement newTryStatement = null;
        Block newTryBody = null;
        TryStatement enclosingTry = (TryStatement)ASTResolving.findAncestor((ASTNode)node, (int)54);
        ListRewrite resourcesRewriter = null;
        ListRewrite clausesRewriter = null;
        if (enclosingTry == null || enclosingTry.getBody() == null || enclosingTry.getBody().statements().get(0) != coveredNodes.get(0)) {
            newTryStatement = ast.newTryStatement();
            newTryBody = ast.newBlock();
            newTryStatement.setBody(newTryBody);
        } else {
            modifyExistingTry = true;
            resourcesRewriter = rewrite.getListRewrite((ASTNode)enclosingTry, TryStatement.RESOURCES2_PROPERTY);
            clausesRewriter = rewrite.getListRewrite((ASTNode)enclosingTry, TryStatement.CATCH_CLAUSES_PROPERTY);
        }
        ICompilationUnit icu = context.getCompilationUnit();
        ASTNode lastNode = nodesInRange.isEmpty() ? (ASTNode)coveredAutoClosableNodes.get(coveredAutoClosableNodes.size() - 1) : (ASTNode)nodesInRange.get(nodesInRange.size() - 1);
        Selection selection = Selection.createFromStartLength((int)start, (int)(lastNode.getStartPosition() - start + lastNode.getLength()));
        SurroundWithTryWithResourcesAnalyzer analyzer = new SurroundWithTryWithResourcesAnalyzer(icu, selection);
        cu.accept((ASTVisitor)analyzer);
        ITypeBinding[] exceptions = analyzer.getExceptions(analyzer.getSelection());
        ArrayList<ITypeBinding> allExceptions = new ArrayList<ITypeBinding>(Arrays.asList(exceptions));
        int resourceCount = 0;
        for (ASTNode coveredNode : coveredAutoClosableNodes) {
            IMethodBinding close;
            Type type;
            ITypeBinding typeBinding;
            ASTNode findAncestor = ASTResolving.findAncestor((ASTNode)coveredNode, (int)60);
            if (findAncestor == null) {
                findAncestor = ASTResolving.findAncestor((ASTNode)coveredNode, (int)7);
            }
            if (!(findAncestor instanceof VariableDeclarationStatement)) continue;
            VariableDeclarationStatement vds = (VariableDeclarationStatement)findAncestor;
            String commentToken = null;
            int extendedStatementStart = cu.getExtendedStartPosition((ASTNode)vds);
            if (vds.getStartPosition() > extendedStatementStart) {
                commentToken = buffer.getText(extendedStatementStart, vds.getStartPosition() - extendedStatementStart);
            }
            if ((typeBinding = (type = vds.getType()).resolveBinding()) != null && (close = SurroundWithTryWithResourcesRefactoringCore.findAutocloseMethod((ITypeBinding)typeBinding)) != null) {
                ITypeBinding[] iTypeBindingArray = close.getExceptionTypes();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding exceptionType = iTypeBindingArray[n2];
                    if (!allExceptions.contains(exceptionType)) {
                        allExceptions.add(exceptionType);
                    }
                    ++n2;
                }
            }
            String typeName = buffer.getText(type.getStartPosition(), type.getLength());
            for (Object object : vds.fragments()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)object;
                VariableDeclarationFragment newVariableDeclarationFragment = ast.newVariableDeclarationFragment();
                SimpleName name = variableDeclarationFragment.getName();
                if (commentToken == null) {
                    int extendedStart = cu.getExtendedStartPosition((ASTNode)variableDeclarationFragment);
                    commentToken = buffer.getText(extendedStart, variableDeclarationFragment.getStartPosition() - extendedStart);
                }
                commentToken = Strings.trimTrailingTabsAndSpaces((String)commentToken);
                newVariableDeclarationFragment.setName(ast.newSimpleName(name.getIdentifier()));
                Expression newExpression = null;
                Expression initializer = variableDeclarationFragment.getInitializer();
                if (initializer == null) {
                    rewrite.remove(coveredNode, null);
                    continue;
                }
                newExpression = (Expression)rewrite.createMoveTarget((ASTNode)initializer);
                newVariableDeclarationFragment.setInitializer(newExpression);
                VariableDeclarationExpression newVariableDeclarationExpression = ast.newVariableDeclarationExpression(newVariableDeclarationFragment);
                newVariableDeclarationExpression.setType((Type)rewrite.createStringPlaceholder(commentToken + typeName, type.getNodeType()));
                ++resourceCount;
                if (modifyExistingTry) {
                    resourcesRewriter.insertLast((ASTNode)newVariableDeclarationExpression, null);
                } else {
                    newTryStatement.resources().add(newVariableDeclarationExpression);
                }
                commentToken = null;
            }
        }
        if (resourceCount == 0) {
            return false;
        }
        String label = CorrectionMessages.QuickAssistProcessor_convert_to_try_with_resource;
        LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 6);
        ImportRewrite imports = proposal.createImportRewrite(context.getASTRoot());
        ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext(node, imports);
        CatchClause catchClause = ast.newCatchClause();
        SingleVariableDeclaration decl = ast.newSingleVariableDeclaration();
        String varName = StubUtility.getExceptionVariableName((IJavaProject)icu.getJavaProject());
        parentBodyDeclaration.getRoot().accept((ASTVisitor)analyzer);
        CodeScopeBuilder.Scope scope = CodeScopeBuilder.perform((BodyDeclaration)analyzer.getEnclosingBodyDeclaration(), (Selection)selection).findScope(selection.getOffset(), selection.getLength());
        scope.setCursor(selection.getOffset());
        String name = scope.createName(varName, false);
        decl.setName(ast.newSimpleName(name));
        ArrayList mustRethrowList = new ArrayList();
        List catchExceptions = analyzer.calculateCatchesAndRethrows(ASTNodes.filterSubtypes(allExceptions), mustRethrowList);
        List filteredExceptions = ASTNodes.filterSubtypes((List)catchExceptions);
        if (catchExceptions.size() > 0) {
            String GROUP_EXC_NAME = "exc_name";
            String GROUP_EXC_TYPE = "exc_type";
            LinkedProposalModelCore linkedProposalModel = new LinkedProposalModelCore();
            int i = 0;
            if (!modifyExistingTry) {
                for (ITypeBinding mustThrow : mustRethrowList) {
                    CatchClause newClause = ast.newCatchClause();
                    SingleVariableDeclaration newDecl = ast.newSingleVariableDeclaration();
                    newDecl.setName(ast.newSimpleName(name));
                    Type importType = imports.addImport(mustThrow, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.EXCEPTION);
                    newDecl.setType(importType);
                    newClause.setException(newDecl);
                    ThrowStatement newThrowStatement = ast.newThrowStatement();
                    newThrowStatement.setExpression((Expression)ast.newSimpleName(name));
                    linkedProposalModel.getPositionGroup("exc_name" + i, true).addPosition(rewrite.track((ASTNode)decl.getName()), false);
                    newClause.getBody().statements().add(newThrowStatement);
                    newTryStatement.catchClauses().add(newClause);
                    ++i;
                }
            }
            UnionType unionType = ast.newUnionType();
            List types = unionType.types();
            for (ITypeBinding exception : filteredExceptions) {
                Type type = imports.addImport(exception, ast, (ImportRewrite.ImportRewriteContext)importRewriteContext, ImportRewrite.TypeLocation.EXCEPTION);
                types.add(type);
                linkedProposalModel.getPositionGroup("exc_type" + i, true).addPosition(rewrite.track((ASTNode)type), i == 0);
                ++i;
            }
            decl.setType((Type)unionType);
            catchClause.setException(decl);
            linkedProposalModel.getPositionGroup("exc_name0", true).addPosition(rewrite.track((ASTNode)decl.getName()), false);
            Statement st = null;
            String s = StubUtility.getCatchBodyContent((ICompilationUnit)icu, (String)"Exception", (String)name, (ASTNode)(coveredNodes.isEmpty() ? node : coveredNodes.get(0)), (String)icu.findRecommendedLineSeparator());
            if (s != null) {
                st = (Statement)rewrite.createStringPlaceholder(s, 41);
            }
            if (st != null) {
                catchClause.getBody().statements().add(st);
            }
            if (modifyExistingTry) {
                clausesRewriter.insertLast((ASTNode)catchClause, null);
            } else {
                newTryStatement.catchClauses().add(catchClause);
            }
        }
        if (modifyExistingTry) {
            int i = 0;
            while (i < coveredAutoClosableNodes.size()) {
                rewrite.remove((ASTNode)coveredAutoClosableNodes.get(i), null);
                ++i;
            }
        } else {
            if (!nodesInRange.isEmpty()) {
                ASTNode firstNode = (ASTNode)nodesInRange.get(0);
                ASTNode methodDeclaration = ASTResolving.findAncestor((ASTNode)firstNode, (int)8);
                ListRewrite listRewrite = rewrite.getListRewrite(methodDeclaration, Block.STATEMENTS_PROPERTY);
                ASTNode createCopyTarget = listRewrite.createMoveTarget(firstNode, (ASTNode)nodesInRange.get(nodesInRange.size() - 1));
                rewrite.getListRewrite((ASTNode)newTryBody, Block.STATEMENTS_PROPERTY).insertFirst(createCopyTarget, null);
            }
            rewrite.replace((ASTNode)coveredAutoClosableNodes.get(0), (ASTNode)newTryStatement, null);
            int i = 1;
            while (i < coveredAutoClosableNodes.size()) {
                rewrite.remove((ASTNode)coveredAutoClosableNodes.get(i), null);
                ++i;
            }
        }
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean getConvertToSwitchExpressionProposals(IInvocationContext context, ASTNode covering, Collection<ProposalKindWrapper> resultingCollections) {
        block7: {
            if (!(covering instanceof Block)) ** GOTO lbl10
            block = (Block)covering;
            statements = block.statements();
            startIndex = QuickAssistProcessorUtil.getIndex((int)context.getSelectionOffset(), (List)statements);
            if (startIndex == -1 || startIndex >= statements.size()) {
                return false;
            }
            covering = (ASTNode)statements.get(startIndex);
            break block7;
lbl-1000:
            // 1 sources

            {
                covering = covering.getParent();
lbl10:
                // 2 sources

                ** while (covering instanceof SwitchCase || covering instanceof SwitchExpression)
            }
        }
        if (!(covering instanceof SwitchStatement)) {
            return false;
        }
        switchStatement = statement = (SwitchStatement)covering;
        fix = SwitchExpressionsFixCore.createConvertToSwitchExpressionFix((SwitchStatement)switchStatement);
        if (fix == null) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        try {
            change = fix.createChange(null);
            proposal = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)change, 2);
            resultingCollections.add(CodeActionHandler.wrap(proposal, "quickassist"));
        }
        catch (CoreException var7_9) {
            // empty catch block
        }
        return true;
    }

    private static boolean getStringConcatToTextBlockProposal(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections) {
        if (resultingCollections == null) {
            return false;
        }
        ASTNode exp = null;
        if (node instanceof Assignment || node instanceof VariableDeclarationFragment || node instanceof FieldDeclaration || node instanceof InfixExpression) {
            exp = node;
        } else {
            ASTNode parent = node.getParent();
            if (parent instanceof Assignment || parent instanceof VariableDeclarationFragment || parent instanceof FieldDeclaration || parent instanceof InfixExpression) {
                exp = parent;
            }
        }
        if (exp == null) {
            return false;
        }
        StringConcatToTextBlockFixCore fix = StringConcatToTextBlockFixCore.createStringConcatToTextBlockFix((ASTNode)exp);
        if (fix == null) {
            return false;
        }
        try {
            CompilationUnitChange change = fix.createChange(null);
            ChangeCorrectionProposalCore proposal = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)change, 5);
            resultingCollections.add(CodeActionHandler.wrap(proposal, "quickassist"));
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean getJoinVariableProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        SplitVariableFixCore fix;
        if (resultingCollections != null && (fix = SplitVariableFixCore.createSplitVariableFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getSplitVariableProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        JoinVariableFixCore fix;
        if (resultingCollections != null && (fix = JoinVariableFixCore.createJoinVariableFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getInvertEqualsProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        InvertEqualsExpressionFixCore fix;
        if (resultingCollections != null && (fix = InvertEqualsExpressionFixCore.createInvertEqualsFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getAddInferredLambdaParameterTypesProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        AddInferredLambdaParameterTypesFixCore fix;
        if (resultingCollections != null && (fix = AddInferredLambdaParameterTypesFixCore.createAddInferredLambdaParameterTypesFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getAddVarLambdaParameterTypesProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        AddVarLambdaParameterTypesFixCore fix;
        if (resultingCollections != null && (fix = AddVarLambdaParameterTypesFixCore.createAddVarLambdaParameterTypesFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getChangeLambdaBodyToBlockProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        ChangeLambdaBodyToBlockFixCore fix;
        if (resultingCollections != null && (fix = ChangeLambdaBodyToBlockFixCore.createChangeLambdaBodyToBlockFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getChangeLambdaBodyToExpressionProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        ChangeLambdaBodyToExpressionFixCore fix;
        if (resultingCollections != null && (fix = ChangeLambdaBodyToExpressionFixCore.createChangeLambdaBodyToBlockFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getRemoveVarOrInferredLambdaParameterTypesProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        RemoveVarOrInferredLambdaParameterTypesFixCore fix;
        if (resultingCollections != null && (fix = RemoveVarOrInferredLambdaParameterTypesFixCore.createRemoveVarOrInferredLambdaParameterTypesFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getConvertLambdaToMethodReferenceProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        ConvertLambdaToMethodReferenceFixCore fix;
        if (resultingCollections != null && (fix = ConvertLambdaToMethodReferenceFixCore.createConvertLambdaToMethodReferenceFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getConvertToMessageFormatProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        ConvertToMessageFormatFixCore fix;
        if (resultingCollections != null && (fix = ConvertToMessageFormatFixCore.createConvertToMessageFormatFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 0);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getConvertToStringBufferProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        ConvertToStringBufferFixCore fix;
        if (resultingCollections != null && (fix = ConvertToStringBufferFixCore.createConvertToStringBufferFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 1);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getConvertToStringFormatProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        ConvertToStringFormatFixCore fix;
        if (resultingCollections != null && (fix = ConvertToStringFormatFixCore.createConvertToStringFormatFix((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 0);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean getAddMissingMethodDeclarationProposal(IInvocationContext context, ASTNode coveringNode, ArrayList<ProposalKindWrapper> resultingCollections) {
        AddMissingMethodDeclarationFixCore fix;
        if (resultingCollections != null && (fix = AddMissingMethodDeclarationFixCore.createAddMissingMethodDeclaration((CompilationUnit)context.getASTRoot(), (ASTNode)coveringNode)) != null) {
            try {
                ChangeCorrectionProposalCore p = new ChangeCorrectionProposalCore(fix.getDisplayString(), (Change)fix.createChange(null), 3);
                resultingCollections.add(CodeActionHandler.wrap(p, "quickassist"));
                return true;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }
}

