/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Range;

public class TestItemUtils {
    public static Range parseTestItemRange(IJavaElement element) throws JavaModelException {
        if (element instanceof ISourceReference) {
            ISourceRange sourceRange = ((ISourceReference)element).getSourceRange();
            ISourceRange nameRange = ((ISourceReference)element).getNameRange();
            if (SourceRange.isAvailable((ISourceRange)sourceRange) && SourceRange.isAvailable((ISourceRange)nameRange)) {
                return JDTUtils.toRange((IOpenable)element.getOpenable(), (int)nameRange.getOffset(), (int)(sourceRange.getLength() - nameRange.getOffset() + sourceRange.getOffset()));
            }
        }
        return null;
    }

    public static String parseFullName(IJavaElement element, TestLevel level, TestKind kind) {
        switch (level) {
            case CLASS: {
                IType type = (IType)element;
                return type.getFullyQualifiedName();
            }
            case METHOD: {
                IMethod method = (IMethod)element;
                if (kind == TestKind.JUnit5 || kind == TestKind.TestNG) {
                    String className = method.getDeclaringType().getFullyQualifiedName();
                    String methodName = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)0x200009L).replaceAll("<.*?>", "").replaceAll(" ", "");
                    return String.valueOf(className) + "#" + methodName;
                }
                return String.valueOf(method.getDeclaringType().getFullyQualifiedName()) + "#" + method.getElementName();
            }
        }
        return element.getElementName();
    }
}

