/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.dom;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.internal.core.dom.util.DOMASTUtil;

public class SourceRangeVerifier
extends ASTVisitor {
    public static boolean DEBUG = false;
    public static boolean DEBUG_THROW = false;
    private StringBuilder bugs;

    public String process(ASTNode node) {
        StringBuilder buffer;
        this.bugs = buffer = new StringBuilder();
        node.accept(this);
        this.bugs = null;
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    public boolean preVisit2(ASTNode node) {
        ASTNode previous = null;
        List properties = node.structuralPropertiesForType();
        for (Object p : properties) {
            StructuralPropertyDescriptor property = (StructuralPropertyDescriptor)p;
            if (property.isChildProperty()) {
                ASTNode child = (ASTNode)node.getStructuralProperty(property);
                if (child == null) continue;
                boolean ok = this.checkChild(node, previous, child);
                if (ok) {
                    previous = child;
                    continue;
                }
                return false;
            }
            if (!property.isChildListProperty()) continue;
            List children = (List)node.getStructuralProperty(property);
            for (Object c : children) {
                ASTNode child = (ASTNode)c;
                boolean ok = this.checkChild(node, previous, child);
                if (ok) {
                    previous = child;
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    private boolean checkChild(ASTNode parent, ASTNode previous, ASTNode child) {
        if ((parent.getFlags() & 9) != 0 || (child.getFlags() & 9) != 0) {
            return false;
        }
        if (DOMASTUtil.isRecordDeclarationSupported(child.getAST()) && child instanceof SingleVariableDeclaration && previous != null && previous instanceof MethodDeclaration && ((MethodDeclaration)previous).isCompactConstructor()) {
            return true;
        }
        int parentStart = parent.getStartPosition();
        int parentEnd = parentStart + parent.getLength();
        int childStart = child.getStartPosition();
        int childEnd = childStart + child.getLength();
        if (previous != null) {
            if (child.getLocationInParent() == ArrayCreation.DIMENSIONS_PROPERTY) {
                return false;
            }
            int previousStart = previous.getStartPosition();
            int previousEnd = previousStart + previous.getLength();
            if (childStart < previousEnd) {
                String bug = "- parent [" + parentStart + ", " + parentEnd + "] " + parent.getClass().getName() + "\n   previous [" + previousStart + ", " + previousEnd + "] " + previous.getClass().getName() + "\n   " + child.getLocationInParent().getId() + " [" + childStart + ", " + childEnd + "] " + child.getClass().getName() + "\n";
                this.bugs.append(bug);
            }
        }
        if (parentStart > childStart || childEnd > parentEnd) {
            String bug = "- parent [" + parentStart + ", " + parentEnd + "] " + parent.getClass().getName() + "\n   " + child.getLocationInParent().getId() + " [" + childStart + ", " + childEnd + "] " + child.getClass().getName() + "\n";
            this.bugs.append(bug);
        }
        return true;
    }
}

