/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.text.edits.TextEditGroup;

public final class SplitTryResourceFixCore
extends CompilationUnitRewriteOperationsFixCore {
    public SplitTryResourceFixCore(String name, CompilationUnit compilationUnit, CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[] operations) {
        super(name, compilationUnit, operations);
    }

    public static boolean initialConditionsCheck(ICompilationUnit compilationUnit, ASTNode node) {
        TryStatement tryStatement;
        VariableDeclarationExpression varDeclExp;
        if (!JavaModelUtil.is1d8OrHigher(compilationUnit.getJavaProject())) {
            return false;
        }
        ASTNode foundNode = ASTNodes.getFirstAncestorOrNull(node, VariableDeclarationExpression.class, Statement.class);
        if (!(foundNode instanceof VariableDeclarationExpression) || (varDeclExp = (VariableDeclarationExpression)foundNode).getLocationInParent() != TryStatement.RESOURCES2_PROPERTY) {
            return false;
        }
        ASTNode parent = foundNode.getParent();
        return parent instanceof TryStatement && (tryStatement = (TryStatement)parent).resources().size() >= 2;
    }

    public static SplitTryResourceFixCore createSplitVariableFix(CompilationUnit compilationUnit, ASTNode node) {
        TryStatement tryStatement;
        VariableDeclarationExpression varDeclExp;
        ASTNode foundNode = ASTNodes.getFirstAncestorOrNull(node, VariableDeclarationExpression.class, Statement.class);
        if (!(foundNode instanceof VariableDeclarationExpression) || (varDeclExp = (VariableDeclarationExpression)foundNode).getLocationInParent() != TryStatement.RESOURCES2_PROPERTY) {
            return null;
        }
        ASTNode parent = foundNode.getParent();
        if (!(parent instanceof TryStatement) || (tryStatement = (TryStatement)parent).resources().size() < 2) {
            return null;
        }
        return new SplitTryResourceFixCore(CorrectionMessages.QuickAssistProcessor_splittryresource_description, compilationUnit, new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[]{new SplitTryResourceProposalOperation(tryStatement, varDeclExp)});
    }

    private static class SplitTryResourceProposalOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final TryStatement tryStatement;
        private final VariableDeclarationExpression expression;

        public SplitTryResourceProposalOperation(TryStatement statement, VariableDeclarationExpression expression) {
            this.tryStatement = statement;
            this.expression = expression;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            TextEditGroup group = new TextEditGroup("abc");
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getAST();
            List resources = this.tryStatement.resources();
            int expIndex = 0;
            while (expIndex < resources.size()) {
                if (resources.get(expIndex) == this.expression) break;
                ++expIndex;
            }
            TryStatement newTryStatement = ast.newTryStatement();
            Block newBlock = ast.newBlock();
            newTryStatement.setBody(newBlock);
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)newTryStatement, TryStatement.RESOURCES2_PROPERTY);
            ListRewrite oldResourcesListRewrite = rewrite.getListRewrite((ASTNode)this.tryStatement, TryStatement.RESOURCES2_PROPERTY);
            listRewrite.insertFirst(oldResourcesListRewrite.createMoveTarget((ASTNode)this.expression, (ASTNode)oldResourcesListRewrite.getOriginalList().get(resources.size() - 1)), group);
            Block originalBlock = this.tryStatement.getBody();
            List originalStatements = originalBlock.statements();
            int size = originalStatements.size();
            ListRewrite originalBlockListRewrite = rewrite.getListRewrite((ASTNode)originalBlock, Block.STATEMENTS_PROPERTY);
            originalBlockListRewrite.insertFirst((ASTNode)newTryStatement, group);
            ListRewrite newBlockListRewrite = rewrite.getListRewrite((ASTNode)newBlock, Block.STATEMENTS_PROPERTY);
            newBlockListRewrite.insertLast(originalBlockListRewrite.createMoveTarget((ASTNode)originalStatements.get(0), (ASTNode)originalStatements.get(size - 1)), group);
        }
    }
}

