/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;

final class StringRangeFinder
extends ASTVisitor {
    private ICompilationUnit cu;
    private Range range;
    private boolean within = false;
    private StringLiteral stringLiteral = null;

    public StringRangeFinder(ICompilationUnit cu, Range range) {
        this.cu = cu;
        this.range = range;
    }

    public boolean visit(StringLiteral stringLiteral) {
        try {
            Location location = JDTUtils.toLocation(this.cu, stringLiteral.getStartPosition(), stringLiteral.getLength());
            Range stringRange = location.getRange();
            if ((this.range.getStart().getLine() > stringRange.getStart().getLine() || this.range.getStart().getLine() == stringRange.getStart().getLine() && this.range.getStart().getCharacter() > stringRange.getStart().getCharacter()) && (this.range.getEnd().getLine() < stringRange.getEnd().getLine() || this.range.getEnd().getLine() == stringRange.getEnd().getLine() && this.range.getEnd().getCharacter() < stringRange.getEnd().getCharacter())) {
                this.within = true;
                this.stringLiteral = stringLiteral;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return true;
    }

    public boolean isWithin() {
        return this.within;
    }

    public StringLiteral getStringLiteral() {
        return this.stringLiteral;
    }
}

