/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.manipulation.CodeGeneration;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ls.core.internal.CompletionUtils;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemDefaults;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class JavadocCompletionProposal {
    private static final String ASTERISK = "*";
    private static final String WHITESPACES = " \t";
    public static final String JAVA_DOC_COMMENT = "Javadoc comment";

    public List<CompletionItem> getProposals(ICompilationUnit cu, int offset, CompletionProposalRequestor collector, IProgressMonitor monitor) throws JavaModelException {
        if (cu == null) {
            throw new IllegalArgumentException("Compilation unit must not be null");
        }
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        IDocument d = JsonRpcHelpers.toDocument(cu.getBuffer());
        if (offset < 0 || d.getLength() == 0) {
            return result;
        }
        try {
            int p = offset == d.getLength() ? offset - 1 : offset;
            IRegion line = d.getLineInformationOfOffset(p);
            String lineStr = d.get(line.getOffset(), line.getLength()).trim();
            if (!lineStr.startsWith("/**")) {
                return result;
            }
            if (!this.hasEndJavadoc(d, offset)) {
                return result;
            }
            String text = collector.getContext().getToken() == null ? "" : new String(collector.getContext().getToken());
            StringBuilder buf = new StringBuilder(text);
            IRegion prefix = this.findPrefixRange(d, line);
            String indentation = d.get(prefix.getOffset(), prefix.getLength());
            int lengthToAdd = Math.min(offset - prefix.getOffset(), prefix.getLength());
            buf.append(indentation.substring(0, lengthToAdd));
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
            ICompilationUnit unit = cu;
            try {
                unit.reconcile(0, false, null, null);
                String string = this.createJavaDocTags(d, offset, indentation, lineDelimiter, unit);
                if (string == null || string.trim().equals(ASTERISK)) {
                    return result;
                }
                buf.append(string);
                int nextNonWS = this.findEndOfWhiteSpace(d, offset, d.getLength());
                if (!Character.isWhitespace(d.getChar(nextNonWS))) {
                    buf.append(lineDelimiter);
                }
            }
            catch (CoreException string) {
                // empty catch block
            }
            CompletionItem ci = new CompletionItem();
            CompletionItemDefaults completionItemDefaults = collector.getCompletionItemDefaults();
            Range range = JDTUtils.toRange((IOpenable)unit, offset, 0);
            boolean isSnippetSupported = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionSnippetsSupported();
            String replacement = this.prepareTemplate(buf.toString(), lineDelimiter, isSnippetSupported);
            if (JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isCompletionListItemDefaultsPropertySupport("editRange") && completionItemDefaults != null && completionItemDefaults.getEditRange() != null && completionItemDefaults.getEditRange().getLeft() == range) {
                ci.setTextEditText(replacement);
            } else {
                ci.setTextEdit(Either.forLeft((Object)new TextEdit(range, replacement)));
            }
            ci.setFilterText(JAVA_DOC_COMMENT);
            ci.setLabel(JAVA_DOC_COMMENT);
            ci.setSortText(SortTextHelper.convertRelevance(0));
            ci.setKind(CompletionItemKind.Snippet);
            CompletionUtils.setInsertTextFormat(ci, completionItemDefaults);
            CompletionUtils.setInsertTextMode(ci, completionItemDefaults);
            String documentation = this.prepareTemplate(buf.toString(), lineDelimiter, false);
            if (documentation.indexOf(lineDelimiter) == 0) {
                documentation = documentation.replaceFirst(lineDelimiter, "");
            }
            ci.setDocumentation(documentation);
            result.add(ci);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return result;
    }

    private String prepareTemplate(String text, String lineDelimiter, boolean addGap) {
        boolean endWithLineDelimiter = text.endsWith(lineDelimiter);
        String[] lines = text.split(lineDelimiter);
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < lines.length) {
            String stripped;
            String line = lines[i];
            if (addGap && (stripped = StringUtils.stripStart((String)line, (String)WHITESPACES)).startsWith(ASTERISK)) {
                if (!stripped.equals(ASTERISK)) {
                    int index = line.indexOf(ASTERISK);
                    buf.append(line.substring(0, index + 1));
                    buf.append(" ${0}");
                    buf.append(lineDelimiter);
                }
                addGap = false;
            }
            buf.append(StringUtils.stripEnd((String)line, (String)WHITESPACES));
            if (i < lines.length - 1 || endWithLineDelimiter) {
                buf.append(lineDelimiter);
            }
            ++i;
        }
        return buf.toString();
    }

    private IRegion findPrefixRange(IDocument document, IRegion line) throws BadLocationException {
        int lineEnd;
        int lineOffset = line.getOffset();
        int indentEnd = this.findEndOfWhiteSpace(document, lineOffset, lineEnd = lineOffset + line.getLength());
        if (indentEnd < lineEnd && document.getChar(indentEnd) == '*') {
            ++indentEnd;
            while (indentEnd < lineEnd && document.getChar(indentEnd) == ' ') {
                ++indentEnd;
            }
        }
        return new Region(lineOffset, indentEnd - lineOffset);
    }

    private int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    private boolean hasEndJavadoc(IDocument document, int offset) throws BadLocationException {
        int pos = -1;
        while (offset < document.getLength()) {
            char c = document.getChar(offset);
            if (!Character.isWhitespace(c) && c != '*') {
                pos = offset;
                break;
            }
            ++offset;
        }
        return document.getLength() >= pos + 2 && document.get(pos - 1, 2).equals("*/");
    }

    private String createJavaDocTags(IDocument document, int offset, String indentation, String lineDelimiter, ICompilationUnit unit) throws CoreException, BadLocationException {
        IJavaElement element = unit.getElementAt(offset);
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 7: {
                return this.createTypeTags(document, offset, indentation, lineDelimiter, (IType)element);
            }
            case 9: {
                return this.createMethodTags(document, offset, indentation, lineDelimiter, (IMethod)element);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String createTypeTags(IDocument document, int offset, String indentation, String lineDelimiter, IType type) throws CoreException, BadLocationException {
        String comment;
        ISourceRange range;
        ASTNode node;
        ASTNode aSTNode;
        if (!this.accept(offset, (IMember)type)) {
            return null;
        }
        CompilationUnit unit = SharedASTProviderCore.getAST((ITypeRoot)type.getTypeRoot(), (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_ACTIVE_ONLY, null);
        if (unit == null) {
            return null;
        }
        String version = type.getJavaProject().getOption("org.eclipse.jdt.core.compiler.compliance", true);
        String[] typeParamNames = null;
        boolean isRecord = false;
        if (!JavaModelUtil.isVersionLessThan((String)version, (String)"14") && (aSTNode = (node = NodeFinder.perform((ASTNode)unit, (int)(range = type.getNameRange()).getOffset(), (int)range.getLength()).getParent())) instanceof RecordDeclaration) {
            void recordDeclaration;
            RecordDeclaration recordDeclaration2 = (RecordDeclaration)aSTNode;
            RecordDeclaration cfr_ignored_0 = (RecordDeclaration)aSTNode;
            List components = recordDeclaration.recordComponents();
            ArrayList<String> paramList = new ArrayList<String>(components.size());
            for (Object o : components) {
                void variableDeclaration;
                Object e = o;
                if (!(e instanceof VariableDeclaration)) continue;
                VariableDeclaration cfr_ignored_1 = (VariableDeclaration)e;
                VariableDeclaration cfr_ignored_2 = (VariableDeclaration)e;
                paramList.add(variableDeclaration.getName().getFullyQualifiedName());
            }
            typeParamNames = paramList.toArray(new String[0]);
            isRecord = true;
        }
        if (typeParamNames == null) {
            typeParamNames = StubUtility.getTypeParameterNames((ITypeParameter[])type.getTypeParameters());
        }
        if ((comment = CodeGeneration.getTypeComment((ICompilationUnit)type.getCompilationUnit(), (String)type.getTypeQualifiedName('.'), (String[])typeParamNames, (String)lineDelimiter)) != null) {
            if (isRecord) {
                CharSequence[] lines = comment.split(System.getProperty("line.separator"));
                int i = 0;
                while (i < lines.length) {
                    if (lines[i].contains("param <")) {
                        lines[i] = ((String)lines[i]).replace("<", "").replace(">", "");
                    }
                    ++i;
                }
                comment = String.join((CharSequence)System.getProperty("line.separator"), lines);
            }
            return this.prepareTemplateComment(comment.trim(), indentation, type.getJavaProject(), lineDelimiter);
        }
        return null;
    }

    private boolean accept(int offset, IMember member) throws JavaModelException {
        ISourceRange nameRange = member.getNameRange();
        if (nameRange == null) {
            return false;
        }
        int srcOffset = nameRange.getOffset();
        return srcOffset > offset;
    }

    private String createMethodTags(IDocument document, int offset, String indentation, String lineDelimiter, IMethod method) throws CoreException, BadLocationException {
        boolean javadocComment;
        if (!this.accept(offset, (IMember)method)) {
            return null;
        }
        IMethod inheritedMethod = this.getInheritedMethod(method);
        String comment = CodeGeneration.getMethodComment((IMethod)method, (IMethod)inheritedMethod, (String)lineDelimiter);
        if (comment != null && (javadocComment = (comment = comment.trim()).startsWith("/**"))) {
            return this.prepareTemplateComment(comment, indentation, method.getJavaProject(), lineDelimiter);
        }
        return null;
    }

    private String prepareTemplateComment(String comment, String indentation, IJavaProject project, String lineDelimiter) {
        if (comment.endsWith("*/")) {
            comment = comment.substring(0, comment.length() - 2);
        }
        if ((comment = comment.trim()).startsWith("/*")) {
            comment = comment.length() > 2 && comment.charAt(2) == '*' ? comment.substring(3) : comment.substring(2);
        }
        int nonSpace = 0;
        int len = comment.length();
        while (nonSpace < len && Character.getType(comment.charAt(nonSpace)) == 12) {
            ++nonSpace;
        }
        comment = comment.substring(nonSpace);
        return comment;
    }

    private IMethod getInheritedMethod(IMethod method) throws JavaModelException {
        IType declaringType = method.getDeclaringType();
        MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester((IType)declaringType);
        return tester.findOverriddenMethod(method, true);
    }
}

