/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ls.core.internal.JDTEnvironmentUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.LanguageServerApplication;

public class ConnectionStreamFactory {
    private StreamProvider provider;
    private LanguageServerApplication application;

    public ConnectionStreamFactory(LanguageServerApplication languageServer) {
        this.application = languageServer;
    }

    public StreamProvider getSelectedStream() {
        if (this.provider == null) {
            this.provider = this.createProvider();
        }
        return this.provider;
    }

    private StreamProvider createProvider() {
        Integer port = JDTEnvironmentUtils.getClientPort();
        if (port != null) {
            return new SocketStreamProvider(JDTEnvironmentUtils.getClientHost(), port);
        }
        File pipeFile = ConnectionStreamFactory.getPipeFile();
        if (pipeFile != null) {
            return new PipeStreamProvider();
        }
        return new StdIOStreamProvider();
    }

    public InputStream getInputStream() throws IOException {
        return this.getSelectedStream().getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getSelectedStream().getOutputStream();
    }

    protected static boolean isWindows() {
        return "win32".equals(Platform.getOS());
    }

    private static File getPipeFile() {
        Optional<String[]> procArgs = ProcessHandle.current().info().arguments();
        String[] arguments = new String[]{};
        if (procArgs.isPresent()) {
            arguments = procArgs.get();
        } else {
            String eclipseCommands = System.getProperty("eclipse.commands");
            if (eclipseCommands != null) {
                arguments = eclipseCommands.split("\n");
            }
        }
        Optional<String> pipeArgs = Stream.of(arguments).filter(arg -> arg.contains("--pipe=")).findFirst();
        if (pipeArgs.isPresent()) {
            String pipeArg = pipeArgs.get();
            String pipeFile = pipeArg.substring(pipeArg.indexOf(61) + 1);
            return new File(pipeFile);
        }
        return null;
    }

    public class NamedPipeInputStream
    extends InputStream {
        private ReadableByteChannel unixChannel;
        private AsynchronousFileChannel winChannel;
        private ByteBuffer buffer = ByteBuffer.allocate(1024);
        private int readyBytes = 0;

        public NamedPipeInputStream(ReadableByteChannel channel) {
            this.unixChannel = channel;
        }

        public NamedPipeInputStream(AsynchronousFileChannel channel) {
            this.winChannel = channel;
        }

        @Override
        public int read() throws IOException {
            block4: {
                if (this.buffer.position() < this.readyBytes) {
                    return this.buffer.get() & 0xFF;
                }
                this.buffer.clear();
                this.readyBytes = this.winChannel != null ? this.winChannel.read(this.buffer, 0L).get().intValue() : this.unixChannel.read(this.buffer);
                if (this.readyBytes != -1) break block4;
                return -1;
            }
            try {
                this.buffer.flip();
                return this.buffer.get() & 0xFF;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    public class NamedPipeOutputStream
    extends OutputStream {
        private WritableByteChannel unixChannel;
        private AsynchronousFileChannel winChannel;
        private ByteBuffer buffer = ByteBuffer.allocate(1);

        public NamedPipeOutputStream(WritableByteChannel channel) {
            this.unixChannel = channel;
        }

        public NamedPipeOutputStream(AsynchronousFileChannel channel) {
            this.winChannel = channel;
        }

        @Override
        public void write(int b) throws IOException {
            this.buffer.clear();
            this.buffer.put((byte)b);
            this.buffer.position(0);
            if (this.winChannel != null) {
                Future<Integer> result = this.winChannel.write(this.buffer, 0L);
                try {
                    result.get();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            } else {
                this.unixChannel.write(this.buffer);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            int BUFFER_SIZE = 1024;
            int blocks = b.length / 1024;
            int writeBytes = 0;
            int i = 0;
            while (i <= blocks) {
                int offset = i * 1024;
                int length = Math.min(b.length - writeBytes, 1024);
                if (length <= 0) break;
                writeBytes += length;
                ByteBuffer buffer = ByteBuffer.wrap(b, offset, length);
                if (this.winChannel != null) {
                    Future<Integer> result = this.winChannel.write(buffer, 0L);
                    try {
                        result.get();
                    }
                    catch (Exception e) {
                        throw new IOException(e);
                    }
                } else {
                    this.unixChannel.write(buffer);
                }
                ++i;
            }
        }
    }

    protected final class PipeStreamProvider
    implements StreamProvider {
        private InputStream input;
        private OutputStream output;

        public PipeStreamProvider() {
            this.initializeNamedPipe();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.input;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.output;
        }

        private void initializeNamedPipe() {
            File pipeFile = ConnectionStreamFactory.getPipeFile();
            if (pipeFile != null) {
                if (ConnectionStreamFactory.isWindows()) {
                    try {
                        AsynchronousFileChannel channel = AsynchronousFileChannel.open(pipeFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                        this.input = new NamedPipeInputStream(channel);
                        this.output = new NamedPipeOutputStream(channel);
                    }
                    catch (IOException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                } else {
                    UnixDomainSocketAddress socketAddress = UnixDomainSocketAddress.of(pipeFile.toPath());
                    try {
                        SocketChannel channel = SocketChannel.open(StandardProtocolFamily.UNIX);
                        channel.connect(socketAddress);
                        this.input = new NamedPipeInputStream(channel);
                        this.output = new NamedPipeOutputStream(channel);
                    }
                    catch (IOException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                }
            }
        }
    }

    protected final class SocketStreamProvider
    implements StreamProvider {
        private final String host;
        private final int port;
        private InputStream fInputStream;
        private OutputStream fOutputStream;

        public SocketStreamProvider(String host, int port) {
            this.host = host;
            this.port = port;
        }

        private void initializeConnection() throws IOException {
            Socket socket = new Socket(this.host, this.port);
            this.fInputStream = socket.getInputStream();
            this.fOutputStream = socket.getOutputStream();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.fInputStream == null) {
                this.initializeConnection();
            }
            return this.fInputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.fOutputStream == null) {
                this.initializeConnection();
            }
            return this.fOutputStream;
        }
    }

    protected final class StdIOStreamProvider
    implements StreamProvider {
        protected StdIOStreamProvider() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return ConnectionStreamFactory.this.application.getIn();
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return ConnectionStreamFactory.this.application.getOut();
        }
    }

    static interface StreamProvider {
        public InputStream getInputStream() throws IOException;

        public OutputStream getOutputStream() throws IOException;
    }
}

