/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.internal.core.AbstractClassFile;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.ModularClassFile;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.util.Disassembler;
import org.eclipse.jdt.internal.core.util.Util;

public class ClassFileWorkingCopy
extends CompilationUnit {
    public AbstractClassFile classFile;

    public ClassFileWorkingCopy(AbstractClassFile classFile, WorkingCopyOwner owner) {
        super((PackageFragment)classFile.getParent(), ClassFileWorkingCopy.sourceFileName(classFile), owner);
        this.classFile = classFile;
    }

    private static String sourceFileName(AbstractClassFile classFile) {
        if (classFile instanceof ModularClassFile) {
            return "module-info.java";
        }
        return ((BinaryType)((ClassFile)classFile).getType()).getSourceFileName(null);
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    @Override
    public IBuffer getBuffer() throws JavaModelException {
        if (this.isWorkingCopy()) {
            return super.getBuffer();
        }
        return this.classFile.getBuffer();
    }

    @Override
    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            if (buffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] characters = buffer.getCharacters();
            if (characters == null) {
                return CharOperation.NO_CHAR;
            }
            return characters;
        }
        catch (JavaModelException e) {
            return CharOperation.NO_CHAR;
        }
    }

    @Override
    public IPath getPath() {
        return this.classFile.getPath();
    }

    @Override
    public JavaElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new ClassFileWorkingCopy(this.classFile, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IResource resource(PackageFragmentRoot root) {
        if (root.isArchive()) {
            return root.resource(root);
        }
        return this.classFile.resource(root);
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer buffer = BufferManager.createBuffer(this);
        IBuffer classFileBuffer = this.classFile.getBuffer();
        if (classFileBuffer != null) {
            buffer.setContents(classFileBuffer.getCharacters());
        } else {
            IClassFileReader reader = ToolFactory.createDefaultClassFileReader(this.classFile, 65535);
            Disassembler disassembler = new Disassembler();
            String contents = disassembler.disassemble(reader, Util.getLineSeparator("", this.getJavaProject()), 16);
            buffer.setContents(contents);
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    protected void toStringName(StringBuilder buffer) {
        buffer.append(this.classFile.getElementName());
    }
}

