"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverviewPreferences = exports.OverviewSchema = exports.getOpenTraceOverviewFailErrorMessage = exports.getSwitchToDefaultViewErrorMessage = exports.DEFAULT_OVERVIEW_OUTPUT_NAME = exports.TRACE_OVERVIEW_DEFAULT_VIEW_KEY = void 0;
const browser_1 = require("@theia/core/lib/browser");
exports.TRACE_OVERVIEW_DEFAULT_VIEW_KEY = 'trace Viewer.trace Overview.defaultView';
exports.DEFAULT_OVERVIEW_OUTPUT_NAME = 'Histogram';
function getSwitchToDefaultViewErrorMessage(preferredName, defaultName) {
    return `The ${preferredName} view cannot be opened as the trace overview. ` +
        `Opening ${defaultName} instead. ` +
        'Please set the Default View preference (Ctrl + ,) of the Trace Overview to an XY view, ' +
        'or make sure the name is spelled correctly.';
}
exports.getSwitchToDefaultViewErrorMessage = getSwitchToDefaultViewErrorMessage;
function getOpenTraceOverviewFailErrorMessage() {
    return 'An error has occurred while opening the trace overview.';
}
exports.getOpenTraceOverviewFailErrorMessage = getOpenTraceOverviewFailErrorMessage;
exports.OverviewSchema = {
    scope: browser_1.PreferenceScope.Folder,
    type: 'object',
    properties: {
        [exports.TRACE_OVERVIEW_DEFAULT_VIEW_KEY]: {
            type: 'string',
            default: exports.DEFAULT_OVERVIEW_OUTPUT_NAME,
            description: 'Specify the name of the view that will be used as the default view for the Trace Overview. ' +
                'Use the same name displayed in the Available Views list. E.g: For the Histogram view, enter Histogram.'
        }
    },
};
exports.OverviewPreferences = Symbol('OverviewPreferences');
//# sourceMappingURL=trace-overview-preference.js.map