"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TraceViewerWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceViewerWidget = exports.TraceViewerWidgetOptions = void 0;
const core_1 = require("@theia/core");
const browser_1 = require("@theia/core/lib/browser");
const react_widget_1 = require("@theia/core/lib/browser/widgets/react-widget");
const inversify_1 = require("inversify");
const tsp_client_provider_impl_1 = require("../tsp-client-provider-impl");
const trace_context_component_1 = require("traceviewer-react-components/lib/components/trace-context-component");
const theia_message_manager_1 = require("../theia-message-manager");
const theming_1 = require("@theia/core/lib/browser/theming");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const trace_explorer_contribution_1 = require("../trace-explorer/trace-explorer-contribution");
const backend_file_service_1 = require("../../common/backend-file-service");
const core_2 = require("@theia/core");
const React = __importStar(require("react"));
require("animate.css");
exports.TraceViewerWidgetOptions = Symbol('TraceViewerWidgetOptions');
let TraceViewerWidget = TraceViewerWidget_1 = class TraceViewerWidget extends react_widget_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.outputDescriptors = [];
        this.loadTraceOverview = true;
        this.resizeHandlers = [];
        this.addResizeHandler = (h) => {
            this.resizeHandlers.push(h);
        };
        this.removeResizeHandler = (h) => {
            const index = this.resizeHandlers.indexOf(h, 0);
            if (index > -1) {
                this.resizeHandlers.splice(index, 1);
            }
        };
        this.markerCategoriesMap = new Map();
        this.toolbarMarkerCategoriesMap = new Map();
        this.selectedMarkerCategoriesMap = new Map();
        this.markerSetsMap = new Map();
        this.selectedMarkerSetId = '';
        this.onOutputAdded = (payload) => this.doHandleOutputAddedSignal(payload);
        this.onTraceOverviewOpened = () => this.doHandleTraceOverviewOpenedSignal();
        this.onTraceOverviewOutputSelected = (payload) => this.doHandleTraceOverviewOutputSelected(payload);
        this.onExperimentSelected = (experiment) => this.doHandleExperimentSelectedSignal(experiment);
        this.onCloseExperiment = (UUID) => this.doHandleCloseExperimentSignal(UUID);
        this.onMarkerCategoryClosedSignal = (payload) => this.doHandleMarkerCategoryClosedSignal(payload);
        this.toDisposeOnNewExplorer = new core_1.DisposableCollection();
    }
    async init() {
        this.uri = new core_1.Path(this.options.traceURI);
        this.id = 'theia-traceOpen';
        this.title.label = 'Trace: ' + this.uri.base;
        this.title.closable = true;
        this.addClass('theia-trace-open');
        this.backgroundTheme = this.themeService.getCurrentTheme().type;
        this.toDispose.push(this.themeService.onDidColorThemeChange(() => this.updateBackgroundTheme()));
        if (!this.options.traceUUID) {
            this.initialize();
        }
        this.traceContextComponent = React.createRef();
        this.tspClient = this.tspClientProvider.getTspClient();
        this.traceManager = this.tspClientProvider.getTraceManager();
        this.experimentManager = this.tspClientProvider.getExperimentManager();
        this.toDispose.push(core_1.Disposable.create(() => {
            this.tspClientProvider.addTspClientChangeListener(tspClient => {
                this.tspClient = tspClient;
                this.traceManager = this.tspClientProvider.getTraceManager();
                this.experimentManager = this.tspClientProvider.getExperimentManager();
            });
        }));
        if (this.options.traceUUID) {
            const experiment = await this.experimentManager.updateExperiment(this.options.traceUUID);
            if (experiment) {
                this.openedExperiment = experiment;
                this.title.label = 'Trace: ' + experiment.name;
                this.id = experiment.UUID;
                this.experimentManager.addExperiment(experiment);
                (0, signal_manager_1.signalManager)().fireExperimentOpenedSignal(experiment);
                if (this.isVisible) {
                    (0, signal_manager_1.signalManager)().fireTraceViewerTabActivatedSignal(experiment);
                }
                this.fetchMarkerSets(experiment.UUID);
            }
            this.update();
        }
        this.subscribeToEvents();
        this.toDispose.push(this.toDisposeOnNewExplorer);
        // Make node focusable so it can achieve focus on activate (avoid warning);
        this.node.tabIndex = 0;
        // Load the trace overview by default
        if (this.loadTraceOverview) {
            this.doHandleTraceOverviewOpenedSignal();
        }
    }
    subscribeToEvents() {
        this.toDisposeOnNewExplorer.dispose();
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.OUTPUT_ADDED, this.onOutputAdded);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.EXPERIMENT_SELECTED, this.onExperimentSelected);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.CLOSE_TRACEVIEWERTAB, this.onCloseExperiment);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.MARKER_CATEGORY_CLOSED, this.onMarkerCategoryClosedSignal);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.OPEN_OVERVIEW_OUTPUT, this.onTraceOverviewOpened);
        (0, signal_manager_1.signalManager)().on(signal_manager_1.Signals.OVERVIEW_OUTPUT_SELECTED, this.onTraceOverviewOutputSelected);
    }
    updateBackgroundTheme() {
        const currentThemeType = this.themeService.getCurrentTheme().type;
        (0, signal_manager_1.signalManager)().fireThemeChangedSignal(currentThemeType);
    }
    dispose() {
        super.dispose();
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.OUTPUT_ADDED, this.onOutputAdded);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.EXPERIMENT_SELECTED, this.onExperimentSelected);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.CLOSE_TRACEVIEWERTAB, this.onCloseExperiment);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.OPEN_OVERVIEW_OUTPUT, this.onTraceOverviewOpened);
        (0, signal_manager_1.signalManager)().off(signal_manager_1.Signals.OVERVIEW_OUTPUT_SELECTED, this.onTraceOverviewOutputSelected);
    }
    async initialize() {
        const cancellation = new core_2.CancellationTokenSource();
        // This will show a progress dialog with "Cancel" option
        this.messageService.showProgress({
            text: 'Open traces',
            options: {
                cancelable: true
            }
        }, () => {
            cancellation.cancel();
        })
            .then(async (progress) => {
            try {
                progress.report({ message: 'Finding traces ', work: { done: 10, total: 100 } });
                const tracesArray = await this.backendFileService.findTraces(this.uri.toString(), cancellation.token);
                if (cancellation.token.isCancellationRequested) {
                    progress.report({ message: 'Complete', work: { done: 100, total: 100 } });
                    this.dispose();
                    return;
                }
                // Check if the folder is empty.
                if (tracesArray.length === 0) {
                    progress.report({ message: 'Complete', work: { done: 100, total: 100 } });
                    progress.cancel();
                    this.messageService.error('No valid traces found in the selected directory: ' + this.uri);
                    this.dispose();
                    return;
                }
                progress.report({ message: 'Opening traces', work: { done: 30, total: 100 } });
                const traces = new Array();
                const invalidTraces = new Array();
                for (let i = 0; i < tracesArray.length; i++) {
                    if (cancellation.token.isCancellationRequested) {
                        break;
                    }
                    const tracePath = new core_1.Path(tracesArray[i]);
                    const traceName = tracePath.name + tracePath.ext;
                    const trace = await this.traceManager.openTrace(tracesArray[i], traceName);
                    if (trace) {
                        traces.push(trace);
                    }
                    else {
                        invalidTraces.push(traceName);
                    }
                }
                if (cancellation.token.isCancellationRequested) {
                    // Rollback traces
                    progress.report({ message: 'Rolling back traces', work: { done: 50, total: 100 } });
                    for (let i = 0; i < traces.length; i++) {
                        await this.traceManager.deleteTrace(traces[i].UUID);
                    }
                    progress.report({ message: 'Complete', work: { done: 100, total: 100 } });
                    this.dispose();
                    return;
                }
                progress.report({ message: 'Merging traces', work: { done: 70, total: 100 } });
                if (traces === undefined || traces.length === 0) {
                    // All the traces are invalid. Display the error message and exit.
                    this.messageService.error('Invalid trace(s): ' + invalidTraces.toString());
                    this.dispose();
                }
                else {
                    const experiment = await this.experimentManager.openExperiment(this.uri.name + this.uri.ext, traces);
                    if (experiment) {
                        const widgets = this.widgetManager.getWidgets(TraceViewerWidget_1.ID);
                        const widget = widgets.find(w => w.id === experiment.UUID);
                        let sendSignal = true;
                        if (widget) {
                            // Close widget if it had been opened previously.
                            cancellation.cancel();
                            this.dispose();
                        }
                        else {
                            this.openedExperiment = experiment;
                            this.title.label = 'Trace: ' + experiment.name;
                            this.id = experiment.UUID;
                            sendSignal = this.isVisible;
                            this.fetchMarkerSets(experiment.UUID);
                        }
                        if (sendSignal) {
                            (0, signal_manager_1.signalManager)().fireTraceViewerTabActivatedSignal(experiment);
                        }
                        this.traceExplorerContribution.openView({
                            activate: true
                        });
                    }
                    // Check if there are any invalid traces and display the warning message with the names of the invalid traces if any.
                    if (Array.isArray(invalidTraces) && invalidTraces.length) {
                        this.messageService.warn('Invalid trace(s): ' + invalidTraces.toString());
                    }
                }
                this.update();
            }
            catch (e) {
                cancellation.cancel();
                this.dispose();
            }
            progress.report({ message: 'Complete', work: { done: 100, total: 100 } });
            progress.cancel();
        });
    }
    storeState() {
        var _a;
        /*
        TODO - BigInt support for storing state in outputs/outputDescriptors
        JSON.stringify cannot serialize BigInt
        */
        if ((_a = this.traceContextComponent) === null || _a === void 0 ? void 0 : _a.current) {
            const persistedState = this.traceContextComponent.current.persistedState;
            return persistedState;
        }
        return undefined;
    }
    restoreState(persistedState) {
        /*
        TODO - BigInt support for restoring state in outputs/outputDescriptors
        Identify what values need to be BigInt and convert.
        */
        if (persistedState.outputs.length > 0 || persistedState.storedOverviewOutput) {
            this.persistedState = persistedState;
            if (persistedState.outputs.length > 0) {
                this.outputDescriptors = persistedState.outputs;
            }
            if (persistedState.storedOverviewOutput) {
                this.overviewOutputDescriptor = persistedState.storedOverviewOutput;
            }
        }
        this.loadTraceOverview = false;
    }
    async fetchMarkerSets(expUUID) {
        const markers = await this.tspClient.fetchMarkerSets(expUUID);
        const markersResponse = markers.getModel();
        if (markersResponse && markers.isOk()) {
            this.addMarkerSets(markersResponse.model);
        }
    }
    async onCloseRequest(msg) {
        this.statusBar.removeElement('time-selection-range');
        super.onCloseRequest(msg);
        if (this.openedExperiment) {
            (0, signal_manager_1.signalManager)().fireExperimentClosedSignal(this.openedExperiment);
        }
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        if (this.openedExperiment) {
            (0, signal_manager_1.signalManager)().fireTraceViewerTabActivatedSignal(this.openedExperiment);
        }
        this.node.focus();
    }
    onResize() {
        this.resizeHandlers.forEach(h => h());
    }
    doHandleCloseExperimentSignal(UUID) {
        this.shell.closeWidget(UUID);
    }
    render() {
        this.onOutputRemoved = this.onOutputRemoved.bind(this);
        this.onOverviewRemoved = this.onOverviewRemoved.bind(this);
        return React.createElement("div", { className: 'trace-viewer-container' }, this.openedExperiment ? React.createElement(trace_context_component_1.TraceContextComponent, { experiment: this.openedExperiment, ref: this.traceContextComponent, tspClient: this.tspClient, outputs: this.outputDescriptors, overviewDescriptor: this.overviewOutputDescriptor, markerCategoriesMap: this.selectedMarkerCategoriesMap, markerSetId: this.selectedMarkerSetId, onOutputRemove: this.onOutputRemoved, onOverviewRemove: this.onOverviewRemoved, addResizeHandler: this.addResizeHandler, removeResizeHandler: this.removeResizeHandler, backgroundTheme: this.backgroundTheme, persistedState: this.persistedState, messageManager: this._signalHandler }) : 'Trace is loading...');
    }
    async fetchAnnotationCategories(output) {
        if (this.openedExperiment) {
            const annotationCategories = await this.tspClient.fetchAnnotationsCategories(this.openedExperiment.UUID, output.id, this.selectedMarkerSetId);
            const annotationCategoriesResponse = annotationCategories.getModel();
            if (annotationCategories.isOk() && annotationCategoriesResponse) {
                const markerCategories = annotationCategoriesResponse.model ? annotationCategoriesResponse.model.annotationCategories : [];
                this.addMarkerCategories(output.id, markerCategories);
            }
        }
    }
    async doHandleOutputAddedSignal(payload) {
        var _a, _b;
        if (this.openedExperiment && payload.getExperiment().UUID === this.openedExperiment.UUID) {
            const exist = this.outputDescriptors.find(output => output.id === payload.getOutputDescriptor().id);
            if (!exist) {
                const output = payload.getOutputDescriptor();
                this.outputDescriptors = this.outputDescriptors.concat(output);
                await this.fetchAnnotationCategories(output);
                this.update();
            }
            else {
                const traceId = this.openedExperiment.UUID;
                if (document.getElementById(traceId + exist.id + 'focusContainer')) {
                    (_a = document.getElementById(traceId + exist.id + 'focusContainer')) === null || _a === void 0 ? void 0 : _a.focus();
                }
                else {
                    (_b = document.getElementById(traceId + exist.id)) === null || _b === void 0 ? void 0 : _b.focus();
                }
                await new Promise(resolve => {
                    const titleHandle = document.getElementById(traceId + exist.id + 'handle');
                    titleHandle === null || titleHandle === void 0 ? void 0 : titleHandle.classList.add('animate__animated', 'animate__pulse');
                    titleHandle === null || titleHandle === void 0 ? void 0 : titleHandle.addEventListener('animationend', event => {
                        event.stopPropagation();
                        titleHandle === null || titleHandle === void 0 ? void 0 : titleHandle.classList.remove('animate__animated', 'animate__pulse');
                        resolve('Animation ended');
                    }, { once: true });
                });
            }
        }
    }
    onOutputRemoved(outputId) {
        const outputToKeep = this.outputDescriptors.filter(output => output.id !== outputId);
        this.outputDescriptors = outputToKeep;
        this.removeMarkerCategories(outputId);
        this.update();
    }
    onOverviewRemoved() {
        this.overviewOutputDescriptor = undefined;
        this.update();
    }
    async doHandleExperimentSelectedSignal(experiment) {
        if (this.openedExperiment && this.openedExperiment.UUID === experiment.UUID) {
            // Update the trace UUID so that the overview can be opened
            if (this.loadTraceOverview) {
                const defaultOutputDescriptor = await this.getDefaultTraceOverviewOutputDescriptor();
                this.updateOverviewOutputDescriptor(defaultOutputDescriptor);
            }
            this.shell.activateWidget(this.openedExperiment.UUID);
        }
    }
    doHandleMarkerCategoryClosedSignal(payload) {
        const traceViewerId = payload.traceViewerId;
        const markerCategory = payload.markerCategory;
        if (traceViewerId === this.id) {
            this.updateMarkerCategoryState(markerCategory);
        }
    }
    async doHandleTraceOverviewOpenedSignal() {
        if (this.openedExperiment) {
            this.loadOverviewOutputDescriptor();
            this.shell.activateWidget(this.openedExperiment.UUID);
        }
    }
    async doHandleTraceOverviewOutputSelected(payload) {
        if (this.openedExperiment && payload && payload.traceId === this.openedExperiment.UUID && payload.outputDescriptor) {
            await this.updateOverviewOutputDescriptor(payload.outputDescriptor);
            this.shell.activateWidget(this.openedExperiment.UUID);
        }
    }
    async updateOverviewOutputDescriptor(outputDescriptor) {
        if (this.openedExperiment && outputDescriptor) {
            this.loadTraceOverview = false;
            this.prevOverviewOutputDescriptor = outputDescriptor; // Save the output for reopening
            this.overviewOutputDescriptor = outputDescriptor;
            this.update();
        }
    }
    addMarkerSets(markerSets) {
        this.markerSetsMap = new Map();
        if (markerSets.length) {
            this.markerSetsMap.set({ name: 'None', id: '' }, true);
        }
        markerSets.forEach(markerSet => {
            if (!this.markerSetsMap.has(markerSet)) {
                this.markerSetsMap.set(markerSet, false);
            }
        });
        (0, signal_manager_1.signalManager)().fireMarkerSetsFetchedSignal();
    }
    addMarkerCategories(outputId, markerCategories) {
        this.removeMarkerCategories(outputId);
        const selectedMarkerCategories = [];
        markerCategories.forEach(category => {
            const categoryInfo = this.toolbarMarkerCategoriesMap.get(category);
            const categoryCount = categoryInfo ? categoryInfo.categoryCount + 1 : 1;
            const toggleInd = categoryInfo ? categoryInfo.toggleInd : true;
            this.toolbarMarkerCategoriesMap.set(category, { categoryCount, toggleInd });
            if (toggleInd) {
                selectedMarkerCategories.push(category);
            }
        });
        this.selectedMarkerCategoriesMap.set(outputId, selectedMarkerCategories);
        this.markerCategoriesMap.set(outputId, markerCategories);
        (0, signal_manager_1.signalManager)().fireMarkerCategoriesFetchedSignal();
    }
    removeMarkerCategories(outputId) {
        const categoriesToRemove = this.markerCategoriesMap.get(outputId);
        if (categoriesToRemove) {
            categoriesToRemove.forEach(category => {
                const categoryInfo = this.toolbarMarkerCategoriesMap.get(category);
                const categoryCount = categoryInfo ? categoryInfo.categoryCount - 1 : 0;
                const toggleInd = categoryInfo ? categoryInfo.toggleInd : true;
                if (categoryCount === 0) {
                    this.toolbarMarkerCategoriesMap.delete(category);
                }
                else {
                    this.toolbarMarkerCategoriesMap.set(category, { categoryCount, toggleInd });
                }
            });
        }
        this.markerCategoriesMap.delete(outputId);
        this.selectedMarkerCategoriesMap.delete(outputId);
    }
    getMarkerSets() {
        return this.markerSetsMap;
    }
    getMarkerCategories() {
        return this.toolbarMarkerCategoriesMap;
    }
    updateMarkerCategoryState(categoryName, skipUpdate) {
        const toggledmarkerCategory = this.toolbarMarkerCategoriesMap.get(categoryName);
        if (toggledmarkerCategory) {
            const categoryCount = toggledmarkerCategory === null || toggledmarkerCategory === void 0 ? void 0 : toggledmarkerCategory.categoryCount;
            const toggleInd = !!!(toggledmarkerCategory === null || toggledmarkerCategory === void 0 ? void 0 : toggledmarkerCategory.toggleInd);
            this.toolbarMarkerCategoriesMap.set(categoryName, { categoryCount, toggleInd });
            this.markerCategoriesMap.forEach((categoriesList, outputId) => {
                const selectedMarkerCategories = categoriesList.filter(category => {
                    const currCategoryInfo = this.toolbarMarkerCategoriesMap.get(category);
                    return currCategoryInfo ? currCategoryInfo.toggleInd : false;
                });
                this.selectedMarkerCategoriesMap.set(outputId, selectedMarkerCategories);
            });
        }
        if (!skipUpdate) {
            this.update();
        }
    }
    updateAllMarkerCategoryState(selectAll) {
        const markerCategories = this.getMarkerCategories();
        for (const [key, value] of markerCategories) {
            if (value.toggleInd === selectAll) {
                continue;
            }
            this.updateMarkerCategoryState(key, true);
        }
        this.update();
    }
    async updateMarkerSetState(markerSet) {
        const selectInd = this.markerSetsMap.get(markerSet);
        if (selectInd) {
            return;
        }
        this.selectedMarkerSetId = markerSet.id;
        const prevSelectedMarkerSet = Array.from(this.markerSetsMap.keys()).find(markerSetItem => this.markerSetsMap.get(markerSetItem) === true);
        if (prevSelectedMarkerSet) {
            this.markerSetsMap.set(prevSelectedMarkerSet, false);
        }
        this.markerSetsMap.set(markerSet, true);
        if (await Promise.all(this.outputDescriptors.map(output => this.fetchAnnotationCategories(output)))) {
            this.update();
        }
    }
    isTimeRelatedChartOpened() {
        const timeRelatedOutputs = this.outputDescriptors.filter(output => output.type === 'TIME_GRAPH' || output.type === 'TREE_TIME_XY');
        return timeRelatedOutputs.length > 0;
    }
    isTableRelatedChartOpened() {
        const tableRelatedOutputs = this.outputDescriptors.filter(output => output.type === 'TABLE');
        return tableRelatedOutputs.length > 0;
    }
    isTraceOverviewOpened() {
        if (this.overviewOutputDescriptor) {
            return true;
        }
        return false;
    }
    async loadOverviewOutputDescriptor() {
        let selectedOutput;
        if (this.prevOverviewOutputDescriptor) {
            selectedOutput = this.prevOverviewOutputDescriptor;
        }
        else {
            selectedOutput = await this.getDefaultTraceOverviewOutputDescriptor();
        }
        this.updateOverviewOutputDescriptor(selectedOutput);
    }
    /**
     * Get the output descriptor for the trace over view
     */
    async getDefaultTraceOverviewOutputDescriptor() {
        const availableDescriptors = await this.getAvailableTraceOverviewOutputDescriptor();
        return availableDescriptors === null || availableDescriptors === void 0 ? void 0 : availableDescriptors.find(output => output.id === TraceViewerWidget_1.DEFAULT_OVERVIEW_DATA_PROVIDER_ID);
    }
    /**
     * Get the output descriptor for the trace over view
     */
    async getAvailableTraceOverviewOutputDescriptor() {
        if (this.openedExperiment) {
            const descriptors = await this.experimentManager.getAvailableOutputs(this.openedExperiment.UUID);
            const overviewOutputDescriptors = descriptors === null || descriptors === void 0 ? void 0 : descriptors.filter(output => output.type === 'TREE_TIME_XY');
            return overviewOutputDescriptors;
        }
    }
};
TraceViewerWidget.ID = 'trace-viewer';
TraceViewerWidget.LABEL = 'Trace Viewer';
TraceViewerWidget.DEFAULT_OVERVIEW_DATA_PROVIDER_ID = 'org.eclipse.tracecompass.internal.tmf.core.histogram.HistogramDataProvider';
__decorate([
    (0, inversify_1.inject)(exports.TraceViewerWidgetOptions),
    __metadata("design:type", Object)
], TraceViewerWidget.prototype, "options", void 0);
__decorate([
    (0, inversify_1.inject)(tsp_client_provider_impl_1.TspClientProvider),
    __metadata("design:type", tsp_client_provider_impl_1.TspClientProvider)
], TraceViewerWidget.prototype, "tspClientProvider", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.StatusBar),
    __metadata("design:type", Object)
], TraceViewerWidget.prototype, "statusBar", void 0);
__decorate([
    (0, inversify_1.inject)(backend_file_service_1.BackendFileService),
    __metadata("design:type", Object)
], TraceViewerWidget.prototype, "backendFileService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.ApplicationShell),
    __metadata("design:type", browser_1.ApplicationShell)
], TraceViewerWidget.prototype, "shell", void 0);
__decorate([
    (0, inversify_1.inject)(theia_message_manager_1.TheiaMessageManager),
    __metadata("design:type", theia_message_manager_1.TheiaMessageManager)
], TraceViewerWidget.prototype, "_signalHandler", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.MessageService),
    __metadata("design:type", core_1.MessageService)
], TraceViewerWidget.prototype, "messageService", void 0);
__decorate([
    (0, inversify_1.inject)(trace_explorer_contribution_1.TraceExplorerContribution),
    __metadata("design:type", trace_explorer_contribution_1.TraceExplorerContribution)
], TraceViewerWidget.prototype, "traceExplorerContribution", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    __metadata("design:type", browser_1.WidgetManager)
], TraceViewerWidget.prototype, "widgetManager", void 0);
__decorate([
    (0, inversify_1.inject)(theming_1.ThemeService),
    __metadata("design:type", theming_1.ThemeService)
], TraceViewerWidget.prototype, "themeService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TraceViewerWidget.prototype, "init", null);
TraceViewerWidget = TraceViewerWidget_1 = __decorate([
    (0, inversify_1.injectable)()
], TraceViewerWidget);
exports.TraceViewerWidget = TraceViewerWidget;
//# sourceMappingURL=trace-viewer.js.map