"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var TraceExplorerOpenedTracesWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TraceExplorerOpenedTracesWidget = void 0;
const inversify_1 = require("inversify");
const browser_1 = require("@theia/core/lib/browser");
const React = __importStar(require("react"));
const core_1 = require("@theia/core");
const tsp_client_provider_impl_1 = require("../../tsp-client-provider-impl");
const signal_manager_1 = require("traceviewer-base/lib/signals/signal-manager");
const trace_explorer_tooltip_widget_1 = require("./trace-explorer-tooltip-widget");
const browser_2 = require("@theia/core/lib/browser");
const trace_viewer_commands_1 = require("../../trace-viewer/trace-viewer-commands");
const trace_explorer_opened_traces_widget_1 = require("traceviewer-react-components/lib/trace-explorer/trace-explorer-opened-traces-widget");
const trace_explorer_commands_1 = require("../trace-explorer-commands");
const trace_viewer_1 = require("../../trace-viewer/trace-viewer");
let TraceExplorerOpenedTracesWidget = TraceExplorerOpenedTracesWidget_1 = class TraceExplorerOpenedTracesWidget extends browser_1.ReactWidget {
    async init() {
        this.id = TraceExplorerOpenedTracesWidget_1.ID;
        this.title.label = TraceExplorerOpenedTracesWidget_1.LABEL;
        this._experimentManager = this.tspClientProvider.getExperimentManager();
        this.tspClientProvider.addTspClientChangeListener(() => {
            this._experimentManager = this.tspClientProvider.getExperimentManager();
        });
        this.update();
    }
    doHandleContextMenuEvent(event, experiment) {
        this.contextMenuRenderer.render({
            menuPath: trace_explorer_commands_1.TraceExplorerMenus.PREFERENCE_EDITOR_CONTEXT_MENU,
            anchor: { x: event.clientX, y: event.clientY },
            args: [experiment.UUID]
        });
    }
    doHandleClickEvent(event, experiment) {
        this.openExperiment(experiment.UUID);
    }
    openExperiment(traceUUID) {
        const widgets = this.widgetManager.getWidgets(trace_viewer_1.TraceViewerWidget.ID);
        const widget = widgets.find(w => w.id === traceUUID);
        // Don't execute command if widget is already open.
        if (!widget) {
            this.commandService.executeCommand(trace_viewer_commands_1.TraceViewerCommand.id, { traceUUID });
        }
    }
    closeExperiment(traceUUID) {
        (0, signal_manager_1.signalManager)().fireCloseTraceViewerTabSignal(traceUUID);
    }
    deleteExperiment(traceUUID) {
        this._experimentManager.deleteExperiment(traceUUID);
        this.closeExperiment(traceUUID);
    }
    render() {
        return React.createElement("div", null,
            React.createElement(trace_explorer_opened_traces_widget_1.ReactOpenTracesWidget, { id: this.id, title: this.title.label, tspClientProvider: this.tspClientProvider, contextMenuRenderer: (event, experiment) => this.doHandleContextMenuEvent(event, experiment), onClick: (event, experiment) => this.doHandleClickEvent(event, experiment) }));
    }
    onResize(msg) {
        super.onResize(msg);
        this.update();
    }
};
TraceExplorerOpenedTracesWidget.ID = 'trace-explorer-opened-traces-widget';
TraceExplorerOpenedTracesWidget.LABEL = 'Opened Traces';
TraceExplorerOpenedTracesWidget.LIST_MARGIN = 2;
TraceExplorerOpenedTracesWidget.LINE_HEIGHT = 16;
__decorate([
    (0, inversify_1.inject)(tsp_client_provider_impl_1.TspClientProvider),
    __metadata("design:type", tsp_client_provider_impl_1.TspClientProvider)
], TraceExplorerOpenedTracesWidget.prototype, "tspClientProvider", void 0);
__decorate([
    (0, inversify_1.inject)(trace_explorer_tooltip_widget_1.TraceExplorerTooltipWidget),
    __metadata("design:type", trace_explorer_tooltip_widget_1.TraceExplorerTooltipWidget)
], TraceExplorerOpenedTracesWidget.prototype, "tooltipWidget", void 0);
__decorate([
    (0, inversify_1.inject)(browser_2.ContextMenuRenderer),
    __metadata("design:type", browser_2.ContextMenuRenderer)
], TraceExplorerOpenedTracesWidget.prototype, "contextMenuRenderer", void 0);
__decorate([
    (0, inversify_1.inject)(core_1.CommandService),
    __metadata("design:type", Object)
], TraceExplorerOpenedTracesWidget.prototype, "commandService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.WidgetManager),
    __metadata("design:type", browser_1.WidgetManager)
], TraceExplorerOpenedTracesWidget.prototype, "widgetManager", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TraceExplorerOpenedTracesWidget.prototype, "init", null);
TraceExplorerOpenedTracesWidget = TraceExplorerOpenedTracesWidget_1 = __decorate([
    (0, inversify_1.injectable)()
], TraceExplorerOpenedTracesWidget);
exports.TraceExplorerOpenedTracesWidget = TraceExplorerOpenedTracesWidget;
//# sourceMappingURL=theia-trace-explorer-opened-traces-widget.js.map