/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.environments;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.internal.launching.environments.AccessRuleParticipant;
import org.eclipse.jdt.internal.launching.environments.EnvironmentMessages;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.environments.IAccessRuleParticipant;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

class ExecutionEnvironment
implements IExecutionEnvironment {
    private IVMInstallChangedListener fListener = new IVMInstallChangedListener(){

        @Override
        public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        }

        @Override
        public void vmAdded(IVMInstall newVm) {
        }

        @Override
        public void vmChanged(PropertyChangeEvent event) {
            if (event.getSource() != null) {
                ExecutionEnvironment.this.fParticipantMap.remove(event.getSource());
                ExecutionEnvironment.this.fRuleCache.remove(event.getSource());
            }
        }

        @Override
        public void vmRemoved(IVMInstall removedVm) {
            ExecutionEnvironment.this.fParticipantMap.remove(removedVm);
            ExecutionEnvironment.this.fRuleCache.remove(removedVm);
        }
    };
    private IConfigurationElement fElement;
    private IAccessRuleParticipant fRuleParticipant;
    private Properties fProfileProperties;
    private boolean fPropertiesInitialized;
    private Set<IVMInstall> fStrictlyCompatible = new HashSet<IVMInstall>();
    private List<IVMInstall> fCompatibleVMs = new ArrayList<IVMInstall>();
    private IVMInstall fDefault = null;
    private IAccessRuleParticipant[] fParticipants = null;
    private Map<IVMInstall, Map<IAccessRuleParticipant, IAccessRule[][]>> fParticipantMap = new HashMap<IVMInstall, Map<IAccessRuleParticipant, IAccessRule[][]>>();
    private Map<IVMInstall, IAccessRule[][]> fRuleCache = new HashMap<IVMInstall, IAccessRule[][]>();
    private static final IPath ALL_PATTERN = new Path("**/*");
    private static final String COMPILER_SETTING_PREFIX = "org.eclipse.jdt.core.compiler";
    private static final String JAVASE = "JavaSE";

    ExecutionEnvironment(IConfigurationElement element) {
        this.fElement = element;
        this.fPropertiesInitialized = false;
        String attribute = this.fElement.getAttribute("ruleParticipant");
        if (attribute != null) {
            this.fRuleParticipant = new AccessRuleParticipant(this.fElement);
        }
        JavaRuntime.addVMInstallChangedListener(this.fListener);
    }

    private void init() {
        EnvironmentsManager.getDefault().initializeCompatibilities();
    }

    @Override
    public String getId() {
        return this.fElement.getAttribute("id");
    }

    @Override
    public String getDescription() {
        return this.fElement.getAttribute("description");
    }

    @Override
    public IVMInstall[] getCompatibleVMs() {
        this.init();
        return this.fCompatibleVMs.toArray(new IVMInstall[this.fCompatibleVMs.size()]);
    }

    @Override
    public boolean isStrictlyCompatible(IVMInstall vm) {
        this.init();
        return this.fStrictlyCompatible.contains(vm);
    }

    @Override
    public IVMInstall getDefaultVM() {
        this.init();
        return this.fDefault;
    }

    @Override
    public void setDefaultVM(IVMInstall vm) {
        this.init();
        if (vm != null && !this.fCompatibleVMs.contains(vm)) {
            throw new IllegalArgumentException(NLS.bind((String)EnvironmentMessages.EnvironmentsManager_0, (Object[])new String[]{this.getId()}));
        }
        if (vm != null && vm.equals(this.fDefault)) {
            return;
        }
        this.fDefault = vm;
        EnvironmentsManager.getDefault().updateDefaultVMs();
        this.rebindClasspathContainers();
    }

    private void rebindClasspathContainers() {
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        if (model != null) {
            try {
                ArrayList<IJavaProject> updates = new ArrayList<IJavaProject>();
                IJavaProject[] javaProjects = model.getJavaProjects();
                IPath path = JavaRuntime.newJREContainerPath(this);
                int i = 0;
                while (i < javaProjects.length) {
                    IJavaProject project = javaProjects[i];
                    IClasspathEntry[] rawClasspath = project.getRawClasspath();
                    int j = 0;
                    while (j < rawClasspath.length) {
                        IClasspathEntry entry = rawClasspath[j];
                        if (entry.getEntryKind() == 5 && entry.getPath().equals((Object)path)) {
                            updates.add(project);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (!updates.isEmpty()) {
                    JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])updates.toArray(new IJavaProject[updates.size()]), (IClasspathContainer[])new IClasspathContainer[updates.size()], (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (JavaModelException e) {
                LaunchingPlugin.log(e);
            }
        }
    }

    void add(IVMInstall vm, boolean strictlyCompatible) {
        if (this.fCompatibleVMs.contains(vm)) {
            return;
        }
        this.fCompatibleVMs.add(vm);
        if (strictlyCompatible) {
            this.fStrictlyCompatible.add(vm);
        }
    }

    void remove(IVMInstall vm) {
        this.fCompatibleVMs.remove(vm);
        this.fStrictlyCompatible.remove(vm);
    }

    void initDefaultVM(IVMInstall vm) {
        this.fDefault = vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAccessRule[][] getAccessRules(IVMInstall vm, LibraryLocation[] libraries, IJavaProject project) {
        IAccessRuleParticipant[] participants = this.getParticipants();
        Map<IAccessRuleParticipant, IAccessRule[][]> rulesByParticipant = this.collectRulesByParticipant(participants, vm, libraries, project);
        ExecutionEnvironment executionEnvironment = this;
        synchronized (executionEnvironment) {
            Map<IAccessRuleParticipant, IAccessRule[][]> cachedRules = this.fParticipantMap.get(vm);
            if (cachedRules == null || !cachedRules.equals(rulesByParticipant)) {
                ArrayList<List<IAccessRule>> libLists = new ArrayList<List<IAccessRule>>();
                int i = 0;
                while (i < libraries.length) {
                    libLists.add(new ArrayList());
                    ++i;
                }
                i = 0;
                while (i < participants.length) {
                    IAccessRuleParticipant participant = participants[i];
                    this.addRules(rulesByParticipant.get(participant), libLists);
                    ++i;
                }
                IAccessRule[][] allRules = new IAccessRule[libraries.length][];
                int i2 = 0;
                while (i2 < libLists.size()) {
                    List<IAccessRule> l = libLists.get(i2);
                    allRules[i2] = l.toArray(new IAccessRule[l.size()]);
                    ++i2;
                }
                this.fParticipantMap.put(vm, rulesByParticipant);
                this.fRuleCache.put(vm, allRules);
                return allRules;
            }
            return this.fRuleCache.get(vm);
        }
    }

    private synchronized IAccessRuleParticipant[] getParticipants() {
        if (this.fParticipants == null) {
            IAccessRuleParticipant[] participants = EnvironmentsManager.getDefault().getAccessRuleParticipants();
            if (this.fRuleParticipant != null) {
                LinkedHashSet<IAccessRuleParticipant> set = new LinkedHashSet<IAccessRuleParticipant>();
                int i = 0;
                while (i < participants.length) {
                    set.add(participants[i]);
                    ++i;
                }
                set.remove(this.fRuleParticipant);
                set.add(this.fRuleParticipant);
                participants = set.toArray(new IAccessRuleParticipant[set.size()]);
            }
            this.fParticipants = participants;
        }
        return this.fParticipants;
    }

    private Map<IAccessRuleParticipant, IAccessRule[][]> collectRulesByParticipant(IAccessRuleParticipant[] participants, IVMInstall vm, LibraryLocation[] libraries, IJavaProject project) {
        HashMap<IAccessRuleParticipant, IAccessRule[][]> map = new HashMap<IAccessRuleParticipant, IAccessRule[][]>();
        int i = 0;
        while (i < participants.length) {
            map.put(participants[i], participants[i].getAccessRules(this, vm, libraries, project));
            ++i;
        }
        return map;
    }

    private void addRules(IAccessRule[][] accessRules, ArrayList<List<IAccessRule>> collect) {
        int i = 0;
        while (i < accessRules.length) {
            IAccessRule lastRule;
            IAccessRule[] libRules = accessRules[i];
            List<IAccessRule> list = collect.get(i);
            if (list.isEmpty() || !(lastRule = list.get(list.size() - 1)).getPattern().equals((Object)ALL_PATTERN)) {
                int j = 0;
                while (j < libRules.length) {
                    list.add(libRules[j]);
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public Properties getProfileProperties() {
        if (!this.fPropertiesInitialized) {
            this.fPropertiesInitialized = true;
            Object path = this.fElement.getAttribute("profileProperties");
            Bundle bundle = null;
            if (path == null) {
                bundle = Platform.getBundle((String)"org.eclipse.osgi");
                path = this.getId().replace('/', '_') + ".profile";
            } else {
                bundle = Platform.getBundle((String)this.fElement.getContributor().getName());
            }
            if (bundle != null && path != null) {
                this.fProfileProperties = this.getJavaProfileProperties(bundle, (String)path);
            }
        }
        return this.fProfileProperties;
    }

    private Properties getJavaProfileProperties(Bundle bundle, String path) {
        String property;
        Properties profile;
        block16: {
            profile = new Properties();
            URL profileURL = bundle.getEntry(path);
            if (profileURL != null) {
                try {
                    Throwable throwable = null;
                    Object var6_7 = null;
                    try (InputStream is = profileURL.openStream();){
                        profileURL = FileLocator.resolve((URL)profileURL);
                        if (is != null) {
                            profile.load(is);
                            this.fixJavaSE9ComplianceSourceTargetLevels(profile);
                        }
                        break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            String compliance = this.getCompliance();
            if (compliance == null) {
                return null;
            }
            profile.setProperty("org.eclipse.jdt.core.compiler.compliance", compliance);
            profile.setProperty("org.eclipse.jdt.core.compiler.source", compliance);
            profile.setProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", compliance);
            profile.setProperty("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            profile.setProperty("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
            profile.setProperty("org.osgi.framework.executionenvironment", this.calculateVMExecutionEnvs(new Version(compliance)));
            profile.setProperty("org.eclipse.jdt.core.compiler.release", "enabled");
            if (JavaCore.compareJavaVersions((String)compliance, (String)"10") > 0) {
                profile.setProperty("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "disabled");
                profile.setProperty("org.eclipse.jdt.core.compiler.problem.reportPreviewFeatures", "warning");
            }
        }
        if ((property = profile.getProperty("org.eclipse.jdt.core.compiler.compliance")) != null && JavaCore.compareJavaVersions((String)property, (String)"9") < 0) {
            profile.setProperty("org.eclipse.jdt.core.compiler.release", "disabled");
        }
        return profile;
    }

    private String calculateVMExecutionEnvs(Version javaVersion) {
        StringBuilder result = new StringBuilder("OSGi/Minimum-1.0, OSGi/Minimum-1.1, OSGi/Minimum-1.2, JavaSE/compact1-1.8, JavaSE/compact2-1.8, JavaSE/compact3-1.8, JRE-1.1, J2SE-1.2, J2SE-1.3, J2SE-1.4, J2SE-1.5, JavaSE-1.6, JavaSE-1.7, JavaSE-1.8");
        Version v = new Version(9, 0, 0);
        while (v.compareTo(javaVersion) <= 0) {
            result.append(',').append(' ').append(JAVASE).append('-').append(v.getMajor());
            if (v.getMinor() > 0) {
                result.append('.').append(v.getMinor());
            }
            v = v.getMajor() == javaVersion.getMajor() ? new Version(v.getMajor(), v.getMinor() + 1, 0) : new Version(v.getMajor() + 1, 0, 0);
        }
        return result.toString();
    }

    private void fixJavaSE9ComplianceSourceTargetLevels(Properties profile) {
        if ("JavaSE-9".equals(this.getId())) {
            profile.setProperty("org.eclipse.jdt.core.compiler.compliance", "9");
            profile.setProperty("org.eclipse.jdt.core.compiler.source", "9");
            profile.setProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "9");
            profile.setProperty("org.eclipse.jdt.core.compiler.release", "enabled");
        }
    }

    @Override
    public IExecutionEnvironment[] getSubEnvironments() {
        String subsets;
        Properties properties = this.getProfileProperties();
        LinkedHashSet<IExecutionEnvironment> subenv = new LinkedHashSet<IExecutionEnvironment>();
        if (properties != null && (subsets = properties.getProperty("org.osgi.framework.executionenvironment")) != null) {
            String[] ids = subsets.split(",");
            int i = 0;
            while (i < ids.length) {
                IExecutionEnvironment sub = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(ids[i].trim());
                if (sub != null && !sub.getId().equals(this.getId())) {
                    subenv.add(sub);
                }
                ++i;
            }
        }
        return subenv.toArray(new IExecutionEnvironment[subenv.size()]);
    }

    @Override
    public Map<String, String> getComplianceOptions() {
        Properties properties = this.getProfileProperties();
        if (properties != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (String string : properties.keySet()) {
                if (!string.startsWith(COMPILER_SETTING_PREFIX)) continue;
                map.put(string, properties.getProperty(string));
            }
            if (!map.isEmpty()) {
                return map;
            }
        }
        return null;
    }

    private String getCompliance() {
        return this.fElement.getAttribute("compliance");
    }

    public String toString() {
        return this.fElement.getAttribute("id");
    }
}

