/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.managers.IMavenArtifactIdentifier;
import org.eclipse.jdt.ls.internal.gradle.checksums.HashProvider;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.osgi.util.NLS;

public class MavenCentralIdentifier
implements IMavenArtifactIdentifier {
    private static final String SHA1_SEARCH_QUERY = "https://search.maven.org/solrsearch/select?q=1:%22{0}%22&rows=1&wt=json";
    private HashProvider hashProvider = new HashProvider("SHA-1");

    @Override
    public ArtifactKey identify(IPath path, IProgressMonitor monitor) {
        if (path == null) {
            return null;
        }
        return this.identify(path.toFile(), monitor);
    }

    private ArtifactKey identify(File file, IProgressMonitor monitor) {
        if (file == null || !file.isFile() || !file.canRead()) {
            return null;
        }
        String sha1 = null;
        try {
            sha1 = this.hashProvider.getChecksum(file);
        }
        catch (IOException e) {
            JavaLanguageServerPlugin.logError("Failed to compute SHA1 checksum for " + file + " : " + e.getMessage());
            return null;
        }
        return this.identifySha1(sha1, monitor);
    }

    private ArtifactKey identifySha1(String sha1, IProgressMonitor monitor) {
        if (sha1 == null || sha1.isBlank()) {
            return null;
        }
        String searchUrl = NLS.bind((String)SHA1_SEARCH_QUERY, (Object)sha1);
        try {
            return this.find(searchUrl, monitor);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logError("Failed to identify " + sha1 + " with Maven Central : " + e.getMessage());
            return null;
        }
    }

    private ArtifactKey find(String searchUrl, IProgressMonitor monitor) {
        HttpRequest httpRequest;
        HttpClient client;
        block7: {
            long seconds;
            String timeoutStr = System.getProperty("java.lsp.mavensearch.timeout", "10");
            try {
                seconds = Long.parseLong(timeoutStr);
            }
            catch (NumberFormatException e) {
                seconds = 10L;
            }
            seconds = seconds <= 0L ? 10L : seconds;
            Duration timeout = Duration.ofSeconds(seconds);
            client = HttpClient.newBuilder().connectTimeout(timeout).proxy(ProxySelector.getDefault()).version(HttpClient.Version.HTTP_2).build();
            httpRequest = HttpRequest.newBuilder().timeout(timeout).uri(URI.create(searchUrl)).GET().build();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (!monitor.isCanceled()) break block7;
            JavaLanguageServerPlugin.logInfo("Maven Central search cancelled");
            return null;
        }
        try {
            HttpResponse<String> response = client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            JsonElement jsonElement = JsonParser.parseString((String)response.body());
            if (jsonElement != null && jsonElement.isJsonObject()) {
                return this.extractKey(jsonElement.getAsJsonObject());
            }
        }
        catch (JsonSyntaxException | IOException | InterruptedException e) {
            JavaLanguageServerPlugin.logException(e);
        }
        return null;
    }

    private ArtifactKey extractKey(JsonObject modelNode) {
        int num;
        JsonObject response = modelNode.getAsJsonObject("response");
        if (response != null && (num = response.get("numFound").getAsInt()) > 0) {
            JsonArray docs = response.getAsJsonArray("docs");
            String a = null;
            String g = null;
            String v = null;
            for (JsonElement d : docs) {
                JsonObject o = d.getAsJsonObject();
                a = o.get("a").getAsString();
                g = o.get("g").getAsString();
                v = o.get("v").getAsString();
                if (a == null || g == null || v == null) continue;
                return new ArtifactKey(g, a, v, null);
            }
        }
        return null;
    }
}

