/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.ConfigurationItem;
import org.eclipse.lsp4j.ConfigurationParams;

public class ConfigurationHandler {
    private ConfigurationHandler() {
    }

    public static Map<String, Object> getFormattingOptions(String uri) {
        if (!JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isWorkspaceConfigurationSupported()) {
            return null;
        }
        ArrayList<ConfigurationItem> configurationItems = new ArrayList<ConfigurationItem>();
        String[] settingKeys = new String[]{"java.format.tabSize", "java.format.insertSpaces"};
        ConfigurationItem tabSizeItem = new ConfigurationItem();
        tabSizeItem.setScopeUri(uri);
        tabSizeItem.setSection(settingKeys[0]);
        configurationItems.add(tabSizeItem);
        ConfigurationItem insertSpacesItem = new ConfigurationItem();
        insertSpacesItem.setScopeUri(uri);
        insertSpacesItem.setSection(settingKeys[1]);
        configurationItems.add(insertSpacesItem);
        ConfigurationParams configurationParams = new ConfigurationParams(configurationItems);
        List<Object> response = JavaLanguageServerPlugin.getInstance().getClientConnection().configuration(configurationParams);
        HashMap<String, Object> results = new HashMap<String, Object>();
        int minLength = Math.min(settingKeys.length, response.size());
        int i = 0;
        while (i < minLength) {
            results.put(settingKeys[i], response.get(i));
            ++i;
        }
        return results;
    }
}

