/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.ASTRewriteCorrectionProposal;

public class CastCorrectionProposal
extends ASTRewriteCorrectionProposal {
    public static final String ADD_CAST_ID = "org.eclipse.jdt.ui.correction.addCast";
    private final Expression fNodeToCast;
    private final ITypeBinding fCastType;

    public CastCorrectionProposal(String label, ICompilationUnit targetCU, Expression nodeToCast, ITypeBinding castType, int relevance) {
        super(label, "quickfix", targetCU, (ASTRewrite)null, relevance);
        this.fNodeToCast = nodeToCast;
        this.fCastType = castType;
    }

    /*
     * WARNING - void declaration
     */
    private Type getNewCastTypeNode(ASTRewrite rewrite, ImportRewrite importRewrite) {
        AST ast = rewrite.getAST();
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((CompilationUnit)this.fNodeToCast.getRoot(), this.fNodeToCast.getStartPosition(), importRewrite);
        if (this.fCastType != null) {
            return importRewrite.addImport(this.fCastType, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.CAST);
        }
        Expression node = this.fNodeToCast;
        ASTNode parent = node.getParent();
        if (parent instanceof CastExpression) {
            node = parent;
            parent = parent.getParent();
        }
        while (parent instanceof ParenthesizedExpression) {
            node = parent;
            parent = parent.getParent();
        }
        ASTNode aSTNode = parent;
        if (aSTNode instanceof MethodInvocation) {
            void invocation;
            MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            if (invocation.getExpression() == node) {
                IBinding targetContext = ASTResolving.getParentMethodOrTypeBinding((ASTNode)node);
                ITypeBinding[] bindings = ASTResolving.getQualifierGuess((ASTNode)node.getRoot(), (String)invocation.getName().getIdentifier(), (List)invocation.arguments(), (IBinding)targetContext);
                if (bindings.length > 0) {
                    ITypeBinding first = this.getCastFavorite(bindings, this.fNodeToCast.resolveTypeBinding());
                    Type newTypeNode = importRewrite.addImport(first, ast, (ImportRewrite.ImportRewriteContext)context, ImportRewrite.TypeLocation.CAST);
                    return newTypeNode;
                }
            }
        }
        SimpleType newCastType = ast.newSimpleType((Name)ast.newSimpleName("Object"));
        return newCastType;
    }

    private ITypeBinding getCastFavorite(ITypeBinding[] suggestedCasts, ITypeBinding nodeToCastBinding) {
        if (nodeToCastBinding == null) {
            return suggestedCasts[0];
        }
        ITypeBinding favourite = suggestedCasts[0];
        int i = 0;
        while (i < suggestedCasts.length) {
            ITypeBinding curr = suggestedCasts[i];
            if (nodeToCastBinding.isCastCompatible(curr)) {
                return curr;
            }
            if (curr.isInterface()) {
                favourite = curr;
            }
            ++i;
        }
        return favourite;
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        AST ast = this.fNodeToCast.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ImportRewrite importRewrite = this.createImportRewrite((CompilationUnit)this.fNodeToCast.getRoot());
        Type newTypeNode = this.getNewCastTypeNode(rewrite, importRewrite);
        if (this.fNodeToCast.getNodeType() == 11) {
            CastExpression expression = (CastExpression)this.fNodeToCast;
            rewrite.replace((ASTNode)expression.getType(), (ASTNode)newTypeNode, null);
        } else {
            Expression expressionCopy = (Expression)rewrite.createCopyTarget((ASTNode)this.fNodeToCast);
            if (CastCorrectionProposal.needsInnerParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression(expressionCopy);
                expressionCopy = parenthesizedExpression;
            }
            CastExpression castExpression = ast.newCastExpression();
            castExpression.setExpression(expressionCopy);
            castExpression.setType(newTypeNode);
            CastExpression replacingNode = castExpression;
            if (CastCorrectionProposal.needsOuterParantheses((ASTNode)this.fNodeToCast)) {
                ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
                parenthesizedExpression.setExpression((Expression)castExpression);
                replacingNode = parenthesizedExpression;
            }
            rewrite.replace((ASTNode)this.fNodeToCast, (ASTNode)replacingNode, null);
        }
        return rewrite;
    }

    private static boolean needsInnerParantheses(ASTNode nodeToCast) {
        int nodeType = nodeToCast.getNodeType();
        return nodeType == 27 || nodeType == 16 || nodeType == 7 || nodeType == 62;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean needsOuterParantheses(ASTNode nodeToCast) {
        ASTNode parent = nodeToCast.getParent();
        ASTNode aSTNode = parent;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            if (methodInvocation.getExpression() == nodeToCast) {
                return true;
            }
        } else {
            ASTNode aSTNode2 = parent;
            if (aSTNode2 instanceof QualifiedName) {
                void name;
                QualifiedName qualifiedName = (QualifiedName)aSTNode2;
                QualifiedName cfr_ignored_1 = (QualifiedName)aSTNode2;
                if (name.getQualifier() == nodeToCast) {
                    return true;
                }
            } else {
                ASTNode aSTNode3 = parent;
                if (aSTNode3 instanceof FieldAccess) {
                    void fieldAccess;
                    FieldAccess fieldAccess2 = (FieldAccess)aSTNode3;
                    FieldAccess cfr_ignored_2 = (FieldAccess)aSTNode3;
                    if (fieldAccess.getExpression() == nodeToCast) {
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

