/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.changes;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.changes.CompilationUnitReorgChange;
import org.eclipse.ltk.core.refactoring.Change;

public class MoveCompilationUnitChange
extends CompilationUnitReorgChange {
    private boolean fUndoable;
    private long fStampToRestore;
    private final IPackageFragment[] fDeletePackages;

    public MoveCompilationUnitChange(ICompilationUnit cu, IPackageFragment newPackage) {
        super(cu, newPackage);
        this.fStampToRestore = -1L;
        this.fDeletePackages = null;
        this.setValidationMethod(5);
    }

    private MoveCompilationUnitChange(IPackageFragment oldPackage, String cuName, IPackageFragment newPackage, long stampToRestore, IPackageFragment[] deletePackages) {
        super(oldPackage.getHandleIdentifier(), newPackage.getHandleIdentifier(), oldPackage.getCompilationUnit(cuName).getHandleIdentifier());
        this.fStampToRestore = stampToRestore;
        this.fDeletePackages = deletePackages;
        this.setValidationMethod(5);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.MoveCompilationUnitChange_name, new String[]{BasicElementLabels.getFileName((ITypeRoot)this.getCu()), MoveCompilationUnitChange.getPackageName(this.getDestinationPackage())});
    }

    @Override
    Change doPerformReorg(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ICompilationUnit moved;
        IResource movedResource;
        IPackageFragment destination;
        String newName = this.getNewName();
        String name = newName == null ? this.getCu().getElementName() : newName;
        long currentStamp = -1L;
        IResource resource = this.getCu().getResource();
        if (resource != null) {
            currentStamp = resource.getModificationStamp();
        }
        this.fUndoable = !(destination = this.getDestinationPackage()).exists() || !destination.getCompilationUnit(name).exists();
        IPackageFragment[] createdPackages = null;
        if (!destination.exists()) {
            IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)destination.getParent();
            createdPackages = this.createDestination(packageFragmentRoot, destination, pm);
        }
        this.getCu().move((IJavaElement)destination, null, newName, true, pm);
        if (this.fStampToRestore != -1L && (movedResource = (moved = destination.getCompilationUnit(name)).getResource()) != null) {
            movedResource.revertModificationStamp(this.fStampToRestore);
        }
        if (this.fDeletePackages != null) {
            int i = this.fDeletePackages.length - 1;
            while (i >= 0) {
                this.fDeletePackages[i].delete(true, pm);
                --i;
            }
        }
        if (this.fUndoable) {
            return new MoveCompilationUnitChange(destination, this.getCu().getElementName(), this.getOldPackage(), currentStamp, createdPackages);
        }
        return null;
    }

    private IPackageFragment[] createDestination(IPackageFragmentRoot root, IPackageFragment destination, IProgressMonitor pm) throws JavaModelException {
        String packageName = destination.getElementName();
        String[] split = packageName.split("\\.");
        ArrayList<IPackageFragment> created = new ArrayList<IPackageFragment>();
        StringBuilder name = new StringBuilder();
        name.append(split[0]);
        int i = 0;
        while (i < split.length) {
            IPackageFragment fragment = root.getPackageFragment(name.toString());
            if (!fragment.exists()) {
                created.add(fragment);
            }
            if (fragment.equals(destination)) {
                root.createPackageFragment(name.toString(), true, pm);
                return created.toArray(new IPackageFragment[created.size()]);
            }
            name.append(".");
            name.append(split[i + 1]);
            ++i;
        }
        return null;
    }
}

