/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.text.correction;

import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.util.CompilationUnitSorter;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.fix.VariableDeclarationFixCore;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jdt.ls.core.internal.ChangeUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.TextEditConverter;
import org.eclipse.jdt.ls.core.internal.codemanipulation.DefaultJavaElementComparator;
import org.eclipse.jdt.ls.core.internal.codemanipulation.GenerateGetterSetterOperation;
import org.eclipse.jdt.ls.core.internal.codemanipulation.PartialSortMembersOperation;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.corrections.IInvocationContext;
import org.eclipse.jdt.ls.core.internal.corrections.InnovationContext;
import org.eclipse.jdt.ls.core.internal.corrections.proposals.FixCorrectionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionProposal;
import org.eclipse.jdt.ls.core.internal.handlers.CodeGenerationUtils;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateAccessorsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateConstructorsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateDelegateMethodsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.GenerateToStringHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JdtDomModels;
import org.eclipse.jdt.ls.core.internal.handlers.OrganizeImportsHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.ActionMessages;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionComparator;
import org.eclipse.jdt.ls.core.internal.text.correction.CodeActionUtility;
import org.eclipse.jdt.ls.core.internal.text.correction.QuickAssistProcessor;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class SourceAssistProcessor {
    private static final Set<String> UNSUPPORTED_RESOURCES = Sets.newHashSet((Object[])new String[]{"module-info.java", "package-info.java"});
    public static final String COMMAND_ID_ACTION_OVERRIDEMETHODSPROMPT = "java.action.overrideMethodsPrompt";
    public static final String COMMAND_ID_ACTION_HASHCODEEQUALSPROMPT = "java.action.hashCodeEqualsPrompt";
    public static final String COMMAND_ID_ACTION_ORGANIZEIMPORTS = "java.action.organizeImports";
    public static final String COMMAND_ID_ACTION_GENERATETOSTRINGPROMPT = "java.action.generateToStringPrompt";
    public static final String COMMAND_ID_ACTION_GENERATEACCESSORSPROMPT = "java.action.generateAccessorsPrompt";
    public static final String COMMAND_ID_ACTION_GENERATECONSTRUCTORSPROMPT = "java.action.generateConstructorsPrompt";
    public static final String COMMAND_ID_ACTION_GENERATEDELEGATEMETHODSPROMPT = "java.action.generateDelegateMethodsPrompt";
    private PreferenceManager preferenceManager;

    public SourceAssistProcessor(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<Either<Command, CodeAction>> getSourceActionCommands(CodeActionParams params, IInvocationContext context, IProblemLocationCore[] locations, IProgressMonitor monitor) {
        boolean hashCodeAndEqualsExists;
        Optional<Either<Command, CodeAction>> sourceOrganizeImports;
        boolean isInImportDeclaration;
        ASTNode coveringNode;
        ArrayList<Either<Command, CodeAction>> $ = new ArrayList<Either<Command, CodeAction>>();
        ICompilationUnit cu = context.getCompilationUnit();
        IType type = SourceAssistProcessor.getSelectionType(context);
        ArrayList<ASTNode> coveredNodes = QuickAssistProcessor.getFullyCoveredNodes(context, context.getCoveringNode());
        boolean isInFieldDeclaration = CodeActionUtility.findASTNode(coveredNodes, coveringNode = context.getCoveringNode(), FieldDeclaration.class) != null;
        ASTNode typeDeclaration = CodeActionUtility.findASTNode(coveredNodes, coveringNode, TypeDeclaration.class);
        boolean isInTypeDeclaration = typeDeclaration != null;
        boolean bl = isInImportDeclaration = CodeActionUtility.findASTNode(coveredNodes, coveringNode, ImportDeclaration.class) != null;
        if (isInFieldDeclaration || isInTypeDeclaration) {
            Optional<Either<Command, CodeAction>> quickAssistGenerateConstructors = this.getGenerateConstructorsAction(params, context, type, "quickassist", monitor);
            this.addSourceActionCommand($, params.getContext(), quickAssistGenerateConstructors);
        }
        Optional<Either<Command, CodeAction>> sourceGenerateConstructors = this.getGenerateConstructorsAction(params, context, type, "source.generate.constructors", monitor);
        this.addSourceActionCommand($, params.getContext(), sourceGenerateConstructors);
        CodeActionProposal organizeImportsProposal = pm -> {
            TextEdit edit = this.getOrganizeImportsTextEdit(context, false, this.preferenceManager.getClientPreferences().isAdvancedOrganizeImportsSupported(), pm);
            return SourceAssistProcessor.convertToWorkspaceEdit(cu, edit);
        };
        if (isInImportDeclaration) {
            sourceOrganizeImports = this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description, "quickassist", organizeImportsProposal, CodeActionComparator.ORGANIZE_IMPORTS_PRIORITY);
            this.addSourceActionCommand($, params.getContext(), sourceOrganizeImports);
        }
        sourceOrganizeImports = this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), CorrectionMessages.ReorgCorrectionsSubProcessor_organizeimports_description, "source.organizeImports", organizeImportsProposal, CodeActionComparator.ORGANIZE_IMPORTS_PRIORITY);
        this.addSourceActionCommand($, params.getContext(), sourceOrganizeImports);
        boolean hasUndefinedTypeError = false;
        IProblem[] iProblemArray = context.getASTRoot().getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.getID() == 0x1000002 || problem.getID() == -1610612233) {
                hasUndefinedTypeError = true;
                break;
            }
            ++n2;
        }
        if (hasUndefinedTypeError) {
            CodeActionProposal allAllMissingImportsProposal = pm -> {
                TextEdit edit = this.getOrganizeImportsTextEdit(context, true, this.preferenceManager.getClientPreferences().isAdvancedOrganizeImportsSupported(), pm);
                return SourceAssistProcessor.convertToWorkspaceEdit(cu, edit);
            };
            Optional<Either<Command, CodeAction>> sourceAddAllMissingImports = this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), CorrectionMessages.UnresolvedElementsSubProcessor_add_allMissing_imports_description, "source", allAllMissingImportsProposal, CodeActionComparator.ADD_ALL_MISSING_IMPORTS_PRIORITY);
            this.addSourceActionCommand($, params.getContext(), sourceAddAllMissingImports);
        }
        if (!UNSUPPORTED_RESOURCES.contains(cu.getResource().getName())) {
            if (isInTypeDeclaration) {
                Optional<Either<Command, CodeAction>> quickAssistOverrideMethods = this.getOverrideMethodsAction(params, "quickassist");
                this.addSourceActionCommand($, params.getContext(), quickAssistOverrideMethods);
            }
            Optional<Either<Command, CodeAction>> sourceOverrideMethods = this.getOverrideMethodsAction(params, "source.overrideMethods");
            this.addSourceActionCommand($, params.getContext(), sourceOverrideMethods);
        }
        List<String> fieldNames = CodeActionUtility.getFieldNames(coveredNodes, coveringNode);
        try {
            this.addGenerateAccessorsSourceActionCommand(params, context, $, type, fieldNames, isInTypeDeclaration);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Failed to generate Getter and Setter source action", e);
        }
        boolean bl2 = hashCodeAndEqualsExists = CodeActionUtility.hasMethod(type, "hashCode", new Class[0]) && CodeActionUtility.hasMethod(type, "equals", Object.class);
        if (this.supportsHashCodeEquals(context, type, monitor)) {
            if (isInTypeDeclaration && !hashCodeAndEqualsExists) {
                Optional<Either<Command, CodeAction>> quickAssistHashCodeEquals = this.getHashCodeEqualsAction(params, "quickassist");
                this.addSourceActionCommand($, params.getContext(), quickAssistHashCodeEquals);
            }
            Optional<Either<Command, CodeAction>> sourceActionHashCodeEquals = this.getHashCodeEqualsAction(params, "source.generate.hashCodeEquals");
            this.addSourceActionCommand($, params.getContext(), sourceActionHashCodeEquals);
        }
        boolean toStringExists = CodeActionUtility.hasMethod(type, "toString", new Class[0]);
        if (this.supportsGenerateToString(type)) {
            boolean nonStaticFields = true;
            try {
                nonStaticFields = this.hasFields(type, false);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            if (nonStaticFields) {
                if (isInTypeDeclaration && !toStringExists) {
                    Optional<Either<Command, CodeAction>> generateToStringQuickAssist = this.getGenerateToStringAction(params, "quickassist");
                    this.addSourceActionCommand($, params.getContext(), generateToStringQuickAssist);
                }
                Optional<Either<Command, CodeAction>> generateToStringCommand = this.getGenerateToStringAction(params, "source.generate.toString");
                this.addSourceActionCommand($, params.getContext(), generateToStringCommand);
            } else {
                CodeActionProposal generateToStringProposal = pm -> {
                    IJavaElement insertPosition = isInTypeDeclaration ? CodeGenerationUtils.findInsertElement(type, null) : CodeGenerationUtils.findInsertElement(type, context.getSelectionOffset());
                    TextEdit edit = GenerateToStringHandler.generateToString(type, new JdtDomModels.LspVariableBinding[0], insertPosition, pm);
                    return SourceAssistProcessor.convertToWorkspaceEdit(cu, edit);
                };
                if (isInTypeDeclaration && !toStringExists) {
                    Optional<Either<Command, CodeAction>> generateToStringQuickAssist = this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), ActionMessages.GenerateToStringAction_label, "quickassist", generateToStringProposal, CodeActionComparator.GENERATE_TOSTRING_PRIORITY);
                    this.addSourceActionCommand($, params.getContext(), generateToStringQuickAssist);
                }
                Optional<Either<Command, CodeAction>> generateToStringCommand = this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), ActionMessages.GenerateToStringAction_label, "source.generate.toString", generateToStringProposal, CodeActionComparator.GENERATE_TOSTRING_PRIORITY);
                this.addSourceActionCommand($, params.getContext(), generateToStringCommand);
            }
        }
        Optional<Either<Command, CodeAction>> generateDelegateMethods = this.getGenerateDelegateMethodsAction(params, context, type);
        this.addSourceActionCommand($, params.getContext(), generateDelegateMethods);
        Optional<Either<Command, CodeAction>> generateFinalModifiers = this.addFinalModifierWherePossibleAction(context);
        this.addSourceActionCommand($, params.getContext(), generateFinalModifiers);
        Optional<Either<Command, CodeAction>> generateFinalModifiersQuickAssist = this.addFinalModifierWherePossibleQuickAssist(context);
        this.addSourceActionCommand($, params.getContext(), generateFinalModifiersQuickAssist);
        Optional<Either<Command, CodeAction>> sortMembersAction = this.getSortMembersAction(context, params, "source.sortMembers", this.preferenceManager.getPreferences().getAvoidVolatileChanges());
        this.addSourceActionCommand($, params.getContext(), sortMembersAction);
        if (isInTypeDeclaration && ((TypeDeclaration)typeDeclaration).isPackageMemberTypeDeclaration()) {
            Optional<Either<Command, CodeAction>> sortMembersQuickAssistForType = this.getSortMembersAction(context, params, "quickassist", this.preferenceManager.getPreferences().getAvoidVolatileChanges());
            this.addSourceActionCommand($, params.getContext(), sortMembersQuickAssistForType);
        }
        if (coveredNodes.size() > 0) {
            Optional<Either<Command, CodeAction>> sortMembersQuickAssistForSelection = this.getSortMembersForSelectionProposal(context, params, coveredNodes, this.preferenceManager.getPreferences().getAvoidVolatileChanges());
            this.addSourceActionCommand($, params.getContext(), sortMembersQuickAssistForSelection);
        }
        return $;
    }

    private void addGenerateAccessorsSourceActionCommand(CodeActionParams params, IInvocationContext context, List<Either<Command, CodeAction>> $, IType type, List<String> fieldNames, boolean isInTypeDeclaration) throws JavaModelException {
        GenerateGetterSetterOperation.AccessorField[] accessors = GenerateGetterSetterOperation.getUnimplementedAccessors(type, GenerateGetterSetterOperation.AccessorKind.BOTH);
        GenerateGetterSetterOperation.AccessorField[] getters = GenerateGetterSetterOperation.getUnimplementedAccessors(type, GenerateGetterSetterOperation.AccessorKind.GETTER);
        GenerateGetterSetterOperation.AccessorField[] setters = GenerateGetterSetterOperation.getUnimplementedAccessors(type, GenerateGetterSetterOperation.AccessorKind.SETTER);
        if (fieldNames.size() > 0) {
            List<GenerateGetterSetterOperation.AccessorField> setterFields;
            List<GenerateGetterSetterOperation.AccessorField> getterFields;
            List<GenerateGetterSetterOperation.AccessorField> accessorFields = Arrays.stream(accessors).filter(accessor -> fieldNames.contains(accessor.fieldName) && accessor.generateGetter && accessor.generateSetter).collect(Collectors.toList());
            if (accessorFields.size() > 0) {
                this.addSourceActionCommand($, params.getContext(), this.getGetterSetterAction(params, context, type, "quickassist", isInTypeDeclaration, accessorFields.toArray(new GenerateGetterSetterOperation.AccessorField[0]), GenerateGetterSetterOperation.AccessorKind.BOTH));
            }
            if ((getterFields = Arrays.stream(getters).filter(getter -> fieldNames.contains(getter.fieldName)).collect(Collectors.toList())).size() > 0) {
                this.addSourceActionCommand($, params.getContext(), this.getGetterSetterAction(params, context, type, "quickassist", isInTypeDeclaration, getterFields.toArray(new GenerateGetterSetterOperation.AccessorField[0]), GenerateGetterSetterOperation.AccessorKind.GETTER));
            }
            if ((setterFields = Arrays.stream(setters).filter(setter -> fieldNames.contains(setter.fieldName)).collect(Collectors.toList())).size() > 0) {
                this.addSourceActionCommand($, params.getContext(), this.getGetterSetterAction(params, context, type, "quickassist", isInTypeDeclaration, setterFields.toArray(new GenerateGetterSetterOperation.AccessorField[0]), GenerateGetterSetterOperation.AccessorKind.SETTER));
            }
        }
        if (getters.length > 0 && setters.length > 0) {
            if (isInTypeDeclaration) {
                Optional<Either<Command, CodeAction>> quickAssistGetterSetter = this.getGetterSetterAction(params, context, type, "quickassist", isInTypeDeclaration, accessors, GenerateGetterSetterOperation.AccessorKind.BOTH);
                this.addSourceActionCommand($, params.getContext(), quickAssistGetterSetter);
            }
            Optional<Either<Command, CodeAction>> sourceGetterSetter = this.getGetterSetterAction(params, context, type, "source.generate.accessors", isInTypeDeclaration, accessors, GenerateGetterSetterOperation.AccessorKind.BOTH);
            this.addSourceActionCommand($, params.getContext(), sourceGetterSetter);
        }
        if (getters.length > 0) {
            if (isInTypeDeclaration) {
                Optional<Either<Command, CodeAction>> quickAssistGetter = this.getGetterSetterAction(params, context, type, "quickassist", isInTypeDeclaration, getters, GenerateGetterSetterOperation.AccessorKind.GETTER);
                this.addSourceActionCommand($, params.getContext(), quickAssistGetter);
            }
            Optional<Either<Command, CodeAction>> sourceGetter = this.getGetterSetterAction(params, context, type, "source.generate.accessors", isInTypeDeclaration, getters, GenerateGetterSetterOperation.AccessorKind.GETTER);
            this.addSourceActionCommand($, params.getContext(), sourceGetter);
        }
        if (setters.length > 0) {
            if (isInTypeDeclaration) {
                Optional<Either<Command, CodeAction>> quickAssistSetter = this.getGetterSetterAction(params, context, type, "quickassist", isInTypeDeclaration, setters, GenerateGetterSetterOperation.AccessorKind.SETTER);
                this.addSourceActionCommand($, params.getContext(), quickAssistSetter);
            }
            Optional<Either<Command, CodeAction>> sourceSetter = this.getGetterSetterAction(params, context, type, "source.generate.accessors", isInTypeDeclaration, setters, GenerateGetterSetterOperation.AccessorKind.SETTER);
            this.addSourceActionCommand($, params.getContext(), sourceSetter);
        }
    }

    private void addSourceActionCommand(List<Either<Command, CodeAction>> result, CodeActionContext context, Optional<Either<Command, CodeAction>> target) {
        if (!target.isPresent()) {
            return;
        }
        Either<Command, CodeAction> targetAction = target.get();
        if (context.getOnly() != null && !context.getOnly().isEmpty()) {
            String actionKind;
            Stream acceptedActionKinds = context.getOnly().stream();
            String string = actionKind = targetAction.getLeft() == null ? ((CodeAction)targetAction.getRight()).getKind() : ((Command)targetAction.getLeft()).getCommand();
            if (!acceptedActionKinds.filter(kind -> actionKind != null && actionKind.startsWith((String)kind)).findFirst().isPresent()) {
                return;
            }
        }
        result.add(targetAction);
    }

    private TextEdit getOrganizeImportsTextEdit(IInvocationContext context, boolean restoreExistingImports, boolean isAdvancedOrganizeImportsSupported, IProgressMonitor monitor) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return null;
        }
        IResource resource = cu.getResource();
        if (resource == null) {
            return null;
        }
        URI uri = resource.getLocationURI();
        if (uri == null) {
            return null;
        }
        return OrganizeImportsHandler.organizeImports(context.getCompilationUnit(), isAdvancedOrganizeImportsSupported ? OrganizeImportsHandler.getChooseImportsFunction(uri.toString(), restoreExistingImports) : null, restoreExistingImports, monitor);
    }

    private Optional<Either<Command, CodeAction>> getOverrideMethodsAction(CodeActionParams params, String kind) {
        if (!this.preferenceManager.getClientPreferences().isOverrideMethodsPromptSupported()) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.OverrideMethodsAction_label, COMMAND_ID_ACTION_OVERRIDEMETHODSPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.overrideMethods")) {
            CodeAction codeAction = new CodeAction(ActionMessages.OverrideMethodsAction_label);
            codeAction.setKind(kind);
            codeAction.setCommand(command);
            codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, CodeActionComparator.GENERATE_OVERRIDE_IMPLEMENT_PRIORITY));
            codeAction.setDiagnostics(Collections.emptyList());
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private Optional<Either<Command, CodeAction>> getGetterSetterAction(CodeActionParams params, IInvocationContext context, IType type, String kind, boolean isInTypeDeclaration, GenerateGetterSetterOperation.AccessorField[] accessors, GenerateGetterSetterOperation.AccessorKind accessorKind) {
        boolean isQuickAssist = kind.equals("quickassist");
        try {
            String actionMessage;
            if (accessors == null || accessors.length == 0) {
                return Optional.empty();
            }
            if (isQuickAssist || accessors.length == 1 || !this.preferenceManager.getClientPreferences().isAdvancedGenerateAccessorsSupported()) {
                String actionMessage2;
                switch (accessorKind) {
                    case BOTH: {
                        actionMessage2 = isQuickAssist && accessors.length == 1 ? Messages.format(ActionMessages.GenerateGetterSetterAction_templateLabel, accessors[0].fieldName) : ActionMessages.GenerateGetterSetterAction_label;
                        break;
                    }
                    case GETTER: {
                        actionMessage2 = isQuickAssist && accessors.length == 1 ? Messages.format(ActionMessages.GenerateGetterAction_templateLabel, accessors[0].fieldName) : ActionMessages.GenerateGetterAction_label;
                        break;
                    }
                    case SETTER: {
                        actionMessage2 = isQuickAssist && accessors.length == 1 ? Messages.format(ActionMessages.GenerateSetterAction_templateLabel, accessors[0].fieldName) : ActionMessages.GenerateSetterAction_label;
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
                CodeActionProposal getAccessorsProposal = pm -> {
                    IJavaElement insertBefore = isInTypeDeclaration ? CodeGenerationUtils.findInsertElement(type, null) : CodeGenerationUtils.findInsertElement(type, params.getRange());
                    GenerateGetterSetterOperation operation = new GenerateGetterSetterOperation(type, context.getASTRoot(), this.preferenceManager.getPreferences().isCodeGenerationTemplateGenerateComments(), insertBefore);
                    TextEdit edit = operation.createTextEdit(pm, accessors);
                    return SourceAssistProcessor.convertToWorkspaceEdit(context.getCompilationUnit(), edit);
                };
                return this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), actionMessage2, kind, getAccessorsProposal, CodeActionComparator.GENERATE_ACCESSORS_PRIORITY);
            }
            switch (accessorKind) {
                case BOTH: {
                    actionMessage = ActionMessages.GenerateGetterSetterAction_ellipsisLabel;
                    break;
                }
                case GETTER: {
                    actionMessage = ActionMessages.GenerateGetterAction_ellipsisLabel;
                    break;
                }
                case SETTER: {
                    actionMessage = ActionMessages.GenerateSetterAction_ellipsisLabel;
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            GenerateAccessorsHandler.AccessorCodeActionParams accessorParams = new GenerateAccessorsHandler.AccessorCodeActionParams(params.getTextDocument(), params.getRange(), params.getContext(), accessorKind);
            Command command = new Command(actionMessage, COMMAND_ID_ACTION_GENERATEACCESSORSPROMPT, Collections.singletonList(accessorParams));
            if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.accessors")) {
                CodeAction codeAction = new CodeAction(actionMessage);
                codeAction.setKind(kind);
                codeAction.setCommand(command);
                codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, CodeActionComparator.GENERATE_ACCESSORS_PRIORITY));
                codeAction.setDiagnostics(Collections.emptyList());
                return Optional.of(Either.forRight((Object)codeAction));
            }
            return Optional.of(Either.forLeft((Object)command));
        }
        catch (OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Failed to generate accessors source action", e);
            return Optional.empty();
        }
    }

    private boolean supportsHashCodeEquals(IInvocationContext context, IType type, IProgressMonitor monitor) {
        CompilationUnit astRoot;
        block5: {
            block4: {
                try {
                    if (type != null && !type.isAnnotation() && !type.isInterface() && !type.isEnum() && type.getCompilationUnit() != null) break block4;
                    return false;
                }
                catch (JavaModelException e) {
                    return false;
                }
            }
            astRoot = context.getASTRoot();
            if (astRoot != null) break block5;
            return false;
        }
        ITypeBinding typeBinding = ASTNodes.getTypeBinding((CompilationUnit)astRoot, (IType)type);
        return typeBinding == null ? false : Arrays.stream(typeBinding.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers())).findAny().isPresent();
    }

    private Optional<Either<Command, CodeAction>> getHashCodeEqualsAction(CodeActionParams params, String kind) {
        if (!this.preferenceManager.getClientPreferences().isHashCodeEqualsPromptSupported()) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.GenerateHashCodeEqualsAction_label, COMMAND_ID_ACTION_HASHCODEEQUALSPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.hashCodeEquals")) {
            CodeAction codeAction = new CodeAction(ActionMessages.GenerateHashCodeEqualsAction_label);
            codeAction.setKind(kind);
            codeAction.setCommand(command);
            codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, CodeActionComparator.GENERATE_HASHCODE_EQUALS_PRIORITY));
            codeAction.setDiagnostics(Collections.emptyList());
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private boolean supportsGenerateToString(IType type) {
        try {
            if (type == null || type.isAnnotation() || type.isInterface() || type.isEnum() || type.isAnonymous() || type.getCompilationUnit() == null) {
                return false;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return true;
    }

    private Optional<Either<Command, CodeAction>> getGenerateToStringAction(CodeActionParams params, String kind) {
        if (!this.preferenceManager.getClientPreferences().isGenerateToStringPromptSupported()) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.GenerateToStringAction_ellipsisLabel, COMMAND_ID_ACTION_GENERATETOSTRINGPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.toString")) {
            CodeAction codeAction = new CodeAction(ActionMessages.GenerateToStringAction_ellipsisLabel);
            codeAction.setKind(kind);
            codeAction.setCommand(command);
            codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, CodeActionComparator.GENERATE_TOSTRING_PRIORITY));
            codeAction.setDiagnostics(Collections.emptyList());
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private Optional<Either<Command, CodeAction>> getGenerateConstructorsAction(CodeActionParams params, IInvocationContext context, IType type, String kind, IProgressMonitor monitor) {
        try {
            if (type == null || type.isAnnotation() || type.isInterface() || type.isAnonymous() || type.getCompilationUnit() == null) {
                return Optional.empty();
            }
            boolean hasNonStaticField = this.hasFields(type, false);
            if (!hasNonStaticField) {
                return Optional.empty();
            }
        }
        catch (JavaModelException e) {
            return Optional.empty();
        }
        if (this.preferenceManager.getClientPreferences().isGenerateConstructorsPromptSupported()) {
            GenerateConstructorsHandler.CheckConstructorsResponse status = GenerateConstructorsHandler.checkConstructorStatus(type, params.getRange(), monitor);
            if (status.constructors.length == 0) {
                return Optional.empty();
            }
            if (status.constructors.length == 1 && status.fields.length == 0) {
                CodeActionProposal generateConstructorsProposal = pm -> {
                    TextEdit edit = GenerateConstructorsHandler.generateConstructors(type, checkConstructorsResponse.constructors, checkConstructorsResponse.fields, params.getRange(), pm);
                    return SourceAssistProcessor.convertToWorkspaceEdit(type.getCompilationUnit(), edit);
                };
                return this.getCodeActionFromProposal(params.getContext(), type.getCompilationUnit(), ActionMessages.GenerateConstructorsAction_label, kind, generateConstructorsProposal, CodeActionComparator.GENERATE_CONSTRUCTORS_PRIORITY);
            }
            Command command = new Command(ActionMessages.GenerateConstructorsAction_ellipsisLabel, COMMAND_ID_ACTION_GENERATECONSTRUCTORSPROMPT, Collections.singletonList(params));
            if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.constructors")) {
                CodeAction codeAction = new CodeAction(ActionMessages.GenerateConstructorsAction_ellipsisLabel);
                codeAction.setKind(kind);
                codeAction.setCommand(command);
                codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, CodeActionComparator.GENERATE_CONSTRUCTORS_PRIORITY));
                codeAction.setDiagnostics(Collections.emptyList());
                return Optional.of(Either.forRight((Object)codeAction));
            }
            return Optional.of(Either.forLeft((Object)command));
        }
        return Optional.empty();
    }

    private Optional<Either<Command, CodeAction>> getGenerateDelegateMethodsAction(CodeActionParams params, IInvocationContext context, IType type) {
        try {
            if (!this.preferenceManager.getClientPreferences().isGenerateDelegateMethodsPromptSupported() || !GenerateDelegateMethodsHandler.supportsGenerateDelegateMethods(type)) {
                return Optional.empty();
            }
        }
        catch (JavaModelException e) {
            return Optional.empty();
        }
        Command command = new Command(ActionMessages.GenerateDelegateMethodsAction_label, COMMAND_ID_ACTION_GENERATEDELEGATEMETHODSPROMPT, Collections.singletonList(params));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind("source.generate.delegateMethods")) {
            CodeAction codeAction = new CodeAction(ActionMessages.GenerateDelegateMethodsAction_label);
            codeAction.setKind("source.generate.delegateMethods");
            codeAction.setCommand(command);
            codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, CodeActionComparator.GENERATE_DELEGATE_METHOD_PRIORITY));
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private Optional<Either<Command, CodeAction>> addFinalModifierWherePossibleAction(IInvocationContext context) {
        IProposableFix fix = (IProposableFix)VariableDeclarationFixCore.createCleanUp((CompilationUnit)context.getASTRoot(), (boolean)true, (boolean)true, (boolean)true);
        return this.getFinalModifierWherePossibleAction(context, fix, ActionMessages.GenerateFinalModifiersAction_label, "source.generate.finalModifiers");
    }

    private Optional<Either<Command, CodeAction>> addFinalModifierWherePossibleQuickAssist(IInvocationContext context) {
        ASTNode coveringNode = context.getCoveringNode();
        ArrayList<ASTNode> coveredNodes = QuickAssistProcessor.getFullyCoveredNodes(context, coveringNode);
        List<ASTNode> possibleASTNodes = this.getPossibleASTNodesForFinalModifier(coveredNodes);
        if (possibleASTNodes.size() == 0) {
            possibleASTNodes = this.getPossibleASTNodesForFinalModifier(Arrays.asList(coveringNode));
        }
        HashSet<String> names = new HashSet<String>();
        for (ASTNode node : possibleASTNodes) {
            names.addAll(CodeActionUtility.getVariableNamesFromASTNode(node));
        }
        String actionMessage = ActionMessages.GenerateFinalModifiersAction_selectionLabel;
        if (names.size() == 1) {
            actionMessage = Messages.format(ActionMessages.GenerateFinalModifiersAction_templateLabel, names.iterator().next());
        }
        VariableDeclarationFixCore fix = VariableDeclarationFixCore.createChangeModifierToFinalFix((CompilationUnit)context.getASTRoot(), (ASTNode[])possibleASTNodes.toArray(new ASTNode[0]));
        return this.getFinalModifierWherePossibleAction(context, (IProposableFix)fix, actionMessage, "quickassist");
    }

    private List<ASTNode> getPossibleASTNodesForFinalModifier(List<ASTNode> targetNodes) {
        ArrayList<ASTNode> results = new ArrayList<ASTNode>();
        for (ASTNode targetNode : targetNodes) {
            ASTNode variableDeclaration = CodeActionUtility.inferASTNode(targetNode, VariableDeclaration.class);
            ASTNode fieldDeclaration = CodeActionUtility.inferASTNode(targetNode, FieldDeclaration.class);
            ASTNode variableDeclarationStatement = CodeActionUtility.inferASTNode(targetNode, VariableDeclarationStatement.class);
            if (variableDeclaration != null) {
                results.add(variableDeclaration);
                continue;
            }
            if (fieldDeclaration != null) {
                results.addAll(((FieldDeclaration)fieldDeclaration).fragments());
                continue;
            }
            if (variableDeclarationStatement == null) continue;
            results.add(variableDeclarationStatement);
        }
        return results;
    }

    private Optional<Either<Command, CodeAction>> getFinalModifierWherePossibleAction(IInvocationContext context, IProposableFix fix, String actionMessage, String kind) {
        WorkspaceEdit edit;
        if (fix == null) {
            return Optional.empty();
        }
        FixCorrectionProposal proposal = new FixCorrectionProposal(fix, null, -1, context, kind);
        if (this.preferenceManager.getClientPreferences().isResolveCodeActionSupported()) {
            CodeAction codeAction = new CodeAction(actionMessage);
            codeAction.setKind(proposal.getKind());
            codeAction.setData((Object)new CodeActionHandler.CodeActionData((Object)proposal, CodeActionComparator.CHANGE_MODIFIER_TO_FINAL_PRIORITY));
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        try {
            edit = ChangeUtil.convertToWorkspaceEdit(proposal.getChange());
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem converting proposal to code actions", e);
            return Optional.empty();
        }
        if (!ChangeUtil.hasChanges(edit)) {
            return Optional.empty();
        }
        Command command = new Command(actionMessage, "java.apply.workspaceEdit", Collections.singletonList(edit));
        if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(proposal.getKind())) {
            CodeAction codeAction = new CodeAction(actionMessage);
            codeAction.setKind(proposal.getKind());
            codeAction.setCommand(command);
            codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, CodeActionComparator.CHANGE_MODIFIER_TO_FINAL_PRIORITY));
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        return Optional.of(Either.forLeft((Object)command));
    }

    private Optional<Either<Command, CodeAction>> getSortMembersProposal(IInvocationContext context, CodeActionParams params, String kind, String label, boolean avoidVolatileChanges) {
        CategorizedTextEditGroup group = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
        try {
            TextEdit edit = CompilationUnitSorter.sort((CompilationUnit)context.getASTRoot(), (Comparator)new DefaultJavaElementComparator(avoidVolatileChanges), (int)0, (TextEditGroup)group, null);
            if (edit == null) {
                return Optional.empty();
            }
            CodeActionProposal sortMembersProposal = pm -> SourceAssistProcessor.convertToWorkspaceEdit(context.getCompilationUnit(), edit);
            return this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), label, kind, sortMembersProposal, CodeActionComparator.SORT_MEMBERS_PRIORITY);
        }
        catch (JavaModelException e) {
            return Optional.empty();
        }
    }

    private Optional<Either<Command, CodeAction>> getSortMembersForSelectionProposal(IInvocationContext context, CodeActionParams params, List<ASTNode> coveredNodes, boolean avoidVolatileChanges) {
        CategorizedTextEditGroup group = new CategorizedTextEditGroup(ActionMessages.SortMembers_selectionLabel, new GroupCategorySet(new GroupCategory(ActionMessages.SortMembers_selectionLabel, ActionMessages.SortMembers_selectionLabel, ActionMessages.SortMembers_selectionLabel)));
        PartialSortMembersOperation operation = new PartialSortMembersOperation(new IJavaElement[]{context.getASTRoot().getJavaElement()}, new DefaultJavaElementComparator(avoidVolatileChanges));
        try {
            TextEdit edit = operation.calculateEdit(context.getASTRoot(), coveredNodes, (TextEditGroup)group);
            if (edit == null) {
                return Optional.empty();
            }
            CodeActionProposal sortMembersProposal = pm -> SourceAssistProcessor.convertToWorkspaceEdit(context.getCompilationUnit(), edit);
            return this.getCodeActionFromProposal(params.getContext(), context.getCompilationUnit(), ActionMessages.SortMembers_selectionLabel, "quickassist", sortMembersProposal, CodeActionComparator.SORT_MEMBERS_PRIORITY);
        }
        catch (JavaModelException e) {
            return Optional.empty();
        }
    }

    private Optional<Either<Command, CodeAction>> getSortMembersAction(IInvocationContext context, CodeActionParams params, String kind, boolean avoidVolatileChanges) {
        ITypeRoot typeRoot;
        CompilationUnit unit = context.getASTRoot();
        if (unit != null && (typeRoot = unit.getTypeRoot()) != null) {
            return this.getSortMembersProposal(context, params, kind, Messages.format(ActionMessages.SortMembers_templateLabel, typeRoot.getElementName()), avoidVolatileChanges);
        }
        return Optional.empty();
    }

    private Optional<Either<Command, CodeAction>> getCodeActionFromProposal(CodeActionContext context, ICompilationUnit cu, String name, String kind, CodeActionProposal proposal, int priority) {
        if (this.preferenceManager.getClientPreferences().isResolveCodeActionSupported()) {
            CodeAction codeAction = new CodeAction(name);
            codeAction.setKind(kind);
            codeAction.setData((Object)new CodeActionHandler.CodeActionData(proposal, priority));
            codeAction.setDiagnostics(Collections.EMPTY_LIST);
            return Optional.of(Either.forRight((Object)codeAction));
        }
        try {
            WorkspaceEdit edit = proposal.resolveEdit((IProgressMonitor)new NullProgressMonitor());
            if (!ChangeUtil.hasChanges(edit)) {
                return Optional.empty();
            }
            Command command = new Command(name, "java.apply.workspaceEdit", Collections.singletonList(edit));
            if (this.preferenceManager.getClientPreferences().isSupportedCodeActionKind(kind)) {
                CodeAction codeAction = new CodeAction(name);
                codeAction.setKind(kind);
                codeAction.setCommand(command);
                codeAction.setData((Object)new CodeActionHandler.CodeActionData(null, priority));
                codeAction.setDiagnostics(context.getDiagnostics());
                return Optional.of(Either.forRight((Object)codeAction));
            }
            return Optional.of(Either.forLeft((Object)command));
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Problem converting proposal to code actions", e);
            return null;
        }
    }

    private boolean hasFields(IType type, boolean includeStatic) throws JavaModelException {
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (includeStatic || !JdtFlags.isStatic((IMember)field)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static WorkspaceEdit convertToWorkspaceEdit(ICompilationUnit cu, TextEdit edit) {
        if (cu == null || edit == null) {
            return null;
        }
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        TextEditConverter converter = new TextEditConverter(cu, edit);
        String uri = JDTUtils.toURI(cu);
        workspaceEdit.getChanges().put(uri, converter.convert());
        return workspaceEdit;
    }

    /*
     * WARNING - void declaration
     */
    public static IType getSelectionType(IInvocationContext context) {
        IType typeDecl;
        ASTNode aSTNode;
        ICompilationUnit unit = context.getCompilationUnit();
        ASTNode node = context.getCoveredNode();
        if (node == null) {
            node = context.getCoveringNode();
        }
        ITypeBinding typeBinding = null;
        while (node != null && !(node instanceof CompilationUnit)) {
            aSTNode = node;
            if (aSTNode instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)aSTNode;
                AbstractTypeDeclaration cfr_ignored_0 = (AbstractTypeDeclaration)aSTNode;
                typeBinding = typeDecl.resolveBinding();
                break;
            }
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof AnonymousClassDeclaration) {
                void anonymousClassDecl;
                AnonymousClassDeclaration anonymousClassDeclaration = (AnonymousClassDeclaration)aSTNode2;
                AnonymousClassDeclaration cfr_ignored_1 = (AnonymousClassDeclaration)aSTNode2;
                typeBinding = anonymousClassDecl.resolveBinding();
                break;
            }
            node = node.getParent();
        }
        if (typeBinding != null && (aSTNode = typeBinding.getJavaElement()) instanceof IType) {
            void type;
            typeDecl = (IType)aSTNode;
            IType cfr_ignored_2 = (IType)aSTNode;
            return type;
        }
        return unit.findPrimaryType();
    }

    public static IType getSelectionType(CodeActionParams params) {
        return SourceAssistProcessor.getSelectionType(params, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IType getSelectionType(CodeActionParams params, IProgressMonitor monitor) {
        InnovationContext context = SourceAssistProcessor.getInnovationContext(params, monitor);
        return context == null ? null : SourceAssistProcessor.getSelectionType(context);
    }

    public static InnovationContext getInnovationContext(CodeActionParams params, IProgressMonitor monitor) {
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return null;
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange());
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange());
        InnovationContext context = new InnovationContext(unit, start, end - start);
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
        if (astRoot == null) {
            return null;
        }
        context.setASTRoot(astRoot);
        return context;
    }

    public static ICompilationUnit getCompilationUnit(CodeActionParams params) {
        return JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
    }

    /*
     * Unable to fully structure code
     */
    public static ASTNode getTypeDeclarationNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (!(node instanceof BodyDeclaration)) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParent();
lbl6:
            // 2 sources

            ** while (node != null && !(node instanceof BodyDeclaration) && !(node instanceof Statement))
        }
lbl7:
        // 1 sources

        return node instanceof TypeDeclaration != false ? node : null;
    }
}

