/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.text.edits.TextEditGroup;

public class ASTNodeDeleteUtil {
    private static ASTNode[] getNodesToDelete(IJavaElement element, CompilationUnit cuNode) throws JavaModelException {
        if (element.getElementType() == 8) {
            if (JdtFlags.isEnum((IMember)((IField)element))) {
                return new ASTNode[]{ASTNodeSearchUtil.getEnumConstantDeclaration((IField)((IField)element), (CompilationUnit)cuNode)};
            }
            return new ASTNode[]{ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)((IField)element), (CompilationUnit)cuNode)};
        }
        if (element.getElementType() == 7 && ((IType)element).isLocal()) {
            IType type = (IType)element;
            if (type.isAnonymous()) {
                EnumConstantDeclaration enumDecl;
                if (type.getParent().getElementType() == 8 && (enumDecl = ASTNodeSearchUtil.getEnumConstantDeclaration((IField)((IField)element.getParent()), (CompilationUnit)cuNode)) != null && enumDecl.getAnonymousClassDeclaration() != null) {
                    return new ASTNode[]{enumDecl.getAnonymousClassDeclaration()};
                }
                ClassInstanceCreation creation = ASTNodeSearchUtil.getClassInstanceCreationNode((IType)type, (CompilationUnit)cuNode);
                if (creation != null) {
                    if (creation.getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY) {
                        return new ASTNode[]{creation.getParent()};
                    }
                    if (creation.getLocationInParent() == VariableDeclarationFragment.INITIALIZER_PROPERTY) {
                        return new ASTNode[]{creation};
                    }
                    return new ASTNode[]{creation.getAnonymousClassDeclaration()};
                }
                return new ASTNode[0];
            }
            ASTNode[] nodes = ASTNodeSearchUtil.getDeclarationNodes((IJavaElement)element, (CompilationUnit)cuNode);
            nodes[0] = nodes[0].getParent();
            return nodes;
        }
        return ASTNodeSearchUtil.getDeclarationNodes((IJavaElement)element, (CompilationUnit)cuNode);
    }

    private static Set<ASTNode> getRemovedNodes(final List<ASTNode> removed, CompilationUnitRewrite rewrite) {
        final HashSet<ASTNode> result = new HashSet<ASTNode>();
        rewrite.getRoot().accept((ASTVisitor)new GenericVisitor(true){

            protected boolean visitNode(ASTNode node) {
                if (removed.contains(node)) {
                    result.add(node);
                }
                return true;
            }
        });
        return result;
    }

    public static void markAsDeleted(IJavaElement[] javaElements, CompilationUnitRewrite rewrite, TextEditGroup group) throws JavaModelException {
        ArrayList<ASTNode> removed = new ArrayList<ASTNode>();
        int i = 0;
        while (i < javaElements.length) {
            ASTNodeDeleteUtil.markAsDeleted(removed, javaElements[i], rewrite, group);
            ++i;
        }
        ASTNodeDeleteUtil.propagateFieldDeclarationNodeDeletions(removed, rewrite, group);
    }

    private static void markAsDeleted(List<ASTNode> list, IJavaElement element, CompilationUnitRewrite rewrite, TextEditGroup group) throws JavaModelException {
        ASTNode[] declarationNodes = ASTNodeDeleteUtil.getNodesToDelete(element, rewrite.getRoot());
        int i = 0;
        while (i < declarationNodes.length) {
            ASTNode node = declarationNodes[i];
            if (node != null) {
                list.add(node);
                rewrite.getASTRewrite().remove(node, group);
                rewrite.getImportRemover().registerRemovedNode(node);
            }
            ++i;
        }
    }

    private static void propagateFieldDeclarationNodeDeletions(List<ASTNode> removed, CompilationUnitRewrite rewrite, TextEditGroup group) {
        Set<ASTNode> removedNodes = ASTNodeDeleteUtil.getRemovedNodes(removed, rewrite);
        for (ASTNode node : removedNodes) {
            if (!(node instanceof VariableDeclarationFragment) || !(node.getParent() instanceof FieldDeclaration)) continue;
            FieldDeclaration fd = (FieldDeclaration)node.getParent();
            if (!removed.contains(fd) && removedNodes.containsAll(fd.fragments())) {
                rewrite.getASTRewrite().remove((ASTNode)fd, group);
            }
            rewrite.getImportRemover().registerRemovedNode((ASTNode)fd);
        }
    }

    private ASTNodeDeleteUtil() {
    }
}

