/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.manipulation.CleanUpContextCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.cleanup.AddDeprecatedAnnotationCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.AddOverrideAnnotationCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.CleanUpUtils;
import org.eclipse.jdt.ls.core.internal.cleanup.ISimpleCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.InstanceofPatternMatch;
import org.eclipse.jdt.ls.core.internal.cleanup.InvertEqualsCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.LambdaExpressionAndMethodRefCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.LambdaExpressionCleanup;
import org.eclipse.jdt.ls.core.internal.cleanup.MemberAccessUsesThisCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.StaticAccessUsesClassNameCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.StringConcatToTextBlockCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.SwitchExpressionCleanup;
import org.eclipse.jdt.ls.core.internal.cleanup.TryWithResourceCleanUp;
import org.eclipse.jdt.ls.core.internal.cleanup.VariableDeclarationFixCleanup;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.text.edits.TextEdit;

public class CleanUpRegistry {
    private Map<String, ISimpleCleanUp> cleanUps;

    public CleanUpRegistry() {
        ArrayList<ISimpleCleanUp> cleanUpsList = new ArrayList<ISimpleCleanUp>();
        cleanUpsList.add(new MemberAccessUsesThisCleanUp());
        cleanUpsList.add(new StaticAccessUsesClassNameCleanUp());
        cleanUpsList.add(new AddOverrideAnnotationCleanUp());
        cleanUpsList.add(new AddDeprecatedAnnotationCleanUp());
        cleanUpsList.add(new StringConcatToTextBlockCleanUp());
        cleanUpsList.add(new InvertEqualsCleanUp());
        cleanUpsList.add(new VariableDeclarationFixCleanup());
        cleanUpsList.add(new SwitchExpressionCleanup());
        cleanUpsList.add(new InstanceofPatternMatch());
        cleanUpsList.add(new LambdaExpressionCleanup());
        cleanUpsList.add(new TryWithResourceCleanUp());
        cleanUpsList.add(new LambdaExpressionAndMethodRefCleanUp());
        this.cleanUps = new HashMap<String, ISimpleCleanUp>();
        cleanUpsList.forEach(cleanUp -> this.cleanUps.put(cleanUp.getIdentifier(), (ISimpleCleanUp)cleanUp));
    }

    public List<org.eclipse.lsp4j.TextEdit> getEditsForAllActiveCleanUps(TextDocumentIdentifier textDocumentId, List<String> cleanUpEnabled, IProgressMonitor monitor) {
        IJavaProject javaProject = JDTUtils.resolveCompilationUnit(textDocumentId.getUri()).getJavaProject();
        List<ISimpleCleanUp> cleanUpsToRun = cleanUpEnabled.stream().distinct().map(cleanUpId -> this.cleanUps.get(cleanUpId)).filter(cleanUpId -> cleanUpId != null).toList();
        if (cleanUpsToRun.isEmpty()) {
            return Collections.emptyList();
        }
        List compilerOptsToEnable = cleanUpsToRun.stream().flatMap(cleanUp -> cleanUp.getRequiredCompilerMarkers().stream()).toList();
        Map opts = javaProject.getOptions(true);
        for (String compilerOpt : compilerOptsToEnable) {
            String currentOptValue = (String)opts.get(compilerOpt);
            if (currentOptValue != null && !currentOptValue.equals("ignore")) continue;
            opts.put(compilerOpt, "warning");
        }
        CleanUpContextCore context = CleanUpUtils.getCleanUpContext(textDocumentId, (Map<String, String>)opts, monitor);
        ArrayList<org.eclipse.lsp4j.TextEdit> textEdits = new ArrayList<org.eclipse.lsp4j.TextEdit>();
        ICompilationUnit cu = context.getCompilationUnit();
        try {
            ICompilationUnit wc = cu.getWorkingCopy(monitor);
            for (ISimpleCleanUp cleanUp2 : cleanUpsToRun) {
                TextEdit jdtEdit = CleanUpUtils.getTextEditFromCleanUp(cleanUp2, context, monitor);
                if (jdtEdit == null) continue;
                wc.applyTextEdit(jdtEdit, monitor);
                context = CleanUpUtils.getCleanUpContext(wc, (Map<String, String>)opts, monitor);
            }
            IBuffer wcBuff = wc.getBuffer();
            IBuffer cuBuff = cu.getBuffer();
            String newText = wcBuff.getContents();
            if (!newText.equals(cuBuff.getContents())) {
                org.eclipse.lsp4j.TextEdit te = new org.eclipse.lsp4j.TextEdit(JDTUtils.toRange((IOpenable)cu, 0, cuBuff.getLength()), newText);
                textEdits.add(te);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return textEdits;
    }
}

