"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBlobContents = exports.getTextContents = void 0;
var path_1 = require("path");
var git_1 = require("../core/git");
var upath = require('upath');
var normalizeSafe = upath.normalizeSafe;
var successExitCodes = new Set([0, 1]);
var utf8Encoding = function (cb) { var _a; return (_a = cb.stdout) === null || _a === void 0 ? void 0 : _a.setEncoding('utf8'); };
var binaryEncoding = function (cb) { var _a; return (_a = cb.stdout) === null || _a === void 0 ? void 0 : _a.setEncoding('binary'); };
/**
 * Retrieve the text (UTF-8) contents of a file from the repository at a given
 * reference, commit, or tree.
 *
 * Returns a promise that will produce a Buffer instance containing
 * the text (UTF-8) contents of the resource or an error if the file doesn't
 * exists in the given revision.
 *
 * @param repositoryPath - The repository from where to read the file. Or the FS path to the repository.
 * @param commitish  - A commit SHA or some other identifier that ultimately dereferences to a commit/tree. `HEAD` is the `HEAD`. If empty string, shows the index state.
 * @param path       - The absolute FS path which is contained in the repository.
 */
function getTextContents(repositoryPath, commitish, path, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var args, opts, textContents;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    args = ['show', commitish + ":" + normalizeSafe((0, path_1.relative)(repositoryPath, path))];
                    opts = __assign(__assign({}, options), { successExitCodes: successExitCodes, processCallback: utf8Encoding });
                    return [4 /*yield*/, (0, git_1.git)(args, repositoryPath, 'getTextContents', opts)];
                case 1:
                    textContents = _a.sent();
                    return [2 /*return*/, Buffer.from(textContents.stdout, 'utf8')];
            }
        });
    });
}
exports.getTextContents = getTextContents;
/**
 * Retrieve the binary contents of a blob from the repository at a given
 * reference, commit, or tree.
 *
 * Returns a promise that will produce a Buffer instance containing
 * the binary contents of the blob or an error if the file doesn't
 * exists in the given revision.
 *
 * @param repositoryPath - The repository from where to read the blob. Or the FS path to the repository.
 * @param commitish  - A commit SHA or some other identifier that ultimately dereferences to a commit/tree. `HEAD` is the `HEAD`. If empty string, shows the index state.
 * @param path       - The absolute FS path which is contained in the repository.
 */
function getBlobContents(repositoryPath, commitish, path, options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var args, opts, blobContents;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    args = ['show', commitish + ":" + path];
                    opts = __assign(__assign({}, options), { successExitCodes: successExitCodes, processCallback: binaryEncoding });
                    return [4 /*yield*/, (0, git_1.git)(args, repositoryPath, 'getBlobContents', opts)];
                case 1:
                    blobContents = _a.sent();
                    return [2 /*return*/, Buffer.from(blobContents.stdout, 'binary')];
            }
        });
    });
}
exports.getBlobContents = getBlobContents;
//# sourceMappingURL=show.js.map