"use strict";
// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginVsCodeDirectoryHandler = void 0;
const path = require("path");
const filenamify = require("filenamify");
const fs = require("@theia/core/shared/fs-extra");
const inversify_1 = require("@theia/core/shared/inversify");
const plugin_ext_1 = require("@theia/plugin-ext");
const node_1 = require("@theia/core/lib/node");
const temp_dir_util_1 = require("@theia/plugin-ext/lib/main/node/temp-dir-util");
const plugin_cli_contribution_1 = require("@theia/plugin-ext/lib/main/node/plugin-cli-contribution");
let PluginVsCodeDirectoryHandler = class PluginVsCodeDirectoryHandler {
    constructor() {
        this.deploymentDirectory = node_1.FileUri.create((0, temp_dir_util_1.getTempDir)('vscode-copied'));
    }
    accept(plugin) {
        console.debug(`Resolving "${plugin.id()}" as a VS Code extension...`);
        return this.attemptResolution(plugin);
    }
    attemptResolution(plugin) {
        return this.resolvePackage(plugin) || this.deriveMetadata(plugin);
    }
    deriveMetadata(plugin) {
        return this.resolveFromSources(plugin) || this.resolveFromVSIX(plugin) || this.resolveFromNpmTarball(plugin);
    }
    async handle(context) {
        await this.copyDirectory(context);
        context.pluginEntry().accept(plugin_ext_1.PluginDeployerEntryType.BACKEND);
    }
    async copyDirectory(context) {
        if (this.pluginCli.copyUncompressedPlugins() && context.pluginEntry().type === plugin_ext_1.PluginType.User) {
            const entry = context.pluginEntry();
            const id = entry.id();
            const pathToRestore = entry.path();
            const origin = entry.originalPath();
            const targetDir = await this.getExtensionDir(context);
            try {
                if (fs.existsSync(targetDir) || !entry.path().startsWith(origin)) {
                    console.log(`[${id}]: already copied.`);
                }
                else {
                    console.log(`[${id}]: copying to "${targetDir}"`);
                    await fs.mkdirp(node_1.FileUri.fsPath(this.deploymentDirectory));
                    await context.copy(origin, targetDir);
                    entry.updatePath(targetDir);
                    if (!this.deriveMetadata(entry)) {
                        throw new Error('Unable to resolve plugin metadata after copying');
                    }
                }
            }
            catch (e) {
                console.warn(`[${id}]: Error when copying.`, e);
                entry.updatePath(pathToRestore);
            }
        }
    }
    resolveFromSources(plugin) {
        const pluginPath = plugin.path();
        return this.resolvePackage(plugin, { pluginPath, pck: this.requirePackage(pluginPath) });
    }
    resolveFromVSIX(plugin) {
        if (!fs.existsSync(path.join(plugin.path(), 'extension.vsixmanifest'))) {
            return false;
        }
        const pluginPath = path.join(plugin.path(), 'extension');
        return this.resolvePackage(plugin, { pluginPath, pck: this.requirePackage(pluginPath) });
    }
    resolveFromNpmTarball(plugin) {
        const pluginPath = path.join(plugin.path(), 'package');
        return this.resolvePackage(plugin, { pluginPath, pck: this.requirePackage(pluginPath) });
    }
    resolvePackage(plugin, options) {
        var _a;
        const { pluginPath, pck } = options || {
            pluginPath: plugin.path(),
            pck: plugin.getValue('package.json')
        };
        if (!pck || !pck.name || !pck.version || !pck.engines || !pck.engines.vscode) {
            return false;
        }
        (_a = pck.publisher) !== null && _a !== void 0 ? _a : (pck.publisher = plugin_ext_1.PluginIdentifiers.UNPUBLISHED);
        if (options) {
            plugin.storeValue('package.json', pck);
            plugin.rootPath = plugin.path();
            plugin.updatePath(pluginPath);
        }
        console.log(`Resolved "${plugin.id()}" to a VS Code extension "${pck.name}@${pck.version}" with engines:`, pck.engines);
        return true;
    }
    requirePackage(pluginPath) {
        var _a;
        try {
            const plugin = fs.readJSONSync(path.join(pluginPath, 'package.json'));
            (_a = plugin.publisher) !== null && _a !== void 0 ? _a : (plugin.publisher = plugin_ext_1.PluginIdentifiers.UNPUBLISHED);
            return plugin;
        }
        catch (_b) {
            return undefined;
        }
    }
    async getExtensionDir(context) {
        return node_1.FileUri.fsPath(this.deploymentDirectory.resolve(filenamify(context.pluginEntry().id(), { replacement: '_' })));
    }
};
__decorate([
    (0, inversify_1.inject)(plugin_cli_contribution_1.PluginCliContribution),
    __metadata("design:type", plugin_cli_contribution_1.PluginCliContribution)
], PluginVsCodeDirectoryHandler.prototype, "pluginCli", void 0);
PluginVsCodeDirectoryHandler = __decorate([
    (0, inversify_1.injectable)()
], PluginVsCodeDirectoryHandler);
exports.PluginVsCodeDirectoryHandler = PluginVsCodeDirectoryHandler;
//# sourceMappingURL=plugin-vscode-directory-handler.js.map