/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.handler;

import com.microsoft.java.test.plugin.launchers.JUnitLaunchUtils;
import com.microsoft.java.test.plugin.util.ProjectTestUtils;
import com.microsoft.java.test.plugin.util.TestSearchUtils;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;

public class TestDelegateCommandHandler
implements IDelegateCommandHandler {
    private static final String GET_TEST_SOURCE_PATH = "vscode.java.test.get.testpath";
    private static final String SEARCH_TEST_ITEMS = "vscode.java.test.search.items";
    private static final String SEARCH_TEST_ALL_ITEMS = "vscode.java.test.search.items.all";
    private static final String SEARCH_TEST_CODE_LENS = "vscode.java.test.search.codelens";
    private static final String SEARCH_TEST_LOCATION = "vscode.java.test.search.location";
    private static final String RESOLVE_JUNIT_ARGUMENT = "vscode.java.test.junit.argument";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        switch (commandId) {
            case "vscode.java.test.get.testpath": {
                return ProjectTestUtils.listTestSourcePaths(arguments, monitor);
            }
            case "vscode.java.test.search.items": {
                return TestSearchUtils.searchTestItems(arguments, monitor);
            }
            case "vscode.java.test.search.items.all": {
                return TestSearchUtils.searchAllTestItems(arguments, monitor);
            }
            case "vscode.java.test.search.codelens": {
                return TestSearchUtils.searchCodeLens(arguments, monitor);
            }
            case "vscode.java.test.search.location": {
                return TestSearchUtils.searchLocation(arguments, monitor);
            }
            case "vscode.java.test.junit.argument": {
                return JUnitLaunchUtils.resolveLaunchArgument(arguments, monitor);
            }
        }
        throw new UnsupportedOperationException(String.format("Java test plugin doesn't support the command '%s'.", commandId));
    }
}

