"use strict";
/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TheiaBlueprintGettingStartedWidget = void 0;
const React = require("react");
const inversify_1 = require("@theia/core/shared/inversify");
const branding_util_1 = require("./branding-util");
const getting_started_widget_1 = require("@theia/getting-started/lib/browser/getting-started-widget");
const vsx_environment_1 = require("@theia/vsx-registry/lib/common/vsx-environment");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const browser_1 = require("@theia/core/lib/browser");
const theia_blueprint_preferences_1 = require("./theia-blueprint-preferences");
const core_1 = require("@theia/core");
let TheiaBlueprintGettingStartedWidget = class TheiaBlueprintGettingStartedWidget extends getting_started_widget_1.GettingStartedWidget {
    constructor() {
        super(...arguments);
        this.toDispose = new core_1.DisposableCollection();
    }
    async init() {
        super.init();
        this.vscodeApiVersion = await this.environment.getVscodeApiVersion();
        await this.preferenceService.ready;
        this.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        const htmlElement = document.getElementById('alwaysShowWelcomePage');
        if (htmlElement) {
            htmlElement.focus();
        }
    }
    render() {
        return React.createElement("div", { className: 'gs-container' },
            React.createElement("div", { className: 'gs-float' },
                React.createElement("div", { className: 'gs-logo' }),
                this.renderActions()),
            this.renderHeader(),
            React.createElement("hr", { className: 'gs-hr' }),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, (0, branding_util_1.renderWhatIs)(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, (0, branding_util_1.renderWhatIsNot)())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, (0, branding_util_1.renderSupport)(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, (0, branding_util_1.renderTickets)(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, (0, branding_util_1.renderSourceCode)(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, (0, branding_util_1.renderDocumentation)(this.windowService))),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, (0, branding_util_1.renderDownloads)())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderPreferences())));
    }
    renderActions() {
        return React.createElement("div", { className: 'gs-container' },
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderOpen())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderRecentWorkspaces())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderSettings())),
            React.createElement("div", { className: 'flex-grid' },
                React.createElement("div", { className: 'col' }, this.renderHelp())));
    }
    renderHeader() {
        return React.createElement("div", { className: 'gs-header' },
            React.createElement("h1", null,
                "Eclipse Theia ",
                React.createElement("span", { className: 'gs-blue-header' }, "Blueprint")),
            this.renderVersion());
    }
    renderVersion() {
        return React.createElement("div", null,
            React.createElement("p", { className: 'gs-sub-header' }, this.applicationInfo ? 'Version ' + this.applicationInfo.version + ' (Beta)' : '(Beta)'),
            React.createElement("p", { className: 'gs-sub-header' }, 'VS Code API Version: ' + this.vscodeApiVersion));
    }
    renderPreferences() {
        return React.createElement(GSPreferences, { preferenceService: this.preferenceService });
    }
};
__decorate([
    (0, inversify_1.inject)(vsx_environment_1.VSXEnvironment),
    __metadata("design:type", Object)
], TheiaBlueprintGettingStartedWidget.prototype, "environment", void 0);
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], TheiaBlueprintGettingStartedWidget.prototype, "windowService", void 0);
__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    __metadata("design:type", Object)
], TheiaBlueprintGettingStartedWidget.prototype, "preferenceService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], TheiaBlueprintGettingStartedWidget.prototype, "init", null);
TheiaBlueprintGettingStartedWidget = __decorate([
    (0, inversify_1.injectable)()
], TheiaBlueprintGettingStartedWidget);
exports.TheiaBlueprintGettingStartedWidget = TheiaBlueprintGettingStartedWidget;
function GSPreferences(props) {
    const [alwaysShowWelcomePage, setAlwaysShowWelcomePage] = React.useState(props.preferenceService.get(theia_blueprint_preferences_1.BlueprintPreferences.alwaysShowWelcomePage, true));
    React.useEffect(() => {
        const preflistener = props.preferenceService.onPreferenceChanged(change => {
            if (change.preferenceName === theia_blueprint_preferences_1.BlueprintPreferences.alwaysShowWelcomePage) {
                const prefValue = change.newValue;
                console.info('Set blueprint.alwaysShowWelcomePage checkbox state to ' + prefValue);
                setAlwaysShowWelcomePage(prefValue);
            }
        });
        return () => preflistener.dispose();
    }, [props.preferenceService]);
    const handleChange = (e) => {
        const newChecked = e.target.checked;
        console.info('Set blueprint.alwaysShowWelcomePage pref to ' + newChecked);
        props.preferenceService.updateValue(theia_blueprint_preferences_1.BlueprintPreferences.alwaysShowWelcomePage, newChecked);
    };
    return React.createElement("div", { className: 'gs-preference' },
        React.createElement("input", { type: "checkbox", className: "theia-input", id: "alwaysShowWelcomePage", onChange: handleChange, checked: alwaysShowWelcomePage }),
        React.createElement("label", { htmlFor: "alwaysShowWelcomePage" }, "Show Welcome Page after every start of the application"));
}
//# sourceMappingURL=theia-blueprint-getting-started-widget.js.map