/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.internal.headless;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tea.core.services.TaskingHeadlessLifeCycle;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.osgi.service.component.annotations.Component;

@TaskingHeadlessLifeCycle.HeadlessPrority(value=2000)
@Component
public class WorkbenchStarter
implements TaskingHeadlessLifeCycle {
    private static final String PRODUCT_ID = "org.eclipse.tea.core.ui.HeadlessTaskingEngine";

    @TaskingHeadlessLifeCycle.HeadlessStartup
    public TaskingHeadlessLifeCycle.StartupAction startWorkbench(TaskingLog log) {
        if (Platform.getProduct() == null || !Platform.getProduct().getId().equals(PRODUCT_ID)) {
            throw new IllegalStateException("Use the org.eclipse.tea.core.ui.HeadlessTaskingEngine product to launch the tasking engine with Workbench support.");
        }
        log.debug("Starting up E4 Workbench...");
        Thread workbench = new Thread(() -> {
            Thread.currentThread().setName("Tasking Headless Workbench");
            try {
                Display display = PlatformUI.createDisplay();
                PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new WorkbenchAdvisor(){

                    public String getInitialWindowPerspectiveId() {
                        return null;
                    }
                });
            }
            catch (Exception e) {
                log.error("Failed to start the workbench - is a DISPLAY set?", (Throwable)e);
            }
        });
        workbench.setDaemon(true);
        workbench.start();
        while (!PlatformUI.isWorkbenchRunning()) {
            Thread.yield();
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return TaskingHeadlessLifeCycle.StartupAction.CONTINUE;
    }

    @TaskingHeadlessLifeCycle.HeadlessShutdown
    public void shutdown(TaskingLog log) throws Exception {
        WorkbenchStarter.cancelAutoBuild();
        Job[] jobArray = Job.getJobManager().find(null);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Job j = jobArray[n2];
            if (!j.isSystem()) {
                if (j.getState() != 4) {
                    j.cancel();
                }
                log.debug("Waiting on Job '" + j.getName() + "'...");
                j.join(10000L, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
        Display.getDefault().syncExec(() -> {
            boolean bl = PlatformUI.getWorkbench().close();
        });
    }

    private static void cancelAutoBuild() {
        Job[] jobs;
        Job[] jobArray = jobs = Job.getJobManager().find(null);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job j = jobArray[n2];
            if (j.belongsTo(ResourcesPlugin.FAMILY_AUTO_BUILD) || j.belongsTo(ResourcesPlugin.FAMILY_AUTO_REFRESH)) {
                j.cancel();
            }
            ++n2;
        }
    }
}

