/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.model.LaunchModel;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object element : (IStructuredSelection)selection) {
                if (!this.canDelete(element)) continue;
                this.delete(element);
            }
        }
        return null;
    }

    public boolean canDelete(Object element) {
        if (element instanceof LaunchNode) {
            LaunchNode node = (LaunchNode)((Object)element);
            return node.isType("launchConfig") && (node.getModel().getModelRoot() instanceof ICategory || !node.getLaunchConfiguration().isReadOnly());
        }
        return false;
    }

    private void delete(Object element) {
        Assert.isNotNull((Object)element);
        if (element instanceof LaunchNode) {
            LaunchNode node = (LaunchNode)((Object)element);
            if (node.getModel().getModelRoot() instanceof ICategory) {
                Managers.getCategoryManager().remove(((ICategory)node.getModel().getModelRoot()).getId(), LaunchModel.getCategoryId(node.getLaunchConfiguration()));
            } else if (MessageDialog.openQuestion((Shell)UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DeleteHandlerDelegate_question_title, (String)NLS.bind((String)Messages.DeleteHandlerDelegate_question_message, (Object)node.getLaunchConfiguration().getName()))) {
                try {
                    node.getLaunchConfiguration().delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

