/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.console;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.tcf.te.runtime.preferences.ScopedEclipsePreferences;
import org.eclipse.tcf.te.tcf.ui.console.activator.UIPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class AbstractConsole
extends MessageConsole
implements IConsoleListener,
IEclipsePreferences.IPreferenceChangeListener,
IPropertyChangeListener {
    private final Map<String, Color> streamColors = new HashMap<String, Color>();
    private final Map<String, MessageConsoleStream> streams = new HashMap<String, MessageConsoleStream>();
    private final ConsoleBuffer buffer = new ConsoleBuffer();
    private boolean showOnOutput = UIPlugin.getScopedPreferences().getBoolean("te.tcf.ui.console.pref.showOnOutput");
    private boolean showOnFirstOutput = !this.showOnOutput;
    private boolean visible = false;
    private boolean initialized = false;
    private static final String[] STREAM_TYPES = new String[]{"te.tcf.ui.console.pref.color.text", "te.tcf.ui.console.pref.color.command", "te.tcf.ui.console.pref.color.commandResponse", "te.tcf.ui.console.pref.color.event", "te.tcf.ui.console.pref.color.progress", "te.tcf.ui.console.pref.color.error"};

    public AbstractConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
        UIPlugin.getScopedPreferences().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        ConsoleBuffer consoleBuffer = this.buffer;
        synchronized (consoleBuffer) {
            this.visible = false;
            JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        }
    }

    public void shutdown() {
        UIPlugin.getScopedPreferences().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
        for (Color color : this.streamColors.values()) {
            color.dispose();
        }
        this.streamColors.clear();
        this.streams.clear();
    }

    protected void init() {
        super.init();
        this.initConsoleOutputLimitSettings();
        this.initConsoleWidthSetting();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)AbstractConsole.this);
                AbstractConsole.this.initializeStreams();
                AbstractConsole.this.flushBuffer();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flushBuffer() {
        ConsoleBuffer consoleBuffer = this.buffer;
        synchronized (consoleBuffer) {
            this.visible = true;
            ConsoleBufferLine[] consoleBufferLineArray = this.buffer.getLinesAndClear();
            int n = consoleBufferLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                ConsoleBufferLine line = consoleBufferLineArray[n2];
                this.appendMessage(line.messageType, line.message);
                ++n2;
            }
        }
    }

    private void initConsoleWidthSetting() {
        ScopedEclipsePreferences store = UIPlugin.getScopedPreferences();
        if (store.getBoolean("te.tcf.ui.console.pref.fixedWidth")) {
            this.setConsoleWidth(store.getInt("te.tcf.ui.console.pref.width"));
        } else {
            this.setConsoleWidth(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConsoleOutputLimitSettings() {
        ScopedEclipsePreferences store = UIPlugin.getScopedPreferences();
        if (store.getBoolean("te.tcf.ui.console.pref.limitOutput")) {
            this.setWaterMarks(1000, store.getInt("te.tcf.ui.console.pref.bufferSize"));
        } else {
            this.setWaterMarks(-1, 0);
        }
        ConsoleBuffer consoleBuffer = this.buffer;
        synchronized (consoleBuffer) {
            this.buffer.setBufferLimit(this.getHighWaterMark());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeStreams() {
        ConsoleBuffer consoleBuffer = this.buffer;
        synchronized (consoleBuffer) {
            if (!this.initialized) {
                RGB defaultColorBlack = PlatformUI.getWorkbench().getDisplay().getSystemColor(2).getRGB();
                String[] stringArray = STREAM_TYPES;
                int n = STREAM_TYPES.length;
                int n2 = 0;
                while (n2 < n) {
                    String streamType = stringArray[n2];
                    MessageConsoleStream stream = this.newMessageStream();
                    Color color = new Color((Device)PlatformUI.getWorkbench().getDisplay(), StringConverter.asRGB((String)UIPlugin.getScopedPreferences().getString(streamType), (RGB)defaultColorBlack));
                    stream.setColor(color);
                    this.streams.put(streamType, stream);
                    this.streamColors.put(streamType, color);
                    ++n2;
                }
                this.setFont(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().get("te.tcf.ui.console.pref.font"));
                this.initialized = true;
            }
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        Assert.isNotNull((Object)event);
        String property = event.getKey();
        if (property == null) {
            return;
        }
        if ("te.tcf.ui.console.pref.fixedWidth".equals(property)) {
            this.initConsoleWidthSetting();
        } else if ("te.tcf.ui.console.pref.limitOutput".equals(property)) {
            this.initConsoleOutputLimitSettings();
        } else if ("te.tcf.ui.console.pref.showOnOutput".equals(property)) {
            this.showOnOutput = UIPlugin.getScopedPreferences().getBoolean("te.tcf.ui.console.pref.showOnOutput");
        }
        if (this.isVisible()) {
            RGB defaultColorBlack = PlatformUI.getWorkbench().getDisplay().getSystemColor(2).getRGB();
            String[] stringArray = STREAM_TYPES;
            int n = STREAM_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String streamType = stringArray[n2];
                if (property.equals(streamType)) {
                    RGB newRGB = StringConverter.asRGB((String)UIPlugin.getScopedPreferences().getString(streamType), (RGB)defaultColorBlack);
                    Color oldColor = this.streamColors.get(streamType);
                    if (oldColor == null && newRGB != null || oldColor != null && !oldColor.getRGB().equals((Object)newRGB)) {
                        Color newColor = new Color((Device)PlatformUI.getWorkbench().getDisplay(), newRGB);
                        MessageConsoleStream stream = this.streams.get(streamType);
                        stream.setColor(newColor);
                        if (oldColor != null) {
                            oldColor.dispose();
                        }
                        this.streamColors.put(streamType, newColor);
                    }
                }
                ++n2;
            }
        }
    }

    public void consolesAdded(IConsole[] consoles) {
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console == this) {
                ConsolePlugin.getDefault().getConsoleManager().addConsoleListener((IConsoleListener)this);
                this.init();
            }
            ++i;
        }
    }

    public void consolesRemoved(IConsole[] consoles) {
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            if (console == this) {
                ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                this.dispose();
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property;
        String string = property = event != null ? event.getProperty() : null;
        if (property != null && this.isVisible() && property.equals("te.tcf.ui.console.pref.font")) {
            this.setFont(((FontRegistry)event.getSource()).get("te.tcf.ui.console.pref.font"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendMessage(char type, String message) {
        block18: {
            if (message == null) {
                return;
            }
            this.showConsole(false);
            ConsoleBuffer consoleBuffer = this.buffer;
            synchronized (consoleBuffer) {
                block17: {
                    if (!this.isVisible()) break block17;
                    switch (type) {
                        case 'C': {
                            MessageConsoleStream stream = this.streams.get("te.tcf.ui.console.pref.color.command");
                            if (stream != null) {
                                stream.println(message);
                                break;
                            }
                            break block18;
                        }
                        case 'R': {
                            MessageConsoleStream stream = this.streams.get("te.tcf.ui.console.pref.color.commandResponse");
                            if (stream != null) {
                                stream.println(message);
                                break;
                            }
                            break block18;
                        }
                        case 'E': {
                            MessageConsoleStream stream = this.streams.get("te.tcf.ui.console.pref.color.event");
                            if (stream != null) {
                                stream.println(message);
                                break;
                            }
                            break block18;
                        }
                        case 'P': {
                            MessageConsoleStream stream = this.streams.get("te.tcf.ui.console.pref.color.progress");
                            if (stream != null) {
                                stream.println(message);
                                break;
                            }
                            break block18;
                        }
                        case 'F': 
                        case 'N': {
                            MessageConsoleStream stream = this.streams.get("te.tcf.ui.console.pref.color.text");
                            if (stream != null) {
                                stream.println(message);
                                break;
                            }
                            break block18;
                        }
                        default: {
                            MessageConsoleStream stream = this.streams.get("te.tcf.ui.console.pref.color.error");
                            if (stream != null) {
                                stream.println(message);
                                break;
                            }
                            break block18;
                        }
                    }
                    break block18;
                }
                this.buffer.addLine(new ConsoleBufferLine(message, type));
            }
        }
    }

    private void showConsole(boolean showNoMatterWhat) {
        if (showNoMatterWhat || this.showOnOutput || this.showOnFirstOutput) {
            this.showOnFirstOutput = false;
            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
        }
    }

    protected static class ConsoleBuffer {
        private int bufferLimit = 0;
        private int charactersConsumed = 0;
        private final List<ConsoleBufferLine> lines = new ArrayList<ConsoleBufferLine>();

        public void setBufferLimit(int limit) {
            this.bufferLimit = limit > 0 ? limit : 0;
        }

        public void addLine(ConsoleBufferLine line) {
            Assert.isNotNull((Object)line);
            while (this.bufferLimit > 0 && this.charactersConsumed + line.message.length() >= this.bufferLimit) {
                ConsoleBufferLine droppedLine = this.lines.remove(0);
                this.charactersConsumed -= droppedLine.message.length();
                if (this.charactersConsumed >= 0) continue;
                this.charactersConsumed = 0;
            }
            this.lines.add(line);
            this.charactersConsumed += line.message.length();
        }

        public ConsoleBufferLine[] getLinesAndClear() {
            ConsoleBufferLine[] result = this.lines.toArray(new ConsoleBufferLine[this.lines.size()]);
            this.lines.clear();
            return result;
        }
    }

    protected static final class ConsoleBufferLine {
        public final String message;
        public final char messageType;

        public ConsoleBufferLine(String message, char messageType) {
            Assert.isNotNull((Object)message);
            this.message = message;
            this.messageType = messageType;
        }
    }
}

