/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.debug.ui.ITCFPresentationProvider;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.osgi.framework.Bundle;

public class TCFPresentationProvider {
    private static ArrayList<ITCFPresentationProvider> providers;

    public static Iterable<ITCFPresentationProvider> getPresentationProviders() {
        if (providers == null) {
            ArrayList<ITCFPresentationProvider> list = new ArrayList<ITCFPresentationProvider>();
            try {
                IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tcf.debug.ui", "presentation_provider");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    try {
                        Bundle bundle = Platform.getBundle((String)extensions[i].getContributor().getName());
                        bundle.start(1);
                        IConfigurationElement[] e = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < e.length) {
                            String nm = e[j].getName();
                            if (nm.equals("class")) {
                                Class c = bundle.loadClass(e[j].getAttribute("name"));
                                list.add((ITCFPresentationProvider)c.newInstance());
                            }
                            ++j;
                        }
                    }
                    catch (Throwable x) {
                        Activator.log("Cannot access presentation provider extension points", x);
                    }
                    ++i;
                }
            }
            catch (Exception x) {
                Activator.log("Cannot access presentation provider extension points", x);
            }
            providers = list;
        }
        return providers;
    }
}

