/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.channelmanager;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperOperationService;
import org.eclipse.tcf.te.runtime.stepper.job.StepperJob;
import org.eclipse.tcf.te.runtime.stepper.utils.StepperHelper;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.events.ChannelEvent;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.internal.channelmanager.StreamListenerProxy;
import org.eclipse.tcf.te.tcf.core.nls.Messages;
import org.eclipse.tcf.te.tcf.core.va.ValueAddManager;
import org.eclipse.tcf.te.tcf.core.va.interfaces.IValueAdd;

public class ChannelManager
extends PlatformObject
implements IChannelManager {
    final Map<IChannel, AtomicInteger> refCounters = new HashMap<IChannel, AtomicInteger>();
    final Map<String, IChannel> channels = new HashMap<String, IChannel>();
    final Map<String, List<IChannelManager.DoneOpenChannel>> pendingDones = new HashMap<String, List<IChannelManager.DoneOpenChannel>>();
    final List<IChannel> forcedChannels = new ArrayList<IChannel>();
    final Map<IChannel, Map<String, Boolean>> forcedChannelFlags = new HashMap<IChannel, Map<String, Boolean>>();
    final Map<IChannel, List<StreamListenerProxy>> streamProxies = new HashMap<IChannel, List<StreamListenerProxy>>();
    final Map<String, StepperJob> pendingOpenChannel = new HashMap<String, StepperJob>();
    final Map<IChannel, StepperJob> pendingCloseChannel = new HashMap<IChannel, StepperJob>();
    final Map<IChannel, IPeer> c2p = new HashMap<IChannel, IPeer>();

    @Override
    public void openChannel(IPeer peer, Map<String, Boolean> flags, IChannelManager.DoneOpenChannel done) {
        this.openChannel(peer, flags, done, null);
    }

    @Override
    public void openChannel(IPeer peer, Map<String, Boolean> flags, final IChannelManager.DoneOpenChannel done, final IProgressMonitor monitor) {
        boolean noPathMap;
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)done);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(1, "trace/channelManager")) {
            try {
                throw new Throwable();
            }
            catch (Throwable e) {
                CoreBundleActivator.getTraceHandler().trace("ChannelManager#openChannel called from:", 1, "trace/channelManager", 1, (Object)this);
                e.printStackTrace();
            }
        }
        final IChannelManager.DoneOpenChannel internalDone = new IChannelManager.DoneOpenChannel(){

            @Override
            public void doneOpenChannel(final Throwable error, final IChannel channel) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        done.doneOpenChannel(error, channel);
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeLater((Runnable)runnable);
                }
            }
        };
        IChannel channel = null;
        final String id = peer.getID();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
            CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_message, (Object)id, flags), 0, "trace/channelManager", 1, (Object)this);
        }
        boolean forceNew = flags != null && flags.containsKey("channel.forceNew") ? flags.get("channel.forceNew") : false;
        boolean noValueAdd = flags != null && flags.containsKey("channel.noValueAdd") ? flags.get("channel.noValueAdd") : false;
        boolean bl = noPathMap = flags != null && flags.containsKey("channel.noPathMap") ? flags.get("channel.noPathMap") : false;
        if (noValueAdd || noPathMap) {
            forceNew = true;
        }
        final boolean finForceNew = forceNew;
        if (!forceNew) {
            channel = this.channels.get(id);
        }
        if (channel != null) {
            if (channel.getState() == 1) {
                AtomicInteger counter = this.refCounters.get(channel);
                if (counter == null) {
                    counter = new AtomicInteger(0);
                    this.refCounters.put(channel, counter);
                }
                counter.incrementAndGet();
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_reuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
                }
                internalDone.doneOpenChannel(null, channel);
            } else if (channel.getState() == 0) {
                List<IChannelManager.DoneOpenChannel> dones = this.pendingDones.get(id);
                if (dones == null) {
                    dones = new ArrayList<IChannelManager.DoneOpenChannel>();
                    this.pendingDones.put(id, dones);
                }
                Assert.isNotNull(dones);
                dones.add(internalDone);
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_pending_message, (Object)id, (Object)("0x" + Integer.toHexString(internalDone.hashCode()))), 0, "trace/channelManager", 1, (Object)this);
                }
            } else {
                this.channels.remove(id);
                this.refCounters.remove(channel);
                this.c2p.remove(channel);
                channel = null;
            }
        }
        if (channel == null) {
            StepperJob job;
            StepperJob stepperJob = job = !forceNew ? this.pendingOpenChannel.get(id) : null;
            if (job == null) {
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_new_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                }
                PropertiesContainer data = new PropertiesContainer();
                data.setProperty("channel.forceNew", forceNew);
                data.setProperty("channel.noValueAdd", noValueAdd);
                data.setProperty("channel.noPathMap", noPathMap);
                data.setProperty("org.eclipse.tcf.te.runtime.stepper.skip_last_run_history", true);
                Callback callback = new Callback((IPropertiesContainer)data, flags, peer){
                    private final /* synthetic */ IPropertiesContainer val$data;
                    private final /* synthetic */ Map val$flags;
                    private final /* synthetic */ IPeer val$peer;
                    {
                        this.val$data = iPropertiesContainer;
                        this.val$flags = map;
                        this.val$peer = iPeer;
                    }

                    protected void internalDone(Object caller, IStatus status) {
                        block12: {
                            List<IChannelManager.DoneOpenChannel> pending;
                            block11: {
                                if (status.getSeverity() != 4) break block11;
                                Throwable error = status.getException();
                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_failed_message, (Object)id, (Object)error), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                                }
                                if (!finForceNew) {
                                    ChannelManager.this.pendingOpenChannel.remove(id);
                                }
                                internalDone.doneOpenChannel(error, null);
                                List<IChannelManager.DoneOpenChannel> pending2 = ChannelManager.this.pendingDones.remove(id);
                                if (pending2 == null || pending2.isEmpty()) break block12;
                                for (IChannelManager.DoneOpenChannel d : pending2) {
                                    d.doneOpenChannel(error, null);
                                }
                                break block12;
                            }
                            IChannel channel = (IChannel)this.val$data.getProperty("org.eclipse.tcf.te.tcf.locator.channel");
                            Assert.isNotNull((Object)channel);
                            Assert.isTrue((channel.getState() == 1 ? 1 : 0) != 0);
                            if (!finForceNew) {
                                ChannelManager.this.channels.put(id, channel);
                            }
                            if (!finForceNew) {
                                ChannelManager.this.refCounters.put(channel, new AtomicInteger(1));
                            }
                            if (finForceNew) {
                                ChannelManager.this.forcedChannels.add(channel);
                            }
                            if (finForceNew) {
                                ChannelManager.this.forcedChannelFlags.put(channel, this.val$flags);
                            }
                            ChannelManager.this.c2p.put(channel, this.val$peer);
                            if (!finForceNew) {
                                ChannelManager.this.pendingOpenChannel.remove(id);
                            }
                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_success_message, (Object)id), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                            }
                            internalDone.doneOpenChannel(null, channel);
                            if (!finForceNew && (pending = ChannelManager.this.pendingDones.remove(id)) != null && !pending.isEmpty()) {
                                for (IChannelManager.DoneOpenChannel d : pending) {
                                    d.doneOpenChannel(null, channel);
                                }
                            }
                        }
                    }
                };
                IStepperOperationService stepperOperationService = StepperHelper.getService((Object)peer, (String)"openChannel");
                IStepContext stepContext = stepperOperationService.getStepContext((Object)peer, "openChannel");
                String stepGroupId = stepperOperationService.getStepGroupId((Object)peer, "openChannel");
                if (stepGroupId != null && stepContext != null) {
                    String name = stepperOperationService.getStepGroupName((Object)peer, "openChannel");
                    boolean isCancelable = stepperOperationService.isCancelable((Object)peer, "openChannel");
                    job = new StepperJob(name != null ? name : "", stepContext, stepperOperationService.getStepGroupData((Object)peer, "openChannel", (IPropertiesContainer)data), stepGroupId, "openChannel", isCancelable, true);
                    job.setJobCallback((ICallback)callback);
                    job.markStatusHandled();
                    if (monitor != null) {
                        final StepperJob finalJob = job;
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                finalJob.run(monitor);
                            }
                        }, job.getName());
                        thread.start();
                    } else {
                        job.schedule();
                    }
                }
                if (job != null && !forceNew) {
                    this.pendingOpenChannel.put(id, job);
                }
            } else {
                List<IChannelManager.DoneOpenChannel> dones = this.pendingDones.get(id);
                if (dones == null) {
                    dones = new ArrayList<IChannelManager.DoneOpenChannel>();
                    this.pendingDones.put(id, dones);
                }
                Assert.isNotNull(dones);
                dones.add(internalDone);
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_openChannel_pending_message, (Object)id, (Object)("0x" + Integer.toHexString(internalDone.hashCode()))), 0, "trace/channelManager", 1, (Object)this);
                }
            }
        }
    }

    @Override
    public IChannel getChannel(final IPeer peer) {
        final AtomicReference channel = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                channel.set(ChannelManager.this.internalGetChannel(peer));
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return (IChannel)channel.get();
    }

    public IChannel internalGetChannel(IPeer peer) {
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String id = peer.getID();
        IChannel channel = this.channels.get(id);
        if (channel != null && channel.getState() != 1 && channel.getState() != 0) {
            this.channels.remove(id);
            this.refCounters.remove(channel);
            this.c2p.remove(channel);
            channel = null;
        }
        return channel;
    }

    @Override
    public void closeChannel(IChannel channel) {
        this.closeChannel(channel, null);
    }

    @Override
    public void closeChannel(final IChannel channel, final IProgressMonitor monitor) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalCloseChannel(channel, monitor);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalCloseChannel(final IChannel channel, final IProgressMonitor monitor) {
        block14: {
            AtomicInteger counter;
            String id;
            block10: {
                block11: {
                    PropertiesContainer data;
                    StepperJob job;
                    boolean isRefCounted;
                    IPeer peer;
                    block13: {
                        block12: {
                            Assert.isNotNull((Object)channel);
                            Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                            IPeer p = this.c2p.get(channel);
                            peer = p != null ? p : channel.getRemotePeer();
                            id = peer.getID();
                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                            }
                            isRefCounted = !this.forcedChannels.contains(channel);
                            AtomicInteger atomicInteger = counter = isRefCounted ? this.refCounters.get(channel) : null;
                            if (counter != null && counter.decrementAndGet() != 0) break block10;
                            job = this.pendingCloseChannel.get(channel);
                            if (job != null) break block11;
                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_close_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                            }
                            data = new PropertiesContainer();
                            data.setProperty("org.eclipse.tcf.te.tcf.locator.channel", (Object)channel);
                            data.setProperty("org.eclipse.tcf.te.runtime.stepper.skip_last_run_history", true);
                            if (isRefCounted) break block12;
                            IChannel shared = this.channels.get(id);
                            if (shared == null || shared.getState() != 1 && shared.getState() != 0) break block13;
                            data.setProperty("ShutdownValueAddStep.skip", true);
                            break block13;
                        }
                        for (IChannel c : this.forcedChannels) {
                            boolean noValueAdd;
                            if (!id.equals(c.getRemotePeer().getID())) continue;
                            Map<String, Boolean> flags = this.forcedChannelFlags.get(c);
                            boolean bl = noValueAdd = flags != null && flags.containsKey("channel.noValueAdd") ? flags.get("channel.noValueAdd") : false;
                            if (noValueAdd) continue;
                            data.setProperty("ShutdownValueAddStep.skip", true);
                            break;
                        }
                    }
                    Callback callback = new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            if (status.getSeverity() == 4) {
                                Throwable error = status.getException();
                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_failed_message, (Object)id, (Object)error), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                                }
                                ChannelManager.this.pendingCloseChannel.remove(channel);
                            } else {
                                ChannelManager.this.pendingCloseChannel.remove(channel);
                                if (isRefCounted) {
                                    ChannelManager.this.channels.remove(id);
                                }
                                if (isRefCounted) {
                                    ChannelManager.this.refCounters.remove(channel);
                                }
                                if (!isRefCounted) {
                                    ChannelManager.this.forcedChannels.remove(channel);
                                }
                                if (!isRefCounted) {
                                    ChannelManager.this.forcedChannelFlags.remove(channel);
                                }
                                ChannelManager.this.c2p.remove(channel);
                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_closed_message, (Object)id), 0, "trace/channelManager", 1, (Object)ChannelManager.this);
                                }
                            }
                            ChannelEvent event = new ChannelEvent(ChannelManager.this, channel, "close", null);
                            EventManager.getInstance().fireEvent((EventObject)event);
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    boolean closeWriter;
                                    boolean bl = closeWriter = ChannelManager.this.internalGetChannel(peer) == null;
                                    if (closeWriter) {
                                        for (IChannel c : (this).ChannelManager.this.forcedChannels) {
                                            if (!id.equals(c.getRemotePeer().getID()) || c.getState() == 2) continue;
                                            closeWriter = false;
                                            break;
                                        }
                                        if (closeWriter) {
                                            ChannelEvent event = new ChannelEvent(ChannelManager.this, channel, "closeWriter", null);
                                            EventManager.getInstance().fireEvent((EventObject)event);
                                        }
                                    }
                                }
                            };
                            if (Protocol.isDispatchThread()) {
                                runnable.run();
                            } else {
                                Protocol.invokeLater((Runnable)runnable);
                            }
                        }
                    };
                    IStepperOperationService stepperOperationService = StepperHelper.getService((Object)peer, (String)"closeChannel");
                    IStepContext stepContext = stepperOperationService.getStepContext((Object)peer, "closeChannel");
                    String stepGroupId = stepperOperationService.getStepGroupId((Object)peer, "closeChannel");
                    if (stepGroupId != null && stepContext != null) {
                        String name = stepperOperationService.getStepGroupName((Object)peer, "closeChannel");
                        boolean isCancelable = stepperOperationService.isCancelable((Object)peer, "closeChannel");
                        job = new StepperJob(name != null ? name : "", stepContext, stepperOperationService.getStepGroupData((Object)peer, "closeChannel", (IPropertiesContainer)data), stepGroupId, "closeChannel", isCancelable, true);
                        job.setJobCallback((ICallback)callback);
                        job.markStatusHandled();
                        if (monitor != null) {
                            final StepperJob finalJob = job;
                            Thread thread = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    finalJob.run(monitor);
                                }
                            }, "Close channel to " + job.getName());
                            thread.start();
                        } else {
                            job.schedule();
                        }
                    }
                    if (job != null) {
                        this.pendingCloseChannel.put(channel, job);
                    }
                    break block14;
                }
                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                    CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_pending_message, (Object)id), 0, "trace/channelManager", 1, (Object)this);
                }
                break block14;
            }
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/channelManager")) {
                CoreBundleActivator.getTraceHandler().trace(NLS.bind((String)Messages.ChannelManager_closeChannel_inuse_message, (Object)id, (Object)counter.toString()), 0, "trace/channelManager", 1, (Object)this);
            }
        }
        ListIterator<IChannel> iter = this.forcedChannels.listIterator();
        while (iter.hasNext()) {
            IChannel c = iter.next();
            if (c.getState() != 2) continue;
            iter.remove();
            this.forcedChannelFlags.remove(c);
            this.c2p.remove(c);
        }
    }

    @Override
    public void shutdown(final IPeer peer, boolean wait) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalShutdown(peer);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else if (wait) {
            Protocol.invokeAndWait((Runnable)runnable);
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    @Override
    public void shutdown(IPeer peer) {
        this.shutdown(peer, false);
    }

    void internalShutdown(IPeer peer) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)peer);
        String id = peer.getID();
        ListIterator<IChannel> iter = this.forcedChannels.listIterator();
        while (iter.hasNext()) {
            IChannel c = iter.next();
            if (!id.equals(c.getRemotePeer().getID())) continue;
            c.close();
            iter.remove();
            this.forcedChannelFlags.remove(c);
        }
        IChannel channel = this.internalGetChannel(peer);
        if (channel != null) {
            this.refCounters.remove(channel);
            this.channels.remove(channel.getRemotePeer().getID());
            this.c2p.remove(channel);
            channel.close();
            ChannelEvent event = new ChannelEvent(this, channel, "close", null);
            EventManager.getInstance().fireEvent((EventObject)event);
            event = new ChannelEvent(this, channel, "closeWriter", null);
            EventManager.getInstance().fireEvent((EventObject)event);
        }
        try {
            IValueAdd[] valueAdds = ValueAddManager.getInstance().getValueAdd(peer);
            if (valueAdds != null) {
                IValueAdd[] iValueAddArray = valueAdds;
                int n = valueAdds.length;
                int n2 = 0;
                while (n2 < n) {
                    IValueAdd valueAdd = iValueAddArray[n2];
                    valueAdd.shutdown(peer.getID(), (ICallback)new Callback());
                    ++n2;
                }
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void closeAll(boolean wait) {
        if (wait) {
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
                ChannelManager.this.internalCloseAll();
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else if (wait) {
            Protocol.invokeAndWait((Runnable)runnable);
        } else {
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    void internalCloseAll() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IChannel[] openChannels = this.channels.values().toArray(new IChannel[this.channels.values().size()]);
        this.refCounters.clear();
        this.channels.clear();
        IChannel[] iChannelArray = openChannels;
        int n = openChannels.length;
        int n2 = 0;
        while (n2 < n) {
            IChannel channel = iChannelArray[n2];
            this.internalCloseChannel(channel, null);
            ++n2;
        }
        this.c2p.clear();
    }

    @Override
    public void subscribeStream(final IChannel channel, String streamType, final IChannelManager.IStreamsListener listener, final IChannelManager.DoneSubscribeStream done) {
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)streamType);
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)done);
        if (channel.getState() != 1) {
            done.doneSubscribeStream(new Exception(Messages.ChannelManager_stream_closed_message));
            return;
        }
        StreamListenerProxy proxy = null;
        List<StreamListenerProxy> proxies = this.streamProxies.get(channel);
        if (proxies != null) {
            for (StreamListenerProxy candidate : proxies) {
                if (!streamType.equals(candidate.getStreamType())) continue;
                proxy = candidate;
                break;
            }
        }
        if (proxy != null) {
            proxy.addListener(listener);
            done.doneSubscribeStream(null);
        } else {
            proxy = new StreamListenerProxy(channel, streamType);
            if (proxies == null) {
                proxies = new ArrayList<StreamListenerProxy>();
                this.streamProxies.put(channel, proxies);
            }
            proxies.add(proxy);
            proxy.addListener(listener);
            IStreams service = (IStreams)channel.getRemoteService(IStreams.class);
            if (service != null) {
                final StreamListenerProxy finProxy = proxy;
                final List<StreamListenerProxy> finProxies = proxies;
                service.subscribe(streamType, (IStreams.StreamsListener)proxy, new IStreams.DoneSubscribe(){

                    public void doneSubscribe(IToken token, Exception error) {
                        if (error != null) {
                            finProxy.removeListener(listener);
                            if (finProxy.isEmpty()) {
                                finProxies.remove(finProxy);
                            }
                            if (finProxies.isEmpty()) {
                                ChannelManager.this.streamProxies.remove(channel);
                            }
                        }
                        done.doneSubscribeStream(error);
                    }
                });
            } else {
                proxy.removeListener(listener);
                if (proxy.isEmpty()) {
                    proxies.remove(proxy);
                }
                if (proxies.isEmpty()) {
                    this.streamProxies.remove(channel);
                }
                done.doneSubscribeStream(new Exception(Messages.ChannelManager_stream_missing_service_message));
            }
        }
    }

    @Override
    public void unsubscribeStream(IChannel channel, String streamType, IChannelManager.IStreamsListener listener, final IChannelManager.DoneUnsubscribeStream done) {
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)streamType);
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)done);
        if (channel.getState() != 1) {
            done.doneUnsubscribeStream(new Exception(Messages.ChannelManager_stream_closed_message));
            return;
        }
        StreamListenerProxy proxy = null;
        List<StreamListenerProxy> proxies = this.streamProxies.get(channel);
        if (proxies != null) {
            for (StreamListenerProxy candidate : proxies) {
                if (!streamType.equals(candidate.getStreamType())) continue;
                proxy = candidate;
                break;
            }
        }
        if (proxy != null) {
            proxy.removeListener(listener);
            if (proxy.isEmpty()) {
                IStreams service;
                proxies.remove(proxy);
                if (proxies.isEmpty()) {
                    this.streamProxies.remove(channel);
                }
                if ((service = (IStreams)channel.getRemoteService(IStreams.class)) != null) {
                    service.unsubscribe(streamType, (IStreams.StreamsListener)proxy, new IStreams.DoneUnsubscribe(){

                        public void doneUnsubscribe(IToken token, Exception error) {
                            done.doneUnsubscribeStream(error);
                        }
                    });
                } else {
                    done.doneUnsubscribeStream(new Exception(Messages.ChannelManager_stream_missing_service_message));
                }
            } else {
                done.doneUnsubscribeStream(null);
            }
        } else {
            done.doneUnsubscribeStream(null);
        }
    }
}

