/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server.jetty;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.http.content.ResourceHttpContent;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class PathResourceHttpContentFactory
implements HttpContent.Factory {
    private final ResourceFactory factory = new PathResourceFactory();
    private final MimeTypes mimeTypes;

    public PathResourceHttpContentFactory(MimeTypes mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public @Nullable HttpContent getContent(String pathInContext) throws IOException {
        Resource resource;
        block3: {
            try {
                resource = this.factory.newResource(pathInContext);
                if (resource != null && !Resources.missing((Resource)resource)) break block3;
                return null;
            }
            catch (Throwable t) {
                InvalidPathException saferException = new InvalidPathException(pathInContext, "Invalid pathInContext");
                saferException.initCause(t);
                throw saferException;
            }
        }
        return this.load(pathInContext, resource);
    }

    public @Nullable HttpContent getContent(Path path, String pathInContext) throws IOException {
        Resource resource;
        block3: {
            try {
                resource = this.factory.newResource(path);
                if (resource != null && !Resources.missing((Resource)resource)) break block3;
                return null;
            }
            catch (Throwable t) {
                InvalidPathException saferException = new InvalidPathException(pathInContext, "Invalid path");
                saferException.initCause(t);
                throw saferException;
            }
        }
        return this.load(pathInContext, resource);
    }

    private @Nullable HttpContent load(String pathInContext, Resource resource) {
        return new ResourceHttpContent(resource, this.mimeTypes.getMimeByExtension(pathInContext));
    }
}

