/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;
import org.eclipse.statet.r.core.source.ast.StdBinary;

@NonNullByDefault
public abstract class Arithmetic
extends StdBinary {
    Arithmetic() {
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return this.getNodeType() == element.getNodeType();
    }

    static final class Div
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.MULT;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.DIV;
        }
    }

    static final class Minus
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.ADD;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.MINUS;
        }
    }

    static final class Mult
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.MULT;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.MULT;
        }
    }

    static final class Plus
    extends Arithmetic {
        @Override
        public final NodeType getNodeType() {
            return NodeType.ADD;
        }

        @Override
        public RTerminal getOperator(int index) {
            return RTerminal.PLUS;
        }
    }
}

