/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFunctionSpec;
import org.eclipse.statet.r.core.model.RFunctionSpecBuilder;
import org.eclipse.statet.r.core.source.RSourceConfig;

@NonNullByDefault
public class RCoreFunctions {
    private static final RCoreFunctions DEFAULT = new RCoreFunctions();
    public static final String BASE_PACKAGE_NAME = "base";
    public static final RElementName BASE_PACKAGE_NS_ELEMENT_NAME = RElementName.create(33, "base");
    public static final String BASE_ASSIGN_NAME = "assign";
    public static final RElementName BASE_ASSIGN_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "assign");
    public final RFunctionSpec BASE_ASSIGN_fSpec;
    public static final String BASE_REMOVE_NAME = "remove";
    public static final RElementName BASE_REMOVE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "remove");
    public static final String BASE_REMOVE_ALIAS_RM = "rm";
    public static final RElementName BASE_REMOVE_ALIAS_RM_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "rm");
    public final RFunctionSpec BASE_REMOVE_fSpec;
    public static final String BASE_EXISTS_NAME = "exists";
    public static final RElementName BASE_EXISTS_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "exists");
    public final RFunctionSpec BASE_EXISTS_fSpec;
    public static final String BASE_GET_NAME = "get";
    public static final RElementName BASE_GET_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "get");
    public final RFunctionSpec BASE_GET_fSpec;
    public static final String BASE_SAVE_NAME = "save";
    public static final RElementName BASE_SAVE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "save");
    public final RFunctionSpec BASE_SAVE_fSpec;
    public static final String BASE_CALL_NAME = "call";
    public static final RElementName BASE_CALL_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "call");
    public final RFunctionSpec BASE_CALL_fSpec;
    public static final String BASE_DOCALL_NAME = "do.call";
    public static final RElementName BASE_DOCALL_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "do.call");
    public final RFunctionSpec BASE_DOCALL_fSpec;
    public static final String BASE_LIBRARY_NAME = "library";
    public static final RElementName BASE_LIBRARY_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "library");
    public final RFunctionSpec BASE_LIBRARY_fSpec;
    public static final String BASE_REQUIRE_NAME = "require";
    public static final RElementName BASE_REQUIRE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "require");
    public final RFunctionSpec BASE_REQUIRE_fSpec;
    public static final String BASE_GLOBALENV_NAME = "globalenv";
    public static final RElementName BASE_GLOBALENV_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "globalenv");
    public final RFunctionSpec BASE_GLOBALENV_fSpec;
    public static final String BASE_TOPENV_NAME = "topenv";
    public static final RElementName BASE_TOPENV_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "topenv");
    public final RFunctionSpec BASE_TOPENV_fSpec;
    public static final String BASE_GETNAMESPACE_NAME = "getNamespace";
    public static final RElementName BASE_GETNAMESPACE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "getNamespace");
    public final RFunctionSpec BASE_GETNAMESPACE_fSpec;
    public static final String BASE_GETNAMESPACENAME_NAME = "getNamespaceName";
    public static final RElementName BASE_GETNAMESPACENAME_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "getNamespaceName");
    public final RFunctionSpec BASE_GETNAMESPACENAME_fSpec;
    public static final String BASE_GETNAMESPACEVERSION_NAME = "getNamespaceVersion";
    public static final RElementName BASE_GETNAMESPACEVERSION_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "getNamespaceVersion");
    public final RFunctionSpec BASE_GETNAMESPACEVERSION_fSpec;
    public static final String BASE_GETNAMESPACEEXPORTS_NAME = "getNamespaceExports";
    public static final RElementName BASE_GETNAMESPACEEXPORTS_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "getNamespaceExports");
    public final RFunctionSpec BASE_GETNAMESPACEEXPORTS_fSpec;
    public static final String BASE_GETNAMESPACEIMPORTS_NAME = "getNamespaceImports";
    public static final RElementName BASE_GETNAMESPACEIMPORTS_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "getNamespaceImports");
    public final RFunctionSpec BASE_GETNAMESPACEIMPORTS_fSpec;
    public static final String BASE_GETNAMESPACEUSERS_NAME = "getNamespaceUsers";
    public static final RElementName BASE_GETNAMESPACEUSERS_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "getNamespaceUsers");
    public final RFunctionSpec BASE_GETNAMESPACEUSERS_fSpec;
    public static final String BASE_GETEXPORTEDVALUE_NAME = "getExportedValue";
    public static final RElementName BASE_GETEXPORTEDVALUE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "getExportedValue");
    public final RFunctionSpec BASE_GETEXPORTEDVALUE_fSpec;
    public static final String BASE_ATTACHNAMESPACE_NAME = "attachNamespace";
    public static final RElementName BASE_ATTACHNAMESPACE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "attachNamespace");
    public final RFunctionSpec BASE_ATTACHNAMESPACE_fSpec;
    public static final String BASE_LOADNAMESPACE_NAME = "loadNamespace";
    public static final RElementName BASE_LOADNAMESPACE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "loadNamespace");
    public final RFunctionSpec BASE_LOADNAMESPACE_fSpec;
    public static final String BASE_REQUIRENAMESPACE_NAME = "requireNamespace";
    public static final RElementName BASE_REQUIRENAMESPACE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "requireNamespace");
    public final RFunctionSpec BASE_REQUIRENAMESPACE_fSpec;
    public static final String BASE_ISNAMESPACELOADED_NAME = "isNamespaceLoaded";
    public static final RElementName BASE_ISNAMESPACELOADED_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "isNamespaceLoaded");
    public final RFunctionSpec BASE_ISNAMESPACELOADED_fSpec;
    public static final String BASE_UNLOADNAMESPACE_NAME = "unloadNamespace";
    public static final RElementName BASE_UNLOADNAMESPACE_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "unloadNamespace");
    public final RFunctionSpec BASE_UNLOADNAMESPACE_fSpec;
    public static final String BASE_C_NAME = "c";
    public static final RElementName BASE_C_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "c");
    public final RFunctionSpec BASE_C_fSpec;
    public static final String BASE_DATAFRAME_NAME = "data.frame";
    public static final RElementName BASE_DATAFRAME_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "data.frame");
    public final RFunctionSpec BASE_DATAFRAME_fSpec;
    public static final String BASE_USEMETHOD_NAME = "UseMethod";
    public static final RElementName BASE_USEMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "UseMethod");
    public final RFunctionSpec BASE_USEMETHOD_fSpec;
    public static final String BASE_NEXTMETHOD_NAME = "NextMethod";
    public static final RElementName BASE_NEXTMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(BASE_PACKAGE_NS_ELEMENT_NAME, "NextMethod");
    public final RFunctionSpec BASE_NEXTMETHOD_fSpec;
    public static final String UTILS_PACKAGE_NAME = "utils";
    public static final RElementName UTILS_PACKAGE_NS_ELEMENT_NAME = RElementName.create(33, "utils");
    public static final String UTILS_METHODS_NAME = "methods";
    public static final RElementName UTILS_METHODS_ELEMENT_NAME = RCoreFunctions.createFunName(UTILS_PACKAGE_NS_ELEMENT_NAME, "methods");
    public final RFunctionSpec UTILS_METHODS_fSpec;
    public static final String UTILS_GETS3METHOD_NAME = "getS3method";
    public static final RElementName UTILS_GETS3METHOD_ELEMENT_NAME = RCoreFunctions.createFunName(UTILS_PACKAGE_NS_ELEMENT_NAME, "getS3method");
    public final RFunctionSpec UTILS_GETS3METHOD_fSpec;
    public static final String UTILS_HELP_NAME = "help";
    public static final RElementName UTILS_HELP_ELEMENT_NAME = RCoreFunctions.createFunName(UTILS_PACKAGE_NS_ELEMENT_NAME, "help");
    public final RFunctionSpec UTILS_HELP_fSpec;
    public static final String UTILS_PERSON_NAME = "person";
    public static final RElementName UTILS_PERSON_ELEMENT_NAME = RCoreFunctions.createFunName(UTILS_PACKAGE_NS_ELEMENT_NAME, "person");
    public final RFunctionSpec UTILS_PERSON_fSpec;
    public static final String METHODS_PACKAGE_NAME = "methods";
    public static final RElementName METHODS_PACKAGE_NS_ELEMENT_NAME = RElementName.create(33, "methods");
    public static final String METHODS_SETGENERIC_NAME = "setGeneric";
    public static final RElementName METHODS_SETGENERIC_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setGeneric");
    public final RFunctionSpec METHODS_SETGENERIC_fSpec;
    public static final String METHODS_SETGROUPGENERIC_NAME = "setGroupGeneric";
    public static final RElementName METHODS_SETGROUPGENERIC_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setGroupGeneric");
    public final RFunctionSpec METHODS_SETGROUPGENERIC_fSpec;
    public static final String METHODS_REMOVEGENERIC_NAME = "removeGeneric";
    public static final RElementName METHODS_REMOVEGENERIC_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "removeGeneric");
    public final RFunctionSpec METHODS_REMOVEGENERIC_fSpec;
    public static final String METHODS_ISGENERIC_NAME = "isGeneric";
    public static final RElementName METHODS_ISGENERIC_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "isGeneric");
    public final RFunctionSpec METHODS_ISGENERIC_fSpec;
    public static final String METHODS_ISGROUP_NAME = "isGroup";
    public static final RElementName METHODS_ISGROUP_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "isGroup");
    public final RFunctionSpec METHODS_ISGROUP_fSpec;
    public static final String METHODS_SIGNATURE_NAME = "signature";
    public static final RElementName METHODS_SIGNATURE_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "signature");
    public final RFunctionSpec METHODS_SIGNATURE_fSpec;
    public static final String METHODS_SETCLASS_NAME = "setClass";
    public static final RElementName METHODS_SETCLASS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setClass");
    public final RFunctionSpec METHODS_SETCLASS_fSpec;
    public static final String METHODS_SETCLASSUNION_NAME = "setClassUnion";
    public static final RElementName METHODS_SETCLASSUNION_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setClassUnion");
    public final RFunctionSpec METHODS_SETCLASSUNION_fSpec;
    public static final String METHODS_REPRESENTATION_NAME = "representation";
    public static final RElementName METHODS_REPRESENTATION_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "representation");
    public final RFunctionSpec METHODS_REPRESENTATION_fSpec;
    public static final String METHODS_PROTOTYPE_NAME = "prototype";
    public static final RElementName METHODS_PROTOTYPE_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "prototype");
    public final RFunctionSpec METHODS_PROTOTYPE_fSpec;
    public static final String METHODS_SETIS_NAME = "setIs";
    public static final RElementName METHODS_SETIS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setIs");
    public final RFunctionSpec METHODS_SETIS_fSpec;
    public static final String METHODS_REMOVECLASS_NAME = "removeClass";
    public static final RElementName METHODS_REMOVECLASS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "removeClass");
    public final RFunctionSpec METHODS_REMOVECLASS_fSpec;
    public static final String METHODS_RESETCLASS_NAME = "resetClass";
    public static final RElementName METHODS_RESETCLASS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "resetClass");
    public final RFunctionSpec METHODS_RESETCLASS_fSpec;
    public static final String METHODS_SETAS_NAME = "setAs";
    public static final RElementName METHODS_SETAS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setAs");
    public final RFunctionSpec METHODS_SETAS_fSpec;
    public static final String METHODS_SETVALIDITY_NAME = "setValidity";
    public static final RElementName METHODS_SETVALIDITY_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setValidity");
    public final RFunctionSpec METHODS_SETVALIDITY_fSpec;
    public static final String METHODS_ISCLASS_NAME = "isClass";
    public static final RElementName METHODS_ISCLASS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "isClass");
    public final RFunctionSpec METHODS_ISCLASS_fSpec;
    public static final String METHODS_EXTENDS_NAME = "extends";
    public static final RElementName METHODS_EXTENDS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "extends");
    public final RFunctionSpec METHODS_EXTENDS_fSpec;
    public static final String METHODS_GETCLASS_NAME = "getClass";
    public static final RElementName METHODS_GETCLASS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "getClass");
    public final RFunctionSpec METHODS_GETCLASS_fSpec;
    public static final String METHODS_GETCLASSDEF_NAME = "getClassDef";
    public static final RElementName METHODS_GETCLASSDEF_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "getClassDef");
    public final RFunctionSpec METHODS_GETCLASSDEF_fSpec;
    public static final String METHODS_FINDCLASS_NAME = "findClass";
    public static final RElementName METHODS_FINDCLASS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "findClass");
    public final RFunctionSpec METHODS_FINDCLASS_fSpec;
    public static final String METHODS_NEW_NAME = "new";
    public static final RElementName METHODS_NEW_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "new");
    public final RFunctionSpec METHODS_NEW_fSpec;
    public static final String METHODS_AS_NAME = "as";
    public static final RElementName METHODS_AS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "as");
    public final RFunctionSpec METHODS_AS_fSpec;
    public static final String METHODS_IS_NAME = "is";
    public static final RElementName METHODS_IS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "is");
    public final RFunctionSpec METHODS_IS_fSpec;
    public static final String METHODS_SETMETHOD_NAME = "setMethod";
    public static final RElementName METHODS_SETMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "setMethod");
    public final RFunctionSpec METHODS_SETMETHOD_fSpec;
    public static final String METHODS_REMOVEMETHOD_NAME = "removeMethod";
    public static final RElementName METHODS_REMOVEMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "removeMethod");
    public final RFunctionSpec METHODS_REMOVEMETHOD_fSpec;
    public static final String METHODS_REMOVEMETHODS_NAME = "removeMethods";
    public static final RElementName METHODS_REMOVEMETHODS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "removeMethods");
    public final RFunctionSpec METHODS_REMOVEMETHODS_fSpec;
    public static final String METHODS_EXISTSMETHOD_NAME = "existsMethod";
    public static final RElementName METHODS_EXISTSMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "existsMethod");
    public final RFunctionSpec METHODS_EXISTSMETHOD_fSpec;
    public static final String METHODS_HASMETHOD_NAME = "hasMethod";
    public static final RElementName METHODS_HASMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "hasMethod");
    public final RFunctionSpec METHODS_HASMETHOD_fSpec;
    public static final String METHODS_GETMETHOD_NAME = "getMethod";
    public static final RElementName METHODS_GETMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "getMethod");
    public final RFunctionSpec METHODS_GETMETHOD_fSpec;
    public static final String METHODS_SELECTMETHOD_NAME = "selectMethod";
    public static final RElementName METHODS_SELECTMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "selectMethod");
    public final RFunctionSpec METHODS_SELECTMETHOD_fSpec;
    public static final String METHODS_GETMETHODS_NAME = "getMethods";
    public static final RElementName METHODS_GETMETHODS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "getMethods");
    public final RFunctionSpec METHODS_GETMETHODS_fSpec;
    public static final String METHODS_FINDMETHOD_NAME = "findMethod";
    public static final RElementName METHODS_FINDMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "findMethod");
    public final RFunctionSpec METHODS_FINDMETHOD_fSpec;
    public static final String METHODS_DUMPMETHOD_NAME = "dumpMethod";
    public static final RElementName METHODS_DUMPMETHOD_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "dumpMethod");
    public final RFunctionSpec METHODS_DUMPMETHOD_fSpec;
    public static final String METHODS_DUMPMETHODS_NAME = "dumpMethods";
    public static final RElementName METHODS_DUMPMETHODS_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "dumpMethods");
    public final RFunctionSpec METHODS_DUMPMETHODS_fSpec;
    public static final String METHODS_SLOT_NAME = "slot";
    public static final RElementName METHODS_SLOT_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "slot");
    public static final String METHODS_SLOT_assign_NAME = "slot<-";
    public static final RElementName METHODS_SLOT_assign_ELEMENT_NAME = RCoreFunctions.createFunName(METHODS_PACKAGE_NS_ELEMENT_NAME, "slot<-");
    public final RFunctionSpec METHODS_SLOT_fSpec;
    private final ImSet<String> packageNames;
    private final HashMap<String, FunctionEntry> nameSpecMap = new HashMap();
    private final Map<String, FunctionEntry> nameSpecMapIm = Collections.unmodifiableMap(this.nameSpecMap);

    public static RCoreFunctions getDefinitions(@Nullable RSourceConfig config) {
        return DEFAULT;
    }

    protected RCoreFunctions() {
        this.packageNames = ImCollections.newSet((Object[])new String[]{BASE_PACKAGE_NAME, UTILS_PACKAGE_NAME, "methods"});
        this.BASE_ASSIGN_fSpec = this.createBaseAssign();
        this.nameSpecMap.put(BASE_ASSIGN_NAME, new FunctionEntry(BASE_ASSIGN_ELEMENT_NAME, this.BASE_ASSIGN_fSpec));
        this.BASE_REMOVE_fSpec = this.createBaseRemove();
        this.nameSpecMap.put(BASE_REMOVE_NAME, new FunctionEntry(BASE_REMOVE_ELEMENT_NAME, this.BASE_REMOVE_fSpec));
        this.nameSpecMap.put(BASE_REMOVE_ALIAS_RM, new FunctionEntry(BASE_REMOVE_ALIAS_RM_ELEMENT_NAME, this.BASE_REMOVE_fSpec));
        this.BASE_EXISTS_fSpec = this.createBaseExists();
        this.nameSpecMap.put(BASE_EXISTS_NAME, new FunctionEntry(BASE_EXISTS_ELEMENT_NAME, this.BASE_EXISTS_fSpec));
        this.BASE_GET_fSpec = this.createBaseGet();
        this.nameSpecMap.put(BASE_GET_NAME, new FunctionEntry(BASE_GET_ELEMENT_NAME, this.BASE_GET_fSpec));
        this.BASE_SAVE_fSpec = this.createBaseSave();
        this.nameSpecMap.put(BASE_SAVE_NAME, new FunctionEntry(BASE_SAVE_ELEMENT_NAME, this.BASE_SAVE_fSpec));
        this.BASE_CALL_fSpec = this.createBaseCall();
        this.nameSpecMap.put(BASE_CALL_NAME, new FunctionEntry(BASE_CALL_ELEMENT_NAME, this.BASE_CALL_fSpec));
        this.BASE_DOCALL_fSpec = this.createBaseDoCall();
        this.nameSpecMap.put(BASE_DOCALL_NAME, new FunctionEntry(BASE_DOCALL_ELEMENT_NAME, this.BASE_DOCALL_fSpec));
        this.BASE_LIBRARY_fSpec = this.createBaseLibrary();
        this.nameSpecMap.put(BASE_LIBRARY_NAME, new FunctionEntry(BASE_LIBRARY_ELEMENT_NAME, this.BASE_LIBRARY_fSpec));
        this.BASE_REQUIRE_fSpec = this.createBaseRequire();
        this.nameSpecMap.put(BASE_REQUIRE_NAME, new FunctionEntry(BASE_REQUIRE_ELEMENT_NAME, this.BASE_REQUIRE_fSpec));
        this.BASE_GLOBALENV_fSpec = this.createBaseGlobalenv();
        this.nameSpecMap.put(BASE_GLOBALENV_NAME, new FunctionEntry(BASE_GLOBALENV_ELEMENT_NAME, this.BASE_GLOBALENV_fSpec));
        this.BASE_TOPENV_fSpec = this.createBaseTopenv();
        this.nameSpecMap.put(BASE_TOPENV_NAME, new FunctionEntry(BASE_TOPENV_ELEMENT_NAME, this.BASE_TOPENV_fSpec));
        this.BASE_GETNAMESPACE_fSpec = this.createBaseGetNamespace();
        this.nameSpecMap.put(BASE_GETNAMESPACE_NAME, new FunctionEntry(BASE_GETNAMESPACE_ELEMENT_NAME, this.BASE_GETNAMESPACE_fSpec));
        this.BASE_GETNAMESPACENAME_fSpec = this.createBaseGetNamespaceName();
        this.nameSpecMap.put(BASE_GETNAMESPACENAME_NAME, new FunctionEntry(BASE_GETNAMESPACENAME_ELEMENT_NAME, this.BASE_GETNAMESPACENAME_fSpec));
        this.BASE_GETNAMESPACEVERSION_fSpec = this.createBaseGetNamespaceVersion();
        this.nameSpecMap.put(BASE_GETNAMESPACEVERSION_NAME, new FunctionEntry(BASE_GETNAMESPACEVERSION_ELEMENT_NAME, this.BASE_GETNAMESPACEVERSION_fSpec));
        this.BASE_GETNAMESPACEEXPORTS_fSpec = this.createBaseGetNamespaceExports();
        this.nameSpecMap.put(BASE_GETNAMESPACEEXPORTS_NAME, new FunctionEntry(BASE_GETNAMESPACEEXPORTS_ELEMENT_NAME, this.BASE_GETNAMESPACEEXPORTS_fSpec));
        this.BASE_GETNAMESPACEIMPORTS_fSpec = this.createBaseGetNamespaceImports();
        this.nameSpecMap.put(BASE_GETNAMESPACEIMPORTS_NAME, new FunctionEntry(BASE_GETNAMESPACEIMPORTS_ELEMENT_NAME, this.BASE_GETNAMESPACEIMPORTS_fSpec));
        this.BASE_GETNAMESPACEUSERS_fSpec = this.createBaseGetNamespaceUsers();
        this.nameSpecMap.put(BASE_GETNAMESPACEUSERS_NAME, new FunctionEntry(BASE_GETNAMESPACEUSERS_ELEMENT_NAME, this.BASE_GETNAMESPACEUSERS_fSpec));
        this.BASE_GETEXPORTEDVALUE_fSpec = this.createBaseGetExportedValue();
        this.nameSpecMap.put(BASE_GETEXPORTEDVALUE_NAME, new FunctionEntry(BASE_GETEXPORTEDVALUE_ELEMENT_NAME, this.BASE_GETEXPORTEDVALUE_fSpec));
        this.BASE_ATTACHNAMESPACE_fSpec = this.createBaseAttachNamespace();
        this.nameSpecMap.put(BASE_ATTACHNAMESPACE_NAME, new FunctionEntry(BASE_ATTACHNAMESPACE_ELEMENT_NAME, this.BASE_ATTACHNAMESPACE_fSpec));
        this.BASE_LOADNAMESPACE_fSpec = this.createBaseLoadNamespace();
        this.nameSpecMap.put(BASE_LOADNAMESPACE_NAME, new FunctionEntry(BASE_LOADNAMESPACE_ELEMENT_NAME, this.BASE_LOADNAMESPACE_fSpec));
        this.BASE_REQUIRENAMESPACE_fSpec = this.createBaseRequireNamespace();
        this.nameSpecMap.put(BASE_REQUIRENAMESPACE_NAME, new FunctionEntry(BASE_REQUIRENAMESPACE_ELEMENT_NAME, this.BASE_REQUIRENAMESPACE_fSpec));
        this.BASE_ISNAMESPACELOADED_fSpec = this.createBaseIsNamespaceLoaded();
        this.nameSpecMap.put(BASE_ISNAMESPACELOADED_NAME, new FunctionEntry(BASE_ISNAMESPACELOADED_ELEMENT_NAME, this.BASE_ISNAMESPACELOADED_fSpec));
        this.BASE_UNLOADNAMESPACE_fSpec = this.createBaseUnloadNamespace();
        this.nameSpecMap.put(BASE_UNLOADNAMESPACE_NAME, new FunctionEntry(BASE_UNLOADNAMESPACE_ELEMENT_NAME, this.BASE_UNLOADNAMESPACE_fSpec));
        this.BASE_C_fSpec = this.createBaseC();
        this.nameSpecMap.put(BASE_C_NAME, new FunctionEntry(BASE_C_ELEMENT_NAME, this.BASE_C_fSpec));
        this.BASE_DATAFRAME_fSpec = this.createBaseC();
        this.nameSpecMap.put(BASE_DATAFRAME_NAME, new FunctionEntry(BASE_DATAFRAME_ELEMENT_NAME, this.BASE_C_fSpec));
        this.BASE_USEMETHOD_fSpec = this.createBaseUseMethod();
        this.nameSpecMap.put(BASE_USEMETHOD_NAME, new FunctionEntry(BASE_USEMETHOD_ELEMENT_NAME, this.BASE_USEMETHOD_fSpec));
        this.BASE_NEXTMETHOD_fSpec = this.createBaseNextMethod();
        this.nameSpecMap.put(BASE_NEXTMETHOD_NAME, new FunctionEntry(BASE_NEXTMETHOD_ELEMENT_NAME, this.BASE_NEXTMETHOD_fSpec));
        this.UTILS_METHODS_fSpec = this.createUtilsMethods();
        this.nameSpecMap.put("methods", new FunctionEntry(UTILS_METHODS_ELEMENT_NAME, this.UTILS_METHODS_fSpec));
        this.UTILS_GETS3METHOD_fSpec = this.createUtilsGetS3Method();
        this.nameSpecMap.put(UTILS_GETS3METHOD_NAME, new FunctionEntry(UTILS_GETS3METHOD_ELEMENT_NAME, this.UTILS_GETS3METHOD_fSpec));
        this.UTILS_HELP_fSpec = this.createUtilsHelp();
        this.nameSpecMap.put(UTILS_HELP_NAME, new FunctionEntry(UTILS_HELP_ELEMENT_NAME, this.UTILS_HELP_fSpec));
        this.UTILS_PERSON_fSpec = this.createUtilsPerson();
        this.nameSpecMap.put(UTILS_PERSON_NAME, new FunctionEntry(UTILS_PERSON_ELEMENT_NAME, this.UTILS_PERSON_fSpec));
        this.METHODS_SETGENERIC_fSpec = this.createMethodsSetGeneric();
        this.nameSpecMap.put(METHODS_SETGENERIC_NAME, new FunctionEntry(METHODS_SETGENERIC_ELEMENT_NAME, this.METHODS_SETGENERIC_fSpec));
        this.METHODS_SETGROUPGENERIC_fSpec = this.createMethodsSetGroupGeneric();
        this.nameSpecMap.put(METHODS_SETGROUPGENERIC_NAME, new FunctionEntry(METHODS_SETGROUPGENERIC_ELEMENT_NAME, this.METHODS_SETGROUPGENERIC_fSpec));
        this.METHODS_REMOVEGENERIC_fSpec = this.createMethodsRemoveGeneric();
        this.nameSpecMap.put(METHODS_REMOVEGENERIC_NAME, new FunctionEntry(METHODS_REMOVEGENERIC_ELEMENT_NAME, this.METHODS_REMOVEGENERIC_fSpec));
        this.METHODS_ISGENERIC_fSpec = this.createMethodsIsGeneric();
        this.nameSpecMap.put(METHODS_ISGENERIC_NAME, new FunctionEntry(METHODS_ISGENERIC_ELEMENT_NAME, this.METHODS_ISGENERIC_fSpec));
        this.METHODS_ISGROUP_fSpec = this.createMethodsIsGroup();
        this.nameSpecMap.put(METHODS_ISGROUP_NAME, new FunctionEntry(METHODS_ISGROUP_ELEMENT_NAME, this.METHODS_ISGROUP_fSpec));
        this.METHODS_SIGNATURE_fSpec = this.createMethodsSignature();
        this.nameSpecMap.put(METHODS_SIGNATURE_NAME, new FunctionEntry(METHODS_SIGNATURE_ELEMENT_NAME, this.METHODS_SIGNATURE_fSpec));
        this.METHODS_SETCLASS_fSpec = this.createMethodsSetClass();
        this.nameSpecMap.put(METHODS_SETCLASS_NAME, new FunctionEntry(METHODS_SETCLASS_ELEMENT_NAME, this.METHODS_SETCLASS_fSpec));
        this.METHODS_SETCLASSUNION_fSpec = this.createMethodsSetClassUnion();
        this.nameSpecMap.put(METHODS_SETCLASSUNION_NAME, new FunctionEntry(METHODS_SETCLASSUNION_ELEMENT_NAME, this.METHODS_SETCLASSUNION_fSpec));
        this.METHODS_REPRESENTATION_fSpec = this.createMethodsRepresentation();
        this.nameSpecMap.put(METHODS_REPRESENTATION_NAME, new FunctionEntry(METHODS_REPRESENTATION_ELEMENT_NAME, this.METHODS_REPRESENTATION_fSpec));
        this.METHODS_PROTOTYPE_fSpec = this.createMethodsPrototype();
        this.nameSpecMap.put(METHODS_PROTOTYPE_NAME, new FunctionEntry(METHODS_PROTOTYPE_ELEMENT_NAME, this.METHODS_PROTOTYPE_fSpec));
        this.METHODS_SETIS_fSpec = this.createMethodsSetIs();
        this.nameSpecMap.put(METHODS_SETIS_NAME, new FunctionEntry(METHODS_SETIS_ELEMENT_NAME, this.METHODS_SETIS_fSpec));
        this.METHODS_REMOVECLASS_fSpec = this.createMethodsRemoveClass();
        this.nameSpecMap.put(METHODS_REMOVECLASS_NAME, new FunctionEntry(METHODS_REMOVECLASS_ELEMENT_NAME, this.METHODS_REMOVECLASS_fSpec));
        this.METHODS_RESETCLASS_fSpec = this.createMethodsResetClass();
        this.nameSpecMap.put(METHODS_RESETCLASS_NAME, new FunctionEntry(METHODS_RESETCLASS_ELEMENT_NAME, this.METHODS_RESETCLASS_fSpec));
        this.METHODS_SETAS_fSpec = this.createMethodsSetAs();
        this.nameSpecMap.put(METHODS_SETAS_NAME, new FunctionEntry(METHODS_SETAS_ELEMENT_NAME, this.METHODS_SETAS_fSpec));
        this.METHODS_SETVALIDITY_fSpec = this.createMethodsSetValidity();
        this.nameSpecMap.put(METHODS_SETVALIDITY_NAME, new FunctionEntry(METHODS_SETVALIDITY_ELEMENT_NAME, this.METHODS_SETVALIDITY_fSpec));
        this.METHODS_ISCLASS_fSpec = this.createMethodsIsClass();
        this.nameSpecMap.put(METHODS_ISCLASS_NAME, new FunctionEntry(METHODS_ISCLASS_ELEMENT_NAME, this.METHODS_ISCLASS_fSpec));
        this.METHODS_EXTENDS_fSpec = this.createMethodsExtends();
        this.nameSpecMap.put(METHODS_EXTENDS_NAME, new FunctionEntry(METHODS_EXTENDS_ELEMENT_NAME, this.METHODS_EXTENDS_fSpec));
        this.METHODS_GETCLASS_fSpec = this.createMethodsGetClass();
        this.nameSpecMap.put(METHODS_GETCLASS_NAME, new FunctionEntry(METHODS_GETCLASS_ELEMENT_NAME, this.METHODS_GETCLASS_fSpec));
        this.METHODS_GETCLASSDEF_fSpec = this.createMethodsGetClassDef();
        this.nameSpecMap.put(METHODS_GETCLASSDEF_NAME, new FunctionEntry(METHODS_GETCLASSDEF_ELEMENT_NAME, this.METHODS_GETCLASSDEF_fSpec));
        this.METHODS_FINDCLASS_fSpec = this.createMethodsFindClass();
        this.nameSpecMap.put(METHODS_FINDCLASS_NAME, new FunctionEntry(METHODS_FINDCLASS_ELEMENT_NAME, this.METHODS_FINDCLASS_fSpec));
        this.METHODS_NEW_fSpec = this.createMethodsNew();
        this.nameSpecMap.put(METHODS_NEW_NAME, new FunctionEntry(METHODS_NEW_ELEMENT_NAME, this.METHODS_NEW_fSpec));
        this.METHODS_AS_fSpec = this.createMethodsAs();
        this.nameSpecMap.put(METHODS_AS_NAME, new FunctionEntry(METHODS_AS_ELEMENT_NAME, this.METHODS_AS_fSpec));
        this.METHODS_IS_fSpec = this.createMethodsIs();
        this.nameSpecMap.put(METHODS_IS_NAME, new FunctionEntry(METHODS_IS_ELEMENT_NAME, this.METHODS_IS_fSpec));
        this.METHODS_SETMETHOD_fSpec = this.createMethodsSetMethod();
        this.nameSpecMap.put(METHODS_SETMETHOD_NAME, new FunctionEntry(METHODS_SETMETHOD_ELEMENT_NAME, this.METHODS_SETMETHOD_fSpec));
        this.METHODS_REMOVEMETHOD_fSpec = this.createMethodsRemoveMethod();
        this.nameSpecMap.put(METHODS_REMOVEMETHOD_NAME, new FunctionEntry(METHODS_REMOVEMETHOD_ELEMENT_NAME, this.METHODS_REMOVEMETHOD_fSpec));
        this.METHODS_REMOVEMETHODS_fSpec = this.createMethodsRemoveMethods();
        this.nameSpecMap.put(METHODS_REMOVEMETHODS_NAME, new FunctionEntry(METHODS_REMOVEMETHODS_ELEMENT_NAME, this.METHODS_REMOVEMETHODS_fSpec));
        this.METHODS_EXISTSMETHOD_fSpec = this.createMethodsExistsMethod();
        this.nameSpecMap.put(METHODS_EXISTSMETHOD_NAME, new FunctionEntry(METHODS_EXISTSMETHOD_ELEMENT_NAME, this.METHODS_EXISTSMETHOD_fSpec));
        this.METHODS_HASMETHOD_fSpec = this.createMethodsHasMethod();
        this.nameSpecMap.put(METHODS_HASMETHOD_NAME, new FunctionEntry(METHODS_HASMETHOD_ELEMENT_NAME, this.METHODS_HASMETHOD_fSpec));
        this.METHODS_GETMETHOD_fSpec = this.createMethodsGetMethod();
        this.nameSpecMap.put(METHODS_GETMETHOD_NAME, new FunctionEntry(METHODS_GETMETHOD_ELEMENT_NAME, this.METHODS_GETMETHOD_fSpec));
        this.METHODS_SELECTMETHOD_fSpec = this.createMethodsSelectMethod();
        this.nameSpecMap.put(METHODS_SELECTMETHOD_NAME, new FunctionEntry(METHODS_SELECTMETHOD_ELEMENT_NAME, this.METHODS_SELECTMETHOD_fSpec));
        this.METHODS_GETMETHODS_fSpec = this.createMethodsGetMethods();
        this.nameSpecMap.put(METHODS_GETMETHODS_NAME, new FunctionEntry(METHODS_GETMETHODS_ELEMENT_NAME, this.METHODS_GETMETHODS_fSpec));
        this.METHODS_FINDMETHOD_fSpec = this.createMethodsFindMethod();
        this.nameSpecMap.put(METHODS_FINDMETHOD_NAME, new FunctionEntry(METHODS_FINDMETHOD_ELEMENT_NAME, this.METHODS_FINDMETHOD_fSpec));
        this.METHODS_DUMPMETHOD_fSpec = this.createMethodsDumpMethod();
        this.nameSpecMap.put(METHODS_DUMPMETHOD_NAME, new FunctionEntry(METHODS_DUMPMETHOD_ELEMENT_NAME, this.METHODS_DUMPMETHOD_fSpec));
        this.METHODS_DUMPMETHODS_fSpec = this.createMethodsDumpMethods();
        this.nameSpecMap.put(METHODS_DUMPMETHODS_NAME, new FunctionEntry(METHODS_DUMPMETHODS_ELEMENT_NAME, this.METHODS_DUMPMETHODS_fSpec));
        this.METHODS_SLOT_fSpec = this.createMethodsSlot();
        this.nameSpecMap.put(METHODS_SLOT_NAME, new FunctionEntry(METHODS_SLOT_ELEMENT_NAME, this.METHODS_SLOT_fSpec));
    }

    protected RFunctionSpec createBaseAssign() {
        return new RFunctionSpecBuilder().addParam("x", 0x2000100).addParams("value", "pos", "envir", "inherits", "immediate").build();
    }

    protected RFunctionSpec createBaseRemove() {
        return new RFunctionSpecBuilder().addParam("...", 0x3000100).addParams("list", "pos", "envir", "inherits").build();
    }

    protected RFunctionSpec createBaseExists() {
        return new RFunctionSpecBuilder().addParam("x", 0x2000100).addParams("where", "envir", "frame", "mode", "inherits").build();
    }

    protected RFunctionSpec createBaseGet() {
        return new RFunctionSpecBuilder().addParam("x", 0x2000100).addParams("pos", "envir", "mode", "inherits").build();
    }

    protected RFunctionSpec createBaseGet0() {
        return new RFunctionSpecBuilder().addParam("x", 0x2000100).addParams("envir", "mode", "inherits", "ifnotfound").build();
    }

    protected RFunctionSpec createBaseSave() {
        return new RFunctionSpecBuilder().addParam("...", 0x3000100).addParam("list", 0x2000100).addParams("file", "ascii", "version", "envir", "compress", "compress_level", "eval.promises", "precheck").build();
    }

    protected RFunctionSpec createBaseCall() {
        return new RFunctionSpecBuilder().addParam("name", 0x2000100).addParam("...").build();
    }

    protected RFunctionSpec createBaseDoCall() {
        return new RFunctionSpecBuilder().addParam("what", 0x3000004).addParams("args", "quote", "envir").build();
    }

    protected RFunctionSpec createBaseLibrary() {
        return new RFunctionSpecBuilder().addParam("package", 0x3000200).addParam(UTILS_HELP_NAME, 0x3000200).addParams("pos", "lib.loc", "character.only", "logical.return", "warn.conflicts", "quietly", "verbose").build();
    }

    protected RFunctionSpec createBaseRequire() {
        return new RFunctionSpecBuilder().addParam("package", 0x3000200).addParams("lib.loc", "quietly", "warn.conflicts", "character.only").build();
    }

    protected RFunctionSpec createBaseGlobalenv() {
        return new RFunctionSpec(new String[0]);
    }

    protected RFunctionSpec createBaseTopenv() {
        return new RFunctionSpec("envir", "matchThisEnv");
    }

    protected RFunctionSpec createBaseGetNamespace() {
        return new RFunctionSpecBuilder().addParam("ns", 0x3000200).build();
    }

    protected RFunctionSpec createBaseGetNamespaceName() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).build();
    }

    protected RFunctionSpec createBaseGetNamespaceVersion() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).build();
    }

    protected RFunctionSpec createBaseGetNamespaceExports() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).build();
    }

    protected RFunctionSpec createBaseGetNamespaceImports() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).build();
    }

    protected RFunctionSpec createBaseGetNamespaceUsers() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).build();
    }

    protected RFunctionSpec createBaseGetExportedValue() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).addParam("name").build();
    }

    protected RFunctionSpec createBaseAttachNamespace() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).addParams("pos", "depends").build();
    }

    protected RFunctionSpec createBaseLoadNamespace() {
        return new RFunctionSpecBuilder().addParam("package", 0x2000200).addParams("lib.loc", "keep.source", "partial", "versionCheck").build();
    }

    protected RFunctionSpec createBaseRequireNamespace() {
        return new RFunctionSpecBuilder().addParam("package", 0x2000200).addParams("...", "quietly").build();
    }

    protected RFunctionSpec createBaseIsNamespaceLoaded() {
        return new RFunctionSpecBuilder().addParam("name", 0x3000200).build();
    }

    protected RFunctionSpec createBaseUnloadNamespace() {
        return new RFunctionSpecBuilder().addParam("ns", 0x2000200).build();
    }

    protected RFunctionSpec createBaseC() {
        return new RFunctionSpecBuilder().addParam("...").addParam("recursive").build();
    }

    protected RFunctionSpec createBaseDataFrame() {
        return new RFunctionSpecBuilder().addParam("...").addParam("row.names").addParam("check.rows").addParam("check.names").addParam("stringsAsFactors").build();
    }

    protected RFunctionSpec createBaseUseMethod() {
        return new RFunctionSpecBuilder().addParam("generic", 4096).addParam("object").build();
    }

    protected RFunctionSpec createBaseNextMethod() {
        return new RFunctionSpecBuilder().addParam("name", 4096).addParams("object", "...").build();
    }

    protected RFunctionSpec createUtilsMethods() {
        return new RFunctionSpecBuilder().addParam("generic.function", 0x3000010).addParam("class", 2048).build();
    }

    protected RFunctionSpec createUtilsGetS3Method() {
        return new RFunctionSpecBuilder().addParam("f", 0x2000010).addParam("class", 2048).addParam("optional").build();
    }

    protected RFunctionSpec createUtilsHelp() {
        return new RFunctionSpecBuilder().addParam("topic", 0x3040000).addParam("package", 0x3000200).addParams("lib.loc", "verbose", "try.all.packages", "help_type").build();
    }

    protected RFunctionSpec createUtilsPerson() {
        return new RFunctionSpecBuilder().addParams("given", "family", "middle").addParam("email").addParam("role", 0x6100000).addParam("comment").returns(64, UTILS_PERSON_NAME).build();
    }

    protected RFunctionSpec createMethodsSetGeneric() {
        return new RFunctionSpec("name", "def", "group", "valueClass", "where", "package", METHODS_SIGNATURE_NAME, "useAsDefault", "genericFunction");
    }

    protected RFunctionSpec createMethodsSetGroupGeneric() {
        return new RFunctionSpec("name", "def", "group", "valueClass", "knownMembers", "where", "package");
    }

    protected RFunctionSpec createMethodsRemoveGeneric() {
        return new RFunctionSpecBuilder().addParam("f", 4096).addParam("where").build();
    }

    protected RFunctionSpec createMethodsIsGeneric() {
        return new RFunctionSpecBuilder().addParam("f", 4096).addParams("where", "fdef", "getName").build();
    }

    protected RFunctionSpec createMethodsIsGroup() {
        return new RFunctionSpecBuilder().addParam("f", 4096).addParams("where", "fdef").build();
    }

    protected RFunctionSpec createMethodsSignature() {
        return new RFunctionSpec("...");
    }

    protected RFunctionSpec createMethodsSetClass() {
        return new RFunctionSpecBuilder().addParam("Class", 2048).addParams(METHODS_REPRESENTATION_NAME, METHODS_PROTOTYPE_NAME, "contains", "validity", "access", "where", "version", "sealed", "package").build();
    }

    protected RFunctionSpec createMethodsSetClassUnion() {
        return new RFunctionSpecBuilder().addParam("name", 2048).addParams("members", "where").build();
    }

    protected RFunctionSpec createMethodsRepresentation() {
        return new RFunctionSpec("...");
    }

    protected RFunctionSpec createMethodsPrototype() {
        return new RFunctionSpec("...");
    }

    protected RFunctionSpec createMethodsSetIs() {
        return new RFunctionSpec("class1", "class2", "test", "coerce", "replace", "by", "where", "classDef", "extensionObject", "doComplete");
    }

    protected RFunctionSpec createMethodsRemoveClass() {
        return new RFunctionSpecBuilder().addParam("Class", 2048).addParam("where").build();
    }

    protected RFunctionSpec createMethodsResetClass() {
        return new RFunctionSpecBuilder().addParam("Class").addParams("classDef", "where").build();
    }

    protected RFunctionSpec createMethodsSetAs() {
        return new RFunctionSpecBuilder().addParam("from", 2048).addParam("to", 2048).addParams("def", "replace", "where").build();
    }

    protected RFunctionSpec createMethodsSetValidity() {
        return new RFunctionSpecBuilder().addParam("Class", 2048).addParams("method", "where").build();
    }

    protected RFunctionSpec createMethodsIsClass() {
        return new RFunctionSpecBuilder().addParam("Class", 2048).addParams("formal", "where").build();
    }

    protected RFunctionSpec createMethodsGetClass() {
        return new RFunctionSpec("Class", ".Force", "where");
    }

    protected RFunctionSpec createMethodsGetClassDef() {
        return new RFunctionSpec("Class", "where", "package");
    }

    protected RFunctionSpec createMethodsFindClass() {
        return new RFunctionSpec("Class", "where", "unique");
    }

    protected RFunctionSpec createMethodsExtends() {
        return new RFunctionSpecBuilder().addParam("class1", 2048).addParam("class2", 2048).addParams("maybe", "fullInfo").build();
    }

    protected RFunctionSpec createMethodsNew() {
        return new RFunctionSpecBuilder().addParam("Class", 2048).addParam("...").build();
    }

    protected RFunctionSpec createMethodsAs() {
        return new RFunctionSpecBuilder().addParam("object").addParam("Class", 2048).addParams("strict", "ext").build();
    }

    protected RFunctionSpec createMethodsIs() {
        return new RFunctionSpecBuilder().addParam("object").addParam("class2", 2048).build();
    }

    protected RFunctionSpec createMethodsSetMethod() {
        return new RFunctionSpec("f", METHODS_SIGNATURE_NAME, "definition", "where", "valueClass", "sealed");
    }

    protected RFunctionSpec createMethodsRemoveMethod() {
        return new RFunctionSpec("f", METHODS_SIGNATURE_NAME, "where");
    }

    protected RFunctionSpec createMethodsRemoveMethods() {
        return new RFunctionSpec("f", "where", "all");
    }

    protected RFunctionSpec createMethodsExistsMethod() {
        return new RFunctionSpecBuilder().addParam("f", 4096).addParams(METHODS_SIGNATURE_NAME, "where").build();
    }

    protected RFunctionSpec createMethodsHasMethod() {
        return new RFunctionSpecBuilder().addParam("f", 4096).addParams(METHODS_SIGNATURE_NAME, "where").build();
    }

    protected RFunctionSpec createMethodsGetMethod() {
        return new RFunctionSpec("f", METHODS_SIGNATURE_NAME, "where", "optional", "mlist", "fdef");
    }

    protected RFunctionSpec createMethodsSelectMethod() {
        return new RFunctionSpec("f", METHODS_SIGNATURE_NAME, "optional", "useInherited", "mlist", "fdef", "verbose");
    }

    protected RFunctionSpec createMethodsGetMethods() {
        return new RFunctionSpec("f", "where");
    }

    protected RFunctionSpec createMethodsFindMethod() {
        return new RFunctionSpec("f", METHODS_SIGNATURE_NAME, "where");
    }

    protected RFunctionSpec createMethodsDumpMethod() {
        return new RFunctionSpecBuilder().addParam("f", 4096).addParams(METHODS_SIGNATURE_NAME, "file", "where", "def").build();
    }

    protected RFunctionSpec createMethodsDumpMethods() {
        return new RFunctionSpecBuilder().addParam("f", 4096).addParams("file", METHODS_SIGNATURE_NAME, "methods", "where").build();
    }

    protected RFunctionSpec createMethodsSlot() {
        return new RFunctionSpec("object", "name", "check");
    }

    public ImSet<String> getPackageNames() {
        return this.packageNames;
    }

    public Set<String> getKnownFunctions() {
        return this.nameSpecMapIm.keySet();
    }

    public @Nullable RElementName getElementName(@Nullable String name) {
        FunctionEntry spec = this.nameSpecMap.get(name);
        return spec != null ? spec.elementName : null;
    }

    public @Nullable RFunctionSpec getFunctionSpec(@Nullable String name) {
        FunctionEntry spec = this.nameSpecMap.get(name);
        return spec != null ? spec.fSpec : null;
    }

    private static RElementName createFunName(RElementName packageName, String name) {
        return RElementName.addScope(RElementName.create(17, name), packageName);
    }

    private static RElementName createClassName(RElementName packageName, String name) {
        return RElementName.addScope(RElementName.create(21, name), packageName);
    }

    private static final class FunctionEntry {
        private final RElementName elementName;
        private final RFunctionSpec fSpec;

        public FunctionEntry(RElementName elementName, RFunctionSpec fSpec) {
            this.elementName = elementName;
            this.fSpec = fSpec;
        }

        public String toString() {
            return this.elementName.toString();
        }
    }
}

