/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.Messages;
import org.eclipse.statet.internal.r.core.RCorePlugin;
import org.eclipse.statet.internal.r.core.RProjectNature;
import org.eclipse.statet.internal.r.core.builder.RdParser;
import org.eclipse.statet.internal.r.core.rmodel.RModelManagerImpl;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.buildpath.core.BuildpathElement;
import org.eclipse.statet.ltk.buildpath.core.BuildpathUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.project.RBuildpaths;
import org.eclipse.statet.r.core.project.RProject;
import org.eclipse.statet.r.core.project.RTaskMarkerHandler;

@NonNullByDefault
public class RBuilder
implements IResourceDeltaVisitor,
IResourceVisitor {
    private final SourceUnitManager suManager = LtkModels.getSourceUnitManager();
    private final List<IFile> toRemoveRSU = new ArrayList<IFile>();
    private final ArrayList<RWorkspaceSourceUnit> toUpdateRSU = new ArrayList();
    private final RModelManagerImpl modelManager;
    private final IncrementalProjectBuilder projectBuilder;
    private MultiStatus statusCollector;
    private IProject project;
    private @Nullable IPath pkgRootPath;
    private @Nullable IPath pkgDescriptionPath;
    private ImList<BuildpathElement> sourceContainters;
    private BuildpathElement currentSourceContainer;
    private final RTaskMarkerHandler taskMarkerHandler = new RTaskMarkerHandler();

    private static IContainer getContainer(IProject project, IPath path) {
        return path.isEmpty() ? project : project.getFolder(path);
    }

    public RBuilder(IncrementalProjectBuilder projectBuilder) {
        this.modelManager = RCorePlugin.getInstance().getRModelManager();
        this.projectBuilder = projectBuilder;
    }

    private void init(RProject rProject) {
        this.project = rProject.getProject();
        this.statusCollector = new MultiStatus("org.eclipse.statet.r.core", 0, "R build status for " + this.project.getName(), null);
        this.sourceContainters = rProject.getRawBuildpath();
        IPath pkgRootAbsPath = rProject.getPkgRootPath();
        if (pkgRootAbsPath != null) {
            this.pkgRootPath = pkgRootAbsPath.removeFirstSegments(1);
            this.pkgDescriptionPath = this.pkgRootPath.append(RBuildpaths.PKG_DESCRIPTION_FILE_PATH);
        } else {
            this.pkgRootPath = null;
            this.pkgDescriptionPath = null;
        }
        this.currentSourceContainer = null;
        this.initRd(rProject);
    }

    private boolean isValidSourceFolder(IResource resource) {
        return this.currentSourceContainer != null && !BuildpathUtils.isExcluded((IResource)resource, (BuildpathElement)this.currentSourceContainer);
    }

    private void clear(SubMonitor m) {
        this.currentSourceContainer = null;
        if (!this.toUpdateRSU.isEmpty()) {
            for (RSourceUnit rSourceUnit : this.toUpdateRSU) {
                if (rSourceUnit == null) continue;
                rSourceUnit.disconnect((IProgressMonitor)m);
            }
            this.toUpdateRSU.clear();
        }
        this.toRemoveRSU.clear();
        this.project = null;
    }

    public IStatus buildFull(RProject rProject, IProgressMonitor monitor) {
        this.init(rProject);
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)13);
        try {
            try {
                m.subTask(NLS.bind((String)"Collecting resource changes of ''{0}''.", (Object)this.project.getName()));
                IContainer pkgRoot = null;
                if (this.pkgRootPath != null) {
                    pkgRoot = this.visitPkgRoot(RBuilder.getContainer(this.project, this.pkgRootPath));
                }
                m.worked(1);
                for (BuildpathElement sourceContainer : this.sourceContainters) {
                    IResource resource = this.project.findMember(sourceContainer.getPath().removeFirstSegments(1));
                    if (resource != null) {
                        this.currentSourceContainer = sourceContainer;
                        resource.accept((IResourceVisitor)this);
                    }
                    if (!m.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                m.worked(1);
                this.modelManager.getIndex().update(rProject, pkgRoot, null, this.toUpdateRSU, this.statusCollector, m.newChild(10));
            }
            catch (CoreException e) {
                this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "An error occurred when indexing the project.", (Throwable)e));
                this.clear(m);
            }
        }
        finally {
            this.clear(m);
        }
        return this.statusCollector;
    }

    public IStatus buildIncremental(RProject rProject, IResourceDelta delta, IProgressMonitor monitor) {
        this.init(rProject);
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)13);
        try {
            try {
                m.subTask(NLS.bind((String)"Collecting resource changes of ''{0}''.", (Object)this.project.getName()));
                IContainer pkgRoot = null;
                if (this.pkgRootPath != null) {
                    pkgRoot = this.visitPkgRoot(delta.findMember(this.pkgRootPath));
                }
                m.worked(1);
                for (BuildpathElement sourceContainer : this.sourceContainters) {
                    IResourceDelta sourceDelta = delta.findMember(sourceContainer.getPath().removeFirstSegments(1));
                    if (sourceDelta != null) {
                        this.currentSourceContainer = sourceContainer;
                        sourceDelta.accept((IResourceDeltaVisitor)this);
                    }
                    if (!m.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                m.worked(1);
                this.modelManager.getIndex().update(rProject, pkgRoot, this.toRemoveRSU, this.toUpdateRSU, this.statusCollector, m.newChild(10));
            }
            catch (CoreException e) {
                this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "An error occurred when indexing the project.", (Throwable)e));
                this.clear(m);
            }
        }
        finally {
            this.clear(m);
        }
        return this.statusCollector;
    }

    public void clean(IProject project, IProgressMonitor monitor) {
        this.project = project;
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)11);
        try {
            try {
                this.project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 2);
                this.clearAllMarkers((IResource)this.project, 2);
                this.modelManager.getIndex().clear(this.project);
            }
            catch (CoreException e) {
                this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, "An error occurred when indexing the project.", (Throwable)e));
                this.clear(m);
            }
        }
        finally {
            this.clear(m);
        }
    }

    private IContainer visitPkgRoot(IContainer pkgRoot) throws CoreException {
        this.project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 2);
        if (pkgRoot.exists()) {
            this.visitPkgFile(pkgRoot.findMember(RBuildpaths.PKG_DESCRIPTION_FILE_PATH));
        }
        return pkgRoot;
    }

    /*
     * WARNING - void declaration
     */
    private @Nullable IContainer visitPkgRoot(@Nullable IResourceDelta delta) throws CoreException {
        IResource iResource;
        if (delta != null && (iResource = delta.getResource()) instanceof IContainer) {
            IContainer iContainer = (IContainer)iResource;
            IContainer cfr_ignored_0 = (IContainer)iResource;
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    void pkgRoot;
                    boolean changed = false;
                    if (!(changed |= this.visitPkgFile(delta.findMember(RBuildpaths.PKG_DESCRIPTION_FILE_PATH)))) break;
                    this.project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
                    pkgRoot.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
                    return pkgRoot;
                }
                case 2: {
                    IResource movedTo;
                    void pkgRoot;
                    this.project.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
                    if ((delta.getFlags() & 0x2000) != 0 && (movedTo = pkgRoot.getWorkspace().getRoot().findMember(delta.getMovedToPath())) != null && !this.isRPkgRootLocation(movedTo)) {
                        pkgRoot.deleteMarkers("org.eclipse.statet.r.resourceMarkers.BuildpathProblem", false, 0);
                    }
                    return pkgRoot;
                }
            }
        }
        return null;
    }

    private void visitPkgFile(@Nullable IResource resource) {
        if (resource instanceof IFile) {
            this.clearAllMarkers(resource, 0);
        }
    }

    private boolean visitPkgFile(@Nullable IResourceDelta delta) throws CoreException {
        IResource resource;
        if (delta != null && (resource = delta.getResource()) instanceof IFile) {
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    this.clearAllMarkers(resource, 0);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResource resource) throws CoreException {
        try {
            if (!this.isValidSourceFolder(resource)) {
                return false;
            }
            IResource iResource = resource;
            if (iResource instanceof IFile) {
                void file;
                IFile iFile = (IFile)iResource;
                IFile cfr_ignored_0 = (IFile)iResource;
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription == null) {
                    return true;
                }
                IContentType contentType = contentDescription.getContentType();
                if (contentType == null) {
                    return true;
                }
                switch (contentType.getId()) {
                    case "org.eclipse.statet.r.contentTypes.RPkgDescription": {
                        if (!resource.getProjectRelativePath().equals((Object)this.pkgDescriptionPath)) {
                            this.clearAllMarkers(resource, 0);
                        }
                        return true;
                    }
                    case "org.eclipse.statet.r.contentTypes.R": {
                        this.clearRMarkers(resource, 2);
                        RWorkspaceSourceUnit su = (RWorkspaceSourceUnit)this.suManager.getSourceUnit(Ltk.PERSISTENCE_CONTEXT, (Object)file, contentType, true, null);
                        if (su != null) {
                            this.toUpdateRSU.add(su);
                        }
                        return true;
                    }
                    case "org.eclipse.statet.r.contentTypes.Rd": {
                        this.clearRMarkers(resource, 2);
                        this.doParseRd((IFile)file);
                        return true;
                    }
                }
            }
            return true;
        }
        catch (CoreException e) {
            this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when checking ''{0}''", (Object)resource.getFullPath().toString()), (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        try {
            if (!this.isValidSourceFolder(resource)) {
                return false;
            }
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    IResource iResource = resource;
                    if (iResource instanceof IFile) {
                        void file;
                        IFile iFile = (IFile)iResource;
                        IFile cfr_ignored_0 = (IFile)iResource;
                        IContentDescription contentDescription = file.getContentDescription();
                        if (contentDescription == null) {
                            return true;
                        }
                        IContentType contentType = contentDescription.getContentType();
                        if (contentType == null) {
                            return true;
                        }
                        switch (contentType.getId()) {
                            case "org.eclipse.statet.r.contentTypes.RPkgDescription": {
                                if (!delta.getProjectRelativePath().equals((Object)this.pkgDescriptionPath)) {
                                    this.clearAllMarkers(resource, 0);
                                }
                                return true;
                            }
                            case "org.eclipse.statet.r.contentTypes.R": {
                                this.clearRMarkers(resource, 0);
                                RWorkspaceSourceUnit su = (RWorkspaceSourceUnit)this.suManager.getSourceUnit(Ltk.PERSISTENCE_CONTEXT, (Object)file, contentType, true, null);
                                if (su != null) {
                                    this.toUpdateRSU.add(su);
                                }
                                return true;
                            }
                            case "org.eclipse.statet.r.contentTypes.Rd": {
                                this.clearRMarkers(resource, 0);
                                this.doParseRd((IFile)file);
                                return true;
                            }
                        }
                    }
                    return true;
                }
                case 2: {
                    IResource movedTo;
                    if ((delta.getFlags() & 0x2000) != 0 && (movedTo = resource.getWorkspace().getRoot().findMember(delta.getMovedToPath())) != null && !this.isRSourceLocation(movedTo)) {
                        this.clearAllMarkers(movedTo, 2);
                    }
                    if (resource instanceof IFile) {
                        this.toRemoveRSU.add((IFile)resource);
                    }
                    return true;
                }
            }
            return true;
        }
        catch (CoreException e) {
            this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when checking ''{0}''", (Object)resource.getFullPath().toString()), (Throwable)e));
            return false;
        }
    }

    private boolean isRSourceLocation(IResource resource) throws CoreException {
        IProject project = resource.getProject();
        if (project == this.project) {
            return true;
        }
        return project.hasNature("org.eclipse.statet.r.resourceProjects.R");
    }

    private boolean isRPkgRootLocation(IResource resource) throws CoreException {
        IProject project = resource.getProject();
        if (project == this.project) {
            return resource.getProjectRelativePath().equals((Object)this.pkgRootPath);
        }
        if (project.hasNature("org.eclipse.statet.r.resourceProjects.RPkg")) {
            RProjectNature rProject = RProjectNature.getRProject(project);
            return rProject != null && resource.getFullPath().equals((Object)rProject.getPkgRootPath());
        }
        return false;
    }

    private void clearAllMarkers(IResource resource, int depth) {
        try {
            resource.deleteMarkers("org.eclipse.statet.r.resourceMarkers.RModelProblem", false, depth);
            resource.deleteMarkers("org.eclipse.statet.r.resourceMarkers.RPkgModelProblem", false, depth);
            resource.deleteMarkers("org.eclipse.statet.r.resourceMarkers.Tasks", false, depth);
        }
        catch (CoreException e) {
            RCorePlugin.logError("R Builder: Failed to remove old markers.", e);
        }
    }

    private void clearRMarkers(IResource resource, int depth) {
        try {
            resource.deleteMarkers("org.eclipse.statet.r.resourceMarkers.RModelProblem", false, depth);
            resource.deleteMarkers("org.eclipse.statet.r.resourceMarkers.Tasks", false, depth);
        }
        catch (CoreException e) {
            RCorePlugin.logError("R Builder: Failed to remove old markers.", e);
        }
    }

    protected void initRd(RProject project) {
        this.taskMarkerHandler.init(project);
    }

    protected void doParseRd(IFile file) throws CoreException {
        try {
            SourceContent sourceContent = new SourceContent(0L, this.readFile(file));
            this.taskMarkerHandler.setup(sourceContent, (IResource)file);
            new RdParser(sourceContent, this.taskMarkerHandler).check();
        }
        catch (CoreException e) {
            this.statusCollector.add((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)"An error occurred when parsing Rd file ''{0}''", (Object)file.getFullPath().toString()), (Throwable)e));
        }
    }

    protected String readFile(IFile file) throws CoreException {
        String charset = null;
        InputStream input = null;
        try {
            int n;
            input = file.getContents();
            charset = file.getCharset();
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));
            StringBuilder text = new StringBuilder(1000);
            char[] readBuffer = new char[2048];
            while ((n = reader.read(readBuffer)) > 0) {
                text.append(readBuffer, 0, n);
            }
            String string = text.toString();
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)Messages.Builder_error_UnsupportedEncoding_message, (Object[])new String[]{charset, file.getName()}), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", 0, NLS.bind((String)Messages.Builder_error_IOReadingFile_message, (Object)file.getName()), (Throwable)e));
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

