/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.util;

import java.util.Iterator;
import org.eclipse.jface.util.DelegatingDragAdapter;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.statet.ecommons.ui.util.SelectionTransferDragAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class ViewerDragSupport {
    private final StructuredViewer viewer;
    private final DelegatingDragAdapter delegatingAdapter;
    private boolean initialized;

    public ViewerDragSupport(StructuredViewer viewer) {
        this.viewer = viewer;
        this.delegatingAdapter = new DelegatingDragAdapter();
        this.delegatingAdapter.addDragSourceListener((TransferDragSourceListener)new SelectionTransferDragAdapter((ISelectionProvider)this.viewer));
        this.initialized = false;
    }

    public void addDragSourceListener(TransferDragSourceListener listener) {
        assert (!this.initialized);
        this.delegatingAdapter.addDragSourceListener(listener);
    }

    public void init() {
        assert (!this.initialized);
        this.viewer.addDragSupport(23, this.delegatingAdapter.getTransfers(), (DragSourceListener)this.delegatingAdapter);
        this.initialized = true;
    }

    public static class TextDragSourceListener
    implements TransferDragSourceListener {
        private final StructuredViewer viewer;
        private String text;

        public TextDragSourceListener(StructuredViewer viewer) {
            this.viewer = viewer;
        }

        public Transfer getTransfer() {
            return TextTransfer.getInstance();
        }

        public void dragStart(DragSourceEvent event) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
            if (selection.isEmpty()) {
                event.doit = false;
                return;
            }
            Iterator iterator = selection.iterator();
            String sep = ", ";
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                sb.append(labelProvider.getText(iterator.next()));
                sb.append(", ");
            }
            this.text = sb.substring(0, sb.length() - ", ".length());
        }

        public void dragSetData(DragSourceEvent event) {
            event.data = this.text;
        }

        public void dragFinished(DragSourceEvent event) {
            this.text = "";
        }
    }
}

