/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.workbench.css;

import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

@NonNullByDefault
public final class StylingUtils {
    public static final String WIDGET_CSS_ID_KEY = "org.eclipse.e4.ui.css.id";
    private static final String SYSTEM_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_system";
    private static final String DEFAULT_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_default";
    private static final String DARK_THEME_ID = "org.eclipse.e4.ui.css.theme.e4_dark";
    private static final String NONE_THEME_ID = "none";

    public static boolean isStylingSupported() {
        return PlatformUI.getWorkbench().getService(IStylingEngine.class) != null;
    }

    public static IStylingEngine getStylingEngine() {
        return (IStylingEngine)ObjectUtils.nonNullAssert((Object)((IStylingEngine)PlatformUI.getWorkbench().getService(IStylingEngine.class)));
    }

    private static String getCurrentCssThemeId() {
        try {
            ITheme theme;
            IThemeEngine engine = (IThemeEngine)PlatformUI.getWorkbench().getService(IThemeEngine.class);
            if (engine != null && (theme = engine.getActiveTheme()) != null) {
                return theme.getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NONE_THEME_ID;
    }

    public static ThemeType getCurrentThemeType(Display display) {
        String themeId;
        switch (themeId = StylingUtils.getCurrentCssThemeId()) {
            case "none": 
            case "org.eclipse.e4.ui.css.theme.e4_system": {
                return Display.isSystemDarkTheme() ? ThemeType.DARK : ThemeType.LIGHT;
            }
            case "org.eclipse.e4.ui.css.theme.e4_dark": {
                return ThemeType.DARK;
            }
            case "org.eclipse.e4.ui.css.theme.e4_default": {
                return ThemeType.LIGHT;
            }
        }
        if (themeId.contains("dark")) {
            return ThemeType.DARK;
        }
        if (themeId.contains("light")) {
            return ThemeType.LIGHT;
        }
        return ThemeType.OTHER;
    }

    public static boolean isCurrentThemeMatchingSystem(Display display) {
        String themeId;
        switch (themeId = StylingUtils.getCurrentCssThemeId()) {
            case "none": 
            case "org.eclipse.e4.ui.css.theme.e4_system": {
                return true;
            }
            case "org.eclipse.e4.ui.css.theme.e4_default": {
                return !Display.isSystemDarkTheme();
            }
        }
        if (themeId.contains("dark")) {
            return Display.isSystemDarkTheme();
        }
        return false;
    }

    public static void disableStyling(Control control) {
        control.setData("org.eclipse.e4.ui.css.disabled", (Object)Boolean.TRUE);
    }

    private StylingUtils() {
    }

    public static enum ThemeType {
        DARK,
        LIGHT,
        OTHER;

    }
}

