/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.content;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.statet.ecommons.ui.content.IElementFilter;
import org.eclipse.statet.jcommons.collections.ImCollections;

public class SetElementFilter
implements IElementFilter {
    private Collection<?> set = Collections.EMPTY_LIST;
    private boolean changed;
    private Filter currentFilter;

    public synchronized boolean setSet(Collection<?> set) {
        if (set == null || set.isEmpty()) {
            set = ImCollections.emptySet();
        }
        this.changed |= !this.set.equals(set);
        this.set = set;
        return this.changed;
    }

    @Override
    public synchronized IElementFilter.IFinalFilter getFinal(boolean newData) {
        if (this.set.isEmpty()) {
            this.currentFilter = null;
        } else if (this.currentFilter == null || newData && this.currentFilter.set != this.set || this.changed && this.currentFilter.set != this.set) {
            this.currentFilter = new Filter(this.set);
        }
        this.changed = false;
        return this.currentFilter;
    }

    protected boolean select(Collection<?> set, Object element) {
        return set.contains(element.toString());
    }

    private class Filter
    implements IElementFilter.IFinalFilter {
        private final Collection<?> set;

        Filter(Collection<?> set) {
            this.set = set;
        }

        @Override
        public boolean select(Object element) {
            return SetElementFilter.this.select(this.set, element);
        }

        @Override
        public boolean isSubOf(IElementFilter.IFinalFilter other) {
            return other == this || other == null || ((Filter)other).set.containsAll(this.set);
        }

        @Override
        public boolean isEqualTo(IElementFilter.IFinalFilter other) {
            return other == this || other instanceof Filter && this.set.equals(((Filter)other).set);
        }
    }
}

