/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.actions.WorkbenchScopingHandler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.actions.AbstractToolScopeHandler;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.progress.IProgressConstants;

@NonNullByDefault
public class RelaunchToolHandler
extends AbstractToolScopeHandler<ToolProcess> {
    public RelaunchToolHandler(IWorkbenchWindow scope, @Nullable String commandId) {
        super(scope, commandId);
    }

    public RelaunchToolHandler(IPageSite scope, ToolProvider toolProvider, @Nullable String commandId) {
        super(scope, toolProvider, commandId);
    }

    @Override
    protected boolean isSupported(Tool tool) {
        return tool instanceof ToolProcess;
    }

    @Override
    protected boolean evaluateIsEnabled(ToolProcess tool) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected @Nullable Object execute(ExecutionEvent event, ToolProcess tool, IEvaluationContext evalContext) throws ExecutionException {
        try {
            tool.terminate();
            Job[] jobArray = Job.getJobManager().find(RelaunchJob.class);
            int n = jobArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    new RelaunchJob(tool).schedule();
                    return null;
                }
                Job job = jobArray[n2];
                if (((RelaunchJob)job).process == tool) {
                    return null;
                }
                ++n2;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return null;
    }

    private static class RelaunchJob
    extends Job {
        private final ToolProcess process;

        public RelaunchJob(ToolProcess process) {
            super(NLS.bind((String)"Relaunch {0}", (Object)process.getLabel(0)));
            this.setUser(false);
            this.setPriority(20);
            ICommandImageService commandImageService = (ICommandImageService)ObjectUtils.nonNullAssert((Object)((ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class)));
            ImageDescriptor imageDescriptor = commandImageService.getImageDescriptor("org.eclipse.statet.nico.commands.RelaunchTool");
            if (imageDescriptor != null) {
                this.setProperty(IProgressConstants.ICON_PROPERTY, imageDescriptor);
            }
            this.process = process;
        }

        public boolean belongsTo(@Nullable Object family) {
            return family == RelaunchJob.class;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class WorkbenchHandler
    extends WorkbenchScopingHandler {
        public WorkbenchHandler() {
            super("org.eclipse.statet.nico.commands.RelaunchTool");
        }

        protected AbstractScopeHandler createScopeHandler(Object scope) {
            return new RelaunchToolHandler((IWorkbenchWindow)scope, this.getCommandId());
        }
    }
}

