/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.dcf.core.source.ast;

import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.Scalar;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public abstract class Value
extends Scalar {
    Value(int statusCode, DslAstNode parent) {
        super(statusCode, parent);
    }

    Value(DslAstNode parent) {
        super(parent);
    }

    public abstract ImList<TextRegion> getTextRegions();

    static class Empty
    extends Value {
        private static final ImList<TextRegion> FRAGMENTS = ImCollections.emptyList();

        Empty(DslAstNode parent, int endOffset) {
            super(parent);
            this.doSetStartEndOffset(parent.getEndOffset(), endOffset);
            this.doSetText("");
        }

        @Override
        public ImList<TextRegion> getTextRegions() {
            return FRAGMENTS;
        }
    }

    public static interface EmptyLine
    extends TextRegion {
    }

    static class EmptyLineTextRegion
    extends BasicTextRegion
    implements EmptyLine {
        public EmptyLineTextRegion(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }
    }

    static class Multiline
    extends Value {
        private final ImList<TextRegion> fragments;

        Multiline(DslAstNode parent, int endOffset, ImList<TextRegion> fragments, @Nullable String text) {
            super(parent);
            this.doSetStartEndOffset(parent.getEndOffset(), endOffset);
            this.doSetText(text);
            this.fragments = fragments;
        }

        @Override
        public ImList<TextRegion> getTextRegions() {
            return this.fragments;
        }
    }

    static class Simple
    extends Value {
        private final ImList<TextRegion> fragments;

        Simple(int statusCode, DslAstNode parent, int startOffset, int endOffset, int textEndOffset) {
            super(statusCode, parent);
            this.doSetStartEndOffset(startOffset, endOffset);
            this.fragments = ImCollections.newList((Object)((Object)(endOffset == textEndOffset ? this : new BasicTextRegion(startOffset, textEndOffset))));
        }

        Simple(DslAstNode parent, int endOffset, TextRegion region, @Nullable String text) {
            super(parent);
            this.doSetStartEndOffset(parent.getEndOffset(), endOffset);
            this.doSetText(text);
            this.fragments = ImCollections.newList((Object)region);
        }

        @Override
        public ImList<TextRegion> getTextRegions() {
            return this.fragments;
        }

        public @Nullable TextRegion getTextRegion() {
            return (TextRegion)this.fragments.get(0);
        }
    }
}

