/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.dsl.dcf.core.source.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.dsl.core.source.ast.DslParser;
import org.eclipse.statet.dsl.core.source.ast.Dummy;
import org.eclipse.statet.dsl.core.source.ast.SourceComponent;
import org.eclipse.statet.dsl.dcf.core.source.DcfLexer;
import org.eclipse.statet.dsl.dcf.core.source.ast.DcfRecord;
import org.eclipse.statet.dsl.dcf.core.source.ast.EmbeddingValue;
import org.eclipse.statet.dsl.dcf.core.source.ast.Field;
import org.eclipse.statet.dsl.dcf.core.source.ast.Name;
import org.eclipse.statet.dsl.dcf.core.source.ast.Value;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;

@NonNullByDefault
public class DcfRParser
extends DslParser {
    private final DcfLexer lexer;
    private final boolean createText;
    private byte nextType;
    private final List<TextRegion> regionsBuilder = new ArrayList<TextRegion>();
    private final StringBuilder tmpTextBuilder = new StringBuilder();
    private @Nullable List<EmbeddingValue> embeddingList;

    public DcfRParser(int level, DcfLexer lexer) {
        super(level);
        this.lexer = lexer;
        this.createText = (level & 0xF) > 1;
    }

    public DcfRParser() {
        this(2, new DcfLexer());
    }

    @Override
    public String getSyntaxLabel() {
        return "DCF (R)";
    }

    public void setCollectEmebeddedNodes(boolean enable) {
        this.embeddingList = enable ? new ArrayList(32) : null;
    }

    public List<EmbeddingValue> getEmbeddingNodes() {
        return this.embeddingList;
    }

    @Override
    protected void clearData() {
        super.clearData();
        CollectionUtils.clear(this.embeddingList);
    }

    @Override
    protected void initTask() {
        super.initTask();
        this.lexer.reset(this.getParseInput());
        this.consumeToken();
    }

    protected final void consumeToken() {
        this.nextType = this.lexer.next();
    }

    private void ensureRecordContent(int startOffset) {
        switch (this.getRecordState()) {
            case 0: {
                DcfRecord recordNode = new DcfRecord((SourceComponent)this.getCurrentNode(), startOffset);
                this.enterNode(recordNode);
                this.beginRecordContent(recordNode);
                return;
            }
            case 1: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected void parseInput(SourceComponent sourceNode) {
        block8: while (true) {
            switch (this.nextType) {
                case -1: {
                    this.exitToSourceComponent(this.lexer.getOffset());
                    return;
                }
                case 1: {
                    this.consumeToken();
                    continue block8;
                }
                case 2: {
                    this.ensureRecordContent(this.lexer.getLineStartOffset());
                    Dummy node = new Dummy(4194784, this.getCurrentNode(), this.lexer.getOffset(), this.lexer.getEndOffset());
                    this.consumeToken();
                    this.addChild(node);
                    continue block8;
                }
                case 3: {
                    this.exitToSourceComponent(this.lexer.getOffset());
                    this.consumeToken();
                    continue block8;
                }
                case 4: {
                    this.parseField();
                    continue block8;
                }
                case 5: 
                case 6: {
                    this.ensureRecordContent(this.lexer.getLineStartOffset());
                    int startOffset = this.lexer.getOffset();
                    int textEndOffset = this.lexer.getEndOffset();
                    this.consumeToken();
                    Value.Simple node = new Value.Simple(4723200, this.getCurrentNode(), startOffset, this.lexer.getOffset(), textEndOffset);
                    this.consumeToken();
                    this.addChild(node);
                    continue block8;
                }
            }
            break;
        }
        throw new IllegalStateException("type= " + this.nextType);
    }

    private void parseField() {
        int offset = this.lexer.getOffset();
        this.ensureRecordContent(offset);
        Field fieldNode = new Field(this.getCurrentNode(), offset, this.lexer.getEndOffset() - 1);
        Name nameNode = new Name(this.lexer.getFlags(), fieldNode, offset, this.lexer.getEndOffset() - 1, this.lexer.getText());
        this.consumeToken();
        List<TextRegion> valueRegions = this.regionsBuilder;
        StringBuilder text = this.createText ? this.tmpTextBuilder : null;
        String firstText = null;
        try {
            int endOffset = this.lexer.getOffset();
            block25: while (true) {
                switch (this.nextType) {
                    case 1: {
                        this.consumeToken();
                        continue block25;
                    }
                    case 5: {
                        valueRegions.add((TextRegion)new BasicTextRegion(this.lexer.getOffset(), this.lexer.getEndOffset()));
                        if (text != null) {
                            switch (valueRegions.size()) {
                                case 1: {
                                    firstText = this.lexer.getText();
                                    break;
                                }
                                case 2: {
                                    text.append(firstText);
                                    text.append('\n');
                                    text.append(this.lexer.getText());
                                    break;
                                }
                                default: {
                                    text.append('\n');
                                    text.append(this.lexer.getText());
                                }
                            }
                        }
                        this.consumeToken();
                        endOffset = this.lexer.getOffset();
                        continue block25;
                    }
                    case 6: {
                        valueRegions.add(new Value.EmptyLineTextRegion(this.lexer.getOffset(), this.lexer.getEndOffset()));
                        if (text != null) {
                            switch (valueRegions.size()) {
                                case 1: {
                                    firstText = "";
                                    break;
                                }
                                case 2: {
                                    text.append(firstText);
                                    text.append('\n');
                                    break;
                                }
                                default: {
                                    text.append('\n');
                                }
                            }
                        }
                        this.consumeToken();
                        endOffset = this.lexer.getOffset();
                        continue block25;
                    }
                    case -1: {
                        break block25;
                    }
                }
                break;
            }
            String foreignType = this.getEmbeddingType(nameNode.getText());
            if (foreignType != null) {
                EmbeddingValue valueNode;
                switch (valueRegions.size()) {
                    case 0: {
                        EmbeddingValue embeddingValue = new EmbeddingValue.Empty(fieldNode, endOffset, foreignType);
                        break;
                    }
                    case 1: {
                        EmbeddingValue embeddingValue = new EmbeddingValue.Simple(fieldNode, endOffset, foreignType, valueRegions.get(0), firstText);
                        break;
                    }
                    default: {
                        EmbeddingValue embeddingValue = valueNode = new EmbeddingValue.Multiline(fieldNode, endOffset, foreignType, (ImList<TextRegion>)ImCollections.toList(valueRegions), text != null ? text.toString() : null);
                    }
                }
                if (this.embeddingList != null) {
                    this.embeddingList.add(valueNode);
                }
                fieldNode.finish(nameNode, valueNode, endOffset);
            } else {
                Value valueNode = switch (valueRegions.size()) {
                    case 0 -> new Value.Empty(fieldNode, endOffset);
                    case 1 -> new Value.Simple(fieldNode, endOffset, valueRegions.get(0), firstText);
                    default -> new Value.Multiline(fieldNode, endOffset, (ImList<TextRegion>)ImCollections.toList(valueRegions), text != null ? text.toString() : null);
                };
                fieldNode.finish(nameNode, valueNode, endOffset);
            }
            this.addChild(fieldNode);
        }
        finally {
            valueRegions.clear();
            if (text != null) {
                text.setLength(0);
            }
        }
    }

    protected @Nullable String getEmbeddingType(@Nullable String name) {
        return null;
    }
}

