/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data.core;

import java.util.Collection;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.core.layer.AbstractLayerDim;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class DataLayerDim<TLayer extends Layer>
extends AbstractLayerDim<TLayer> {
    private final long idCat;

    public DataLayerDim(TLayer layer, Orientation orientation, long idCat) {
        super(layer, orientation);
        this.idCat = idCat;
    }

    @Override
    public long getPositionId(long refPosition, long position) {
        if (position < 0L || position >= this.getPositionCount()) {
            throw new PositionOutOfBoundsException(position, this.getOrientation());
        }
        return this.idCat | position;
    }

    @Override
    public long getPositionById(long id) {
        long position;
        if ((id & 0x7FF0000000000000L) == this.idCat && (position = id & 0xFFFFFFFFFFFFFL) < this.getPositionCount()) {
            return position;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public long localToUnderlyingPosition(long refPosition, long position) {
        return position;
    }

    @Override
    public long underlyingToLocalPosition(LayerDim sourceUnderlyingDim, long underlyingPosition) {
        throw new IllegalArgumentException("underlyingLayer");
    }

    @Override
    public List<LRange> underlyingToLocalPositions(LayerDim sourceUnderlyingDim, Collection<LRange> underlyingPositions) {
        throw new IllegalArgumentException("underlyingLayer");
    }

    @Override
    public @Nullable ImList<LayerDim> getUnderlyingDimsByPosition(long position) {
        return null;
    }

    @Override
    public long getPreferredSize() {
        return this.getSize();
    }

    @Override
    public long getPositionByPixel(long pixel) {
        long position;
        long startPixel = 0L;
        long endPixel = this.getSize();
        if (pixel < startPixel || pixel >= endPixel) {
            throw new PixelOutOfBoundsException(pixel, this.getOrientation());
        }
        long startPosition = 0L;
        long endPosition = this.getPositionCount();
        while (true) {
            double size = (double)(endPixel - startPixel) / (double)(endPosition - startPosition);
            position = startPosition + (long)((double)(pixel - startPixel) / size);
            long start = this.getPositionStart(position);
            long end = start + (long)this.getPositionSize(position);
            if (pixel < start) {
                endPosition = position;
                endPixel = start;
                continue;
            }
            if (pixel < end) break;
            startPosition = position + 1L;
            startPixel = end;
        }
        return position;
    }

    @Override
    public long getPositionStart(long refPosition, long position) {
        return this.getPositionStart(position);
    }

    @Override
    public int getPositionSize(long refPosition, long position) {
        return this.getPositionSize(position);
    }
}

