/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import javax.management.OperationsException;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.RjInitFailedException;
import org.eclipse.statet.rj.server.util.RJContext;
import org.eclipse.statet.rj.servi.node.PropertiesBean;

@NonNullByDefault
public class MXUtils {
    public static boolean validate(PropertiesBean bean) throws OperationsException {
        ArrayList<PropertiesBean.ValidationMessage> messages = new ArrayList<PropertiesBean.ValidationMessage>();
        if (bean.validate(messages)) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormat.format("The configuration ''{0}'' has invalid values:\n", bean.getBeanId()));
        for (PropertiesBean.ValidationMessage message : messages) {
            if (message.getPropertyId() != null) {
                sb.append("{");
                sb.append(message.getPropertyId());
                sb.append("}: ");
            }
            sb.append(message);
            sb.append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        throw new OperationsException(sb.toString());
    }

    public static PropertiesBean loadInit(PropertiesBean bean, RJContext context) throws RjInitFailedException {
        try {
            Properties map = context.loadProperties(bean.getBeanId());
            if (map == null) {
                Utils.logInfo(MessageFormat.format("The configuration ''{0}'' could not be found. Default values are used.", bean.getBeanId()));
            } else {
                bean.load(map);
                bean.validate(null);
            }
            return bean;
        }
        catch (IOException e) {
            throw new RjInitFailedException(MessageFormat.format("Failed to load configuration ''{0}''.", bean.getBeanId()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertiesBean load(PropertiesBean bean, RJContext context) throws OperationsException {
        try {
            Properties map = context.loadProperties(bean.getBeanId());
            if (map != null) {
                PropertiesBean propertiesBean = bean;
                synchronized (propertiesBean) {
                    bean.load(map);
                    MXUtils.validate(bean);
                }
            }
            return bean;
        }
        catch (IOException e) {
            throw new OperationsException(MessageFormat.format("Failed to load configuration ''{0}'': {1}", bean.getBeanId(), e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(PropertiesBean bean, RJContext context) throws OperationsException {
        try {
            Properties map = new Properties();
            PropertiesBean propertiesBean = bean;
            synchronized (propertiesBean) {
                if (!MXUtils.validate(bean)) {
                    return;
                }
                bean.save(map);
            }
            context.saveProperties(bean.getBeanId(), map);
            return;
        }
        catch (IOException e) {
            throw new OperationsException(MessageFormat.format("Failed to save configuration ''{0}'': {1}", bean.getBeanId(), e.getMessage()));
        }
    }
}

